/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

public class ChangeCallsToPassAllDataVisitor
extends AbstractSoyNodeVisitor<Void> {
    @Override
    public Void exec(SoyNode node) {
        Preconditions.checkArgument((node instanceof SoyFileSetNode || node instanceof SoyFileNode || node instanceof TemplateNode ? 1 : 0) != 0);
        this.visit(node);
        return null;
    }

    @Override
    protected void visitCallNode(CallNode node) {
        CallNode newCallNode;
        CallNode nodeCast;
        if (node.numChildren() == 0) {
            return;
        }
        this.visitChildrenAllowingConcurrentModification(node);
        if (node.isPassingData() && !node.isPassingAllData()) {
            return;
        }
        for (CallParamNode param : node.getChildren()) {
            if (!(param instanceof CallParamValueNode)) {
                return;
            }
            CallParamValueNode valueParam = (CallParamValueNode)param;
            if (!("$" + valueParam.getKey()).equals(valueParam.getValueExprText())) {
                return;
            }
            ExprRootNode<?> valueExprRoot = ((CallParamValueNode)param).getValueExprUnion().getExpr();
            if (valueExprRoot == null) {
                return;
            }
            VarRefNode valueDataRef = (VarRefNode)valueExprRoot.getChild(0);
            if (!valueDataRef.isLocalVar().booleanValue() && !valueDataRef.isInjected()) continue;
            return;
        }
        if (node instanceof CallBasicNode) {
            nodeCast = (CallBasicNode)node;
            newCallNode = new CallBasicNode.Builder(node.getId(), node.getSourceLocation()).calleeName(((CallBasicNode)nodeCast).getCalleeName()).sourceCalleeName(((CallBasicNode)nodeCast).getSrcCalleeName()).isPassingData(true).isPassingAllData(true).userSuppliedPlaceholderName(node.getUserSuppliedPhName()).escapingDirectiveNames(node.getEscapingDirectiveNames()).buildAndThrowIfInvalid();
        } else {
            nodeCast = (CallDelegateNode)node;
            newCallNode = new CallDelegateNode.Builder(node.getId(), node.getSourceLocation()).delCalleeName(((CallDelegateNode)nodeCast).getDelCalleeName()).delCalleeVariantExpr(((CallDelegateNode)nodeCast).getDelCalleeVariantExpr()).allowEmptyDefault(((CallDelegateNode)nodeCast).allowsEmptyDefault()).isPassingData(true).isPassingAllData(true).userSuppliedPlaceholderName(node.getUserSuppliedPhName()).escapingDirectiveNames(node.getEscapingDirectiveNames()).buildAndThrowIfInvalid();
        }
        node.getParent().replaceChild(node, newCallNode);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }
}

