/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

final class HelperFunctions {
    HelperFunctions() {
    }

    static Optional<String> converterForType(SoyType valueType) {
        throw new AssertionError((Object)"TODO");
    }

    static FieldAccessStrategy strategyForFieldLookup(SoyType containerType, String fieldName) {
        throw new AssertionError((Object)"TODO");
    }

    static FieldAccessStrategy defaultStrategyForField(String fieldName) {
        if (BaseUtils.isIdentifier(fieldName) && !JsSrcUtils.isReservedWord(fieldName)) {
            return new FieldAccessStrategy(FieldAccessOperator.DOT, fieldName);
        }
        return new FieldAccessStrategy(FieldAccessOperator.BRACKET, fieldName);
    }

    static enum FieldAccessOperator {
        DOT,
        BRACKET,
        METHOD,
        LIBRARY_FN;

    }

    static final class FieldAccessStrategy {
        final FieldAccessOperator op;
        final String fieldKey;

        FieldAccessStrategy(FieldAccessOperator op, String fieldKey) {
            this.op = (FieldAccessOperator)((Object)Preconditions.checkNotNull((Object)((Object)op)));
            this.fieldKey = (String)Preconditions.checkNotNull((Object)fieldKey);
        }

        JsExpr read(JsExpr container) {
            switch (this.op) {
                case DOT: {
                    if (!BaseUtils.isIdentifier(this.fieldKey)) {
                        throw new AssertionError((Object)this.fieldKey);
                    }
                    return new JsExpr(container.getText() + "." + this.fieldKey, container.getPrecedence());
                }
                case BRACKET: {
                    return new JsExpr(container.getText() + "[" + BaseUtils.escapeToSoyString(this.fieldKey, true) + "]", Integer.MAX_VALUE);
                }
                case METHOD: {
                    if (!BaseUtils.isIdentifier(this.fieldKey)) {
                        throw new AssertionError((Object)this.fieldKey);
                    }
                    return new JsExpr(container.getText() + "." + this.fieldKey + "()", container.getPrecedence());
                }
            }
            throw new AssertionError((Object)("unexpected op " + (Object)((Object)this.op)));
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof FieldAccessStrategy)) {
                return false;
            }
            FieldAccessStrategy that = this;
            return this.op == that.op && this.fieldKey.equals(that.fieldKey);
        }

        public int hashCode() {
            return 31 * this.op.hashCode() + this.fieldKey.hashCode() ^ 0xD5E45D71;
        }
    }

    static final class FieldAccessorHelperInfo
    extends BaseHelperInfo {
        final SoyType containerType;
        final String fieldName;

        FieldAccessorHelperInfo(String closurePath, CodeLocation codeLocation, SoyType containerType, String fieldName) {
            super(closurePath, codeLocation);
            this.containerType = (SoyType)Preconditions.checkNotNull((Object)containerType);
            this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
        }
    }

    static final class ValueConverterHelperInfo
    extends BaseHelperInfo {
        final SoyType valueType;

        ValueConverterHelperInfo(String closurePath, CodeLocation codeLocation, SoyType valueType) {
            super(closurePath, codeLocation);
            this.valueType = (SoyType)Preconditions.checkNotNull((Object)valueType);
        }
    }

    static enum CodeLocation {
        GENERATED,
        EXTERNAL;

    }

    static abstract class BaseHelperInfo {
        final String closurePath;
        final CodeLocation codeLocation;
        boolean appearsInUnion;

        BaseHelperInfo(String closurePath, CodeLocation codeLocation) {
            this.closurePath = (String)Preconditions.checkNotNull((Object)closurePath);
            this.codeLocation = (CodeLocation)((Object)Preconditions.checkNotNull((Object)((Object)codeLocation)));
        }
    }
}

