/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;

public final class RenderContext {
    private final SoyRecord ij;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;

    public RenderContext(SoyRecord ij, SoyCssRenamingMap cssRenamingMap, SoyIdRenamingMap xidRenamingMap) {
        this.ij = (SoyRecord)Preconditions.checkNotNull((Object)ij);
        this.cssRenamingMap = (SoyCssRenamingMap)Preconditions.checkNotNull((Object)cssRenamingMap);
        this.xidRenamingMap = (SoyIdRenamingMap)Preconditions.checkNotNull((Object)xidRenamingMap);
    }

    public SoyRecord ijParams() {
        return this.ij;
    }

    public String renameCssSelector(String selector) {
        String string = this.cssRenamingMap.get(selector);
        return string == null ? selector : string;
    }

    public String renameXid(String id) {
        String string = this.xidRenamingMap.get(id);
        return string == null ? id + "_" : string;
    }
}

