/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.BytecodeProducer;
import java.util.Arrays;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class Statement
extends BytecodeProducer {
    static final Statement NULL_STATEMENT = new Statement(){

        @Override
        void doGen(GeneratorAdapter adapter) {
        }
    };
    private final Optional<SourceLocation> location;
    private final Label start;
    private final Label end;

    static Statement concat(Statement ... statements) {
        return Statement.concat(Arrays.asList(statements));
    }

    static Statement concat(final Iterable<? extends Statement> statements) {
        Preconditions.checkNotNull(statements);
        return new Statement(){

            @Override
            void doGen(GeneratorAdapter adapter) {
                for (Statement statement : statements) {
                    statement.gen(adapter);
                }
            }
        };
    }

    Statement() {
        this((Optional<SourceLocation>)Optional.absent());
    }

    Statement(SourceLocation location) {
        this((Optional<SourceLocation>)(location.isKnown() ? Optional.of((Object)location) : Optional.absent()));
    }

    private Statement(Optional<SourceLocation> location) {
        this.location = location;
        this.start = new Label();
        this.end = new Label();
    }

    public final Label start() {
        return this.start;
    }

    public final Label end() {
        return this.end;
    }

    public final Statement withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        return new Statement(location){

            @Override
            void doGen(GeneratorAdapter adapter) {
                Statement.this.doGen(adapter);
            }
        };
    }

    @Override
    final void gen(GeneratorAdapter adapter) {
        adapter.mark(this.start);
        this.doGen(adapter);
        adapter.mark(this.end);
        if (this.location.isPresent()) {
            adapter.visitLineNumber(((SourceLocation)this.location.get()).getLineNumber(), this.start);
            adapter.visitLineNumber(((SourceLocation)this.location.get()).getEndLine(), this.end);
        }
    }

    abstract void doGen(GeneratorAdapter var1);

    public String toString() {
        return "Statement:\n" + this.trace();
    }
}

