/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class SoyExpression
extends Expression {
    static final SoyExpression NULL = new NullExpression();
    private final Class<?> clazz;
    private final Type type;

    SoyExpression(Class<?> clazz) {
        this.clazz = clazz;
        this.type = Type.getType(clazz);
    }

    @Override
    final Type resultType() {
        return this.type;
    }

    Class<?> clazz() {
        return this.clazz;
    }

    boolean isKnownString() {
        return this.clazz().equals(String.class) || StringData.class.isAssignableFrom(this.clazz) || SanitizedContent.class.isAssignableFrom(this.clazz);
    }

    boolean isKnownInt() {
        return this.clazz().equals(Long.TYPE) || this.clazz().equals(IntegerData.class);
    }

    boolean isKnownFloat() {
        return this.clazz().equals(Double.TYPE) || this.clazz().equals(FloatData.class);
    }

    final boolean isKnownNumber() {
        return this.isKnownFloat() || this.isKnownInt();
    }

    abstract SoyExpression box();

    SoyExpression convert(Class<?> asType) {
        if (asType.equals(Long.TYPE)) {
            return MethodRef.SOY_VALUE_LONG_VALUE.invokeAsBoxedSoyExpression(this);
        }
        if (asType.equals(Double.TYPE)) {
            return MethodRef.SOY_VALUE_FLOAT_VALUE.invokeAsBoxedSoyExpression(this);
        }
        if (asType.equals(String.class)) {
            return MethodRef.TO_STRING.invokeAsBoxedSoyExpression(this);
        }
        if (asType.equals(Boolean.TYPE)) {
            return MethodRef.SOY_VALUE_COERCE_TO_BOOLEAN.invokeAsBoxedSoyExpression(this);
        }
        throw new UnsupportedOperationException("Can't unbox " + this.clazz + " as " + asType);
    }

    static abstract class ListExpression
    extends SoyExpression {
        ListExpression() {
            super(List.class);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(ListImpl.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    MethodRef.LIST_IMPL_FOR_PROVIDER_LIST.invoke(ListExpression.this).gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (List.class.isAssignableFrom(asType)) {
                return this;
            }
            return super.convert(asType);
        }
    }

    static abstract class MapExpression
    extends SoyExpression {
        MapExpression() {
            super(Map.class);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(DictImpl.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invoke(MapExpression.this).gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (Map.class.isAssignableFrom(asType)) {
                return this;
            }
            return super.convert(asType);
        }
    }

    static abstract class StringExpression
    extends SoyExpression {
        StringExpression() {
            super(String.class);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(StringData.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    MethodRef.STRING_DATA_FOR_VALUE.invoke(StringExpression.this).gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (asType.equals(String.class)) {
                return this;
            }
            return super.convert(asType);
        }
    }

    static abstract class FloatExpression
    extends SoyExpression {
        FloatExpression() {
            super(Double.TYPE);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(FloatData.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    MethodRef.FLOAT_DATA_FOR_VALUE.invoke(FloatExpression.this).gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (asType.equals(Double.TYPE)) {
                return this;
            }
            if (asType.equals(Long.TYPE)) {
                throw new UnsupportedOperationException("floats cannot be converted to ints");
            }
            return super.convert(asType);
        }
    }

    private static final class NullExpression
    extends SoyExpression {
        private NullExpression() {
            super(Object.class);
        }

        @Override
        void gen(GeneratorAdapter mv) {
            mv.visitInsn(1);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(NullData.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    FieldRef.NULL_DATA_INSTANCE.accessor().gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (asType.equals(Object.class)) {
                return this;
            }
            if (asType.equals(Boolean.TYPE)) {
                return BoolExpression.FALSE;
            }
            return super.convert(asType);
        }

        @Override
        boolean isConstant() {
            return true;
        }
    }

    static abstract class IntExpression
    extends SoyExpression {
        IntExpression() {
            super(Long.TYPE);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(IntegerData.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    MethodRef.INTEGER_DATA_FOR_VALUE.invoke(IntExpression.this).gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (asType.equals(Long.TYPE)) {
                return this;
            }
            if (asType.equals(Double.TYPE)) {
                return new FloatExpression(){

                    @Override
                    void gen(GeneratorAdapter adapter) {
                        IntExpression.this.gen(adapter);
                        adapter.cast(Type.LONG_TYPE, Type.DOUBLE_TYPE);
                    }
                };
            }
            return super.convert(asType);
        }
    }

    static abstract class BoolExpression
    extends SoyExpression {
        static final BoolExpression FALSE = new BoolExpression(){

            @Override
            void gen(GeneratorAdapter mv) {
                mv.push(false);
            }

            @Override
            SoyExpression box() {
                return new DefaultBoxed(BooleanData.class, FALSE){

                    @Override
                    void gen(GeneratorAdapter mv) {
                        FieldRef.BOOLEAN_DATA_FALSE.accessor().gen(mv);
                    }
                };
            }
        };
        static final BoolExpression TRUE = new BoolExpression(){

            @Override
            void gen(GeneratorAdapter mv) {
                mv.push(true);
            }

            @Override
            SoyExpression box() {
                return new DefaultBoxed(BooleanData.class, TRUE){

                    @Override
                    void gen(GeneratorAdapter mv) {
                        FieldRef.BOOLEAN_DATA_TRUE.accessor().gen(mv);
                    }
                };
            }
        };

        BoolExpression() {
            super(Boolean.TYPE);
        }

        @Override
        SoyExpression box() {
            return new DefaultBoxed(BooleanData.class, this){

                @Override
                void gen(GeneratorAdapter mv) {
                    MethodRef.BOOLEAN_DATA_FOR_VALUE.invoke(BoolExpression.this).gen(mv);
                }
            };
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            if (asType.equals(Boolean.TYPE)) {
                return this;
            }
            return super.convert(asType);
        }
    }

    static abstract class DefaultBoxed
    extends BoxedExpression {
        private final SoyExpression unboxed;

        DefaultBoxed(Class<? extends SoyValue> clazz, SoyExpression unboxed) {
            super(clazz);
            this.unboxed = unboxed;
        }

        @Override
        boolean isKnownFloat() {
            return this.unboxed.isKnownFloat();
        }

        @Override
        boolean isKnownInt() {
            return this.unboxed.isKnownInt();
        }

        @Override
        boolean isKnownString() {
            return this.unboxed.isKnownString();
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            return this.unboxed.convert(asType);
        }

        @Override
        final boolean isConstant() {
            return this.unboxed.isConstant();
        }
    }

    static abstract class BoxedExpression
    extends SoyExpression {
        BoxedExpression(Class<? extends SoyValue> clazz) {
            super(clazz);
        }

        final Class<? extends SoyValue> clazz() {
            return super.clazz().asSubclass(SoyValue.class);
        }

        @Override
        final SoyExpression box() {
            return this;
        }
    }
}

