/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.primitives.Longs;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class MemoryClassLoader
extends ClassLoader {
    private static final ClassData TOMBSTONE = ClassData.create(TypeInfo.create("not.a.real.Class"), Longs.toByteArray((long)-559038737L));
    private final ConcurrentMap<String, ClassData> classesByName;

    private MemoryClassLoader(Map<String, ClassData> generatedClasses) {
        super(ClassLoader.getSystemClassLoader());
        this.classesByName = new ConcurrentHashMap<String, ClassData>(generatedClasses);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassData classDef = this.classesByName.put(name, TOMBSTONE);
        if (classDef == null) {
            this.classesByName.remove(name);
            throw new ClassNotFoundException(name);
        }
        if (classDef == TOMBSTONE) {
            throw new IllegalStateException("class already defined: " + name);
        }
        return super.defineClass(name, classDef.data(), 0, classDef.data().length);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    static final class Builder {
        private final Map<String, ClassData> generatedClasses = new LinkedHashMap<String, ClassData>();

        Builder() {
        }

        Builder addAll(Iterable<ClassData> classes) {
            for (ClassData item : classes) {
                this.add(item);
            }
            return this;
        }

        Builder add(ClassData classData) {
            ClassData prev = this.generatedClasses.put(classData.type().className(), classData);
            if (prev != null) {
                throw new IllegalStateException("multiple classes generated named: " + classData.type());
            }
            return this;
        }

        MemoryClassLoader build() {
            return new MemoryClassLoader(this.generatedClasses);
        }
    }
}

