/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AutoValue_LocalVariable;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.TypeInfo;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class LocalVariable
extends Expression {
    LocalVariable() {
    }

    static LocalVariable createThisVar(TypeInfo owner, Label start, Label end) {
        return new AutoValue_LocalVariable("this", owner.type(), 0, start, end);
    }

    static LocalVariable createLocal(String name, int index, Type type, Label start, Label end) {
        Preconditions.checkArgument((!name.equals("this") ? 1 : 0) != 0);
        return new AutoValue_LocalVariable(name, type, index, start, end);
    }

    abstract String variableName();

    @Override
    abstract Type resultType();

    abstract int index();

    abstract Label start();

    abstract Label end();

    void tableEntry(GeneratorAdapter mv) {
        mv.visitLocalVariable(this.variableName(), this.resultType().getDescriptor(), null, this.start(), this.end(), this.index());
    }

    @Override
    public void gen(GeneratorAdapter mv) {
        mv.visitVarInsn(this.resultType().getOpcode(21), this.index());
    }

    void store(GeneratorAdapter mv) {
        mv.visitVarInsn(this.resultType().getOpcode(54), this.index());
    }
}

