/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.jbcsrc.AutoValue_ConstructorRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

abstract class ConstructorRef {
    static final ConstructorRef ARRAY_LIST_SIZE = ConstructorRef.create(ArrayList.class, Integer.TYPE);
    static final ConstructorRef LINKED_HASH_MAP_SIZE = ConstructorRef.create(LinkedHashMap.class, Integer.TYPE);

    ConstructorRef() {
    }

    private static ConstructorRef create(Class<?> clazz, Class<?> ... argTypes) {
        Constructor<?> c;
        TypeInfo type = TypeInfo.create(clazz);
        try {
            c = clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        Type constructorType = Type.getType(c);
        return new AutoValue_ConstructorRef(type, Method.getMethod(c), (ImmutableList<Type>)ImmutableList.copyOf((Object[])constructorType.getArgumentTypes()));
    }

    abstract TypeInfo instanceClass();

    abstract Method method();

    abstract ImmutableList<Type> argTypes();

    Expression construct(final Expression ... args) {
        Expression.checkTypes(this.argTypes(), args);
        return new Expression(){

            @Override
            void gen(GeneratorAdapter mv) {
                mv.newInstance(ConstructorRef.this.instanceClass().type());
                mv.dup();
                for (Expression arg : args) {
                    arg.gen(mv);
                }
                mv.invokeConstructor(ConstructorRef.this.instanceClass().type(), ConstructorRef.this.method());
            }

            @Override
            Type resultType() {
                return ConstructorRef.this.instanceClass().type();
            }
        };
    }
}

