/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.TypeInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class BytecodeUtils {
    static final Method NULLARY_INIT = Method.getMethod((String)"void <init>()");
    static final Method CLASS_INIT = Method.getMethod((String)"void <clinit>()");

    private BytecodeUtils() {
    }

    static Expression constant(final int value) {
        return new Expression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                mv.push(value);
            }

            @Override
            public Type resultType() {
                return Type.INT_TYPE;
            }

            @Override
            boolean isConstant() {
                return true;
            }
        };
    }

    static Expression constant(final char value) {
        return new Expression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                mv.push((int)value);
            }

            @Override
            public Type resultType() {
                return Type.CHAR_TYPE;
            }

            @Override
            boolean isConstant() {
                return true;
            }
        };
    }

    static SoyExpression.IntExpression constant(final long value) {
        return new SoyExpression.IntExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                mv.push(value);
            }

            @Override
            boolean isConstant() {
                return true;
            }
        };
    }

    static SoyExpression.FloatExpression constant(final double value) {
        return new SoyExpression.FloatExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                mv.push(value);
            }

            @Override
            boolean isConstant() {
                return true;
            }
        };
    }

    static SoyExpression.StringExpression constant(final String value) {
        Preconditions.checkNotNull((Object)value);
        return new SoyExpression.StringExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                mv.push(value);
            }

            @Override
            boolean isConstant() {
                return true;
            }
        };
    }

    static Expression dupExpr(final Type type) {
        switch (type.getSize()) {
            case 1: {
                return new Expression(){

                    @Override
                    void gen(GeneratorAdapter mv) {
                        mv.dup();
                    }

                    @Override
                    Type resultType() {
                        return type;
                    }
                };
            }
            case 2: {
                return new Expression(){

                    @Override
                    void gen(GeneratorAdapter mv) {
                        mv.dup2();
                    }

                    @Override
                    Type resultType() {
                        return type;
                    }
                };
            }
        }
        throw new AssertionError((Object)("cannot dup() " + type));
    }

    static void loadDefault(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(3);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                break;
            }
            case 7: {
                mv.visitInsn(9);
                break;
            }
            case 8: {
                mv.visitInsn(14);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(1);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected sort for type: " + type));
            }
        }
    }

    static void defineDefaultConstructor(ClassVisitor cv, TypeInfo ownerType) {
        GeneratorAdapter mg = new GeneratorAdapter(1, NULLARY_INIT, null, null, cv);
        Label start = mg.mark();
        Label end = mg.newLabel();
        LocalVariable thisVar = LocalVariable.createThisVar(ownerType, start, end);
        thisVar.gen(mg);
        mg.invokeConstructor(Type.getType(Object.class), NULLARY_INIT);
        mg.returnValue();
        mg.mark(end);
        thisVar.tableEntry(mg);
        mg.endMethod();
    }

    static SoyExpression.BoolExpression compare(final int comparisonOpcode, final Expression left, final Expression right) {
        BytecodeUtils.checkIntComparisonOpcode(comparisonOpcode);
        Preconditions.checkArgument((boolean)left.resultType().equals((Object)right.resultType()), (String)"left and right must have matching types, found %s and %s", (Object[])new Object[]{left.resultType(), right.resultType()});
        return new SoyExpression.BoolExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                left.gen(mv);
                right.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifCmp(left.resultType(), comparisonOpcode, ifTrue);
                mv.push(false);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.push(true);
                mv.mark(end);
            }

            @Override
            boolean isConstant() {
                return left.isConstant() && right.isConstant();
            }
        };
    }

    private static void checkIntComparisonOpcode(int opcode) {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode for comparison operation: " + opcode);
    }

    static SoyExpression.BoolExpression logicalNot(final Expression baseExpr) {
        baseExpr.checkType(Type.BOOLEAN_TYPE);
        Preconditions.checkArgument((boolean)baseExpr.resultType().equals((Object)Type.BOOLEAN_TYPE), (Object)"not a boolean expression");
        return new SoyExpression.BoolExpression(){

            @Override
            void gen(GeneratorAdapter mv) {
                baseExpr.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifZCmp(154, ifTrue);
                mv.push(true);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.push(false);
                mv.mark(end);
            }

            @Override
            boolean isConstant() {
                return baseExpr.isConstant();
            }
        };
    }
}

