/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.ErrorPrettyPrinter;
import com.google.template.soy.base.internal.SoyFileSupplier;
import java.io.PrintStream;
import java.util.List;

final class CompilationResult {
    private final ImmutableCollection<? extends SoySyntaxException> errors;
    private final ErrorPrettyPrinter prettyPrinter;

    CompilationResult(ImmutableCollection<? extends SoySyntaxException> errors, ErrorPrettyPrinter prettyPrinter) {
        this.errors = errors;
        this.prettyPrinter = prettyPrinter;
    }

    boolean isSuccess() {
        return this.errors.isEmpty();
    }

    void printErrors(PrintStream out) {
        Preconditions.checkState((!this.isSuccess() ? 1 : 0) != 0);
        for (SoySyntaxException e : this.errors) {
            this.prettyPrinter.print(e, out);
        }
    }

    static CompilationResult success() {
        return new CompilationResult((ImmutableCollection<? extends SoySyntaxException>)ImmutableList.of(), new ErrorPrettyPrinter((List<SoyFileSupplier>)ImmutableList.of()));
    }
}

