/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.google.sitebricks.client.AHCWebClient;
import com.google.sitebricks.client.Transport;
import com.google.sitebricks.client.Web;
import com.google.sitebricks.client.WebClient;
import com.google.sitebricks.client.transport.Text;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class WebClientBuilder
implements Web.FormatBuilder {
    private final Injector injector;
    private String url;
    private Map<String, String> headers;
    private Web.Auth authType;
    private String username;
    private String password;
    private boolean usePreemptiveAuth;

    @Inject
    public WebClientBuilder(Injector injector) {
        this.injector = injector;
    }

    public Web.FormatBuilder clientOf(String url) {
        this.url = url;
        this.headers = null;
        return this;
    }

    public Web.FormatBuilder clientOf(String url, Map<String, String> headers) {
        this.url = url;
        this.headers = headers;
        return this;
    }

    @Override
    public <T> Web.ReadAsBuilder<T> transports(Class<T> clazz) {
        return new InternalReadAsBuilder(new TypeLiteral<T>(){});
    }

    @Override
    public <T> Web.ReadAsBuilder<T> transports(TypeLiteral<T> clazz) {
        return new InternalReadAsBuilder(clazz);
    }

    @Override
    public <T> WebClient<T> transportsText() {
        return this.transports(String.class).over(Text.class);
    }

    @Override
    public Web.FormatBuilder auth(Web.Auth auth, String username, String password) {
        return this.auth(auth, username, password, false);
    }

    @Override
    public Web.FormatBuilder auth(Web.Auth auth, String username, String password, boolean usePreemptiveAuth) {
        Preconditions.checkArgument((null != auth ? 1 : 0) != 0, (Object)"Invalid auth type, null.");
        Preconditions.checkArgument((null != username ? 1 : 0) != 0, (Object)"Username cannot be null.");
        Preconditions.checkArgument((null != password ? 1 : 0) != 0, (Object)"Password cannot be null.");
        this.authType = auth;
        this.username = username;
        this.password = password;
        this.usePreemptiveAuth = usePreemptiveAuth;
        return this;
    }

    private class InternalReadAsBuilder<T>
    implements Web.ReadAsBuilder<T> {
        private final TypeLiteral<T> transporting;

        private InternalReadAsBuilder(TypeLiteral<T> transporting) {
            this.transporting = transporting;
        }

        @Override
        public WebClient<T> over(Class<? extends Transport> transport) {
            return new AHCWebClient<T>(WebClientBuilder.this.injector, (Transport)WebClientBuilder.this.injector.getInstance(transport), WebClientBuilder.this.authType, WebClientBuilder.this.username, WebClientBuilder.this.password, WebClientBuilder.this.usePreemptiveAuth, WebClientBuilder.this.url, WebClientBuilder.this.headers, this.transporting);
        }
    }
}

