/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.PlaceDetails;

public class PlaceDetailsRequest
extends PendingResultBase<PlaceDetails, PlaceDetailsRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/details/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    public PlaceDetailsRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public PlaceDetailsRequest placeId(String placeId) {
        return (PlaceDetailsRequest)this.param("placeid", placeId);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("placeid")) {
            throw new IllegalArgumentException("Request must contain 'placeId'.");
        }
    }

    static class Response
    implements ApiResponse<PlaceDetails> {
        public String status;
        public PlaceDetails result;
        public String[] htmlAttributions;
        public String errorMessage;

        Response() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public PlaceDetails getResult() {
            if (this.result != null) {
                this.result.htmlAttributions = this.htmlAttributions;
            }
            return this.result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

