/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.PhotoResult;

public class PhotoRequest
extends PendingResultBase<PhotoResult, PhotoRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/photo");

    public PhotoRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("photoreference")) {
            throw new IllegalArgumentException("Request must contain 'photoReference'.");
        }
        if (!this.params().containsKey("maxheight") && !this.params().containsKey("maxwidth")) {
            throw new IllegalArgumentException("Request must contain 'maxHeight' or 'maxWidth'.");
        }
    }

    public PhotoRequest photoReference(String photoReference) {
        return (PhotoRequest)this.param("photoreference", photoReference);
    }

    public PhotoRequest maxHeight(int maxHeight) {
        return (PhotoRequest)this.param("maxheight", String.valueOf(maxHeight));
    }

    public PhotoRequest maxWidth(int maxWidth) {
        return (PhotoRequest)this.param("maxwidth", String.valueOf(maxWidth));
    }

    public static class Response
    implements ApiResponse<PhotoResult> {
        private Response() {
        }

        @Override
        public boolean successful() {
            return false;
        }

        @Override
        public PhotoResult getResult() {
            return null;
        }

        @Override
        public ApiException getError() {
            return null;
        }
    }
}

