/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.errors;

import com.google.maps.errors.InvalidRequestException;
import com.google.maps.errors.MaxElementsExceededException;
import com.google.maps.errors.NotFoundException;
import com.google.maps.errors.OverQueryLimitException;
import com.google.maps.errors.RequestDeniedException;
import com.google.maps.errors.UnknownErrorException;
import com.google.maps.errors.ZeroResultsException;

public class ApiException
extends Exception {
    protected ApiException(String message) {
        super(message);
    }

    public static ApiException from(String status, String errorMessage) {
        switch (status) {
            case "OK": {
                return null;
            }
            case "INVALID_REQUEST": {
                return new InvalidRequestException(errorMessage);
            }
            case "MAX_ELEMENTS_EXCEEDED": {
                return new MaxElementsExceededException(errorMessage);
            }
            case "NOT_FOUND": {
                return new NotFoundException(errorMessage);
            }
            case "OVER_QUERY_LIMIT": {
                return new OverQueryLimitException(errorMessage);
            }
            case "REQUEST_DENIED": {
                return new RequestDeniedException(errorMessage);
            }
            case "UNKNOWN_ERROR": {
                return new UnknownErrorException(errorMessage);
            }
            case "ZERO_RESULTS": {
                return new ZeroResultsException(errorMessage);
            }
        }
        String string = String.valueOf(String.valueOf("An unexpected error occurred. Status: "));
        String string2 = String.valueOf(String.valueOf(status));
        String string3 = String.valueOf(String.valueOf(errorMessage));
        return new UnknownErrorException(new StringBuilder(11 + string.length() + string2.length() + string3.length()).append(string).append(string2).append(", ").append("Message: ").append(string3).toString());
    }
}

