/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeDeclarationsIR {
    public static Node.TypeDeclarationNode stringType() {
        return new Node.TypeDeclarationNode(200);
    }

    public static Node.TypeDeclarationNode numberType() {
        return new Node.TypeDeclarationNode(202);
    }

    public static Node.TypeDeclarationNode booleanType() {
        return new Node.TypeDeclarationNode(201);
    }

    public static Node.TypeDeclarationNode nullable(Node.TypeDeclarationNode type) {
        return new Node.TypeDeclarationNode(208, type);
    }

    public static Node.TypeDeclarationNode anyType() {
        return new Node.TypeDeclarationNode(206);
    }

    public static Node.TypeDeclarationNode voidType() {
        return new Node.TypeDeclarationNode(209);
    }

    public static Node.TypeDeclarationNode undefinedType() {
        return new Node.TypeDeclarationNode(214);
    }

    public static Node.TypeDeclarationNode namedType(String typeName) {
        return TypeDeclarationsIR.namedType(Splitter.on((char)'.').split((CharSequence)typeName));
    }

    public static Node.TypeDeclarationNode namedType(Iterable<String> segments) {
        Iterator<String> segmentsIt = segments.iterator();
        Node node = IR.name(segmentsIt.next());
        while (segmentsIt.hasNext()) {
            node = IR.getprop(node, IR.string(segmentsIt.next()));
        }
        return new Node.TypeDeclarationNode(211, node);
    }

    public static Node.TypeDeclarationNode recordType(LinkedHashMap<String, Node.TypeDeclarationNode> properties) {
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(213);
        for (Map.Entry<String, Node.TypeDeclarationNode> prop : properties.entrySet()) {
            Node stringKey = IR.stringKey(prop.getKey());
            node.addChildToBack(stringKey);
            if (prop.getValue() == null) continue;
            stringKey.addChildToFront(prop.getValue());
        }
        return node;
    }

    private static Node maybeAddType(Node node, Node.TypeDeclarationNode type) {
        if (type != null) {
            node.setDeclaredTypeExpression(type);
        }
        return node;
    }

    public static Node.TypeDeclarationNode functionType(Node returnType, LinkedHashMap<String, Node.TypeDeclarationNode> requiredParams, LinkedHashMap<String, Node.TypeDeclarationNode> optionalParams, String restName, Node.TypeDeclarationNode restType) {
        Node name;
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(203, returnType);
        Preconditions.checkNotNull(requiredParams);
        Preconditions.checkNotNull(optionalParams);
        for (Map.Entry<String, Node.TypeDeclarationNode> param : requiredParams.entrySet()) {
            name = IR.name(param.getKey());
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(name, param.getValue()));
        }
        for (Map.Entry<String, Node.TypeDeclarationNode> param : optionalParams.entrySet()) {
            name = IR.name(param.getKey());
            name.putBooleanProp(80, true);
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(name, param.getValue()));
        }
        if (restName != null) {
            Node rest = Node.newString(173, restName);
            node.addChildrenToBack(TypeDeclarationsIR.maybeAddType(rest, restType));
        }
        return node;
    }

    public static Node.TypeDeclarationNode parameterizedType(Node.TypeDeclarationNode baseType, Iterable<Node.TypeDeclarationNode> typeParameters) {
        if (Iterables.isEmpty(typeParameters)) {
            return baseType;
        }
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(204, baseType);
        for (Node node2 : typeParameters) {
            node.addChildToBack(node2);
        }
        return node;
    }

    public static Node.TypeDeclarationNode arrayType(Node elementType) {
        return new Node.TypeDeclarationNode(215, elementType);
    }

    public static Node.TypeDeclarationNode unionType(Iterable<Node.TypeDeclarationNode> options) {
        Preconditions.checkArgument((!Iterables.isEmpty(options) ? 1 : 0) != 0, (Object)"union must have at least one option");
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(205);
        for (Node node2 : options) {
            node.addChildToBack(node2);
        }
        return node;
    }

    public static Node.TypeDeclarationNode unionType(Node.TypeDeclarationNode ... options) {
        return TypeDeclarationsIR.unionType(Arrays.asList(options));
    }

    public static Node.TypeDeclarationNode optionalParameter(Node.TypeDeclarationNode parameterType) {
        return new Node.TypeDeclarationNode(212, parameterType);
    }
}

