/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.AmbientDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EnumDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.GenericTypeListTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.IndexSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.InterfaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ModuleImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.NamespaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.NamespaceNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParameterizedTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RecordTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeAliasTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeQueryTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypedParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.TypeDeclarationsIR;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

class IRFactory {
    static final String GETTER_ERROR_MESSAGE = "getters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SETTER_ERROR_MESSAGE = "setters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SUSPICIOUS_COMMENT_WARNING = "Non-JSDoc comment has annotations. Did you mean to start it with '/**'?";
    static final String INVALID_ES3_PROP_NAME = "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String INVALID_ES5_STRICT_OCTAL = "Octal integer literals are not supported in Ecmascript 5 strict mode.";
    static final String INVALID_NUMBER_LITERAL = "Invalid number literal.";
    static final String STRING_CONTINUATION_ERROR = "String continuations are not supported in this language mode.";
    static final String STRING_CONTINUATION_WARNING = "String continuations are not recommended. See https://google-styleguide.googlecode.com/svn/trunk/javascriptguide.xml#Multiline_string_literals";
    static final String BINARY_NUMBER_LITERAL_WARNING = "Binary integer literals are not supported in this language mode.";
    static final String OCTAL_NUMBER_LITERAL_WARNING = "Octal integer literals are not supported in this language mode.";
    static final String OCTAL_STRING_LITERAL_WARNING = "Octal literals in strings are not supported in this language mode.";
    static final String DUPLICATE_PARAMETER = "Duplicate parameter name \"%s\"";
    static final String DUPLICATE_LABEL = "Duplicate label \"%s\"";
    static final String UNLABELED_BREAK = "unlabelled break must be inside loop or switch";
    static final String UNEXPECTED_CONTINUE = "continue must be inside loop";
    static final String UNEXPECTED_LABLED_CONTINUE = "continue can only use labeles of iteration statements";
    static final String UNEXPECTED_RETURN = "return must be inside function";
    static final String UNDEFINED_LABEL = "undefined label \"%s\"";
    private final String sourceString;
    private final List<Integer> newlines;
    private final StaticSourceFile sourceFile;
    private final String sourceName;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final TransformDispatcher transformDispatcher;
    private static final ImmutableSet<String> ALLOWED_DIRECTIVES = ImmutableSet.of((Object)"use strict");
    private static final ImmutableSet<String> ES5_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super"});
    private static final ImmutableSet<String> ES5_STRICT_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
    private final Set<String> reservedKeywords;
    private final Set<Comment> parsedComments = new HashSet<Comment>();
    JSDocInfoBuilder fileLevelJsDocBuilder;
    JSDocInfo fileOverviewInfo = null;
    private final Node templateNode;
    private final UnmodifiableIterator<Comment> nextCommentIter;
    private Comment currentComment;
    private boolean currentFileIsExterns = false;
    private boolean hasTypeSyntax = false;
    private boolean hasJsDocTypeAnnotations = false;

    private IRFactory(String sourceString, StaticSourceFile sourceFile, Config config, ErrorReporter errorReporter, ImmutableList<Comment> comments) {
        this.sourceString = sourceString;
        this.nextCommentIter = comments.iterator();
        this.currentComment = this.nextCommentIter.hasNext() ? (Comment)this.nextCommentIter.next() : null;
        this.newlines = new ArrayList<Integer>();
        this.sourceFile = sourceFile;
        this.fileLevelJsDocBuilder = new JSDocInfoBuilder(config.parseJsDocDocumentation);
        int charNo = 0;
        while ((charNo = sourceString.indexOf(10, charNo)) != -1) {
            this.newlines.add(charNo);
            ++charNo;
        }
        this.sourceName = sourceFile == null ? null : sourceFile.getName();
        this.config = config;
        this.errorReporter = errorReporter;
        this.transformDispatcher = new TransformDispatcher();
        this.templateNode = this.createTemplateNode();
        switch (config.languageMode) {
            case ECMASCRIPT3: {
                this.reservedKeywords = null;
                break;
            }
            case ECMASCRIPT5: 
            case ECMASCRIPT6: {
                this.reservedKeywords = ES5_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT5_STRICT: 
            case ECMASCRIPT6_STRICT: 
            case ECMASCRIPT6_TYPED: {
                this.reservedKeywords = ES5_STRICT_RESERVED_KEYWORDS;
                break;
            }
            default: {
                throw new IllegalStateException("unknown language mode: " + (Object)((Object)config.languageMode));
            }
        }
    }

    private Node createTemplateNode() {
        Node templateNode = new Node(132);
        templateNode.setStaticSourceFile(this.sourceFile);
        return templateNode;
    }

    public static Node transformTree(ProgramTree tree, StaticSourceFile sourceFile, String sourceString, Config config, ErrorReporter errorReporter) {
        IRFactory irFactory = new IRFactory(sourceString, sourceFile, config, errorReporter, tree.sourceComments);
        Node n = irFactory.justTransform(tree);
        irFactory.setSourceInfo(n, tree);
        if (tree.sourceComments != null) {
            for (Comment comment : tree.sourceComments) {
                if (comment.type == Comment.Type.JSDOC && !irFactory.parsedComments.contains(comment)) {
                    irFactory.handlePossibleFileOverviewJsDoc(comment);
                    continue;
                }
                if (comment.type != Comment.Type.BLOCK) continue;
                irFactory.handleBlockComment(comment);
            }
        }
        irFactory.setFileOverviewJsDoc(n);
        irFactory.validateAll(n);
        return n;
    }

    private void validateAll(Node n) {
        this.validate(n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateAll(c);
        }
    }

    private void validate(Node n) {
        this.validateParameters(n);
        this.validateBreakContinue(n);
        this.validateReturn(n);
        this.validateLabel(n);
    }

    private void validateBreakContinue(Node n) {
        block8: {
            block9: {
                if (!n.isBreak() && !n.isContinue()) break block8;
                Node labelName = n.getFirstChild();
                if (labelName == null) break block9;
                Node parent = n.getParent();
                while (!parent.isLabel() || !IRFactory.labelsMatch(parent, labelName)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(SimpleFormat.format(UNDEFINED_LABEL, labelName.getString()), this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!parent.isLabel() || !IRFactory.labelsMatch(parent, labelName) || !n.isContinue() || IRFactory.isContinueTarget(parent.getLastChild())) break block8;
                this.errorReporter.error(UNEXPECTED_LABLED_CONTINUE, this.sourceName, n.getLineno(), n.getCharno());
                break block8;
            }
            if (n.isContinue()) {
                Node parent = n.getParent();
                while (!IRFactory.isContinueTarget(parent)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(UNEXPECTED_CONTINUE, this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
            } else {
                Node parent = n.getParent();
                while (!IRFactory.isBreakTarget(parent)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(UNLABELED_BREAK, this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
            }
        }
    }

    private void validateReturn(Node n) {
        if (n.isReturn()) {
            Node parent = n;
            while ((parent = parent.getParent()) != null) {
                if (!parent.isFunction()) continue;
                return;
            }
            this.errorReporter.error(UNEXPECTED_RETURN, this.sourceName, n.getLineno(), n.getCharno());
        }
    }

    private static boolean isBreakTarget(Node n) {
        switch (n.getType()) {
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 163: {
                return true;
            }
        }
        return false;
    }

    private static boolean isContinueTarget(Node n) {
        switch (n.getType()) {
            case 113: 
            case 114: 
            case 115: 
            case 163: {
                return true;
            }
        }
        return false;
    }

    private static boolean labelsMatch(Node label, Node labelName) {
        return label.getFirstChild().getString().equals(labelName.getString());
    }

    private void validateParameters(Node n) {
        if (n.isParamList()) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (!c.isName()) continue;
                for (Node sibling = c.getNext(); sibling != null; sibling = sibling.getNext()) {
                    if (!sibling.isName() || !c.getString().equals(sibling.getString())) continue;
                    this.errorReporter.warning(SimpleFormat.format(DUPLICATE_PARAMETER, c.getString()), this.sourceName, n.getLineno(), n.getCharno());
                }
            }
        }
    }

    private JSDocInfo recordJsDoc(SourceRange location, JSDocInfo info) {
        if (info != null && info.hasTypeInformation()) {
            this.hasJsDocTypeAnnotations = true;
            if (this.hasTypeSyntax) {
                this.errorReporter.error("Can only have JSDoc or inline type annotations, not both", this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
            }
        }
        return info;
    }

    private void recordTypeSyntax(SourceRange location) {
        this.hasTypeSyntax = true;
        if (this.hasJsDocTypeAnnotations) {
            this.errorReporter.error("Can only have JSDoc or inline type annotations, not both", this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
        }
    }

    private void validateLabel(Node n) {
        if (n.isLabel()) {
            Node labelName = n.getFirstChild();
            for (Node parent = n.getParent(); parent != null && !parent.isFunction(); parent = parent.getParent()) {
                if (!parent.isLabel() || !IRFactory.labelsMatch(parent, labelName)) continue;
                this.errorReporter.error(SimpleFormat.format(DUPLICATE_LABEL, labelName.getString()), this.sourceName, n.getLineno(), n.getCharno());
                break;
            }
        }
    }

    private void setFileOverviewJsDoc(Node irNode) {
        JSDocInfo rootNodeJsDoc = this.fileLevelJsDocBuilder.build();
        if (rootNodeJsDoc != null) {
            irNode.setJSDocInfo(rootNodeJsDoc);
        }
        if (this.fileOverviewInfo != null) {
            if (irNode.getJSDocInfo() != null && irNode.getJSDocInfo().getLicense() != null) {
                JSDocInfoBuilder builder = JSDocInfoBuilder.copyFrom(this.fileOverviewInfo);
                builder.recordLicense(irNode.getJSDocInfo().getLicense());
                this.fileOverviewInfo = builder.build();
            }
            irNode.setJSDocInfo(this.fileOverviewInfo);
        }
    }

    private Node transformBlock(ParseTree node) {
        Node irNode = this.transform(node);
        if (!irNode.isBlock()) {
            if (irNode.isEmpty()) {
                irNode.setType(125);
            } else {
                Node newBlock = this.newNode(125, irNode);
                this.setSourceInfo(newBlock, irNode);
                irNode = newBlock;
            }
            irNode.setIsAddedBlock(true);
        }
        return irNode;
    }

    private void handleBlockComment(Comment comment) {
        Pattern p = Pattern.compile("(/|(\n[ \t]*))\\*[ \t]*@[a-zA-Z]+[ \t\n{]");
        if (p.matcher(comment.value).find()) {
            this.errorReporter.warning(SUSPICIOUS_COMMENT_WARNING, this.sourceName, IRFactory.lineno(comment.location.start), IRFactory.charno(comment.location.start));
        }
    }

    private boolean handlePossibleFileOverviewJsDoc(JsDocInfoParser jsDocParser) {
        if (jsDocParser.getFileOverviewJSDocInfo() != this.fileOverviewInfo) {
            this.fileOverviewInfo = jsDocParser.getFileOverviewJSDocInfo();
            if (this.fileOverviewInfo.isExterns()) {
                this.currentFileIsExterns = true;
            }
            return true;
        }
        return false;
    }

    private void handlePossibleFileOverviewJsDoc(Comment comment) {
        JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment);
        this.parsedComments.add(comment);
        this.handlePossibleFileOverviewJsDoc(jsDocParser);
    }

    private Comment getJsDoc(SourceRange location) {
        Comment closestPreviousComment = null;
        while (this.currentComment != null && this.currentComment.location.end.offset <= location.start.offset) {
            if (this.currentComment.type == Comment.Type.JSDOC) {
                closestPreviousComment = this.currentComment;
            }
            if (this.nextCommentIter.hasNext()) {
                this.currentComment = (Comment)this.nextCommentIter.next();
                continue;
            }
            this.currentComment = null;
        }
        return closestPreviousComment;
    }

    private Comment getJsDoc(ParseTree tree) {
        return this.getJsDoc(tree.location);
    }

    private Comment getJsDoc(Token token) {
        return this.getJsDoc(token.location);
    }

    private JSDocInfo handleJsDoc(Comment comment) {
        if (comment != null) {
            JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment);
            this.parsedComments.add(comment);
            if (!this.handlePossibleFileOverviewJsDoc(jsDocParser)) {
                return this.recordJsDoc(comment.location, jsDocParser.retrieveAndResetParsedJSDocInfo());
            }
        }
        return null;
    }

    private JSDocInfo handleJsDoc(ParseTree node) {
        if (!this.shouldAttachJSDocHere(node)) {
            return null;
        }
        return this.handleJsDoc(this.getJsDoc(node));
    }

    private boolean shouldAttachJSDocHere(ParseTree tree) {
        switch (tree.type) {
            case EXPRESSION_STATEMENT: 
            case LABELLED_STATEMENT: {
                return false;
            }
            case CALL_EXPRESSION: 
            case CONDITIONAL_EXPRESSION: 
            case BINARY_OPERATOR: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case POSTFIX_EXPRESSION: {
                ParseTree nearest = IRFactory.findNearestNode(tree);
                return nearest.type != ParseTreeType.PAREN_EXPRESSION;
            }
        }
        return true;
    }

    private static ParseTree findNearestNode(ParseTree tree) {
        block9: while (true) {
            switch (tree.type) {
                case EXPRESSION_STATEMENT: {
                    tree = tree.asExpressionStatement().expression;
                    continue block9;
                }
                case CALL_EXPRESSION: {
                    tree = tree.asCallExpression().operand;
                    continue block9;
                }
                case BINARY_OPERATOR: {
                    tree = tree.asBinaryOperator().left;
                    continue block9;
                }
                case CONDITIONAL_EXPRESSION: {
                    tree = tree.asConditionalExpression().condition;
                    continue block9;
                }
                case MEMBER_EXPRESSION: {
                    tree = tree.asMemberExpression().operand;
                    continue block9;
                }
                case MEMBER_LOOKUP_EXPRESSION: {
                    tree = tree.asMemberLookupExpression().operand;
                    continue block9;
                }
                case POSTFIX_EXPRESSION: {
                    tree = tree.asPostfixExpression().operand;
                    continue block9;
                }
            }
            break;
        }
        return tree;
    }

    private JSDocInfo handleJsDoc(Token token) {
        return this.handleJsDoc(this.getJsDoc(token));
    }

    private Node transform(ParseTree tree) {
        JSDocInfo info = this.handleJsDoc(tree);
        Node node = this.justTransform(tree);
        if (info != null) {
            node = this.maybeInjectCastNode(tree, info, node);
            node.setJSDocInfo(info);
        }
        this.setSourceInfo(node, tree);
        return node;
    }

    private Node maybeInjectCastNode(ParseTree node, JSDocInfo info, Node irNode) {
        if (node.type == ParseTreeType.PAREN_EXPRESSION && info.hasType()) {
            irNode = this.newNode(155, irNode);
        }
        return irNode;
    }

    private Node transformNodeWithInlineJsDoc(ParseTree node, boolean optionalInline) {
        JSDocInfo info = this.handleInlineJsDoc(node, optionalInline);
        Node irNode = this.justTransform(node);
        if (info != null) {
            irNode.setJSDocInfo(info);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private JSDocInfo handleInlineJsDoc(ParseTree node, boolean optional) {
        return this.handleInlineJsDoc(node.location, optional);
    }

    private JSDocInfo handleInlineJsDoc(Token token, boolean optional) {
        return this.handleInlineJsDoc(token.location, optional);
    }

    private JSDocInfo handleInlineJsDoc(SourceRange location, boolean optional) {
        Comment comment = this.getJsDoc(location);
        if (!(comment == null || optional && comment.value.contains("@"))) {
            return this.recordJsDoc(location, this.parseInlineTypeDoc(comment));
        }
        return this.handleJsDoc(comment);
    }

    private Node transformNumberAsString(LiteralToken token) {
        double value = this.normalizeNumber(token);
        Node irNode = this.newStringNode(IRFactory.getStringValue(value));
        JSDocInfo jsDocInfo = this.handleJsDoc(token);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, token);
        return irNode;
    }

    private static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    private static int lineno(ParseTree node) {
        return IRFactory.lineno(node.location.start);
    }

    private static int charno(ParseTree node) {
        return IRFactory.charno(node.location.start);
    }

    private static int lineno(SourcePosition location) {
        return location.line + 1;
    }

    private static int charno(SourcePosition location) {
        return location.column;
    }

    private void setSourceInfo(Node node, Node ref) {
        node.setLineno(ref.getLineno());
        node.setCharno(ref.getCharno());
        this.maybeSetLengthFrom(node, ref);
    }

    private void setSourceInfo(Node irNode, ParseTree node) {
        if (irNode.getLineno() == -1) {
            this.setSourceInfo(irNode, node.location.start, node.location.end);
        }
    }

    private void setSourceInfo(Node irNode, Token token) {
        this.setSourceInfo(irNode, token.location.start, token.location.end);
    }

    private void setSourceInfo(Node node, SourcePosition start, SourcePosition end) {
        if (node.getLineno() == -1) {
            int lineno = IRFactory.lineno(start);
            node.setLineno(lineno);
            int charno = IRFactory.charno(start);
            node.setCharno(charno);
            this.maybeSetLength(node, start, end);
        }
    }

    private JsDocInfoParser createJsDocInfoParser(Comment node) {
        String comment = node.value;
        int lineno = IRFactory.lineno(node.location.start);
        int charno = IRFactory.charno(node.location.start);
        int position = node.location.start.offset;
        int numOpeningChars = 3;
        JsDocInfoParser jsdocParser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, charno + numOpeningChars), comment, position, this.sourceFile, this.config, this.errorReporter);
        jsdocParser.setFileLevelJsDocBuilder(this.fileLevelJsDocBuilder);
        jsdocParser.setFileOverviewJSDocInfo(this.fileOverviewInfo);
        jsdocParser.parse();
        return jsdocParser;
    }

    private JSDocInfo parseInlineTypeDoc(Comment node) {
        String comment = node.value;
        int lineno = IRFactory.lineno(node.location.start);
        int charno = IRFactory.charno(node.location.start);
        int numOpeningChars = 3;
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, charno + numOpeningChars), comment, node.location.start.offset, this.sourceFile, this.config, this.errorReporter);
        return parser.parseInlineTypeDoc();
    }

    private void maybeSetLength(Node node, SourcePosition start, SourcePosition end) {
        if (this.config.isIdeMode) {
            node.setLength(end.offset - start.offset);
        }
    }

    private void maybeSetLengthFrom(Node node, Node ref) {
        if (this.config.isIdeMode) {
            node.setLength(ref.getLength());
        }
    }

    private Node justTransform(ParseTree node) {
        return this.transformDispatcher.process(node);
    }

    private String normalizeRegex(LiteralToken token) {
        String value = token.value;
        int lastSlash = value.lastIndexOf(47);
        return value.substring(1, lastSlash);
    }

    private String normalizeString(LiteralToken token, boolean templateLiteral) {
        String value = token.value;
        if (templateLiteral) {
            value = value.replaceAll("(?<!\\\\)\r(\n)?", "\n");
        }
        int start = templateLiteral ? 0 : 1;
        int cur = value.indexOf(92);
        if (cur == -1) {
            return templateLiteral ? value : value.substring(1, value.length() - 1);
        }
        StringBuilder result = new StringBuilder();
        while (cur != -1) {
            if (cur - start > 0) {
                result.append(value, start, cur);
            }
            char c = value.charAt(++cur);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append(c);
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'v': {
                    result.append('\u000b');
                    break;
                }
                case '\n': {
                    if (this.isEs5OrBetterMode()) {
                        this.errorReporter.warning(STRING_CONTINUATION_WARNING, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                        break;
                    }
                    this.errorReporter.error(STRING_CONTINUATION_ERROR, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char next1 = value.charAt(cur + 1);
                    if (this.inStrictContext() && (c != '0' || IRFactory.isOctalDigit(next1))) {
                        this.errorReporter.warning(OCTAL_STRING_LITERAL_WARNING, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                    }
                    if (!IRFactory.isOctalDigit(next1)) {
                        result.append((char)IRFactory.octaldigit(c));
                        break;
                    }
                    char next2 = value.charAt(cur + 2);
                    if (!IRFactory.isOctalDigit(next2)) {
                        result.append((char)(8 * IRFactory.octaldigit(c) + IRFactory.octaldigit(next1)));
                        ++cur;
                        break;
                    }
                    result.append((char)(64 * IRFactory.octaldigit(c) + 8 * IRFactory.octaldigit(next1) + IRFactory.octaldigit(next2)));
                    cur += 2;
                    break;
                }
                case 'x': {
                    result.append((char)(IRFactory.hexdigit(value.charAt(cur + 1)) * 16 + IRFactory.hexdigit(value.charAt(cur + 2))));
                    cur += 2;
                    break;
                }
                case 'u': {
                    String hexDigits;
                    int escapeEnd;
                    if (value.charAt(cur + 1) != '{') {
                        escapeEnd = cur + 5;
                        hexDigits = value.substring(cur + 1, escapeEnd);
                    } else {
                        escapeEnd = cur + 2;
                        while (Character.digit(value.charAt(escapeEnd), 16) >= 0) {
                            ++escapeEnd;
                        }
                        hexDigits = value.substring(cur + 2, escapeEnd);
                        ++escapeEnd;
                    }
                    result.append(Character.toChars(Integer.parseInt(hexDigits, 16)));
                    cur = escapeEnd - 1;
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            start = cur + 1;
            cur = value.indexOf(92, start);
        }
        result.append(value, start, templateLiteral ? value.length() : value.length() - 1);
        return result.toString();
    }

    boolean isEs6Mode() {
        return this.config.languageMode == Config.LanguageMode.ECMASCRIPT6 || this.config.languageMode == Config.LanguageMode.ECMASCRIPT6_STRICT || this.config.languageMode == Config.LanguageMode.ECMASCRIPT6_TYPED;
    }

    boolean isEs5OrBetterMode() {
        return this.config.languageMode != Config.LanguageMode.ECMASCRIPT3;
    }

    private boolean inStrictContext() {
        return this.config.languageMode == Config.LanguageMode.ECMASCRIPT5_STRICT || this.config.languageMode == Config.LanguageMode.ECMASCRIPT6_STRICT || this.config.languageMode == Config.LanguageMode.ECMASCRIPT6_TYPED;
    }

    double normalizeNumber(LiteralToken token) {
        String value = token.value;
        SourceRange location = token.location;
        int length = value.length();
        Preconditions.checkState((length > 0 ? 1 : 0) != 0);
        Preconditions.checkState((value.charAt(0) != '-' && value.charAt(0) != '+' ? 1 : 0) != 0);
        if (value.charAt(0) == '.') {
            return Double.valueOf('0' + value);
        }
        if (value.charAt(0) == '0' && length > 1) {
            switch (value.charAt(1)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return Double.valueOf(value);
                }
                case 'B': 
                case 'b': {
                    if (!this.isEs6Mode()) {
                        this.errorReporter.warning(BINARY_NUMBER_LITERAL_WARNING, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                    }
                    double v = 0.0;
                    int c = 1;
                    while (++c < length) {
                        v = v * 2.0 + (double)IRFactory.binarydigit(value.charAt(c));
                    }
                    return v;
                }
                case 'O': 
                case 'o': {
                    if (!this.isEs6Mode()) {
                        this.errorReporter.warning(OCTAL_NUMBER_LITERAL_WARNING, this.sourceName, IRFactory.lineno(token.location.start), IRFactory.charno(token.location.start));
                    }
                    double v = 0.0;
                    int c = 1;
                    while (++c < length) {
                        v = v * 8.0 + (double)IRFactory.octaldigit(value.charAt(c));
                    }
                    return v;
                }
                case 'X': 
                case 'x': {
                    double v = 0.0;
                    int c = 1;
                    while (++c < length) {
                        v = v * 16.0 + (double)IRFactory.hexdigit(value.charAt(c));
                    }
                    return v;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.errorReporter.warning(INVALID_ES5_STRICT_OCTAL, this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
                    if (!this.inStrictContext()) {
                        double v = 0.0;
                        int c = 0;
                        while (++c < length) {
                            v = v * 8.0 + (double)IRFactory.octaldigit(value.charAt(c));
                        }
                        return v;
                    }
                    return Double.valueOf(value);
                }
            }
            this.errorReporter.error(INVALID_NUMBER_LITERAL, this.sourceName, IRFactory.lineno(location.start), IRFactory.charno(location.start));
            return 0.0;
        }
        return Double.valueOf(value);
    }

    private static int binarydigit(char c) {
        if (c >= '0' && c <= '1') {
            return c - 48;
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }

    private static int octaldigit(char c) {
        if (IRFactory.isOctalDigit(c)) {
            return c - 48;
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static int hexdigit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static int transformBooleanTokenType(TokenType token) {
        switch (token) {
            case TRUE: {
                return 44;
            }
            case FALSE: {
                return 43;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private static int transformPostfixTokenType(TokenType token) {
        switch (token) {
            case PLUS_PLUS: {
                return 102;
            }
            case MINUS_MINUS: {
                return 103;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private static int transformUnaryTokenType(TokenType token) {
        switch (token) {
            case BANG: {
                return 26;
            }
            case TILDE: {
                return 27;
            }
            case PLUS: {
                return 28;
            }
            case MINUS: {
                return 29;
            }
            case DELETE: {
                return 31;
            }
            case TYPEOF: {
                return 32;
            }
            case PLUS_PLUS: {
                return 102;
            }
            case MINUS_MINUS: {
                return 103;
            }
            case VOID: {
                return 122;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private static int transformBinaryTokenType(TokenType token) {
        switch (token) {
            case BAR: {
                return 9;
            }
            case CARET: {
                return 10;
            }
            case AMPERSAND: {
                return 11;
            }
            case EQUAL_EQUAL: {
                return 12;
            }
            case NOT_EQUAL: {
                return 13;
            }
            case OPEN_ANGLE: {
                return 14;
            }
            case LESS_EQUAL: {
                return 15;
            }
            case CLOSE_ANGLE: {
                return 16;
            }
            case GREATER_EQUAL: {
                return 17;
            }
            case LEFT_SHIFT: {
                return 18;
            }
            case RIGHT_SHIFT: {
                return 19;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return 20;
            }
            case PLUS: {
                return 21;
            }
            case MINUS: {
                return 22;
            }
            case STAR: {
                return 23;
            }
            case SLASH: {
                return 24;
            }
            case PERCENT: {
                return 25;
            }
            case EQUAL_EQUAL_EQUAL: {
                return 45;
            }
            case NOT_EQUAL_EQUAL: {
                return 46;
            }
            case IN: {
                return 51;
            }
            case INSTANCEOF: {
                return 52;
            }
            case COMMA: {
                return 85;
            }
            case EQUAL: {
                return 86;
            }
            case BAR_EQUAL: {
                return 87;
            }
            case CARET_EQUAL: {
                return 88;
            }
            case AMPERSAND_EQUAL: {
                return 89;
            }
            case LEFT_SHIFT_EQUAL: {
                return 90;
            }
            case RIGHT_SHIFT_EQUAL: {
                return 91;
            }
            case UNSIGNED_RIGHT_SHIFT_EQUAL: {
                return 92;
            }
            case PLUS_EQUAL: {
                return 93;
            }
            case MINUS_EQUAL: {
                return 94;
            }
            case STAR_EQUAL: {
                return 95;
            }
            case SLASH_EQUAL: {
                return 96;
            }
            case PERCENT_EQUAL: {
                return 97;
            }
            case OR: {
                return 100;
            }
            case AND: {
                return 101;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private Node newNode(int type) {
        return new Node(type).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1) {
        return new Node(type, child1).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1, Node child2) {
        return new Node(type, child1, child2).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1, Node child2, Node child3) {
        return new Node(type, child1, child2, child3).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String value) {
        return IR.string(value).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(int type, String value) {
        return Node.newString(type, value).clonePropsFrom(this.templateNode);
    }

    private Node newNumberNode(Double value) {
        return IR.number(value).clonePropsFrom(this.templateNode);
    }

    private Node cloneProps(Node n) {
        if (!n.hasProps()) {
            n.clonePropsFrom(this.templateNode);
        }
        for (Node child : n.children()) {
            this.cloneProps(child);
        }
        return n;
    }

    private class TransformDispatcher {
        private TransformDispatcher() {
        }

        private Node processObjectLitKeyAsString(Token token) {
            Node ret;
            if (token == null) {
                return this.createMissingExpressionNode();
            }
            if (token.type == TokenType.IDENTIFIER) {
                ret = this.processName(token.asIdentifier(), true);
            } else if (token.type == TokenType.NUMBER) {
                ret = IRFactory.this.transformNumberAsString(token.asLiteral());
                ret.putBooleanProp(36, true);
            } else {
                ret = this.processString(token.asLiteral());
                ret.putBooleanProp(36, true);
            }
            Preconditions.checkState((boolean)ret.isString());
            return ret;
        }

        Node processComprehension(ComprehensionTree tree) {
            return this.unsupportedLanguageFeature(tree, "array/generator comprehensions");
        }

        Node processComprehensionFor(ComprehensionForTree tree) {
            return this.unsupportedLanguageFeature(tree, "array/generator comprehensions");
        }

        Node processComprehensionIf(ComprehensionIfTree tree) {
            return this.unsupportedLanguageFeature(tree, "array/generator comprehensions");
        }

        Node processArrayLiteral(ArrayLiteralExpressionTree tree) {
            Node node = IRFactory.this.newNode(63);
            for (ParseTree child : tree.elements) {
                Node c = IRFactory.this.transform(child);
                node.addChildToBack(c);
            }
            return node;
        }

        Node processArrayPattern(ArrayPatternTree tree) {
            this.maybeWarnEs6Feature(tree, "destructuring");
            Node node = IRFactory.this.newNode(156);
            for (ParseTree child : tree.elements) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processObjectPattern(ObjectPatternTree tree) {
            this.maybeWarnEs6Feature(tree, "destructuring");
            Node node = IRFactory.this.newNode(157);
            for (ParseTree child : tree.fields) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processAssignmentRestElement(AssignmentRestElementTree tree) {
            return IRFactory.this.newStringNode(173, tree.identifier.value);
        }

        Node processAstRoot(ProgramTree rootNode) {
            Node node = IRFactory.this.newNode(132);
            for (ParseTree child : rootNode.sourceElements) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            this.parseDirectives(node);
            return node;
        }

        private void parseDirectives(Node node) {
            HashSet<String> directives = null;
            while (this.isDirective(node.getFirstChild())) {
                String directive = node.removeFirstChild().getFirstChild().getString();
                if (directives == null) {
                    directives = new HashSet<String>();
                }
                directives.add(directive);
            }
            if (directives != null) {
                node.setDirectives(directives);
            }
        }

        private boolean isDirective(Node n) {
            if (n == null) {
                return false;
            }
            int nType = n.getType();
            return nType == 130 && n.getFirstChild().isString() && ALLOWED_DIRECTIVES.contains((Object)n.getFirstChild().getString());
        }

        Node processBlock(BlockTree blockNode) {
            Node node = IRFactory.this.newNode(125);
            for (ParseTree child : blockNode.statements) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processBreakStatement(BreakStatementTree statementNode) {
            Node node = IRFactory.this.newNode(116);
            if (statementNode.getLabel() != null) {
                Node labelName = this.transformLabelName(statementNode.name);
                node.addChildToBack(labelName);
            }
            return node;
        }

        Node transformLabelName(IdentifierToken token) {
            Node label = IRFactory.this.newStringNode(153, token.value);
            IRFactory.this.setSourceInfo(label, token);
            return label;
        }

        Node processConditionalExpression(ConditionalExpressionTree exprNode) {
            return IRFactory.this.newNode(98, IRFactory.this.transform(exprNode.condition), IRFactory.this.transform(exprNode.left), IRFactory.this.transform(exprNode.right));
        }

        Node processContinueStatement(ContinueStatementTree statementNode) {
            Node node = IRFactory.this.newNode(117);
            if (statementNode.getLabel() != null) {
                Node labelName = this.transformLabelName(statementNode.name);
                node.addChildToBack(labelName);
            }
            return node;
        }

        Node processDoLoop(DoWhileStatementTree loopNode) {
            return IRFactory.this.newNode(114, IRFactory.this.transformBlock(loopNode.body), IRFactory.this.transform(loopNode.condition));
        }

        Node processElementGet(MemberLookupExpressionTree getNode) {
            return IRFactory.this.newNode(35, IRFactory.this.transform(getNode.operand), IRFactory.this.transform(getNode.memberExpression));
        }

        Node processEmptyStatement(EmptyStatementTree exprNode) {
            return IRFactory.this.newNode(124);
        }

        Node processExpressionStatement(ExpressionStatementTree statementNode) {
            Node node = IRFactory.this.newNode(130);
            node.addChildToBack(IRFactory.this.transform(statementNode.expression));
            return node;
        }

        Node processForInLoop(ForInStatementTree loopNode) {
            Node initializer = IRFactory.this.transform(loopNode.initializer);
            ImmutableSet invalidInitializers = ImmutableSet.of((Object)63, (Object)64);
            if (invalidInitializers.contains((Object)initializer.getType())) {
                IRFactory.this.errorReporter.error("Invalid LHS for a for-in loop", IRFactory.this.sourceName, IRFactory.lineno(loopNode.initializer), IRFactory.charno(loopNode.initializer));
            }
            return IRFactory.this.newNode(115, initializer, IRFactory.this.transform(loopNode.collection), IRFactory.this.transformBlock(loopNode.body));
        }

        Node processForOf(ForOfStatementTree loopNode) {
            this.maybeWarnEs6Feature(loopNode, "for-of loop");
            Node initializer = IRFactory.this.transform(loopNode.initializer);
            ImmutableSet invalidInitializers = ImmutableSet.of((Object)63, (Object)64);
            if (invalidInitializers.contains((Object)initializer.getType())) {
                IRFactory.this.errorReporter.error("Invalid LHS for a for-of loop", IRFactory.this.sourceName, IRFactory.lineno(loopNode.initializer), IRFactory.charno(loopNode.initializer));
            }
            return IRFactory.this.newNode(163, initializer, IRFactory.this.transform(loopNode.collection), IRFactory.this.transformBlock(loopNode.body));
        }

        Node processForLoop(ForStatementTree loopNode) {
            Node node = IRFactory.this.newNode(115, this.transformOrEmpty(loopNode.initializer, (ParseTree)loopNode), this.transformOrEmpty(loopNode.condition, (ParseTree)loopNode), this.transformOrEmpty(loopNode.increment, (ParseTree)loopNode));
            node.addChildToBack(IRFactory.this.transformBlock(loopNode.body));
            return node;
        }

        Node transformOrEmpty(ParseTree tree, ParseTree parent) {
            if (tree == null) {
                Node n = IRFactory.this.newNode(124);
                IRFactory.this.setSourceInfo(n, parent);
                return n;
            }
            return IRFactory.this.transform(tree);
        }

        Node transformOrEmpty(IdentifierToken token, ParseTree parent) {
            if (token == null) {
                Node n = IRFactory.this.newNode(124);
                IRFactory.this.setSourceInfo(n, parent);
                return n;
            }
            return this.processName(token);
        }

        Node processFunctionCall(CallExpressionTree callNode) {
            Node node = IRFactory.this.newNode(37, IRFactory.this.transform(callNode.operand));
            for (ParseTree child : callNode.arguments.arguments) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processFunction(FunctionDeclarationTree functionTree) {
            Node result;
            Node newName;
            IdentifierToken name;
            boolean isSignature;
            boolean isDeclaration = functionTree.kind == FunctionDeclarationTree.Kind.DECLARATION;
            boolean isMember = functionTree.kind == FunctionDeclarationTree.Kind.MEMBER;
            boolean isArrow = functionTree.kind == FunctionDeclarationTree.Kind.ARROW;
            boolean isGenerator = functionTree.isGenerator;
            boolean bl = isSignature = functionTree.functionBody.type == ParseTreeType.EMPTY_STATEMENT;
            if (!IRFactory.this.isEs6Mode()) {
                if (isGenerator) {
                    this.maybeWarnEs6Feature(functionTree, "generators");
                }
                if (isMember) {
                    this.maybeWarnEs6Feature(functionTree, "member declarations");
                }
                if (isArrow) {
                    this.maybeWarnEs6Feature(functionTree, "short function syntax");
                }
            }
            if ((name = functionTree.name) != null) {
                newName = this.processNameWithInlineJSDoc(name);
            } else {
                if (isDeclaration || isMember) {
                    IRFactory.this.errorReporter.error("unnamed function statement", IRFactory.this.sourceName, IRFactory.lineno(functionTree), IRFactory.charno(functionTree));
                    newName = this.createMissingNameNode();
                } else {
                    newName = IRFactory.this.newStringNode(38, "");
                }
                IRFactory.this.setSourceInfo(newName, functionTree);
            }
            Node node = IRFactory.this.newNode(105);
            if (!isMember) {
                node.addChildToBack(newName);
            } else {
                Node emptyName = IRFactory.this.newStringNode(38, "");
                IRFactory.this.setSourceInfo(emptyName, functionTree);
                node.addChildToBack(emptyName);
            }
            this.maybeProcessGenerics(node.getFirstChild(), functionTree.generics);
            node.addChildToBack(IRFactory.this.transform(functionTree.formalParameterList));
            this.maybeProcessType(node, functionTree.returnType);
            Node bodyNode = IRFactory.this.transform(functionTree.functionBody);
            if (!(isArrow || isSignature || bodyNode.isBlock())) {
                Preconditions.checkState((boolean)((IRFactory)IRFactory.this).config.isIdeMode);
                bodyNode = IR.block();
            }
            this.parseDirectives(bodyNode);
            node.addChildToBack(bodyNode);
            node.setIsGeneratorFunction(isGenerator);
            node.setIsArrowFunction(isArrow);
            node.putBooleanProp(80, functionTree.isOptional);
            if (functionTree.kind == FunctionDeclarationTree.Kind.MEMBER) {
                IRFactory.this.setSourceInfo(node, functionTree);
                Node member = IRFactory.this.newStringNode(160, name.value);
                member.addChildToBack(node);
                member.setStaticMember(functionTree.isStatic);
                this.maybeProcessAccessibilityModifier(member, functionTree, functionTree.access);
                node.setDeclaredTypeExpression(node.getDeclaredTypeExpression());
                result = member;
            } else {
                result = node;
            }
            return result;
        }

        Node processFormalParameterList(FormalParameterListTree tree) {
            Node params = IRFactory.this.newNode(83);
            if (this.checkParameters(tree.parameters)) {
                for (ParseTree param : tree.parameters) {
                    Node paramNode = IRFactory.this.transformNodeWithInlineJsDoc(param, false);
                    Preconditions.checkState((paramNode.isName() || paramNode.isRest() || paramNode.isArrayPattern() || paramNode.isObjectPattern() || paramNode.isDefaultValue() ? 1 : 0) != 0);
                    params.addChildToBack(paramNode);
                }
            }
            return params;
        }

        Node processDefaultParameter(DefaultParameterTree tree) {
            this.maybeWarnEs6Feature(tree, "default parameters");
            return IRFactory.this.newNode(179, IRFactory.this.transform(tree.lhs), IRFactory.this.transform(tree.defaultValue));
        }

        Node processRestParameter(RestParameterTree tree) {
            this.maybeWarnEs6Feature(tree, "rest parameters");
            return IRFactory.this.newStringNode(173, tree.identifier.value);
        }

        Node processSpreadExpression(SpreadExpressionTree tree) {
            this.maybeWarnEs6Feature(tree, "spread expression");
            return IRFactory.this.newNode(174, IRFactory.this.transform(tree.expression));
        }

        Node processIfStatement(IfStatementTree statementNode) {
            Node node = IRFactory.this.newNode(108);
            node.addChildToBack(IRFactory.this.transform(statementNode.condition));
            node.addChildToBack(IRFactory.this.transformBlock(statementNode.ifClause));
            if (statementNode.elseClause != null) {
                node.addChildToBack(IRFactory.this.transformBlock(statementNode.elseClause));
            }
            return node;
        }

        Node processBinaryExpression(BinaryOperatorTree exprNode) {
            return IRFactory.this.newNode(IRFactory.transformBinaryTokenType(exprNode.operator.type), IRFactory.this.transform(exprNode.left), IRFactory.this.transform(exprNode.right));
        }

        Node processDebuggerStatement(DebuggerStatementTree node) {
            return IRFactory.this.newNode(152);
        }

        Node processThisExpression(ThisExpressionTree node) {
            return IRFactory.this.newNode(42);
        }

        Node processLabeledStatement(LabelledStatementTree labelTree) {
            return IRFactory.this.newNode(126, this.transformLabelName(labelTree.name), IRFactory.this.transform(labelTree.statement));
        }

        Node processName(IdentifierExpressionTree nameNode) {
            return this.processName(nameNode, false);
        }

        Node processName(IdentifierExpressionTree nameNode, boolean asString) {
            return this.processName(nameNode.identifierToken, asString);
        }

        Node processName(IdentifierToken identifierToken) {
            return this.processName(identifierToken, false);
        }

        Node processName(IdentifierToken identifierToken, boolean asString) {
            Node node;
            if (asString) {
                node = IRFactory.this.newStringNode(40, identifierToken.value);
            } else {
                JSDocInfo info = IRFactory.this.handleJsDoc(identifierToken);
                if (this.isReservedKeyword(identifierToken.toString())) {
                    IRFactory.this.errorReporter.error("identifier is a reserved word", IRFactory.this.sourceName, IRFactory.lineno(identifierToken.location.start), IRFactory.charno(identifierToken.location.start));
                }
                node = IRFactory.this.newStringNode(38, identifierToken.value);
                if (info != null) {
                    node.setJSDocInfo(info);
                }
            }
            IRFactory.this.setSourceInfo(node, identifierToken);
            return node;
        }

        Node processString(LiteralToken token) {
            Preconditions.checkArgument((token.type == TokenType.STRING ? 1 : 0) != 0);
            Node node = IRFactory.this.newStringNode(40, IRFactory.this.normalizeString(token, false));
            IRFactory.this.setSourceInfo(node, token);
            return node;
        }

        Node processTemplateLiteralToken(LiteralToken token) {
            Preconditions.checkArgument((token.type == TokenType.NO_SUBSTITUTION_TEMPLATE || token.type == TokenType.TEMPLATE_HEAD || token.type == TokenType.TEMPLATE_MIDDLE || token.type == TokenType.TEMPLATE_TAIL ? 1 : 0) != 0);
            Node node = IRFactory.this.newStringNode(IRFactory.this.normalizeString(token, true));
            node.putProp(71, token.value);
            IRFactory.this.setSourceInfo(node, token);
            return node;
        }

        Node processNameWithInlineJSDoc(IdentifierToken identifierToken) {
            JSDocInfo info = IRFactory.this.handleInlineJsDoc(identifierToken, true);
            if (this.isReservedKeyword(identifierToken.toString())) {
                IRFactory.this.errorReporter.error("identifier is a reserved word", IRFactory.this.sourceName, IRFactory.lineno(identifierToken.location.start), IRFactory.charno(identifierToken.location.start));
            }
            Node node = IRFactory.this.newStringNode(38, identifierToken.toString());
            if (info != null) {
                node.setJSDocInfo(info);
            }
            IRFactory.this.setSourceInfo(node, identifierToken);
            return node;
        }

        private boolean isAllowedProp(String identifier) {
            if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                return !TokenStream.isKeyword(identifier);
            }
            return true;
        }

        private boolean isReservedKeyword(String identifier) {
            if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                return TokenStream.isKeyword(identifier);
            }
            return IRFactory.this.reservedKeywords != null && IRFactory.this.reservedKeywords.contains(identifier);
        }

        Node processNewExpression(NewExpressionTree exprNode) {
            Node node = IRFactory.this.newNode(30, IRFactory.this.transform(exprNode.operand));
            if (exprNode.arguments != null) {
                for (ParseTree arg : exprNode.arguments.arguments) {
                    node.addChildToBack(IRFactory.this.transform(arg));
                }
            }
            return node;
        }

        Node processNumberLiteral(LiteralExpressionTree literalNode) {
            double value = IRFactory.this.normalizeNumber(literalNode.literalToken.asLiteral());
            Node number = IRFactory.this.newNumberNode(value);
            IRFactory.this.setSourceInfo(number, literalNode);
            return number;
        }

        Node processObjectLiteral(ObjectLiteralExpressionTree objTree) {
            Node node = IRFactory.this.newNode(64);
            boolean maybeWarn = false;
            for (ParseTree el : objTree.propertyNameAndValues) {
                Node key;
                if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                    if (el.type == ParseTreeType.GET_ACCESSOR) {
                        this.reportGetter(el);
                        continue;
                    }
                    if (el.type == ParseTreeType.SET_ACCESSOR) {
                        this.reportSetter(el);
                        continue;
                    }
                }
                if (!((key = IRFactory.this.transform(el)).isComputedProp() || key.isQuotedString() || IRFactory.this.currentFileIsExterns || this.isAllowedProp(key.getString()))) {
                    IRFactory.this.errorReporter.warning(IRFactory.INVALID_ES3_PROP_NAME, IRFactory.this.sourceName, key.getLineno(), key.getCharno());
                }
                if (key.getFirstChild() == null) {
                    maybeWarn = true;
                }
                node.addChildToBack(key);
            }
            if (maybeWarn) {
                this.maybeWarnEs6Feature(objTree, "extended object literals");
            }
            return node;
        }

        Node processComputedPropertyDefinition(ComputedPropertyDefinitionTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            return IRFactory.this.newNode(175, IRFactory.this.transform(tree.property), IRFactory.this.transform(tree.value));
        }

        Node processComputedPropertyMemberVariable(ComputedPropertyMemberVariableTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            this.maybeWarnTypeSyntax(tree, "computed property");
            Node n = IRFactory.this.newNode(175, IRFactory.this.transform(tree.property));
            this.maybeProcessType(n, tree.declaredType);
            n.putBooleanProp(75, true);
            n.putProp(84, (Object)tree.access);
            n.setStaticMember(tree.isStatic);
            this.maybeProcessAccessibilityModifier(n, tree, tree.access);
            return n;
        }

        Node processComputedPropertyMethod(ComputedPropertyMethodTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            Node n = IRFactory.this.newNode(175, IRFactory.this.transform(tree.property), IRFactory.this.transform(tree.method));
            n.putBooleanProp(72, true);
            if (tree.method.asFunctionDeclaration().isStatic) {
                n.setStaticMember(true);
            }
            this.maybeProcessAccessibilityModifier(n, tree, tree.access);
            return n;
        }

        Node processComputedPropertyGetter(ComputedPropertyGetterTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            Node key = IRFactory.this.transform(tree.property);
            Node body = IRFactory.this.transform(tree.body);
            Node function = IR.function(IR.name(""), IR.paramList(), body);
            function.useSourceInfoIfMissingFromForTree(body);
            Node n = IRFactory.this.newNode(175, key, function);
            n.putBooleanProp(73, true);
            return n;
        }

        Node processComputedPropertySetter(ComputedPropertySetterTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            Node key = IRFactory.this.transform(tree.property);
            Node body = IRFactory.this.transform(tree.body);
            Node paramList = IR.paramList(this.safeProcessName(tree.parameter));
            Node function = IR.function(IR.name(""), paramList, body);
            function.useSourceInfoIfMissingFromForTree(body);
            Node n = IRFactory.this.newNode(175, key, function);
            n.putBooleanProp(74, true);
            return n;
        }

        Node processGetAccessor(GetAccessorTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.propertyName);
            key.setType(147);
            Node body = IRFactory.this.transform(tree.body);
            Node dummyName = IR.name("");
            IRFactory.this.setSourceInfo(dummyName, tree.body);
            Node paramList = IR.paramList();
            IRFactory.this.setSourceInfo(paramList, tree.body);
            Node value = IRFactory.this.newNode(105, dummyName, paramList, body);
            IRFactory.this.setSourceInfo(value, tree.body);
            key.addChildToFront(value);
            key.setStaticMember(tree.isStatic);
            return key;
        }

        Node processSetAccessor(SetAccessorTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.propertyName);
            key.setType(148);
            Node body = IRFactory.this.transform(tree.body);
            Node dummyName = IR.name("");
            IRFactory.this.setSourceInfo(dummyName, tree.propertyName);
            Node paramList = IR.paramList(this.safeProcessName(tree.parameter));
            IRFactory.this.setSourceInfo(paramList, tree.parameter);
            Node value = IRFactory.this.newNode(105, dummyName, paramList, body);
            IRFactory.this.setSourceInfo(value, tree.body);
            key.addChildToFront(value);
            key.setStaticMember(tree.isStatic);
            return key;
        }

        Node processPropertyNameAssignment(PropertyNameAssignmentTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.name);
            key.setType(154);
            if (tree.value != null) {
                key.addChildToFront(IRFactory.this.transform(tree.value));
            }
            return key;
        }

        private Node safeProcessName(IdentifierToken identifierToken) {
            if (identifierToken == null) {
                return this.createMissingExpressionNode();
            }
            return this.processName(identifierToken);
        }

        Node processParenthesizedExpression(ParenExpressionTree exprNode) {
            return IRFactory.this.transform(exprNode.expression);
        }

        Node processPropertyGet(MemberExpressionTree getNode) {
            Node leftChild = IRFactory.this.transform(getNode.operand);
            IdentifierToken nodeProp = getNode.memberName;
            Node rightChild = this.processObjectLitKeyAsString(nodeProp);
            if (!(rightChild.isQuotedString() || IRFactory.this.currentFileIsExterns || this.isAllowedProp(rightChild.getString()))) {
                IRFactory.this.errorReporter.warning(IRFactory.INVALID_ES3_PROP_NAME, IRFactory.this.sourceName, rightChild.getLineno(), rightChild.getCharno());
            }
            return IRFactory.this.newNode(33, leftChild, rightChild);
        }

        Node processRegExpLiteral(LiteralExpressionTree literalTree) {
            LiteralToken token = literalTree.literalToken.asLiteral();
            Node literalStringNode = IRFactory.this.newStringNode(IRFactory.this.normalizeRegex(token));
            IRFactory.this.setSourceInfo(literalStringNode, token);
            Node node = IRFactory.this.newNode(47, literalStringNode);
            String rawRegex = token.value;
            int lastSlash = rawRegex.lastIndexOf(47);
            String flags = "";
            if (lastSlash < rawRegex.length()) {
                flags = rawRegex.substring(lastSlash + 1);
            }
            this.validateRegExpFlags(literalTree, flags);
            if (!flags.isEmpty()) {
                Node flagsNode = IRFactory.this.newStringNode(flags);
                IRFactory.this.setSourceInfo(flagsNode, token);
                node.addChildToBack(flagsNode);
            }
            return node;
        }

        private void validateRegExpFlags(LiteralExpressionTree tree, String flags) {
            UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)flags).iterator();
            block4: while (unmodifiableIterator.hasNext()) {
                char flag = ((Character)unmodifiableIterator.next()).charValue();
                switch (flag) {
                    case 'g': 
                    case 'i': 
                    case 'm': {
                        continue block4;
                    }
                    case 'u': 
                    case 'y': {
                        this.maybeWarnEs6Feature(tree, "new RegExp flag '" + flag + "'");
                        continue block4;
                    }
                }
                IRFactory.this.errorReporter.error("Invalid RegExp flag '" + flag + "'", IRFactory.this.sourceName, IRFactory.lineno(tree), IRFactory.charno(tree));
            }
        }

        Node processReturnStatement(ReturnStatementTree statementNode) {
            Node node = IRFactory.this.newNode(4);
            if (statementNode.expression != null) {
                node.addChildToBack(IRFactory.this.transform(statementNode.expression));
            }
            return node;
        }

        Node processStringLiteral(LiteralExpressionTree literalTree) {
            LiteralToken token = literalTree.literalToken.asLiteral();
            Node n = this.processString(token);
            String value = n.getString();
            if (value.indexOf(11) != -1) {
                int start = token.location.start.offset;
                int end = token.location.end.offset;
                if (start < IRFactory.this.sourceString.length() && IRFactory.this.sourceString.substring(start, Math.min(IRFactory.this.sourceString.length(), end)).contains("\\v")) {
                    n.putBooleanProp(54, true);
                }
            }
            return n;
        }

        Node processTemplateLiteral(TemplateLiteralExpressionTree tree) {
            this.maybeWarnEs6Feature(tree, "template literals");
            Node templateLitNode = IRFactory.this.newNode(177);
            IRFactory.this.setSourceInfo(templateLitNode, tree);
            Node node = tree.operand == null ? templateLitNode : IRFactory.this.newNode(176, IRFactory.this.transform(tree.operand), templateLitNode);
            for (ParseTree child : tree.elements) {
                templateLitNode.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processTemplateLiteralPortion(TemplateLiteralPortionTree tree) {
            return this.processTemplateLiteralToken(tree.value.asLiteral());
        }

        Node processTemplateSubstitution(TemplateSubstitutionTree tree) {
            return IRFactory.this.newNode(178, IRFactory.this.transform(tree.expression));
        }

        Node processSwitchCase(CaseClauseTree caseNode) {
            ParseTree expr = caseNode.expression;
            Node node = IRFactory.this.newNode(111, IRFactory.this.transform(expr));
            Node block = IRFactory.this.newNode(125);
            block.putBooleanProp(38, true);
            IRFactory.this.setSourceInfo(block, caseNode);
            if (caseNode.statements != null) {
                for (ParseTree child : caseNode.statements) {
                    block.addChildToBack(IRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        Node processSwitchDefault(DefaultClauseTree caseNode) {
            Node node = IRFactory.this.newNode(112);
            Node block = IRFactory.this.newNode(125);
            block.putBooleanProp(38, true);
            IRFactory.this.setSourceInfo(block, caseNode);
            if (caseNode.statements != null) {
                for (ParseTree child : caseNode.statements) {
                    block.addChildToBack(IRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        Node processSwitchStatement(SwitchStatementTree statementNode) {
            Node node = IRFactory.this.newNode(110, IRFactory.this.transform(statementNode.expression));
            for (ParseTree child : statementNode.caseClauses) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        Node processThrowStatement(ThrowStatementTree statementNode) {
            return IRFactory.this.newNode(49, IRFactory.this.transform(statementNode.value));
        }

        Node processTryStatement(TryStatementTree statementNode) {
            Node node = IRFactory.this.newNode(77, IRFactory.this.transformBlock(statementNode.body));
            Node block = IRFactory.this.newNode(125);
            boolean lineSet = false;
            ParseTree cc = statementNode.catchBlock;
            if (cc != null) {
                IRFactory.this.setSourceInfo(block, cc);
                lineSet = true;
                block.addChildToBack(IRFactory.this.transform(cc));
            }
            node.addChildToBack(block);
            ParseTree finallyBlock = statementNode.finallyBlock;
            if (finallyBlock != null) {
                node.addChildToBack(IRFactory.this.transformBlock(finallyBlock));
            }
            if (!lineSet && finallyBlock != null) {
                IRFactory.this.setSourceInfo(block, finallyBlock);
            }
            return node;
        }

        Node processCatchClause(CatchTree clauseNode) {
            return IRFactory.this.newNode(120, IRFactory.this.transform(clauseNode.exception), IRFactory.this.transformBlock(clauseNode.catchBody));
        }

        Node processFinally(FinallyTree finallyNode) {
            return IRFactory.this.transformBlock(finallyNode.block);
        }

        Node processUnaryExpression(UnaryExpressionTree exprNode) {
            int type = IRFactory.transformUnaryTokenType(exprNode.operator.type);
            Node operand = IRFactory.this.transform(exprNode.operand);
            if (type == 29 && operand.isNumber()) {
                operand.setDouble(-operand.getDouble());
                return operand;
            }
            if (!(type != 31 || operand.isGetProp() || operand.isGetElem() || operand.isName())) {
                String msg = "Invalid delete operand. Only properties can be deleted.";
                IRFactory.this.errorReporter.error(msg, IRFactory.this.sourceName, operand.getLineno(), 0);
            }
            return IRFactory.this.newNode(type, operand);
        }

        Node processPostfixExpression(PostfixExpressionTree exprNode) {
            int type = IRFactory.transformPostfixTokenType(exprNode.operator.type);
            Node node = IRFactory.this.newNode(type, IRFactory.this.transform(exprNode.operand));
            node.putBooleanProp(32, true);
            return node;
        }

        Node processVariableStatement(VariableStatementTree stmt) {
            return IRFactory.this.justTransform(stmt.declarations);
        }

        Node processVariableDeclarationList(VariableDeclarationListTree decl) {
            int declType;
            switch (decl.declarationType) {
                case CONST: {
                    this.maybeWarnEs6Feature(decl, "const declarations");
                    declType = 149;
                    break;
                }
                case LET: {
                    this.maybeWarnEs6Feature(decl, "let declarations");
                    declType = 162;
                    break;
                }
                case VAR: {
                    declType = 118;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Node node = IRFactory.this.newNode(declType);
            for (VariableDeclarationTree child : decl.declarations) {
                node.addChildToBack(IRFactory.this.transformNodeWithInlineJsDoc(child, true));
            }
            return node;
        }

        Node processVariableDeclaration(VariableDeclarationTree decl) {
            Node node = IRFactory.this.transformNodeWithInlineJsDoc(decl.lvalue, true);
            if (decl.initializer != null) {
                Node initializer = IRFactory.this.transform(decl.initializer);
                node.addChildToBack(initializer);
                IRFactory.this.maybeSetLength(node, decl.location.start, decl.location.end);
            }
            this.maybeProcessType(node, decl.declaredType);
            return node;
        }

        Node processWhileLoop(WhileStatementTree stmt) {
            return IRFactory.this.newNode(113, IRFactory.this.transform(stmt.condition), IRFactory.this.transformBlock(stmt.body));
        }

        Node processWithStatement(WithStatementTree stmt) {
            return IRFactory.this.newNode(119, IRFactory.this.transform(stmt.expression), IRFactory.this.transformBlock(stmt.body));
        }

        Node processMissingExpression(MissingPrimaryExpressionTree tree) {
            return this.createMissingExpressionNode();
        }

        private Node createMissingNameNode() {
            return IRFactory.this.newStringNode(38, "__missing_name__");
        }

        private Node createMissingExpressionNode() {
            return IRFactory.this.newStringNode(38, "__missing_expression__");
        }

        Node processIllegalToken(ParseTree node) {
            IRFactory.this.errorReporter.error("Unsupported syntax: " + (Object)((Object)node.type), IRFactory.this.sourceName, IRFactory.lineno(node), 0);
            return IRFactory.this.newNode(124);
        }

        void reportGetter(ParseTree node) {
            IRFactory.this.errorReporter.error(IRFactory.GETTER_ERROR_MESSAGE, IRFactory.this.sourceName, IRFactory.lineno(node), 0);
        }

        void reportSetter(ParseTree node) {
            IRFactory.this.errorReporter.error(IRFactory.SETTER_ERROR_MESSAGE, IRFactory.this.sourceName, IRFactory.lineno(node), 0);
        }

        Node processBooleanLiteral(LiteralExpressionTree literal) {
            return IRFactory.this.newNode(IRFactory.transformBooleanTokenType(literal.literalToken.type));
        }

        Node processNullLiteral(LiteralExpressionTree literal) {
            return IRFactory.this.newNode(41);
        }

        Node processNull(NullTree literal) {
            return IRFactory.this.newNode(124);
        }

        Node processCommaExpression(CommaExpressionTree tree) {
            Node root = IRFactory.this.newNode(85);
            SourcePosition start = ((ParseTree)tree.expressions.get((int)0)).location.start;
            SourcePosition end = ((ParseTree)tree.expressions.get((int)1)).location.end;
            IRFactory.this.setSourceInfo(root, start, end);
            for (ParseTree expr : tree.expressions) {
                int count = root.getChildCount();
                if (count < 2) {
                    root.addChildrenToBack(IRFactory.this.transform(expr));
                    continue;
                }
                end = expr.location.end;
                root = IRFactory.this.newNode(85, root, IRFactory.this.transform(expr));
                IRFactory.this.setSourceInfo(root, start, end);
            }
            return root;
        }

        Node processClassDeclaration(ClassDeclarationTree tree) {
            this.maybeWarnEs6Feature(tree, "class");
            Node name = this.transformOrEmpty(tree.name, (ParseTree)tree);
            this.maybeProcessGenerics(name, tree.generics);
            Node superClass = this.transformOrEmpty(tree.superClass, (ParseTree)tree);
            Node interfaces = this.transformListOrEmpty(316, tree.interfaces);
            Node body = IRFactory.this.newNode(159);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.elements) {
                if (child.type == ParseTreeType.MEMBER_VARIABLE || child.type == ParseTreeType.COMPUTED_PROPERTY_MEMBER_VARIABLE) {
                    this.maybeWarnTypeSyntax(child, "member variable in class");
                }
                body.addChildToBack(IRFactory.this.transform(child));
            }
            Node classNode = IRFactory.this.newNode(158, name, superClass, body);
            if (!interfaces.isEmpty()) {
                this.maybeWarnTypeSyntax(tree, "implements");
                classNode.putProp(82, interfaces);
            }
            return classNode;
        }

        Node processInterfaceDeclaration(InterfaceDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, "interface");
            Node name = this.processName(tree.name);
            this.maybeProcessGenerics(name, tree.generics);
            Node superInterfaces = this.transformListOrEmpty(312, tree.superInterfaces);
            Node body = IRFactory.this.newNode(313);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.elements) {
                body.addChildToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.newNode(311, name, superInterfaces, body);
        }

        Node processEnumDeclaration(EnumDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, "enum");
            Node name = this.processName(tree.name);
            Node body = IRFactory.this.newNode(315);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.members) {
                body.addChildrenToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.newNode(314, name, body);
        }

        Node processSuper(SuperExpressionTree tree) {
            this.maybeWarnEs6Feature(tree, "super");
            return IRFactory.this.newNode(161);
        }

        Node processMemberVariable(MemberVariableTree tree) {
            Node member = IRFactory.this.newStringNode(319, tree.name.value);
            this.maybeProcessType(member, tree.declaredType);
            member.setStaticMember(tree.isStatic);
            member.putBooleanProp(80, tree.isOptional);
            this.maybeProcessAccessibilityModifier(member, tree, tree.access);
            return member;
        }

        Node processYield(YieldExpressionTree tree) {
            Node yield = IRFactory.this.newNode(164);
            if (tree.expression != null) {
                yield.addChildToBack(IRFactory.this.transform(tree.expression));
            }
            yield.setYieldFor(tree.isYieldFor);
            return yield;
        }

        Node processExportDecl(ExportDeclarationTree tree) {
            this.maybeWarnEs6Feature(tree, "modules");
            Node decls = null;
            if (tree.isExportAll) {
                Preconditions.checkState((tree.declaration == null && tree.exportSpecifierList == null ? 1 : 0) != 0);
            } else if (tree.declaration != null) {
                Preconditions.checkState((tree.exportSpecifierList == null ? 1 : 0) != 0);
                decls = IRFactory.this.transform(tree.declaration);
            } else {
                decls = this.transformList(170, tree.exportSpecifierList);
            }
            if (decls == null) {
                decls = IRFactory.this.newNode(124);
            }
            IRFactory.this.setSourceInfo(decls, tree);
            Node export = IRFactory.this.newNode(169, decls);
            if (tree.from != null) {
                Node from = this.processString(tree.from);
                export.addChildToBack(from);
            }
            export.putBooleanProp(63, tree.isExportAll);
            export.putBooleanProp(62, tree.isDefault);
            return export;
        }

        Node processExportSpec(ExportSpecifierTree tree) {
            Node exportSpec = IRFactory.this.newNode(171, this.processName(tree.importedName));
            if (tree.destinationName != null) {
                exportSpec.addChildToBack(this.processName(tree.destinationName));
            }
            return exportSpec;
        }

        Node processImportDecl(ImportDeclarationTree tree) {
            this.maybeWarnEs6Feature(tree, "modules");
            Node firstChild = this.transformOrEmpty(tree.defaultBindingIdentifier, (ParseTree)tree);
            Node secondChild = tree.nameSpaceImportIdentifier != null ? IRFactory.this.newStringNode(168, tree.nameSpaceImportIdentifier.value) : this.transformListOrEmpty(166, tree.importSpecifierList);
            Node thirdChild = this.processString(tree.moduleSpecifier);
            return IRFactory.this.newNode(165, firstChild, secondChild, thirdChild);
        }

        Node processImportSpec(ImportSpecifierTree tree) {
            Node importSpec = IRFactory.this.newNode(167, this.processName(tree.importedName));
            if (tree.destinationName != null) {
                importSpec.addChildToBack(this.processName(tree.destinationName));
            }
            return importSpec;
        }

        Node processModuleImport(ModuleImportTree tree) {
            this.maybeWarnEs6Feature(tree, "modules");
            Node module = IRFactory.this.newNode(172, this.processName(tree.name), this.processString(tree.from));
            return module;
        }

        Node processTypeName(TypeNameTree tree) {
            Node typeNode;
            if (tree.segments.size() == 1) {
                String typeName;
                switch (typeName = (String)tree.segments.get(0)) {
                    case "any": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.anyType());
                        break;
                    }
                    case "number": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.numberType());
                        break;
                    }
                    case "boolean": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.booleanType());
                        break;
                    }
                    case "string": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.stringType());
                        break;
                    }
                    case "void": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.voidType());
                        break;
                    }
                    case "undefined": {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.undefinedType());
                        break;
                    }
                    default: {
                        typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.namedType(tree.segments));
                        break;
                    }
                }
            } else {
                typeNode = IRFactory.this.cloneProps(TypeDeclarationsIR.namedType(tree.segments));
            }
            IRFactory.this.setSourceInfo(typeNode, tree);
            return typeNode;
        }

        Node processTypedParameter(TypedParameterTree typeAnnotation) {
            Node param = IRFactory.this.transform(typeAnnotation.param);
            this.maybeProcessType(param, typeAnnotation.typeAnnotation);
            return param;
        }

        Node processOptionalParameter(OptionalParameterTree optionalParam) {
            this.maybeWarnTypeSyntax(optionalParam, "optional parameter");
            Node param = IRFactory.this.transform(optionalParam.param);
            param.putBooleanProp(80, true);
            return param;
        }

        private void maybeProcessType(Node typeTarget, ParseTree typeTree) {
            if (typeTree != null) {
                IRFactory.this.recordJsDoc(typeTree.location, typeTarget.getJSDocInfo());
                Node typeExpression = this.convertTypeTree(typeTree);
                if (typeExpression.isString()) {
                    typeExpression = IRFactory.this.cloneProps(new Node.TypeDeclarationNode(40, typeExpression.getString()));
                }
                typeTarget.setDeclaredTypeExpression((Node.TypeDeclarationNode)typeExpression);
            }
        }

        private void maybeProcessGenerics(Node n, GenericTypeListTree generics) {
            if (generics != null) {
                this.maybeWarnTypeSyntax(generics, "generics");
                n.putProp(81, IRFactory.this.transform(generics));
            }
        }

        private Node convertTypeTree(ParseTree typeTree) {
            this.maybeWarnTypeSyntax(typeTree);
            return IRFactory.this.transform(typeTree);
        }

        Node processParameterizedType(ParameterizedTypeTree tree) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (ParseTree arg : tree.typeArguments) {
                arguments.add((Object)((Node.TypeDeclarationNode)IRFactory.this.transform(arg)));
            }
            Node.TypeDeclarationNode typeName = (Node.TypeDeclarationNode)IRFactory.this.transform(tree.typeName);
            return IRFactory.this.cloneProps(TypeDeclarationsIR.parameterizedType(typeName, (Iterable<Node.TypeDeclarationNode>)arguments.build()));
        }

        Node processArrayType(ArrayTypeTree tree) {
            return IRFactory.this.cloneProps(TypeDeclarationsIR.arrayType(IRFactory.this.transform(tree.elementType)));
        }

        Node processRecordType(RecordTypeTree tree) {
            Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(213);
            for (ParseTree child : tree.members) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.cloneProps(node);
        }

        Node processUnionType(UnionTypeTree tree) {
            ImmutableList.Builder options = ImmutableList.builder();
            for (ParseTree option : tree.types) {
                options.add((Object)((Node.TypeDeclarationNode)IRFactory.this.transform(option)));
            }
            return IRFactory.this.cloneProps(TypeDeclarationsIR.unionType((Iterable<Node.TypeDeclarationNode>)options.build()));
        }

        Node processTypeAlias(TypeAliasTree tree) {
            this.maybeWarnTypeSyntax(tree, "type alias");
            Node typeAlias = IRFactory.this.newStringNode(317, tree.alias.value);
            typeAlias.addChildrenToFront(IRFactory.this.transform(tree.original));
            return typeAlias;
        }

        Node processAmbientDeclaration(AmbientDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, "ambient declaration");
            return IRFactory.this.newNode(318, IRFactory.this.transform(tree.declaration));
        }

        Node processNamespaceDeclaration(NamespaceDeclarationTree tree) {
            this.maybeWarnTypeSyntax(tree, "namespace declaration");
            Node name = this.processNamespaceName(tree.name);
            Node body = IRFactory.this.newNode(322);
            IRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.elements) {
                body.addChildToBack(IRFactory.this.transform(child));
            }
            return IRFactory.this.newNode(172, name, body);
        }

        Node processNamespaceName(NamespaceNameTree name) {
            ImmutableList<String> segments = name.segments;
            if (segments.size() == 1) {
                Node namespaceName = IRFactory.this.newStringNode(38, (String)segments.get(0));
                IRFactory.this.setSourceInfo(namespaceName, name);
                return namespaceName;
            }
            UnmodifiableIterator segmentsIt = segments.iterator();
            Node node = IR.name((String)segmentsIt.next());
            IRFactory.this.setSourceInfo(node, name);
            while (segmentsIt.hasNext()) {
                Node string = IRFactory.this.newStringNode(40, (String)segmentsIt.next());
                IRFactory.this.setSourceInfo(string, name);
                node = IRFactory.this.newNode(33, node, string);
                IRFactory.this.setSourceInfo(node, name);
            }
            return node;
        }

        Node processIndexSignature(IndexSignatureTree tree) {
            this.maybeWarnTypeSyntax(tree, "index signature");
            Node name = IRFactory.this.transform(tree.name);
            Node.TypeDeclarationNode indexType = name.getDeclaredTypeExpression();
            if (indexType.getType() != 202 && indexType.getType() != 200) {
                IRFactory.this.errorReporter.error("Index signature parameter type must be 'string' or 'number'", IRFactory.this.sourceName, IRFactory.lineno(tree.name), IRFactory.charno(tree.name));
            }
            Node signature = IRFactory.this.newNode(320, name);
            this.maybeProcessType(signature, tree.declaredType);
            return signature;
        }

        Node processCallSignature(CallSignatureTree tree) {
            this.maybeWarnTypeSyntax(tree, tree.isNew ? "constructor signature" : "call signature");
            Node signature = IRFactory.this.newNode(321, IRFactory.this.transform(tree.formalParameterList));
            this.maybeProcessType(signature, tree.returnType);
            this.maybeProcessGenerics(signature, tree.generics);
            signature.putBooleanProp(83, tree.isNew);
            return signature;
        }

        private boolean checkParameters(ImmutableList<ParseTree> params) {
            boolean seenOptional = false;
            boolean good = true;
            block5: for (int i = 0; i < params.size(); ++i) {
                ParseTree param = (ParseTree)params.get(i);
                Node type = null;
                if (param.type == ParseTreeType.TYPED_PARAMETER) {
                    TypedParameterTree typedParam = param.asTypedParameter();
                    type = IRFactory.this.transform(typedParam.typeAnnotation);
                    param = typedParam.param;
                }
                switch (param.type) {
                    case IDENTIFIER_EXPRESSION: {
                        if (!seenOptional) continue block5;
                        IRFactory.this.errorReporter.error("A required parameter cannot follow an optional parameter.", IRFactory.this.sourceName, IRFactory.lineno(param), IRFactory.charno(param));
                        good = false;
                        continue block5;
                    }
                    case OPTIONAL_PARAMETER: {
                        seenOptional = true;
                        continue block5;
                    }
                    case REST_PARAMETER: {
                        if (i != params.size() - 1) {
                            IRFactory.this.errorReporter.error("A rest parameter must be last in a parameter list.", IRFactory.this.sourceName, IRFactory.lineno(param), IRFactory.charno(param));
                            good = false;
                        }
                        if (type == null || type.getType() == 215) continue block5;
                        IRFactory.this.errorReporter.error("A rest parameter must be of an array type.", IRFactory.this.sourceName, IRFactory.lineno(param), IRFactory.charno(param));
                        good = false;
                        continue block5;
                    }
                }
            }
            return good;
        }

        Node processFunctionType(FunctionTypeTree tree) {
            LinkedHashMap<String, Node.TypeDeclarationNode> requiredParams = new LinkedHashMap<String, Node.TypeDeclarationNode>();
            LinkedHashMap<String, Node.TypeDeclarationNode> optionalParams = new LinkedHashMap<String, Node.TypeDeclarationNode>();
            String restName = null;
            Node.TypeDeclarationNode restType = null;
            if (this.checkParameters(tree.formalParameterList.parameters)) {
                block5: for (ParseTree param : tree.formalParameterList.parameters) {
                    Node.TypeDeclarationNode type = null;
                    if (param.type == ParseTreeType.TYPED_PARAMETER) {
                        TypedParameterTree typedParam = param.asTypedParameter();
                        type = (Node.TypeDeclarationNode)IRFactory.this.transform(typedParam.typeAnnotation);
                        param = typedParam.param;
                    }
                    switch (param.type) {
                        case IDENTIFIER_EXPRESSION: {
                            requiredParams.put(param.asIdentifierExpression().identifierToken.toString(), type);
                            continue block5;
                        }
                        case OPTIONAL_PARAMETER: {
                            this.maybeWarnTypeSyntax(param, "optional parameter");
                            optionalParams.put(param.asOptionalParameter().param.asIdentifierExpression().identifierToken.toString(), type);
                            continue block5;
                        }
                        case REST_PARAMETER: {
                            restName = param.asRestParameter().identifier.toString();
                            restType = type;
                            continue block5;
                        }
                    }
                    throw new IllegalStateException("Illegal parameter type: " + (Object)((Object)param.type));
                }
            }
            return IRFactory.this.cloneProps(TypeDeclarationsIR.functionType(IRFactory.this.transform(tree.returnType), requiredParams, optionalParams, restName, restType));
        }

        Node processTypeQuery(TypeQueryTree tree) {
            UnmodifiableIterator segmentsIt = tree.segments.iterator();
            Node node = IRFactory.this.newStringNode(38, (String)segmentsIt.next());
            while (segmentsIt.hasNext()) {
                node = IR.getprop(node, IR.string((String)segmentsIt.next()));
            }
            return IRFactory.this.cloneProps(new Node.TypeDeclarationNode(32, node));
        }

        Node processGenericTypeList(GenericTypeListTree tree) {
            Node list = IRFactory.this.newNode(217);
            for (Map.Entry<IdentifierToken, ParseTree> generic : tree.generics.entrySet()) {
                Node type = IRFactory.this.newStringNode(216, generic.getKey().value);
                ParseTree bound = generic.getValue();
                if (bound != null) {
                    type.addChildToBack(IRFactory.this.transform(bound));
                }
                list.addChildToBack(type);
            }
            return list;
        }

        private Node transformList(int type, ImmutableList<ParseTree> list) {
            Node n = IRFactory.this.newNode(type);
            for (ParseTree tree : list) {
                n.addChildToBack(IRFactory.this.transform(tree));
            }
            return n;
        }

        private Node transformListOrEmpty(int type, ImmutableList<ParseTree> list) {
            if (list == null || list.isEmpty()) {
                return IRFactory.this.newNode(124);
            }
            return this.transformList(type, list);
        }

        void maybeWarnEs6Feature(ParseTree node, String feature) {
            if (!IRFactory.this.isEs6Mode()) {
                IRFactory.this.errorReporter.warning("this language feature is only supported in es6 mode: " + feature, IRFactory.this.sourceName, IRFactory.lineno(node), IRFactory.charno(node));
            }
        }

        void maybeProcessAccessibilityModifier(Node n, ParseTree tree, TokenType type) {
            if (type != null) {
                JSDocInfo.Visibility access;
                switch (type) {
                    case PUBLIC: {
                        access = JSDocInfo.Visibility.PUBLIC;
                        break;
                    }
                    case PROTECTED: {
                        access = JSDocInfo.Visibility.PROTECTED;
                        break;
                    }
                    case PRIVATE: {
                        access = JSDocInfo.Visibility.PRIVATE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected access modifier type");
                    }
                }
                n.putProp(84, (Object)access);
            }
        }

        void maybeWarnTypeSyntax(ParseTree node, String feature) {
            if (((IRFactory)IRFactory.this).config.languageMode != Config.LanguageMode.ECMASCRIPT6_TYPED) {
                IRFactory.this.errorReporter.warning("type syntax is only supported in ES6 typed mode: " + feature, IRFactory.this.sourceName, IRFactory.lineno(node), IRFactory.charno(node));
            }
            IRFactory.this.recordTypeSyntax(node.location);
        }

        void maybeWarnTypeSyntax(ParseTree node) {
            this.maybeWarnTypeSyntax(node, "type annotation");
        }

        Node unsupportedLanguageFeature(ParseTree node, String feature) {
            IRFactory.this.errorReporter.error("unsupported language feature: " + feature, IRFactory.this.sourceName, IRFactory.lineno(node), IRFactory.charno(node));
            return this.createMissingExpressionNode();
        }

        Node processLiteralExpression(LiteralExpressionTree expr) {
            switch (expr.literalToken.type) {
                case NUMBER: {
                    return this.processNumberLiteral(expr);
                }
                case STRING: {
                    return this.processStringLiteral(expr);
                }
                case FALSE: 
                case TRUE: {
                    return this.processBooleanLiteral(expr);
                }
                case NULL: {
                    return this.processNullLiteral(expr);
                }
                case REGULAR_EXPRESSION: {
                    return this.processRegExpLiteral(expr);
                }
            }
            throw new IllegalStateException("Unexpected literal type: " + expr.literalToken.getClass() + " type: " + (Object)((Object)expr.literalToken.type));
        }

        public Node process(ParseTree node) {
            switch (node.type) {
                case BINARY_OPERATOR: {
                    return this.processBinaryExpression(node.asBinaryOperator());
                }
                case ARRAY_LITERAL_EXPRESSION: {
                    return this.processArrayLiteral(node.asArrayLiteralExpression());
                }
                case TEMPLATE_LITERAL_EXPRESSION: {
                    return this.processTemplateLiteral(node.asTemplateLiteralExpression());
                }
                case TEMPLATE_LITERAL_PORTION: {
                    return this.processTemplateLiteralPortion(node.asTemplateLiteralPortion());
                }
                case TEMPLATE_SUBSTITUTION: {
                    return this.processTemplateSubstitution(node.asTemplateSubstitution());
                }
                case UNARY_EXPRESSION: {
                    return this.processUnaryExpression(node.asUnaryExpression());
                }
                case BLOCK: {
                    return this.processBlock(node.asBlock());
                }
                case BREAK_STATEMENT: {
                    return this.processBreakStatement(node.asBreakStatement());
                }
                case CALL_EXPRESSION: {
                    return this.processFunctionCall(node.asCallExpression());
                }
                case CASE_CLAUSE: {
                    return this.processSwitchCase(node.asCaseClause());
                }
                case DEFAULT_CLAUSE: {
                    return this.processSwitchDefault(node.asDefaultClause());
                }
                case CATCH: {
                    return this.processCatchClause(node.asCatch());
                }
                case CONTINUE_STATEMENT: {
                    return this.processContinueStatement(node.asContinueStatement());
                }
                case DO_WHILE_STATEMENT: {
                    return this.processDoLoop(node.asDoWhileStatement());
                }
                case EMPTY_STATEMENT: {
                    return this.processEmptyStatement(node.asEmptyStatement());
                }
                case EXPRESSION_STATEMENT: {
                    return this.processExpressionStatement(node.asExpressionStatement());
                }
                case DEBUGGER_STATEMENT: {
                    return this.processDebuggerStatement(node.asDebuggerStatement());
                }
                case THIS_EXPRESSION: {
                    return this.processThisExpression(node.asThisExpression());
                }
                case FOR_STATEMENT: {
                    return this.processForLoop(node.asForStatement());
                }
                case FOR_IN_STATEMENT: {
                    return this.processForInLoop(node.asForInStatement());
                }
                case FUNCTION_DECLARATION: {
                    return this.processFunction(node.asFunctionDeclaration());
                }
                case MEMBER_LOOKUP_EXPRESSION: {
                    return this.processElementGet(node.asMemberLookupExpression());
                }
                case MEMBER_EXPRESSION: {
                    return this.processPropertyGet(node.asMemberExpression());
                }
                case CONDITIONAL_EXPRESSION: {
                    return this.processConditionalExpression(node.asConditionalExpression());
                }
                case IF_STATEMENT: {
                    return this.processIfStatement(node.asIfStatement());
                }
                case LABELLED_STATEMENT: {
                    return this.processLabeledStatement(node.asLabelledStatement());
                }
                case PAREN_EXPRESSION: {
                    return this.processParenthesizedExpression(node.asParenExpression());
                }
                case IDENTIFIER_EXPRESSION: {
                    return this.processName(node.asIdentifierExpression());
                }
                case NEW_EXPRESSION: {
                    return this.processNewExpression(node.asNewExpression());
                }
                case OBJECT_LITERAL_EXPRESSION: {
                    return this.processObjectLiteral(node.asObjectLiteralExpression());
                }
                case COMPUTED_PROPERTY_DEFINITION: {
                    return this.processComputedPropertyDefinition(node.asComputedPropertyDefinition());
                }
                case COMPUTED_PROPERTY_GETTER: {
                    return this.processComputedPropertyGetter(node.asComputedPropertyGetter());
                }
                case COMPUTED_PROPERTY_MEMBER_VARIABLE: {
                    return this.processComputedPropertyMemberVariable(node.asComputedPropertyMemberVariable());
                }
                case COMPUTED_PROPERTY_METHOD: {
                    return this.processComputedPropertyMethod(node.asComputedPropertyMethod());
                }
                case COMPUTED_PROPERTY_SETTER: {
                    return this.processComputedPropertySetter(node.asComputedPropertySetter());
                }
                case RETURN_STATEMENT: {
                    return this.processReturnStatement(node.asReturnStatement());
                }
                case POSTFIX_EXPRESSION: {
                    return this.processPostfixExpression(node.asPostfixExpression());
                }
                case PROGRAM: {
                    return this.processAstRoot(node.asProgram());
                }
                case LITERAL_EXPRESSION: {
                    return this.processLiteralExpression(node.asLiteralExpression());
                }
                case SWITCH_STATEMENT: {
                    return this.processSwitchStatement(node.asSwitchStatement());
                }
                case THROW_STATEMENT: {
                    return this.processThrowStatement(node.asThrowStatement());
                }
                case TRY_STATEMENT: {
                    return this.processTryStatement(node.asTryStatement());
                }
                case VARIABLE_STATEMENT: {
                    return this.processVariableStatement(node.asVariableStatement());
                }
                case VARIABLE_DECLARATION_LIST: {
                    return this.processVariableDeclarationList(node.asVariableDeclarationList());
                }
                case VARIABLE_DECLARATION: {
                    return this.processVariableDeclaration(node.asVariableDeclaration());
                }
                case WHILE_STATEMENT: {
                    return this.processWhileLoop(node.asWhileStatement());
                }
                case WITH_STATEMENT: {
                    return this.processWithStatement(node.asWithStatement());
                }
                case COMMA_EXPRESSION: {
                    return this.processCommaExpression(node.asCommaExpression());
                }
                case NULL: {
                    return this.processNull(node.asNull());
                }
                case FINALLY: {
                    return this.processFinally(node.asFinally());
                }
                case MISSING_PRIMARY_EXPRESSION: {
                    return this.processMissingExpression(node.asMissingPrimaryExpression());
                }
                case PROPERTY_NAME_ASSIGNMENT: {
                    return this.processPropertyNameAssignment(node.asPropertyNameAssignment());
                }
                case GET_ACCESSOR: {
                    return this.processGetAccessor(node.asGetAccessor());
                }
                case SET_ACCESSOR: {
                    return this.processSetAccessor(node.asSetAccessor());
                }
                case FORMAL_PARAMETER_LIST: {
                    return this.processFormalParameterList(node.asFormalParameterList());
                }
                case CLASS_DECLARATION: {
                    return this.processClassDeclaration(node.asClassDeclaration());
                }
                case SUPER_EXPRESSION: {
                    return this.processSuper(node.asSuperExpression());
                }
                case YIELD_EXPRESSION: {
                    return this.processYield(node.asYieldStatement());
                }
                case FOR_OF_STATEMENT: {
                    return this.processForOf(node.asForOfStatement());
                }
                case EXPORT_DECLARATION: {
                    return this.processExportDecl(node.asExportDeclaration());
                }
                case EXPORT_SPECIFIER: {
                    return this.processExportSpec(node.asExportSpecifier());
                }
                case IMPORT_DECLARATION: {
                    return this.processImportDecl(node.asImportDeclaration());
                }
                case IMPORT_SPECIFIER: {
                    return this.processImportSpec(node.asImportSpecifier());
                }
                case MODULE_IMPORT: {
                    return this.processModuleImport(node.asModuleImport());
                }
                case ARRAY_PATTERN: {
                    return this.processArrayPattern(node.asArrayPattern());
                }
                case OBJECT_PATTERN: {
                    return this.processObjectPattern(node.asObjectPattern());
                }
                case ASSIGNMENT_REST_ELEMENT: {
                    return this.processAssignmentRestElement(node.asAssignmentRestElement());
                }
                case COMPREHENSION: {
                    return this.processComprehension(node.asComprehension());
                }
                case COMPREHENSION_FOR: {
                    return this.processComprehensionFor(node.asComprehensionFor());
                }
                case COMPREHENSION_IF: {
                    return this.processComprehensionIf(node.asComprehensionIf());
                }
                case DEFAULT_PARAMETER: {
                    return this.processDefaultParameter(node.asDefaultParameter());
                }
                case REST_PARAMETER: {
                    return this.processRestParameter(node.asRestParameter());
                }
                case SPREAD_EXPRESSION: {
                    return this.processSpreadExpression(node.asSpreadExpression());
                }
                case TYPE_NAME: {
                    return this.processTypeName(node.asTypeName());
                }
                case TYPED_PARAMETER: {
                    return this.processTypedParameter(node.asTypedParameter());
                }
                case OPTIONAL_PARAMETER: {
                    return this.processOptionalParameter(node.asOptionalParameter());
                }
                case PARAMETERIZED_TYPE_TREE: {
                    return this.processParameterizedType(node.asParameterizedType());
                }
                case ARRAY_TYPE: {
                    return this.processArrayType(node.asArrayType());
                }
                case RECORD_TYPE: {
                    return this.processRecordType(node.asRecordType());
                }
                case UNION_TYPE: {
                    return this.processUnionType(node.asUnionType());
                }
                case FUNCTION_TYPE: {
                    return this.processFunctionType(node.asFunctionType());
                }
                case TYPE_QUERY: {
                    return this.processTypeQuery(node.asTypeQuery());
                }
                case GENERIC_TYPE_LIST: {
                    return this.processGenericTypeList(node.asGenericTypeList());
                }
                case MEMBER_VARIABLE: {
                    return this.processMemberVariable(node.asMemberVariable());
                }
                case INTERFACE_DECLARATION: {
                    return this.processInterfaceDeclaration(node.asInterfaceDeclaration());
                }
                case ENUM_DECLARATION: {
                    return this.processEnumDeclaration(node.asEnumDeclaration());
                }
                case TYPE_ALIAS: {
                    return this.processTypeAlias(node.asTypeAlias());
                }
                case AMBIENT_DECLARATION: {
                    return this.processAmbientDeclaration(node.asAmbientDeclaration());
                }
                case NAMESPACE_DECLARATION: {
                    return this.processNamespaceDeclaration(node.asNamespaceDeclaration());
                }
                case INDEX_SIGNATURE: {
                    return this.processIndexSignature(node.asIndexSignature());
                }
                case CALL_SIGNATURE: {
                    return this.processCallSignature(node.asCallSignature());
                }
            }
            return this.processIllegalToken(node);
        }
    }
}

