/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

public final class CheckForInOverArray
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    final AbstractCompiler compiler;
    final JSTypeRegistry typeRegistry;
    public static final DiagnosticType FOR_IN_OVER_ARRAY = DiagnosticType.warning("JSC_FOR_IN_OVER_ARRAY", "For..in over array is discouraged.");

    public CheckForInOverArray(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
    }

    public boolean isForInOverArray(Node n) {
        if (NodeUtil.isForIn(n)) {
            Preconditions.checkState((n.getChildCount() == 3 ? 1 : 0) != 0);
            Node child = n.getFirstChild().getNext();
            JSType type = child.getJSType();
            if (type != null && this.containsArray(type)) {
                return true;
            }
        }
        return false;
    }

    private boolean containsArray(JSType type) {
        JSType arrayType;
        if (type.isArrayType()) {
            return true;
        }
        return type.isUnionType() && (arrayType = this.typeRegistry.getNativeType(JSTypeNative.ARRAY_TYPE)).isSubtype(type);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.isForInOverArray(n)) {
            this.compiler.report(t.makeError(parent, FOR_IN_OVER_ARRAY, new String[0]));
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }
}

