/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GwtIncompatible(value="java.util.regex")
public final class JsFunctionParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(JsFunctionParser.class.getName());
    private Pattern pattern;
    private Matcher matcher;
    private Collection<SymbolInfo> symbols;
    private Collection<String> functionsToParse;

    public JsFunctionParser(Collection<String> functions, ErrorManager errorManager) {
        super(errorManager);
        this.functionsToParse = functions;
        this.pattern = JsFunctionParser.getPattern(functions);
        this.matcher = this.pattern.matcher("");
    }

    private static Pattern getPattern(Collection<String> functions) {
        StringBuilder sb = new StringBuilder("(?:^|;)\\s*(");
        for (String function : functions) {
            sb.append(Pattern.quote(function) + "|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")\\s*\\((.*?)\\)");
        return Pattern.compile(sb.toString());
    }

    public Collection<SymbolInfo> parseFile(String filePath, String fileContents) {
        return this.parseReader(filePath, new StringReader(fileContents));
    }

    private Collection<SymbolInfo> parseReader(String filePath, Reader fileContents) {
        this.symbols = new ArrayList<SymbolInfo>();
        logger.fine("Parsing Source: " + filePath);
        this.doParse(filePath, fileContents);
        return this.symbols;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean hasFunctions = false;
        boolean parseLine = false;
        for (String function : this.functionsToParse) {
            if (!line.contains(function)) continue;
            parseLine = true;
            break;
        }
        if (parseLine) {
            this.matcher.reset(line);
            while (this.matcher.find()) {
                hasFunctions = true;
                String functionName = this.matcher.group(1);
                String arg = this.parseJsString(this.matcher.group(2));
                this.symbols.add(new SymbolInfo(functionName, arg));
            }
        }
        return !this.shortcutMode || hasFunctions || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)line);
    }

    public static class SymbolInfo {
        public final String functionName;
        public final String symbol;

        private SymbolInfo(String functionName, String symbol) {
            this.functionName = functionName;
            this.symbol = symbol;
        }
    }
}

