/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import java.util.List;

class LintPassConfig
extends PassConfig.PassConfigDelegate {
    private final PassFactory lintChecks = new PassFactory("lintChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckEmptyStatements(compiler), (Object)new CheckEnums(compiler), (Object)new CheckInterfaces(compiler), (Object)new CheckJSDocStyle(compiler), (Object)new CheckJSDoc(compiler), (Object)new CheckPrototypeProperties(compiler), (Object)new CheckRequiresForConstructors(compiler), (Object)new CheckRequiresAndProvidesSorted(compiler)));
        }
    };

    LintPassConfig(CompilerOptions options) {
        super(new DefaultPassConfig(options));
    }

    @Override
    protected List<PassFactory> getChecks() {
        return ImmutableList.of((Object)this.lintChecks);
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }
}

