/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

abstract class DataFlowAnalysis<N, L extends LatticeElement> {
    private final ControlFlowGraph<N> cfg;
    final JoinOp<L> joinOp;
    protected final Set<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> orderedWorkSet;
    public static final int MAX_STEPS = 400000;

    DataFlowAnalysis(ControlFlowGraph<N> targetCfg, JoinOp<L> joinOp) {
        this.cfg = targetCfg;
        this.joinOp = joinOp;
        Comparator<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> nodeComparator = this.cfg.getOptionalNodeComparator(this.isForward());
        this.orderedWorkSet = nodeComparator != null ? new TreeSet<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>>(nodeComparator) : new LinkedHashSet<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>>();
    }

    final ControlFlowGraph<N> getCfg() {
        return this.cfg;
    }

    L getExitLatticeElement() {
        DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node = this.getCfg().getImplicitReturn();
        FlowState state = (FlowState)node.getAnnotation();
        return state.getIn();
    }

    protected L join(L latticeA, L latticeB) {
        return (L)((LatticeElement)this.joinOp.apply(ImmutableList.of(latticeA, latticeB)));
    }

    abstract boolean isForward();

    abstract L flowThrough(N var1, L var2);

    final void analyze() {
        this.analyze(400000);
    }

    final void analyze(int maxSteps) {
        this.initialize();
        int step = 0;
        while (!this.orderedWorkSet.isEmpty()) {
            if (step > maxSteps) {
                throw new MaxIterationsExceededException("Analysis did not terminate after " + maxSteps + " iterations");
            }
            DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> curNode = this.orderedWorkSet.iterator().next();
            this.orderedWorkSet.remove(curNode);
            this.joinInputs(curNode);
            if (this.flow(curNode)) {
                List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> nextNodes = this.isForward() ? this.cfg.getDirectedSuccNodes(curNode) : this.cfg.getDirectedPredNodes(curNode);
                for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> nextNode : nextNodes) {
                    if (nextNode == this.cfg.getImplicitReturn()) continue;
                    this.orderedWorkSet.add(nextNode);
                }
            }
            ++step;
        }
        if (this.isForward()) {
            this.joinInputs(this.getCfg().getImplicitReturn());
        }
    }

    abstract L createInitialEstimateLattice();

    abstract L createEntryLattice();

    protected void initialize() {
        this.orderedWorkSet.clear();
        for (DiGraph.DiGraphNode node : this.cfg.getDirectedGraphNodes()) {
            node.setAnnotation(new FlowState((LatticeElement)this.createInitialEstimateLattice(), (LatticeElement)this.createInitialEstimateLattice(), null));
            if (node == this.cfg.getImplicitReturn()) continue;
            this.orderedWorkSet.add(node);
        }
    }

    protected boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
        FlowState state = (FlowState)node.getAnnotation();
        if (this.isForward()) {
            LatticeElement outBefore = state.out;
            state.out = this.flowThrough(node.getValue(), state.in);
            return !outBefore.equals(state.out);
        }
        LatticeElement inBefore = state.in;
        state.in = this.flowThrough(node.getValue(), state.out);
        return !inBefore.equals(state.in);
    }

    protected void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
        FlowState state = (FlowState)node.getAnnotation();
        if (this.isForward()) {
            if (this.cfg.getEntry() == node) {
                state.setIn(this.createEntryLattice());
            } else {
                List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> inNodes = this.cfg.getDirectedPredNodes(node);
                if (inNodes.size() == 1) {
                    FlowState inNodeState = (FlowState)inNodes.get(0).getAnnotation();
                    state.setIn(inNodeState.getOut());
                } else if (inNodes.size() > 1) {
                    ArrayList values = new ArrayList(inNodes.size());
                    for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> currentNode : inNodes) {
                        FlowState currentNodeState = (FlowState)currentNode.getAnnotation();
                        values.add(currentNodeState.getOut());
                    }
                    state.setIn((LatticeElement)this.joinOp.apply(values));
                }
            }
        } else {
            List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> inNodes = this.cfg.getDirectedSuccNodes(node);
            if (inNodes.size() == 1) {
                DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> inNode = inNodes.get(0);
                if (inNode == this.cfg.getImplicitReturn()) {
                    state.setOut(this.createEntryLattice());
                } else {
                    FlowState inNodeState = (FlowState)inNode.getAnnotation();
                    state.setOut(inNodeState.getIn());
                }
            } else if (inNodes.size() > 1) {
                ArrayList values = new ArrayList(inNodes.size());
                for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> currentNode : inNodes) {
                    FlowState currentNodeState = (FlowState)currentNode.getAnnotation();
                    values.add(currentNodeState.getIn());
                }
                state.setOut((LatticeElement)this.joinOp.apply(values));
            }
        }
    }

    static void computeEscaped(final Scope jsScope, final Set<Var> escaped, AbstractCompiler compiler) {
        NodeTraversal.AbstractPostOrderCallback finder = new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (jsScope == t.getScope() || !n.isName() || parent.isFunction()) {
                    return;
                }
                String name = n.getString();
                Var var = t.getScope().getVar(name);
                if (var != null && var.scope == jsScope) {
                    escaped.add(jsScope.getVar(name));
                }
            }
        };
        NodeTraversal t = new NodeTraversal(compiler, finder);
        t.traverseAtScope(jsScope);
        Iterator i = jsScope.getVars();
        while (i.hasNext()) {
            Var var = (Var)i.next();
            if (!var.getParentNode().isCatch() && !compiler.getCodingConvention().isExported(var.getName())) continue;
            escaped.add(var);
        }
    }

    static class BranchedFlowState<L extends LatticeElement>
    implements Annotation {
        private L in;
        private List<L> out;

        private BranchedFlowState(L inState, List<L> outState) {
            Preconditions.checkNotNull(inState);
            Preconditions.checkNotNull(outState);
            this.in = inState;
            this.out = outState;
        }

        L getIn() {
            return this.in;
        }

        void setIn(L in) {
            Preconditions.checkNotNull(in);
            this.in = in;
        }

        public String toString() {
            return SimpleFormat.format("IN: %s OUT: %s", this.in, this.out);
        }

        public int hashCode() {
            return Objects.hash(this.in, this.out);
        }

        /* synthetic */ BranchedFlowState(LatticeElement x0, List x1, 1 x2) {
            this(x0, x1);
        }
    }

    static abstract class BranchedForwardDataFlowAnalysis<N, L extends LatticeElement>
    extends DataFlowAnalysis<N, L> {
        @Override
        protected void initialize() {
            this.orderedWorkSet.clear();
            for (DiGraph.DiGraphNode node : this.getCfg().getDirectedGraphNodes()) {
                int outEdgeCount = this.getCfg().getOutEdges(node.getValue()).size();
                ArrayList outLattices = new ArrayList();
                for (int i = 0; i < outEdgeCount; ++i) {
                    outLattices.add(this.createInitialEstimateLattice());
                }
                node.setAnnotation(new BranchedFlowState((LatticeElement)this.createInitialEstimateLattice(), outLattices, null));
                if (node == this.getCfg().getImplicitReturn()) continue;
                this.orderedWorkSet.add(node);
            }
        }

        BranchedForwardDataFlowAnalysis(ControlFlowGraph<N> targetCfg, JoinOp<L> joinOp) {
            super(targetCfg, joinOp);
        }

        @Override
        L getExitLatticeElement() {
            DiGraph.DiGraphNode node = this.getCfg().getImplicitReturn();
            BranchedFlowState state = (BranchedFlowState)node.getAnnotation();
            return state.getIn();
        }

        @Override
        final boolean isForward() {
            return true;
        }

        abstract List<L> branchedFlowThrough(N var1, L var2);

        @Override
        protected final boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
            BranchedFlowState state = (BranchedFlowState)node.getAnnotation();
            List outBefore = state.out;
            state.out = this.branchedFlowThrough(node.getValue(), state.in);
            Preconditions.checkState((outBefore.size() == state.out.size() ? 1 : 0) != 0);
            for (int i = 0; i < outBefore.size(); ++i) {
                if (((LatticeElement)outBefore.get(i)).equals(state.out.get(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
            BranchedFlowState state = (BranchedFlowState)node.getAnnotation();
            List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> predNodes = this.getCfg().getDirectedPredNodes(node);
            ArrayList<LatticeElement> values = new ArrayList<LatticeElement>(predNodes.size());
            for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> predNode : predNodes) {
                BranchedFlowState predNodeState = (BranchedFlowState)predNode.getAnnotation();
                LatticeElement in = (LatticeElement)predNodeState.out.get(this.getCfg().getDirectedSuccNodes(predNode).indexOf(node));
                values.add(in);
            }
            if (this.getCfg().getEntry() == node) {
                state.setIn(this.createEntryLattice());
            } else if (!values.isEmpty()) {
                state.setIn((LatticeElement)this.joinOp.apply(values));
            }
        }
    }

    static class MaxIterationsExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        MaxIterationsExceededException(String msg) {
            super(msg);
        }
    }

    static class FlowState<L extends LatticeElement>
    implements Annotation {
        private L in;
        private L out;

        private FlowState(L inState, L outState) {
            Preconditions.checkNotNull(inState);
            Preconditions.checkNotNull(outState);
            this.in = inState;
            this.out = outState;
        }

        L getIn() {
            return this.in;
        }

        void setIn(L in) {
            Preconditions.checkNotNull(in);
            this.in = in;
        }

        L getOut() {
            return this.out;
        }

        void setOut(L out) {
            Preconditions.checkNotNull(out);
            this.out = out;
        }

        public String toString() {
            return SimpleFormat.format("IN: %s OUT: %s", this.in, this.out);
        }

        public int hashCode() {
            return Objects.hash(this.in, this.out);
        }

        /* synthetic */ FlowState(LatticeElement x0, LatticeElement x1, 1 x2) {
            this(x0, x1);
        }
    }
}

