/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

final class ClosureOptimizePrimitives
implements CompilerPass {
    private final AbstractCompiler compiler;

    ClosureOptimizePrimitives(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindObjectCreateCalls pass = new FindObjectCreateCalls();
        NodeTraversal.traverseEs6(this.compiler, root, pass);
    }

    private void processObjectCreateCall(Node callNode) {
        Node curParam = callNode.getFirstChild().getNext();
        if (ClosureOptimizePrimitives.canOptimizeObjectCreate(curParam)) {
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = curParam.getNext();
                curParam = valueNode.getNext();
                callNode.removeChild(keyNode);
                callNode.removeChild(valueNode);
                if (!keyNode.isString()) {
                    keyNode = IR.string(NodeUtil.getStringValue(keyNode)).srcref(keyNode);
                }
                keyNode.setType(154);
                keyNode.setQuotedString();
                objNode.addChildToBack(IR.propdef(keyNode, valueNode));
            }
            callNode.getParent().replaceChild(callNode, objNode);
            this.compiler.reportCodeChange();
        }
    }

    private static boolean canOptimizeObjectCreate(Node firstParam) {
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            if (!curParam.isString() && !curParam.isNumber()) {
                return false;
            }
            if ((curParam = curParam.getNext()) != null) continue;
            return false;
        }
        return true;
    }

    private void processObjectCreateSetCall(Node callNode) {
        Node curParam = callNode.getFirstChild().getNext();
        if (ClosureOptimizePrimitives.canOptimizeObjectCreateSet(curParam)) {
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = IR.trueNode().srcref(keyNode);
                curParam = curParam.getNext();
                callNode.removeChild(keyNode);
                if (!keyNode.isString()) {
                    keyNode = IR.string(NodeUtil.getStringValue(keyNode)).srcref(keyNode);
                }
                keyNode.setType(154);
                keyNode.setQuotedString();
                objNode.addChildToBack(IR.propdef(keyNode, valueNode));
            }
            callNode.getParent().replaceChild(callNode, objNode);
            this.compiler.reportCodeChange();
        }
    }

    private static boolean canOptimizeObjectCreateSet(Node firstParam) {
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            if (curParam.isString() || curParam.isNumber()) continue;
            return false;
        }
        return true;
    }

    private class FindObjectCreateCalls
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindObjectCreateCalls() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall()) {
                Node fn = n.getFirstChild();
                if (fn.matchesQualifiedName("goog$object$create") || fn.matchesQualifiedName("goog.object.create")) {
                    ClosureOptimizePrimitives.this.processObjectCreateCall(n);
                } else if (fn.matchesQualifiedName("goog$object$createSet") || fn.matchesQualifiedName("goog.object.createSet")) {
                    ClosureOptimizePrimitives.this.processObjectCreateSetCall(n);
                }
            }
        }
    }
}

