/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.head;

import com.google.javascript.rhino.head.Context;
import com.google.javascript.rhino.head.Evaluator;
import com.google.javascript.rhino.head.Interpreter;
import com.google.javascript.rhino.head.ScriptStackElement;
import com.google.javascript.rhino.head.SecurityUtilities;
import java.io.CharArrayWriter;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RhinoException
extends RuntimeException {
    static final long serialVersionUID = 1883500631321581169L;
    private static boolean useMozillaStackStyle = false;
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Evaluator e = Context.createInterpreter();
        if (e != null) {
            e.captureStackInfo(this);
        }
    }

    RhinoException(String details) {
        super(details);
        Evaluator e = Context.createInterpreter();
        if (e != null) {
            e.captureStackInfo(this);
        }
    }

    @Override
    public final String getMessage() {
        String details = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return details;
        }
        StringBuffer buf = new StringBuffer(details);
        buf.append(" (");
        if (this.sourceName != null) {
            buf.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            buf.append('#');
            buf.append(this.lineNumber);
        }
        buf.append(')');
        return buf.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String sourceName) {
        if (sourceName == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = sourceName;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int lineNumber) {
        if (lineNumber <= 0) {
            throw new IllegalArgumentException(String.valueOf(lineNumber));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = lineNumber;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int columnNumber) {
        if (columnNumber <= 0) {
            throw new IllegalArgumentException(String.valueOf(columnNumber));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = columnNumber;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String lineSource) {
        if (lineSource == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = lineSource;
    }

    final void recordErrorOrigin(String sourceName, int lineNumber, String lineSource, int columnNumber) {
        if (lineNumber == -1) {
            lineNumber = 0;
        }
        if (sourceName != null) {
            this.initSourceName(sourceName);
        }
        if (lineNumber != 0) {
            this.initLineNumber(lineNumber);
        }
        if (lineSource != null) {
            this.initLineSource(lineSource);
        }
        if (columnNumber != 0) {
            this.initColumnNumber(columnNumber);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter writer = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(writer));
        String origStackTrace = writer.toString();
        Evaluator e = Context.createInterpreter();
        if (e != null) {
            return e.getPatchedStack(this, origStackTrace);
        }
        return null;
    }

    public String getScriptStackTrace() {
        ScriptStackElement[] stack;
        StringBuilder buffer = new StringBuilder();
        String lineSeparator = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement elem : stack = this.getScriptStack()) {
            if (useMozillaStackStyle) {
                elem.renderMozillaStyle(buffer);
            } else {
                elem.renderJavaStyle(buffer);
            }
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    @Deprecated
    public String getScriptStackTrace(FilenameFilter filter) {
        return this.getScriptStackTrace();
    }

    public ScriptStackElement[] getScriptStack() {
        Evaluator interpreter;
        ArrayList<ScriptStackElement> list = new ArrayList<ScriptStackElement>();
        ScriptStackElement[][] interpreterStack = null;
        if (this.interpreterStackInfo != null && (interpreter = Context.createInterpreter()) instanceof Interpreter) {
            interpreterStack = ((Interpreter)interpreter).getScriptStackElements(this);
        }
        int interpreterStackIndex = 0;
        StackTraceElement[] stack = this.getStackTrace();
        Pattern pattern = Pattern.compile("_c_(.*)_\\d+");
        for (StackTraceElement e : stack) {
            String fileName = e.getFileName();
            if (e.getMethodName().startsWith("_c_") && e.getLineNumber() > -1 && fileName != null && !fileName.endsWith(".java")) {
                String methodName = e.getMethodName();
                Matcher match = pattern.matcher(methodName);
                methodName = !"_c_script_0".equals(methodName) && match.find() ? match.group(1) : null;
                list.add(new ScriptStackElement(fileName, methodName, e.getLineNumber()));
                continue;
            }
            if (!"com.google.javascript.rhino.head.Interpreter".equals(e.getClassName()) || !"interpretLoop".equals(e.getMethodName()) || interpreterStack == null || interpreterStack.length <= interpreterStackIndex) continue;
            for (ScriptStackElement elem : interpreterStack[interpreterStackIndex++]) {
                list.add(elem);
            }
        }
        return list.toArray(new ScriptStackElement[list.size()]);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.generateStackTrace());
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.generateStackTrace());
        }
    }

    public static boolean usesMozillaStackStyle() {
        return useMozillaStackStyle;
    }

    public static void useMozillaStackStyle(boolean flag) {
        useMozillaStackStyle = flag;
    }
}

