/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class WhitelistWarningsGuard
extends WarningsGuard {
    private final Set<String> whiteList;
    private static final Pattern LINE_NUMBER = Pattern.compile(":\\d+");

    public WhitelistWarningsGuard(Set<String> whiteList) {
        this.whiteList = whiteList;
    }

    @Override
    public CheckLevel level(JSError error) {
        if (this.containWarning(WhitelistWarningsGuard.formatWarning(error))) {
            return CheckLevel.WARNING;
        }
        return null;
    }

    protected boolean containWarning(String formattedWarning) {
        return this.whiteList.contains(formattedWarning);
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_WHITELIST.getValue();
    }

    public static WhitelistWarningsGuard fromFile(File file) {
        return new WhitelistWarningsGuard(WhitelistWarningsGuard.loadWhitelistedJsWarnings(file));
    }

    public static Set<String> loadWhitelistedJsWarnings(File file) {
        return WhitelistWarningsGuard.loadWhitelistedJsWarnings((InputSupplier<InputStreamReader>)Files.newReaderSupplier((File)file, (Charset)Charsets.UTF_8));
    }

    protected static Set<String> loadWhitelistedJsWarnings(InputSupplier<InputStreamReader> supplier) {
        Preconditions.checkNotNull(supplier);
        HashSet<String> result = new HashSet<String>();
        try {
            for (String line : CharStreams.readLines(supplier)) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                result.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String formatWarning(JSError error) {
        return WhitelistWarningsGuard.formatWarning(error, false);
    }

    public static String formatWarning(JSError error, boolean withLineNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(error.sourceName).append(":");
        if (withLineNumber) {
            sb.append(error.lineNumber);
        }
        String descriptionFirstLine = WhitelistWarningsGuard.getFirstLine(error.description);
        if (!withLineNumber) {
            descriptionFirstLine = LINE_NUMBER.matcher(descriptionFirstLine).replaceAll(":");
        }
        sb.append("  ").append(descriptionFirstLine);
        return sb.toString();
    }

    public static String getFirstLine(String warning) {
        int lineLength = warning.indexOf(10);
        if (lineLength > 0) {
            warning = warning.substring(0, lineLength);
        }
        return warning;
    }

    public static class WhitelistBuilder
    implements ErrorHandler {
        private final Set<JSError> warnings = Sets.newLinkedHashSet();
        private String productName = null;
        private String generatorTarget = null;
        private boolean withLineNumber = false;

        public WhitelistBuilder setProductName(String name) {
            this.productName = name;
            return this;
        }

        public WhitelistBuilder setGeneratorTarget(String name) {
            this.generatorTarget = name;
            return this;
        }

        public WhitelistBuilder setWithLineNumber(boolean line) {
            this.withLineNumber = line;
            return this;
        }

        @Override
        public void report(CheckLevel level, JSError error) {
            this.warnings.add(error);
        }

        public void writeWhitelist(File out) throws IOException {
            PrintStream stream = new PrintStream(out);
            this.appendWhitelist(stream);
            stream.close();
        }

        public void appendWhitelist(PrintStream out) {
            out.append("# This is a list of legacy warnings that have yet to be fixed.\n");
            if (this.productName != null) {
                out.append("# Please find some time and fix at least one of them and it will be the happiest day for " + this.productName + ".\n");
            }
            if (this.generatorTarget != null) {
                out.append("# When you fix any of these warnings, run " + this.generatorTarget + " task.\n");
            }
            TreeMultimap warningsByType = TreeMultimap.create();
            for (JSError warning : this.warnings) {
                warningsByType.put((Object)warning.getType(), (Object)WhitelistWarningsGuard.formatWarning(warning, this.withLineNumber));
            }
            for (DiagnosticType type : warningsByType.keySet()) {
                out.append("\n# Warning ").append(type.key).append(": ").println(WhitelistWarningsGuard.getFirstLine(type.format.toPattern()));
                for (String warning : warningsByType.get((Object)type)) {
                    out.println(warning);
                }
            }
        }
    }
}

