/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.jscomp.Strings;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.rhino.Node;

class SanityCheck
implements CompilerPass {
    static final DiagnosticType CANNOT_PARSE_GENERATED_CODE = DiagnosticType.error("JSC_CANNOT_PARSE_GENERATED_CODE", "Internal compiler error. Cannot parse generated code: {0}");
    static final DiagnosticType GENERATED_BAD_CODE = DiagnosticType.error("JSC_GENERATED_BAD_CODE", "Internal compiler error. Generated bad code.----------------------------------------\nExpected:\n{0}\n----------------------------------------\nActual:\n{1}");
    private final AbstractCompiler compiler;
    private final AstValidator astValidator = new AstValidator();

    SanityCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.sanityCheckAst(externs, root);
        this.sanityCheckNormalization(externs, root);
        this.sanityCheckCodeGeneration(root);
        this.sanityCheckVars(externs, root);
    }

    private void sanityCheckAst(Node externs, Node root) {
        this.astValidator.validateCodeRoot(externs);
        this.astValidator.validateCodeRoot(root);
    }

    private void sanityCheckVars(Node externs, Node root) {
        if (this.compiler.getLifeCycleStage().isNormalized()) {
            new VarCheck(this.compiler, true).process(externs, root);
        }
    }

    private Node sanityCheckCodeGeneration(Node root) {
        if (this.compiler.hasHaltingErrors()) {
            return null;
        }
        String source = this.compiler.toSource(root);
        Node root2 = this.compiler.parseSyntheticCode(source);
        if (this.compiler.hasHaltingErrors()) {
            this.compiler.report(JSError.make(CANNOT_PARSE_GENERATED_CODE, Strings.truncateAtMaxLength(source, 100, true)));
            throw new IllegalStateException("Sanity Check failed");
        }
        String source2 = this.compiler.toSource(root2);
        if (!source.equals(source2)) {
            this.compiler.report(JSError.make(GENERATED_BAD_CODE, source, source2));
            throw new IllegalStateException("Sanity Check failed");
        }
        return root2;
    }

    private void sanityCheckNormalization(Node externs, Node root) {
        CodeChangeHandler.ForbiddenChange handler = new CodeChangeHandler.ForbiddenChange();
        this.compiler.addChangeHandler(handler);
        new PrepareAst(this.compiler, true).process(null, root);
        if (this.compiler.getLifeCycleStage().isNormalized()) {
            new Normalize(this.compiler, true).process(externs, root);
            if (this.compiler.getLifeCycleStage().isNormalizedUnobfuscated()) {
                boolean checkUserDeclarations = true;
                Normalize.VerifyConstants pass = new Normalize.VerifyConstants(this.compiler, checkUserDeclarations);
                pass.process(externs, root);
            }
        }
        this.compiler.removeChangeHandler(handler);
    }
}

