/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.head.ErrorReporter;
import com.google.javascript.rhino.head.EvaluatorException;
import com.google.javascript.rhino.head.ScriptRuntime;
import com.google.javascript.rhino.head.ast.IdeErrorReporter;
import java.util.Map;
import java.util.regex.Pattern;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType TYPE_PARSE_ERROR = DiagnosticType.warning("JSC_TYPE_PARSE_ERROR", "{0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. IE8 (and below) will parse trailing commas in array and object literals incorrectly. If you are targeting newer versions of JS, set the appropriate language_in option.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    private final Map<Pattern, DiagnosticType> typeMap;
    final AbstractCompiler compiler;

    private Pattern replacePlaceHolders(String s) {
        s = Pattern.quote(s);
        return Pattern.compile(s.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q"));
    }

    private RhinoErrorReporter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeMap = ImmutableMap.of((Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.extra.trailing.comma")), (Object)TRAILING_COMMA, (Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.dup.parms")), (Object)DUPLICATE_PARAM, (Object)this.replacePlaceHolders(com.google.javascript.rhino.ScriptRuntime.getMessage0("msg.bad.jsdoc.tag")), (Object)BAD_JSDOC_ANNOTATION, (Object)Pattern.compile("^Bad type annotation.*"), (Object)TYPE_PARSE_ERROR);
    }

    public static ErrorReporter forNewRhino(AbstractCompiler compiler) {
        return new NewRhinoErrorReporter(compiler);
    }

    public static com.google.javascript.rhino.ErrorReporter forOldRhino(AbstractCompiler compiler) {
        return new OldRhinoErrorReporter(compiler);
    }

    void warningAtLine(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.WARNING));
    }

    void errorAtLine(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.ERROR));
    }

    private JSError makeError(String message, String sourceName, int line, int lineOffset, CheckLevel defaultLevel) {
        for (Map.Entry<Pattern, DiagnosticType> entry : this.typeMap.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            return JSError.make(sourceName, line, lineOffset, entry.getValue(), message);
        }
        return JSError.make(sourceName, line, lineOffset, defaultLevel, PARSE_ERROR, message);
    }

    private static class NewRhinoErrorReporter
    extends RhinoErrorReporter
    implements IdeErrorReporter {
        private NewRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, String sourceLine, int lineOffset) {
            super.errorAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int offset, int length) {
            int line = 1;
            int column = 0;
            SourceFile file = this.compiler.getSourceFileByName(sourceName);
            if (file != null) {
                line = file.getLineOfOffset(offset);
                column = file.getColumnOfOffset(offset);
            }
            super.errorAtLine(message, sourceName, line, column);
        }

        @Override
        public void warning(String message, String sourceName, int line, String sourceLine, int lineOffset) {
            super.warningAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int offset, int length) {
            int line = 1;
            int column = 0;
            SourceFile file = this.compiler.getSourceFileByName(sourceName);
            if (file != null) {
                line = file.getLineOfOffset(offset);
                column = file.getColumnOfOffset(offset);
            }
            super.errorAtLine(message, sourceName, line, column);
        }
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements com.google.javascript.rhino.ErrorReporter {
        private OldRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            super.errorAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            super.warningAtLine(message, sourceName, line, lineOffset);
        }
    }
}

