/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.LimitInputStream;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.EmptyMessageBundle;
import com.google.javascript.jscomp.JqueryCodingConvention;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.XtbMessageBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.StringOptionHandler;

public class CommandLineRunner
extends AbstractCommandLineRunner<Compiler, CompilerOptions> {
    private final Flags flags = new Flags();
    private boolean isConfigValid = false;
    private static final List<String> DEFAULT_EXTERNS_NAMES = ImmutableList.of((Object)"es3.js", (Object)"es5.js", (Object)"w3c_event.js", (Object)"w3c_event3.js", (Object)"gecko_event.js", (Object)"ie_event.js", (Object)"webkit_event.js", (Object)"w3c_dom1.js", (Object)"w3c_dom2.js", (Object)"w3c_dom3.js", (Object)"gecko_dom.js", (Object)"ie_dom.js", (Object[])new String[]{"webkit_dom.js", "w3c_css.js", "gecko_css.js", "ie_css.js", "webkit_css.js", "google.js", "deprecated.js", "fileapi.js", "flash.js", "gears_symbols.js", "gears_types.js", "gecko_xml.js", "html5.js", "ie_vml.js", "iphone.js", "webstorage.js", "w3c_anim_timing.js", "w3c_css3d.js", "w3c_elementtraversal.js", "w3c_geolocation.js", "w3c_indexeddb.js", "w3c_navigation_timing.js", "w3c_range.js", "w3c_selectors.js", "w3c_xml.js", "window.js", "webkit_notifications.js", "webgl.js"});

    protected CommandLineRunner(String[] args) {
        this.initConfigFromFlags(args, System.err);
    }

    protected CommandLineRunner(String[] args, PrintStream out, PrintStream err) {
        super(out, err);
        this.initConfigFromFlags(args, err);
    }

    private List<String> tokenizeKeepingQuotedStrings(List<String> lines) {
        ArrayList tokens = Lists.newArrayList();
        Pattern tokenPattern = Pattern.compile("(?:[^ \t\f\\x0B'\"]|(?:'[^']*'|\"[^\"]*\"))+");
        for (String line : lines) {
            Matcher matcher = tokenPattern.matcher(line);
            while (matcher.find()) {
                tokens.add(matcher.group(0));
            }
        }
        return tokens;
    }

    private List<String> processArgs(String[] args) {
        Pattern argPattern = Pattern.compile("(--[a-zA-Z_]+)=(.*)");
        Pattern quotesPattern = Pattern.compile("^['\"](.*)['\"]$");
        ArrayList processedArgs = Lists.newArrayList();
        for (String arg : args) {
            Matcher matcher = argPattern.matcher(arg);
            if (matcher.matches()) {
                processedArgs.add(matcher.group(1));
                String value = matcher.group(2);
                Matcher quotesMatcher = quotesPattern.matcher(value);
                if (quotesMatcher.matches()) {
                    processedArgs.add(quotesMatcher.group(1));
                    continue;
                }
                processedArgs.add(value);
                continue;
            }
            processedArgs.add(arg);
        }
        return processedArgs;
    }

    private void processFlagFile(PrintStream err) throws CmdLineException, IOException {
        File flagFileInput = new File(this.flags.flag_file);
        List<String> argsInFile = this.tokenizeKeepingQuotedStrings(Files.readLines((File)flagFileInput, (Charset)Charset.defaultCharset()));
        this.flags.flag_file = "";
        List<String> processedFileArgs = this.processArgs(argsInFile.toArray(new String[0]));
        CmdLineParser parserFileArgs = new CmdLineParser((Object)this.flags);
        Flags.warningGuardSpec.clear();
        parserFileArgs.parseArgument(processedFileArgs.toArray(new String[0]));
        if (!this.flags.flag_file.equals("")) {
            err.println("ERROR - Arguments in the file cannot contain --flagfile option.");
            this.isConfigValid = false;
        }
    }

    private void initConfigFromFlags(String[] args, PrintStream err) {
        List<String> processedArgs = this.processArgs(args);
        CmdLineParser parser = new CmdLineParser((Object)this.flags);
        Flags.warningGuardSpec.clear();
        this.isConfigValid = true;
        try {
            parser.parseArgument(processedArgs.toArray(new String[0]));
            if (!this.flags.flag_file.equals("")) {
                this.processFlagFile(err);
            }
        }
        catch (CmdLineException e) {
            err.println(e.getMessage());
            this.isConfigValid = false;
        }
        catch (IOException ioErr) {
            err.println("ERROR - " + this.flags.flag_file + " read error.");
            this.isConfigValid = false;
        }
        if (this.flags.version) {
            err.println("Closure Compiler (http://code.google.com/closure/compiler)\nVersion: " + Compiler.getReleaseVersion() + "\n" + "Built on: " + Compiler.getReleaseDate());
            err.flush();
        }
        if (this.flags.process_common_js_modules) {
            this.flags.process_closure_primitives = true;
            this.flags.manage_closure_dependencies = true;
            if (this.flags.common_js_entry_module == null) {
                err.println("Please specify --common_js_entry_module.");
                err.flush();
                this.isConfigValid = false;
            }
            this.flags.closure_entry_point = Lists.newArrayList((Object[])new String[]{ProcessCommonJSModules.toModuleName(this.flags.common_js_entry_module)});
        }
        if (!this.isConfigValid || this.flags.display_help) {
            this.isConfigValid = false;
            parser.printUsage((OutputStream)err);
        } else {
            CodingConvention conv = this.flags.third_party ? CodingConventions.getDefault() : (this.flags.process_jquery_primitives ? new JqueryCodingConvention() : new ClosureCodingConvention());
            this.getCommandLineConfig().setPrintTree(this.flags.print_tree).setPrintAst(this.flags.print_ast).setPrintPassGraph(this.flags.print_pass_graph).setJscompDevMode(this.flags.jscomp_dev_mode).setLoggingLevel(this.flags.logging_level).setExterns(this.flags.externs).setJs(this.flags.getJsFiles()).setJsOutputFile(this.flags.js_output_file).setModule(this.flags.module).setVariableMapInputFile(this.flags.variable_map_input_file).setPropertyMapInputFile(this.flags.property_map_input_file).setVariableMapOutputFile(this.flags.variable_map_output_file).setCreateNameMapFiles(this.flags.create_name_map_files).setPropertyMapOutputFile(this.flags.property_map_output_file).setCodingConvention(conv).setSummaryDetailLevel(this.flags.summary_detail_level).setOutputWrapper(this.flags.output_wrapper).setModuleWrapper(this.flags.module_wrapper).setModuleOutputPathPrefix(this.flags.module_output_path_prefix).setCreateSourceMap(this.flags.create_source_map).setSourceMapFormat(this.flags.source_map_format).setWarningGuardSpec(Flags.warningGuardSpec).setDefine(this.flags.define).setCharset(this.flags.charset).setManageClosureDependencies(this.flags.manage_closure_dependencies).setOnlyClosureDependencies(this.flags.only_closure_dependencies).setClosureEntryPoints(this.flags.closure_entry_point).setOutputManifest((List<String>)ImmutableList.of((Object)this.flags.output_manifest)).setAcceptConstKeyword(this.flags.accept_const_keyword).setLanguageIn(this.flags.language_in).setProcessCommonJSModules(this.flags.process_common_js_modules).setCommonJSModulePathPrefix(this.flags.common_js_path_prefix).setTransformAMDToCJSModules(this.flags.transform_amd_modules).setWarningsWhitelistFile(this.flags.warnings_whitelist_file);
        }
    }

    @Override
    protected CompilerOptions createOptions() {
        CompilerOptions options = new CompilerOptions();
        if (this.flags.process_jquery_primitives) {
            options.setCodingConvention(new JqueryCodingConvention());
        } else {
            options.setCodingConvention(new ClosureCodingConvention());
        }
        CompilationLevel level = this.flags.compilation_level;
        level.setOptionsForCompilationLevel(options);
        if (this.flags.debug) {
            level.setDebugOptionsForCompilationLevel(options);
        }
        if (this.flags.use_types_for_optimization) {
            level.setTypeBasedOptimizationOptions(options);
        }
        if (this.flags.generate_exports) {
            options.setGenerateExports(this.flags.generate_exports);
        }
        WarningLevel wLevel = this.flags.warning_level;
        wLevel.setOptionsForWarningLevel(options);
        for (FormattingOption formattingOption : this.flags.formatting) {
            formattingOption.applyToOptions(options);
        }
        options.closurePass = this.flags.process_closure_primitives;
        boolean bl = options.jqueryPass = this.flags.process_jquery_primitives && CompilationLevel.ADVANCED_OPTIMIZATIONS == level;
        if (!this.flags.translationsFile.isEmpty()) {
            try {
                options.messageBundle = new XtbMessageBundle(new FileInputStream(this.flags.translationsFile), this.flags.translationsProject);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading XTB file", e);
            }
        } else if (CompilationLevel.ADVANCED_OPTIMIZATIONS == level) {
            options.messageBundle = new EmptyMessageBundle();
        }
        return options;
    }

    @Override
    protected Compiler createCompiler() {
        return new Compiler(this.getErrorPrintStream());
    }

    @Override
    protected List<SourceFile> createExterns() throws AbstractCommandLineRunner.FlagUsageException, IOException {
        List<SourceFile> externs = super.createExterns();
        if (this.flags.use_only_custom_externs || this.isInTestMode()) {
            return externs;
        }
        List<SourceFile> defaultExterns = CommandLineRunner.getDefaultExterns();
        defaultExterns.addAll(externs);
        return defaultExterns;
    }

    public static List<SourceFile> getDefaultExterns() throws IOException {
        InputStream input = CommandLineRunner.class.getResourceAsStream("/externs.zip");
        if (input == null) {
            input = CommandLineRunner.class.getResourceAsStream("externs.zip");
        }
        Preconditions.checkNotNull((Object)input);
        ZipInputStream zip = new ZipInputStream(input);
        HashMap externsMap = Maps.newHashMap();
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            BufferedInputStream entryStream = new BufferedInputStream((InputStream)new LimitInputStream((InputStream)zip, entry.getSize()));
            externsMap.put(entry.getName(), SourceFile.fromInputStream("externs.zip//" + entry.getName(), entryStream));
        }
        Preconditions.checkState((boolean)((Object)externsMap.keySet()).equals(Sets.newHashSet(DEFAULT_EXTERNS_NAMES)), (Object)"Externs zip must match our hard-coded list of externs.");
        ArrayList externs = Lists.newArrayList();
        for (String key : DEFAULT_EXTERNS_NAMES) {
            externs.add(externsMap.get(key));
        }
        return externs;
    }

    public boolean shouldRunCompiler() {
        return this.isConfigValid;
    }

    public static void main(String[] args) {
        CommandLineRunner runner = new CommandLineRunner(args);
        if (runner.shouldRunCompiler()) {
            runner.run();
        } else {
            System.exit(-1);
        }
    }

    private static enum FormattingOption {
        PRETTY_PRINT,
        PRINT_INPUT_DELIMITER;


        private void applyToOptions(CompilerOptions options) {
            switch (this) {
                case PRETTY_PRINT: {
                    options.prettyPrint = true;
                    break;
                }
                case PRINT_INPUT_DELIMITER: {
                    options.printInputDelimiter = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown formatting option: " + (Object)((Object)this));
                }
            }
        }
    }

    private static class Flags {
        private static final AbstractCommandLineRunner.WarningGuardSpec warningGuardSpec = new AbstractCommandLineRunner.WarningGuardSpec();
        @Option(name="--help", handler=BooleanOptionHandler.class, usage="Displays this message")
        private boolean display_help = false;
        @Option(name="--print_tree", handler=BooleanOptionHandler.class, usage="Prints out the parse tree and exits")
        private boolean print_tree = false;
        @Option(name="--print_ast", handler=BooleanOptionHandler.class, usage="Prints a dot file describing the internal abstract syntax tree and exits")
        private boolean print_ast = false;
        @Option(name="--print_pass_graph", handler=BooleanOptionHandler.class, usage="Prints a dot file describing the passes that will get run and exits")
        private boolean print_pass_graph = false;
        @Option(name="--jscomp_dev_mode", aliases={"--dev_mode"})
        private CompilerOptions.DevMode jscomp_dev_mode = CompilerOptions.DevMode.OFF;
        @Option(name="--logging_level", usage="The logging level (standard java.util.logging.Level values) for Compiler progress. Does not control errors or warnings for the JavaScript code under compilation")
        private String logging_level = Level.WARNING.getName();
        @Option(name="--externs", usage="The file containing JavaScript externs. You may specify multiple")
        private List<String> externs = Lists.newArrayList();
        @Option(name="--js", usage="The JavaScript filename. You may specify multiple")
        private List<String> js = Lists.newArrayList();
        @Option(name="--js_output_file", usage="Primary output filename. If not specified, output is written to stdout")
        private String js_output_file = "";
        @Option(name="--module", usage="A JavaScript module specification. The format is <name>:<num-js-files>[:[<dep>,...][:]]]. Module names must be unique. Each dep is the name of a module that this module depends on. Modules must be listed in dependency order, and JS source files must be listed in the corresponding order. Where --module flags occur in relation to --js flags is unimportant")
        private List<String> module = Lists.newArrayList();
        @Option(name="--variable_map_input_file", usage="File containing the serialized version of the variable renaming map produced by a previous compilation")
        private String variable_map_input_file = "";
        @Option(name="--property_map_input_file", usage="File containing the serialized version of the property renaming map produced by a previous compilation")
        private String property_map_input_file = "";
        @Option(name="--variable_map_output_file", usage="File where the serialized version of the variable renaming map produced should be saved")
        private String variable_map_output_file = "";
        @Option(name="--create_name_map_files", handler=BooleanOptionHandler.class, usage="If true, variable renaming and property renaming map files will be produced as {binary name}_vars_map.out and {binary name}_props_map.out. Note that this flag cannot be used in conjunction with either variable_map_output_file or property_map_output_file")
        private boolean create_name_map_files = false;
        @Option(name="--property_map_output_file", usage="File where the serialized version of the property renaming map produced should be saved")
        private String property_map_output_file = "";
        @Option(name="--third_party", handler=BooleanOptionHandler.class, usage="Check source validity but do not enforce Closure style rules and conventions")
        private boolean third_party = false;
        @Option(name="--summary_detail_level", usage="Controls how detailed the compilation summary is. Values: 0 (never print summary), 1 (print summary only if there are errors or warnings), 2 (print summary if type checking is on, see --check_types), 3 (always print summary). The default level is 1")
        private int summary_detail_level = 1;
        @Option(name="--output_wrapper", usage="Interpolate output into this string at the place denoted by the marker token %output%. See --output_wrapper_marker")
        private String output_wrapper = "";
        @Option(name="--module_wrapper", usage="An output wrapper for a JavaScript module (optional). The format is <name>:<wrapper>. The module name must correspond with a module specified using --module. The wrapper must contain %s as the code placeholder. The %basename% placeholder can also be used to substitute the base name of the module output file.")
        private List<String> module_wrapper = Lists.newArrayList();
        @Option(name="--module_output_path_prefix", usage="Prefix for filenames of compiled JS modules. <module-name>.js will be appended to this prefix. Directories will be created as needed. Use with --module")
        private String module_output_path_prefix = "./";
        @Option(name="--create_source_map", usage="If specified, a source map file mapping the generated source files back to the original source file will be output to the specified path. The %outname% placeholder will expand to the name of the output file that the source map corresponds to.")
        private String create_source_map = "";
        @Option(name="--source_map_format", usage="The source map format to produce. Options: V1, V2, V3, DEFAULT. DEFAULT produces V2.")
        private SourceMap.Format source_map_format = SourceMap.Format.DEFAULT;
        @Option(name="--jscomp_error", handler=WarningGuardErrorOptionHandler.class, usage="Make the named class of warnings an error. Options:accessControls, ambiguousFunctionDecl, checkRegExp, checkTypes, checkVars, const, constantProperty, deprecated, duplicateMessage, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, missingProperties, nonStandardJsDocs, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, visibility")
        private List<String> jscomp_error = Lists.newArrayList();
        @Option(name="--jscomp_warning", handler=WarningGuardWarningOptionHandler.class, usage="Make the named class of warnings a normal warning. Options:accessControls, ambiguousFunctionDecl, checkRegExp, checkTypes, checkVars, const, constantProperty, deprecated, duplicateMessage, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, missingProperties, nonStandardJsDocs, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, visibility")
        private List<String> jscomp_warning = Lists.newArrayList();
        @Option(name="--jscomp_off", handler=WarningGuardOffOptionHandler.class, usage="Turn off the named class of warnings. Options:accessControls, ambiguousFunctionDecl, checkRegExp, checkTypes, checkVars, const, constantProperty, deprecated, duplicateMessage, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, missingProperties, nonStandardJsDocs, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, visibility")
        private List<String> jscomp_off = Lists.newArrayList();
        @Option(name="--define", aliases={"--D", "-D"}, usage="Override the value of a variable annotated @define. The format is <name>[=<val>], where <name> is the name of a @define variable and <val> is a boolean, number, or a single-quoted string that contains no single quotes. If [=<val>] is omitted, the variable is marked true")
        private List<String> define = Lists.newArrayList();
        @Option(name="--charset", usage="Input and output charset for all files. By default, we accept UTF-8 as input and output US_ASCII")
        private String charset = "";
        @Option(name="--compilation_level", usage="Specifies the compilation level to use. Options: WHITESPACE_ONLY, SIMPLE_OPTIMIZATIONS, ADVANCED_OPTIMIZATIONS")
        private CompilationLevel compilation_level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        @Option(name="--use_types_for_optimization", usage="Experimental: perform additional optimizations based on available information.  Inaccurate type annotations may result in incorrect results.")
        private boolean use_types_for_optimization = false;
        @Option(name="--warning_level", usage="Specifies the warning level to use. Options: QUIET, DEFAULT, VERBOSE")
        private WarningLevel warning_level = WarningLevel.DEFAULT;
        @Option(name="--use_only_custom_externs", handler=BooleanOptionHandler.class, usage="Specifies whether the default externs should be excluded")
        private boolean use_only_custom_externs = false;
        @Option(name="--debug", handler=BooleanOptionHandler.class, usage="Enable debugging options")
        private boolean debug = false;
        @Option(name="--generate_exports", handler=BooleanOptionHandler.class, usage="Generates export code for those marked with @export")
        private boolean generate_exports = false;
        @Option(name="--formatting", usage="Specifies which formatting options, if any, should be applied to the output JS. Options: PRETTY_PRINT, PRINT_INPUT_DELIMITER")
        private List<FormattingOption> formatting = Lists.newArrayList();
        @Option(name="--process_common_js_modules", usage="Process CommonJS modules to a concatenable form.")
        private boolean process_common_js_modules = false;
        @Option(name="--common_js_module_path_prefix", usage="Path prefix to be removed from CommonJS module names.")
        private String common_js_path_prefix = ProcessCommonJSModules.DEFAULT_FILENAME_PREFIX;
        @Option(name="--common_js_entry_module", usage="Root of your common JS dependency hierarchy. Your main script.")
        private String common_js_entry_module;
        @Option(name="--transform_amd_modules", usage="Transform AMD to CommonJS modules.")
        private boolean transform_amd_modules = false;
        @Option(name="--process_closure_primitives", handler=BooleanOptionHandler.class, usage="Processes built-ins from the Closure library, such as goog.require(), goog.provide(), and goog.exportSymbol()")
        private boolean process_closure_primitives = true;
        @Option(name="--manage_closure_dependencies", handler=BooleanOptionHandler.class, usage="Automatically sort dependencies so that a file that goog.provides symbol X will always come before a file that goog.requires symbol X. If an input provides symbols, and those symbols are never required, then that input will not be included in the compilation.")
        private boolean manage_closure_dependencies = false;
        @Option(name="--only_closure_dependencies", handler=BooleanOptionHandler.class, usage="Only include files in the transitive dependency of the entry points (specified by closure_entry_point). Files that do not provide dependencies will be removed. This supersedesmanage_closure_dependencies")
        private boolean only_closure_dependencies = false;
        @Option(name="--closure_entry_point", usage="Entry points to the program. Must be goog.provide'd symbols. Any goog.provide'd symbols that are not a transitive dependency of the entry points will be removed. Files without goog.provides, and their dependencies, will always be left in. If any entry points are specified, then the manage_closure_dependencies option will be set to true and all files will be sorted in dependency order.")
        private List<String> closure_entry_point = Lists.newArrayList();
        @Option(name="--process_jquery_primitives", handler=BooleanOptionHandler.class, usage="Processes built-ins from the Jquery library, such as jQuery.fn and jQuery.extend()")
        private boolean process_jquery_primitives = false;
        @Option(name="--output_manifest", usage="Prints out a list of all the files in the compilation. If --manage_closure_dependencies is on, this will not include files that got dropped because they were not required. The %outname% placeholder expands to the JS output file. If you're using modularization, using %outname% will create a manifest for each module.")
        private String output_manifest = "";
        @Option(name="--accept_const_keyword", usage="Allows usage of const keyword.")
        private boolean accept_const_keyword = false;
        @Option(name="--language_in", usage="Sets what language spec that input sources conform. Options: ECMASCRIPT3 (default), ECMASCRIPT5, ECMASCRIPT5_STRICT")
        private String language_in = "ECMASCRIPT3";
        @Option(name="--version", handler=BooleanOptionHandler.class, usage="Prints the compiler version to stderr.")
        private boolean version = false;
        @Option(name="--translations_file", usage="Source of translated messages. Currently only supports XTB.")
        private String translationsFile = "";
        @Option(name="--translations_project", usage="Scopes all translations to the specified project.When specified, we will use different message ids so that messages in different projects can have different translations.")
        private String translationsProject = null;
        @Option(name="--flagfile", usage="A file containing additional command-line options.")
        private String flag_file = "";
        @Option(name="--warnings_whitelist_file", usage="A file containing warnings to suppress. Each line should be of the form\n<file-name>:<line-number>?  <warning-description>")
        private String warnings_whitelist_file = "";
        @Argument
        private List<String> arguments = Lists.newArrayList();

        private Flags() {
        }

        List<String> getJsFiles() {
            ArrayList allJsInputs = Lists.newArrayListWithCapacity((int)(this.js.size() + this.arguments.size()));
            allJsInputs.addAll(this.js);
            allJsInputs.addAll(this.arguments);
            return allJsInputs;
        }

        private static class WarningGuardSetter
        implements Setter<String> {
            private final Setter<? super String> proxy;
            private final CheckLevel level;

            private WarningGuardSetter(Setter<? super String> proxy, CheckLevel level) {
                this.proxy = proxy;
                this.level = level;
            }

            public boolean isMultiValued() {
                return this.proxy.isMultiValued();
            }

            public Class<String> getType() {
                return this.proxy.getType();
            }

            public void addValue(String value) throws CmdLineException {
                this.proxy.addValue((Object)value);
                warningGuardSpec.add(this.level, value);
            }
        }

        public static class WarningGuardOffOptionHandler
        extends StringOptionHandler {
            public WarningGuardOffOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, (Setter)new WarningGuardSetter(setter, CheckLevel.OFF));
            }
        }

        public static class WarningGuardWarningOptionHandler
        extends StringOptionHandler {
            public WarningGuardWarningOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, (Setter)new WarningGuardSetter(setter, CheckLevel.WARNING));
            }
        }

        public static class WarningGuardErrorOptionHandler
        extends StringOptionHandler {
            public WarningGuardErrorOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, (Setter)new WarningGuardSetter(setter, CheckLevel.ERROR));
            }
        }

        public static class BooleanOptionHandler
        extends OptionHandler<Boolean> {
            private static final Set<String> TRUES = Sets.newHashSet((Object[])new String[]{"true", "on", "yes", "1"});
            private static final Set<String> FALSES = Sets.newHashSet((Object[])new String[]{"false", "off", "no", "0"});

            public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
                super(parser, option, setter);
            }

            public int parseArguments(Parameters params) throws CmdLineException {
                String param = null;
                try {
                    param = params.getParameter(0);
                }
                catch (CmdLineException e) {
                    // empty catch block
                }
                if (param == null) {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                String lowerParam = param.toLowerCase();
                if (TRUES.contains(lowerParam)) {
                    this.setter.addValue((Object)true);
                } else if (FALSES.contains(lowerParam)) {
                    this.setter.addValue((Object)false);
                } else {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                return 1;
            }

            public String getDefaultMetaVariable() {
                return null;
            }
        }
    }
}

