/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeIterators;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InlineVariables
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Mode mode;
    private final boolean inlineAllStrings;
    private final IdentifyConstants identifyConstants = new IdentifyConstants();

    InlineVariables(AbstractCompiler compiler, Mode mode, boolean inlineAllStrings) {
        this.compiler = compiler;
        this.mode = mode;
        this.inlineAllStrings = inlineAllStrings;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new InliningBehavior(), this.getFilterForMode());
        callback.process(externs, root);
    }

    private Predicate<Scope.Var> getFilterForMode() {
        switch (this.mode) {
            case ALL: {
                return Predicates.alwaysTrue();
            }
            case LOCALS_ONLY: {
                return new IdentifyLocals();
            }
            case CONSTANTS_ONLY: {
                return new IdentifyConstants();
            }
        }
        throw new IllegalStateException();
    }

    private class InliningBehavior
    implements ReferenceCollectingCallback.Behavior {
        private final Set<Scope.Var> staleVars = Sets.newHashSet();
        final Map<Node, AliasCandidate> aliasCandidates = Maps.newHashMap();

        private InliningBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            this.collectAliasCandidates(t, referenceMap);
            this.doInlinesForScope(t, referenceMap);
        }

        private void collectAliasCandidates(NodeTraversal t, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            if (InlineVariables.this.mode != Mode.CONSTANTS_ONLY) {
                Iterator<Scope.Var> it = t.getScope().getVars();
                while (it.hasNext()) {
                    ReferenceCollectingCallback.Reference init;
                    Node value;
                    Scope.Var v = it.next();
                    ReferenceCollectingCallback.ReferenceCollection referenceInfo = referenceMap.getReferences(v);
                    if (referenceInfo == null || referenceInfo.references.size() < 2 || !referenceInfo.isWellDefined() || !referenceInfo.isAssignedOnceInLifetime() || (value = (init = referenceInfo.getInitializingReference()).getAssignedValue()) == null || !value.isName()) continue;
                    this.aliasCandidates.put(value, new AliasCandidate(v, referenceInfo));
                }
            }
        }

        private void doInlinesForScope(NodeTraversal t, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            boolean maybeModifiedArguments = this.maybeEscapedOrModifiedArguments(t.getScope(), referenceMap);
            Iterator<Scope.Var> it = t.getScope().getVars();
            while (it.hasNext()) {
                Scope.Var v = it.next();
                ReferenceCollectingCallback.ReferenceCollection referenceInfo = referenceMap.getReferences(v);
                if (referenceInfo == null || this.isVarInlineForbidden(v)) continue;
                if (this.isInlineableDeclaredConstant(v, referenceInfo)) {
                    ReferenceCollectingCallback.Reference init = referenceInfo.getInitializingReferenceForConstants();
                    Node value = init.getAssignedValue();
                    this.inlineDeclaredConstant(v, value, referenceInfo.references);
                    this.staleVars.add(v);
                    continue;
                }
                if (InlineVariables.this.mode == Mode.CONSTANTS_ONLY) continue;
                this.inlineNonConstants(v, referenceInfo, maybeModifiedArguments);
            }
        }

        private boolean maybeEscapedOrModifiedArguments(Scope scope, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            Scope.Var arguments;
            ReferenceCollectingCallback.ReferenceCollection refs;
            if (scope.isLocal() && (refs = referenceMap.getReferences(arguments = scope.getArgumentsVar())) != null && !refs.references.isEmpty()) {
                for (ReferenceCollectingCallback.Reference ref : refs.references) {
                    Node refNode = ref.getNode();
                    Node refParent = ref.getParent();
                    if (NodeUtil.isGet(refParent) && refNode == ref.getParent().getFirstChild() && !this.isLValue(refParent)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isLValue(Node n) {
            Node parent = n.getParent();
            return parent.isInc() || parent.isDec() || NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n;
        }

        private void inlineNonConstants(Scope.Var v, ReferenceCollectingCallback.ReferenceCollection referenceInfo, boolean maybeModifiedArguments) {
            Node value;
            ReferenceCollectingCallback.Reference init;
            int firstRefAfterInit;
            int refCount = referenceInfo.references.size();
            ReferenceCollectingCallback.Reference declaration = referenceInfo.references.get(0);
            int n = firstRefAfterInit = declaration == (init = referenceInfo.getInitializingReference()) ? 2 : 3;
            if (refCount > 1 && this.isImmutableAndWellDefinedVariable(v, referenceInfo)) {
                if (init != null) {
                    value = init.getAssignedValue();
                } else {
                    Node srcLocation = declaration.getNode();
                    value = NodeUtil.newUndefinedNode(srcLocation);
                }
                Preconditions.checkNotNull((Object)value);
                this.inlineWellDefinedVariable(v, value, referenceInfo.references);
                this.staleVars.add(v);
            } else if (refCount == firstRefAfterInit) {
                ReferenceCollectingCallback.Reference reference = referenceInfo.references.get(firstRefAfterInit - 1);
                if (this.canInline(declaration, init, reference)) {
                    this.inline(v, declaration, init, reference);
                    this.staleVars.add(v);
                }
            } else if (declaration != init && refCount == 2 && this.isValidDeclaration(declaration) && this.isValidInitialization(init)) {
                value = init.getAssignedValue();
                Preconditions.checkNotNull((Object)value);
                this.inlineWellDefinedVariable(v, value, referenceInfo.references);
                this.staleVars.add(v);
            }
            if (!maybeModifiedArguments && !this.staleVars.contains(v) && referenceInfo.isWellDefined() && referenceInfo.isAssignedOnceInLifetime()) {
                List<ReferenceCollectingCallback.Reference> refs = referenceInfo.references;
                for (int i = 1; i < refs.size(); ++i) {
                    AliasCandidate candidate;
                    Node nameNode = refs.get(i).getNode();
                    if (!this.aliasCandidates.containsKey(nameNode) || this.staleVars.contains((candidate = this.aliasCandidates.get(nameNode)).alias) || this.isVarInlineForbidden(candidate.alias)) continue;
                    ReferenceCollectingCallback.Reference aliasInit = candidate.refInfo.getInitializingReference();
                    Node value2 = aliasInit.getAssignedValue();
                    Preconditions.checkNotNull((Object)value2);
                    this.inlineWellDefinedVariable(candidate.alias, value2, ((AliasCandidate)candidate).refInfo.references);
                    this.staleVars.add(candidate.alias);
                }
            }
        }

        private void blacklistVarReferencesInTree(Node root, Scope scope) {
            for (Node c = root.getFirstChild(); c != null; c = c.getNext()) {
                this.blacklistVarReferencesInTree(c, scope);
            }
            if (root.isName()) {
                this.staleVars.add(scope.getVar(root.getString()));
            }
        }

        private boolean isVarInlineForbidden(Scope.Var var) {
            return var.isExtern() || InlineVariables.this.compiler.getCodingConvention().isExported(var.name) || "JSCompiler_renameProperty".equals(var.name) || this.staleVars.contains(var);
        }

        private void inline(Scope.Var v, ReferenceCollectingCallback.Reference declaration, ReferenceCollectingCallback.Reference init, ReferenceCollectingCallback.Reference reference) {
            Node value = init.getAssignedValue();
            Preconditions.checkState((value != null ? 1 : 0) != 0);
            boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(value);
            this.inlineValue(v, reference, value.detachFromParent());
            if (declaration != init) {
                Node expressRoot = init.getGrandparent();
                Preconditions.checkState((boolean)expressRoot.isExprResult());
                NodeUtil.removeChild(expressRoot.getParent(), expressRoot);
            }
            if (!isFunctionDeclaration) {
                this.removeDeclaration(declaration);
            } else {
                InlineVariables.this.compiler.reportCodeChange();
            }
        }

        private void inlineWellDefinedVariable(Scope.Var v, Node value, List<ReferenceCollectingCallback.Reference> refSet) {
            ReferenceCollectingCallback.Reference decl = refSet.get(0);
            for (int i = 1; i < refSet.size(); ++i) {
                this.inlineValue(v, refSet.get(i), value.cloneTree());
            }
            this.removeDeclaration(decl);
        }

        private void inlineDeclaredConstant(Scope.Var v, Node value, List<ReferenceCollectingCallback.Reference> refSet) {
            ReferenceCollectingCallback.Reference decl = null;
            for (ReferenceCollectingCallback.Reference r : refSet) {
                if (r.getNode() == v.getNameNode()) {
                    decl = r;
                    continue;
                }
                this.inlineValue(v, r, value.cloneTree());
            }
            this.removeDeclaration(decl);
        }

        private void removeDeclaration(ReferenceCollectingCallback.Reference declaration) {
            Node varNode = declaration.getParent();
            Node grandparent = declaration.getGrandparent();
            varNode.removeChild(declaration.getNode());
            if (!varNode.hasChildren()) {
                Preconditions.checkState((boolean)varNode.isVar());
                NodeUtil.removeChild(grandparent, varNode);
            }
            InlineVariables.this.compiler.reportCodeChange();
        }

        private void inlineValue(Scope.Var v, ReferenceCollectingCallback.Reference ref, Node value) {
            if (ref.isSimpleAssignmentToName()) {
                ref.getGrandparent().replaceChild(ref.getParent(), value);
            } else {
                ref.getParent().replaceChild(ref.getNode(), value);
            }
            this.blacklistVarReferencesInTree(value, v.scope);
            InlineVariables.this.compiler.reportCodeChange();
        }

        private boolean isInlineableDeclaredConstant(Scope.Var var, ReferenceCollectingCallback.ReferenceCollection refInfo) {
            if (!InlineVariables.this.identifyConstants.apply(var)) {
                return false;
            }
            if (!refInfo.isAssignedOnceInLifetime()) {
                return false;
            }
            ReferenceCollectingCallback.Reference init = refInfo.getInitializingReferenceForConstants();
            if (init == null) {
                return false;
            }
            Node value = init.getAssignedValue();
            if (value == null) {
                return false;
            }
            if (!NodeUtil.isImmutableValue(value)) {
                return false;
            }
            return !value.isString() || this.isStringWorthInlining(var, refInfo.references);
        }

        private boolean isStringWorthInlining(Scope.Var var, List<ReferenceCollectingCallback.Reference> refs) {
            if (!InlineVariables.this.inlineAllStrings && !var.isDefine()) {
                int inlineBytes;
                int len = var.getInitialValue().getString().length() + "''".length();
                int noInlineBytes = "var xx=;".length() + len + 4 * (refs.size() - 1);
                return noInlineBytes >= (inlineBytes = (len - 1) * (refs.size() - 1));
            }
            return true;
        }

        private boolean canInline(ReferenceCollectingCallback.Reference declaration, ReferenceCollectingCallback.Reference initialization, ReferenceCollectingCallback.Reference reference) {
            if (!(this.isValidDeclaration(declaration) && this.isValidInitialization(initialization) && this.isValidReference(reference))) {
                return false;
            }
            if (declaration != initialization && !initialization.getGrandparent().isExprResult()) {
                return false;
            }
            if (declaration.getBasicBlock() != initialization.getBasicBlock() || declaration.getBasicBlock() != reference.getBasicBlock()) {
                return false;
            }
            Node value = initialization.getAssignedValue();
            Preconditions.checkState((value != null ? 1 : 0) != 0);
            if (value.isGetProp() && reference.getParent().isCall() && reference.getParent().getFirstChild() == reference.getNode()) {
                return false;
            }
            if (value.isFunction()) {
                Node callNode = reference.getParent();
                if (reference.getParent().isCall()) {
                    CodingConvention convention = InlineVariables.this.compiler.getCodingConvention();
                    CodingConvention.SubclassRelationship relationship = convention.getClassesDefinedByCall(callNode);
                    if (relationship != null) {
                        return false;
                    }
                    if (convention.getSingletonGetterClassName(callNode) != null) {
                        return false;
                    }
                }
            }
            return this.canMoveAggressively(value) || this.canMoveModerately(initialization, reference);
        }

        private boolean canMoveAggressively(Node value) {
            return NodeUtil.isLiteralValue(value, true) || value.isFunction();
        }

        private boolean canMoveModerately(ReferenceCollectingCallback.Reference initialization, ReferenceCollectingCallback.Reference reference) {
            NodeIterators.LocalVarMotion it;
            if (initialization.getParent().isVar()) {
                it = NodeIterators.LocalVarMotion.forVar(initialization.getNode(), initialization.getParent(), initialization.getGrandparent());
            } else if (initialization.getParent().isAssign()) {
                Preconditions.checkState((boolean)initialization.getGrandparent().isExprResult());
                it = NodeIterators.LocalVarMotion.forAssign(initialization.getNode(), initialization.getParent(), initialization.getGrandparent(), initialization.getGrandparent().getParent());
            } else {
                throw new IllegalStateException("Unexpected initialization parent " + initialization.getParent().toStringTree());
            }
            Node targetName = reference.getNode();
            while (it.hasNext()) {
                Node curNode = (Node)it.next();
                if (curNode != targetName) continue;
                return true;
            }
            return false;
        }

        private boolean isValidDeclaration(ReferenceCollectingCallback.Reference declaration) {
            return declaration.getParent().isVar() && !declaration.getGrandparent().isFor() || NodeUtil.isFunctionDeclaration(declaration.getParent());
        }

        private boolean isValidInitialization(ReferenceCollectingCallback.Reference initialization) {
            if (initialization == null) {
                return false;
            }
            if (initialization.isDeclaration()) {
                return NodeUtil.isFunctionDeclaration(initialization.getParent()) || initialization.getNode().getFirstChild() != null;
            }
            Node parent = initialization.getParent();
            Preconditions.checkState((parent.isAssign() && parent.getFirstChild() == initialization.getNode() ? 1 : 0) != 0);
            return true;
        }

        private boolean isValidReference(ReferenceCollectingCallback.Reference reference) {
            return !reference.isDeclaration() && !reference.isLvalue();
        }

        private boolean isImmutableAndWellDefinedVariable(Scope.Var v, ReferenceCollectingCallback.ReferenceCollection refInfo) {
            List<ReferenceCollectingCallback.Reference> refSet = refInfo.references;
            int startingReadRef = 1;
            ReferenceCollectingCallback.Reference refDecl = refSet.get(0);
            if (!this.isValidDeclaration(refDecl)) {
                return false;
            }
            boolean isNeverAssigned = refInfo.isNeverAssigned();
            if (!isNeverAssigned) {
                boolean isInlinableThisAlias;
                ReferenceCollectingCallback.Reference refInit = refInfo.getInitializingReference();
                if (!this.isValidInitialization(refInit)) {
                    return false;
                }
                if (refDecl != refInit) {
                    Preconditions.checkState((refInit == refSet.get(1) ? 1 : 0) != 0);
                    startingReadRef = 2;
                }
                if (!refInfo.isWellDefined()) {
                    return false;
                }
                Node value = refInit.getAssignedValue();
                Preconditions.checkNotNull((Object)value);
                boolean isImmutableValueWorthInlining = NodeUtil.isImmutableValue(value) && (!value.isString() || this.isStringWorthInlining(v, refInfo.references));
                boolean bl = isInlinableThisAlias = value.isThis() && !refInfo.isEscaped();
                if (!isImmutableValueWorthInlining && !isInlinableThisAlias) {
                    return false;
                }
            }
            for (int i = startingReadRef; i < refSet.size(); ++i) {
                ReferenceCollectingCallback.Reference ref = refSet.get(i);
                if (this.isValidReference(ref)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AliasCandidate {
        private final Scope.Var alias;
        private final ReferenceCollectingCallback.ReferenceCollection refInfo;

        AliasCandidate(Scope.Var alias, ReferenceCollectingCallback.ReferenceCollection refInfo) {
            this.alias = alias;
            this.refInfo = refInfo;
        }
    }

    private class IdentifyLocals
    implements Predicate<Scope.Var> {
        private IdentifyLocals() {
        }

        public boolean apply(Scope.Var var) {
            return var.scope.isLocal();
        }
    }

    private class IdentifyConstants
    implements Predicate<Scope.Var> {
        private IdentifyConstants() {
        }

        public boolean apply(Scope.Var var) {
            return var.isConst();
        }
    }

    static enum Mode {
        CONSTANTS_ONLY,
        LOCALS_ONLY,
        ALL;

    }
}

