/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeParameters
implements Serializable {
    private final ImmutableMap<String, Node> typeParams;
    static final TypeParameters EMPTY = new TypeParameters((Map<String, Node>)ImmutableMap.of());

    private TypeParameters(Map<String, Node> typeParams) {
        this.typeParams = ImmutableMap.copyOf(typeParams);
    }

    static TypeParameters make(List<String> ordinaryTypeParams) {
        return TypeParameters.make(ordinaryTypeParams, (Map<String, Node>)ImmutableMap.of());
    }

    static TypeParameters make(List<String> ordinaryTypeParams, Map<String, Node> ttlParams) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : ordinaryTypeParams) {
            builder.put((Object)typeParam, (Object)IR.empty());
        }
        builder.putAll(ttlParams);
        return new TypeParameters((Map<String, Node>)builder.build());
    }

    List<String> asList() {
        return this.typeParams.keySet().asList();
    }

    List<String> getOrdinaryTypeParams() {
        boolean foundTtlVariable = false;
        for (Map.Entry entry : this.typeParams.entrySet()) {
            if (((Node)entry.getValue()).isEmpty()) continue;
            foundTtlVariable = true;
            break;
        }
        if (foundTtlVariable) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry entry : this.typeParams.entrySet()) {
                if (!((Node)entry.getValue()).isEmpty()) continue;
                builder.add(entry.getKey());
            }
            return builder.build();
        }
        return this.typeParams.keySet().asList();
    }

    public Map<String, Node> getTypeTransformations() {
        boolean foundOrdinaryTypeVariable = false;
        for (Map.Entry entry : this.typeParams.entrySet()) {
            if (!((Node)entry.getValue()).isEmpty()) continue;
            foundOrdinaryTypeVariable = true;
            break;
        }
        if (foundOrdinaryTypeVariable) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.typeParams.entrySet()) {
                if (((Node)entry.getValue()).isEmpty()) continue;
                builder.put(entry);
            }
            return builder.build();
        }
        return this.typeParams;
    }

    boolean isEmpty() {
        return this.typeParams.isEmpty();
    }

    boolean contains(String typeParam) {
        return this.typeParams.containsKey((Object)typeParam);
    }

    public boolean equals(Object o) {
        TypeParameters other = (TypeParameters)o;
        return this.typeParams.equals(other.typeParams);
    }

    public int hashCode() {
        return Objects.hashCode(this.typeParams);
    }
}

