/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.TypeParameters;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JSTypeCreatorFromJSDoc
implements Serializable {
    public static final DiagnosticType INVALID_GENERICS_INSTANTIATION = DiagnosticType.warning("JSC_NTI_INVALID_GENERICS_INSTANTIATION", "Invalid generics instantiation{0}.\nExpected {1} type argument(s), but found {2}");
    public static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_NTI_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    public static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_NTI_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    public static final DiagnosticType INHERITANCE_CYCLE = DiagnosticType.warning("JSC_NTI_INHERITANCE_CYCLE", "Cycle detected in inheritance chain of type {0}");
    public static final DiagnosticType DICT_IMPLEMENTS_INTERF = DiagnosticType.warning("JSC_NTI_DICT_IMPLEMENTS_INTERF", "Class {0} is a dict. Dicts can't implement interfaces");
    public static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_NTI_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    public static final DiagnosticType CONFLICTING_EXTENDED_TYPE = DiagnosticType.warning("JSC_NTI_CONFLICTING_EXTENDED_TYPE", "{1} cannot extend this type; {0}s can only extend {0}s");
    public static final DiagnosticType CONFLICTING_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_NTI_CONFLICTING_IMPLEMENTED_TYPE", "{0} cannot implement this type; an interface can only extend, but not implement interfaces");
    public static final DiagnosticType UNION_IS_UNINHABITABLE = DiagnosticType.warning("JSC_NTI_UNION_IS_UNINHABITABLE", "Union of {0} with {1} would create an impossible type");
    public static final DiagnosticType NEW_EXPECTS_OBJECT_OR_TYPEVAR = DiagnosticType.warning("JSC_NTI_NEW_EXPECTS_OBJECT_OR_TYPEVAR", "The \"new:\" annotation only accepts object types and type variables; found {0}");
    public static final DiagnosticType BAD_ARRAY_TYPE_SYNTAX = DiagnosticType.warning("JSC_NTI_BAD_ARRAY_TYPE_SYNTAX", "The [] type syntax is not supported. Please use Array<T> instead");
    public static final DiagnosticType CANNOT_MAKE_TYPEVAR_NON_NULL = DiagnosticType.warning("JSC_NTI_CANNOT_MAKE_TYPEVAR_NON_NULL", "Cannot use ! to restrict type variable type.\nPrefer to make type argument non-nullable and add null explicitly where needed (e.g. through ?T or T|null)");
    public static final DiagnosticType CIRCULAR_TYPEDEF_ENUM = DiagnosticType.warning("JSC_NTI_CIRCULAR_TYPEDEF_ENUM", "Circular typedefs/enums are not allowed");
    public static final DiagnosticType ENUM_WITH_TYPEVARS = DiagnosticType.warning("JSC_NTI_ENUM_WITH_TYPEVARS", "An enum type cannot include type variables");
    public static final DiagnosticType ENUM_IS_TOP = DiagnosticType.warning("JSC_NTI_ENUM_IS_TOP", "An enum type cannot be *. Use ? if you do not want the elements checked");
    public static final DiagnosticType ENUM_IS_UNION = DiagnosticType.warning("JSC_NTI_ENUM_IS_UNION", "An enum type cannot be a union type");
    public static final DiagnosticType WRONG_PARAMETER_ORDER = DiagnosticType.warning("JSC_NTI_WRONG_PARAMETER_ORDER", "Wrong parameter order: required parameters are first, then optional, then varargs");
    public static final DiagnosticType IMPLEMENTS_NON_INTERFACE = DiagnosticType.warning("JSC_NTI_IMPLEMENTS_NON_INTERFACE", "Cannot implement non-interface {0}");
    public static final DiagnosticType EXTENDS_NON_INTERFACE = DiagnosticType.warning("JSC_NTI_EXTENDS_NON_INTERFACE", "Cannot extend non-interface {0}");
    public static final DiagnosticType FUNCTION_WITH_NONFUNC_JSDOC = DiagnosticType.warning("JSC_NTI_FUNCTION_WITH_NONFUNC_JSDOC", "The function is annotated with a non-function jsdoc. Ignoring jsdoc");
    public static final DiagnosticType TEMPLATED_GETTER_SETTER = DiagnosticType.warning("JSC_NTI_TEMPLATED_GETTER_SETTER", "@template can't be used with getters/setters");
    public static final DiagnosticType TWO_JSDOCS = DiagnosticType.warning("JSC_NTI_TWO_JSDOCS", "Found two JsDoc comments for {0}");
    public static final DiagnosticGroup COMPATIBLE_DIAGNOSTICS = new DiagnosticGroup(BAD_ARRAY_TYPE_SYNTAX, CIRCULAR_TYPEDEF_ENUM, CONFLICTING_EXTENDED_TYPE, CONFLICTING_IMPLEMENTED_TYPE, EXTENDS_NON_INTERFACE, EXTENDS_NON_OBJECT, EXTENDS_NOT_ON_CTOR_OR_INTERF, IMPLEMENTS_NON_INTERFACE, IMPLEMENTS_WITHOUT_CONSTRUCTOR, INHERITANCE_CYCLE, NEW_EXPECTS_OBJECT_OR_TYPEVAR, TEMPLATED_GETTER_SETTER, TWO_JSDOCS, WRONG_PARAMETER_ORDER);
    public static final DiagnosticGroup NEW_DIAGNOSTICS = new DiagnosticGroup(CANNOT_MAKE_TYPEVAR_NON_NULL, DICT_IMPLEMENTS_INTERF, ENUM_IS_TOP, ENUM_IS_UNION, ENUM_WITH_TYPEVARS, FUNCTION_WITH_NONFUNC_JSDOC, INVALID_GENERICS_INSTANTIATION, UNION_IS_UNINHABITABLE);
    private final CodingConvention convention;
    private final UniqueNameGenerator nameGen;
    private final JSTypes commonTypes;
    private final Function<Node, Void> recordPropertyName;
    private int howmanyTypeVars = 0;
    private final Set<JSError> warnings = new LinkedHashSet<JSError>();
    private final Map<Node, String> unknownTypeNames = new LinkedHashMap<Node, String>();
    private final FunctionAndSlotType qmarkFunctionDeclared;
    private static final boolean NULLABLE_TYPES_BY_DEFAULT = true;

    public JSTypeCreatorFromJSDoc(JSTypes commonTypes, CodingConvention convention, UniqueNameGenerator nameGen, Function<Node, Void> recordPropertyName) {
        Preconditions.checkNotNull((Object)commonTypes);
        this.commonTypes = commonTypes;
        this.qmarkFunctionDeclared = new FunctionAndSlotType(null, DeclaredFunctionType.qmarkFunctionDeclaration(commonTypes));
        this.convention = convention;
        this.nameGen = nameGen;
        this.recordPropertyName = recordPropertyName;
    }

    public JSType maybeMakeNullable(JSType t) {
        return JSType.join(this.commonTypes.NULL, t);
    }

    public JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, RawNominalType ownerType, DeclaredTypeRegistry registry) {
        return this.getDeclaredTypeOfNode(jsdoc, registry, ownerType == null ? ImmutableList.of() : ownerType.getTypeParameters());
    }

    public JSType getTypeOfCommentNode(Node n, RawNominalType ownerType, DeclaredTypeRegistry registry) {
        return this.getTypeFromComment(n, registry, ownerType == null ? ImmutableList.of() : ownerType.getTypeParameters());
    }

    private JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (jsdoc == null) {
            return null;
        }
        return this.getTypeFromJSTypeExpression(jsdoc.getType(), registry, typeParameters);
    }

    public Set<JSError> getWarnings() {
        return this.warnings;
    }

    public Map<Node, String> getUnknownTypesMap() {
        return this.unknownTypeNames;
    }

    private JSType getTypeFromJSTypeExpression(JSTypeExpression expr, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (expr == null) {
            return null;
        }
        return this.getTypeFromComment(expr.getRoot(), registry, typeParameters);
    }

    private JSType getTypeFromComment(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getTypeFromCommentHelper(n, registry, typeParameters);
    }

    private JSType getTypeFromCommentHelper(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        Preconditions.checkNotNull((Object)n);
        if (typeParameters == null) {
            typeParameters = ImmutableList.of();
        }
        switch (n.getToken()) {
            case LC: {
                return this.getRecordTypeHelper(n, registry, (ImmutableList<String>)typeParameters);
            }
            case EMPTY: {
                return this.commonTypes.UNKNOWN;
            }
            case VOID: {
                return this.commonTypes.UNDEFINED;
            }
            case LB: {
                this.warnings.add(JSError.make(n, BAD_ARRAY_TYPE_SYNTAX, new String[0]));
                return this.commonTypes.UNKNOWN;
            }
            case STRING: {
                return this.getNamedTypeHelper(n, registry, (ImmutableList<String>)typeParameters);
            }
            case PIPE: {
                JSType union = this.commonTypes.BOTTOM;
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    JSType nextType = this.getTypeFromCommentHelper(child, registry, (ImmutableList<String>)typeParameters);
                    if (nextType.isUnknown()) {
                        return this.commonTypes.UNKNOWN;
                    }
                    JSType nextUnion = JSType.join(union, nextType);
                    if (nextUnion.isBottom()) {
                        this.warnings.add(JSError.make(n, UNION_IS_UNINHABITABLE, nextType.toString(), union.toString()));
                        return this.commonTypes.UNKNOWN;
                    }
                    union = nextUnion;
                }
                return union;
            }
            case BANG: {
                JSType nullableType = this.getTypeFromCommentHelper(n.getFirstChild(), registry, (ImmutableList<String>)typeParameters);
                if (nullableType.isTypeVariable()) {
                    this.warnings.add(JSError.make(n, CANNOT_MAKE_TYPEVAR_NON_NULL, new String[0]));
                }
                return nullableType.removeType(this.commonTypes.NULL);
            }
            case QMARK: {
                Node child = n.getFirstChild();
                if (child == null) {
                    return this.commonTypes.UNKNOWN;
                }
                return JSType.join(this.commonTypes.NULL, this.getTypeFromCommentHelper(child, registry, (ImmutableList<String>)typeParameters));
            }
            case STAR: {
                return this.commonTypes.TOP;
            }
            case FUNCTION: {
                return this.getFunTypeHelper(n, registry, (ImmutableList<String>)typeParameters);
            }
        }
        throw new IllegalArgumentException("Unsupported type exp: " + (Object)((Object)n.getToken()) + " " + n.toStringTree());
    }

    private boolean isUnionWithUndefined(Node n) {
        if (n == null || n.getToken() != Token.PIPE) {
            return false;
        }
        for (Node child : n.children()) {
            if (!child.isVoid() && (!child.isString() || !child.getString().equals("void") && !child.getString().equals("undefined"))) continue;
            return true;
        }
        return false;
    }

    private JSType getRecordTypeHelper(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        LinkedHashMap<String, Property> props = new LinkedHashMap<String, Property>();
        for (Node propNode = n.getFirstFirstChild(); propNode != null; propNode = propNode.getNext()) {
            boolean isPropDeclared = propNode.getToken() == Token.COLON;
            Node propNameNode = isPropDeclared ? propNode.getFirstChild() : propNode;
            String propName = propNameNode.getString();
            if (propName.startsWith("'") || propName.startsWith("\"")) {
                propName = propName.substring(1, propName.length() - 1);
            }
            this.recordPropertyName.apply((Object)propNameNode);
            JSType propType = !isPropDeclared ? this.commonTypes.UNKNOWN : this.getTypeFromCommentHelper(propNode.getLastChild(), registry, typeParameters);
            Property prop = propType.equals(this.commonTypes.UNDEFINED) || this.isUnionWithUndefined(propNode.getLastChild()) ? Property.makeOptional(null, propType, propType) : Property.make(propType, propType);
            props.put(propName, prop);
        }
        return JSType.fromObjectType(ObjectType.fromProperties(this.commonTypes, props));
    }

    private JSType getNamedTypeHelper(Node n, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) {
        String typeName;
        switch (typeName = n.getString()) {
            case "boolean": {
                this.checkInvalidGenericsInstantiation(n);
                return this.commonTypes.BOOLEAN;
            }
            case "null": {
                this.checkInvalidGenericsInstantiation(n);
                return this.commonTypes.NULL;
            }
            case "number": {
                this.checkInvalidGenericsInstantiation(n);
                return this.commonTypes.NUMBER;
            }
            case "string": {
                this.checkInvalidGenericsInstantiation(n);
                return this.commonTypes.STRING;
            }
            case "undefined": 
            case "void": {
                this.checkInvalidGenericsInstantiation(n);
                return this.commonTypes.UNDEFINED;
            }
            case "Function": {
                this.checkInvalidGenericsInstantiation(n);
                return this.maybeMakeNullable(this.commonTypes.qmarkFunction());
            }
            case "Object": {
                JSType result;
                if (n.hasChildren()) {
                    RawNominalType iobject = this.commonTypes.getIObjectType();
                    if (iobject == null) {
                        return this.commonTypes.UNKNOWN;
                    }
                    result = this.getNominalTypeHelper(iobject, n, registry, outerTypeParameters);
                } else {
                    result = this.commonTypes.getTopObject();
                }
                return this.maybeMakeNullable(result);
            }
        }
        return this.lookupTypeByName(typeName, n, registry, outerTypeParameters);
    }

    private JSType lookupTypeByName(String name, Node n, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) {
        String tvar = UniqueNameGenerator.findGeneratedName(name, outerTypeParameters);
        if (tvar != null) {
            this.checkInvalidGenericsInstantiation(n);
            return JSType.fromTypeVar(this.commonTypes, tvar);
        }
        Declaration decl = registry.getDeclaration(QualifiedName.fromQualifiedString(name), true);
        if (decl == null) {
            this.unknownTypeNames.put(n, name);
            return this.commonTypes.UNKNOWN;
        }
        if (decl.getTypedef() != null) {
            this.checkInvalidGenericsInstantiation(n);
            return this.getTypedefType(decl.getTypedef(), registry);
        }
        if (decl.getEnum() != null) {
            this.checkInvalidGenericsInstantiation(n);
            return this.getEnumPropType(decl.getEnum(), registry);
        }
        if (decl.isTypeVar()) {
            this.checkInvalidGenericsInstantiation(n);
            ++this.howmanyTypeVars;
            return decl.getTypeOfSimpleDecl();
        }
        if (decl.getNominal() != null) {
            return this.getNominalTypeHelper(decl.getNominal(), n, registry, outerTypeParameters);
        }
        return this.commonTypes.UNKNOWN;
    }

    private JSType getTypedefType(Typedef td, DeclaredTypeRegistry registry) {
        this.resolveTypedef(td, registry);
        return td.getType();
    }

    public void resolveTypedef(Typedef td, DeclaredTypeRegistry registry) {
        JSType tdType;
        Preconditions.checkState((td != null ? 1 : 0) != 0, (Object)"getTypedef should only be called when we know that the typedef is defined");
        if (td.isResolved()) {
            return;
        }
        JSTypeExpression texp = td.getTypeExpr();
        if (texp == null) {
            this.warnings.add(JSError.make(td.getTypeExprForErrorReporting().getRoot(), CIRCULAR_TYPEDEF_ENUM, new String[0]));
            tdType = this.commonTypes.UNKNOWN;
        } else {
            Node texpRoot;
            tdType = this.getTypeFromJSTypeExpression(texp, registry, null);
            if (tdType.isSingletonObj() && (texpRoot = texp.getRoot()).getToken() == Token.LC) {
                for (Node propNode : texpRoot.getFirstChild().children()) {
                    Node propNameNode = propNode.hasChildren() ? propNode.getFirstChild() : propNode;
                    this.recordPropertyName.apply((Object)propNameNode);
                }
            }
        }
        td.resolveTypedef(tdType);
    }

    private JSType getEnumPropType(EnumType e, DeclaredTypeRegistry registry) {
        this.resolveEnum(e, registry);
        return e.getPropType();
    }

    public void resolveEnum(EnumType e, DeclaredTypeRegistry registry) {
        JSType enumeratedType;
        Preconditions.checkState((e != null ? 1 : 0) != 0, (Object)"getEnum should only be called when we know that the enum is defined");
        if (e.isResolved()) {
            return;
        }
        JSTypeExpression texp = e.getTypeExpr();
        if (texp == null) {
            this.warnings.add(JSError.make(e.getTypeExprForErrorReporting().getRoot(), CIRCULAR_TYPEDEF_ENUM, new String[0]));
            enumeratedType = this.commonTypes.UNKNOWN;
        } else {
            int numTypeVars = this.howmanyTypeVars;
            enumeratedType = this.getTypeFromJSTypeExpression(texp, registry, null);
            if (this.howmanyTypeVars > numTypeVars) {
                this.warnings.add(JSError.make(texp.getRoot(), ENUM_WITH_TYPEVARS, new String[0]));
                enumeratedType = this.commonTypes.UNKNOWN;
                this.howmanyTypeVars = numTypeVars;
            } else if (enumeratedType.isTop()) {
                this.warnings.add(JSError.make(texp.getRoot(), ENUM_IS_TOP, new String[0]));
                enumeratedType = this.commonTypes.UNKNOWN;
            } else if (enumeratedType.isUnion()) {
                this.warnings.add(JSError.make(texp.getRoot(), ENUM_IS_UNION, new String[0]));
                enumeratedType = this.commonTypes.UNKNOWN;
            }
        }
        e.resolveEnum(enumeratedType);
    }

    private void checkInvalidGenericsInstantiation(Node n) {
        if (n.hasChildren()) {
            Preconditions.checkState((boolean)n.getFirstChild().isNormalBlock(), (Object)n);
            this.warnings.add(JSError.make(n, INVALID_GENERICS_INSTANTIATION, "", "0", String.valueOf(n.getFirstChild().getChildCount())));
        }
    }

    private JSType getNominalTypeHelper(RawNominalType rawType, Node n, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) {
        int typeParamsSize;
        NominalType uninstantiated = rawType.getAsNominalType();
        if (!rawType.isGeneric() && !n.hasChildren()) {
            return rawType.getInstanceWithNullability(true);
        }
        ImmutableList.Builder typeList = ImmutableList.builder();
        if (n.hasChildren()) {
            Preconditions.checkState((boolean)n.getFirstChild().isNormalBlock(), (Object)n);
            for (Node child : n.getFirstChild().children()) {
                typeList.add((Object)this.getTypeFromCommentHelper(child, registry, outerTypeParameters));
            }
        }
        Object typeArguments = typeList.build();
        ImmutableList<String> typeParameters = rawType.getTypeParameters();
        int typeArgsSize = typeArguments.size();
        if (typeArgsSize != (typeParamsSize = typeParameters.size())) {
            if (typeArgsSize > typeParamsSize) {
                this.warnings.add(JSError.make(n, INVALID_GENERICS_INSTANTIATION, " for type " + uninstantiated.getName(), String.valueOf(typeParamsSize), String.valueOf(typeArgsSize)));
            }
            typeArguments = this.fixLengthOfTypeList(typeParameters.size(), (List<JSType>)typeArguments);
            NominalType instantiated = uninstantiated.instantiateGenerics((List<JSType>)typeArguments);
            return this.maybeMakeNullable(JSType.fromObjectType(ObjectType.fromNominalType(instantiated)));
        }
        return this.maybeMakeNullable(JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics((List<JSType>)typeArguments))));
    }

    private List<JSType> fixLengthOfTypeList(int desiredLength, List<JSType> typeList) {
        int length = typeList.size();
        if (length == desiredLength) {
            return typeList;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < desiredLength; ++i) {
            builder.add((Object)(i < length ? typeList.get(i) : this.commonTypes.UNKNOWN));
        }
        return builder.build();
    }

    private JSType getFunTypeHelper(Node jsdocNode, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        this.fillInFunTypeBuilder(jsdocNode, null, registry, typeParameters, builder);
        return this.commonTypes.fromFunctionType(builder.buildFunction());
    }

    private void fillInFunTypeBuilder(Node jsdocNode, RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters, FunctionTypeBuilder builder) {
        Node child = jsdocNode.getFirstChild();
        if (child.isThis()) {
            if (ownerType == null) {
                builder.addReceiverType(this.getThisOrNewType(child.getFirstChild(), registry, typeParameters));
            }
            child = child.getNext();
        } else if (child.isNew()) {
            Node newTypeNode = child.getFirstChild();
            JSType t = this.getThisOrNewType(newTypeNode, registry, typeParameters);
            if (!(t.isSubtypeOf(this.commonTypes.getTopObject()) || t.hasTypeVariable() && !t.hasScalar())) {
                this.warnings.add(JSError.make(newTypeNode, NEW_EXPECTS_OBJECT_OR_TYPEVAR, t.toString()));
            }
            builder.addNominalType(t);
            child = child.getNext();
        }
        if (child.isParamList()) {
            for (Node arg = child.getFirstChild(); arg != null; arg = arg.getNext()) {
                try {
                    switch (arg.getToken()) {
                        case EQUALS: {
                            builder.addOptFormal(this.getTypeFromCommentHelper(arg.getFirstChild(), registry, typeParameters));
                            break;
                        }
                        case ELLIPSIS: {
                            Node restNode = arg.getFirstChild();
                            builder.addRestFormals(restNode == null ? this.commonTypes.UNKNOWN : this.getTypeFromCommentHelper(restNode, registry, typeParameters));
                            break;
                        }
                        default: {
                            builder.addReqFormal(this.getTypeFromCommentHelper(arg, registry, typeParameters));
                            break;
                        }
                    }
                    continue;
                }
                catch (FunctionTypeBuilder.WrongParameterOrderException e) {
                    this.warnings.add(JSError.make(jsdocNode, WRONG_PARAMETER_ORDER, new String[0]));
                    builder.addPlaceholderFormal();
                }
            }
            child = child.getNext();
        }
        builder.addRetType(this.getTypeFromCommentHelper(child, registry, typeParameters));
    }

    private JSType getThisOrNewType(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        JSType t = this.getTypeFromComment(n, registry, typeParameters);
        return t.isSingletonObjWithNull() ? t.removeType(this.commonTypes.NULL) : t;
    }

    private ImmutableSet<NominalType> getImplementedInterfaces(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, registry, typeParameters, true);
    }

    private ImmutableSet<NominalType> getExtendedInterfaces(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, registry, typeParameters, false);
    }

    private ImmutableSet<NominalType> getInterfacesHelper(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters, boolean implementedIntfs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSTypeExpression texp : implementedIntfs ? jsdoc.getImplementedInterfaces() : jsdoc.getExtendedInterfaces()) {
            Node expRoot = texp.getRoot();
            JSType interfaceType = this.getTypeFromComment(expRoot, registry, typeParameters);
            NominalType nt = interfaceType.getNominalTypeIfSingletonObj();
            if (nt != null && nt.isInterface()) {
                builder.add((Object)nt);
                continue;
            }
            if (implementedIntfs) {
                this.warnings.add(JSError.make(expRoot, IMPLEMENTS_NON_INTERFACE, interfaceType.toString()));
                continue;
            }
            this.warnings.add(JSError.make(expRoot, EXTENDS_NON_INTERFACE, interfaceType.toString()));
        }
        return builder.build();
    }

    public FunctionAndSlotType getFunctionType(JSDocInfo jsdoc, String functionName, Node declNode, RawNominalType constructorType, RawNominalType ownerType, DeclaredTypeRegistry registry) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        if (ownerType != null) {
            builder.addReceiverType(ownerType.getInstanceAsJSType());
        }
        try {
            if (jsdoc != null && jsdoc.getType() != null) {
                JSType simpleType = this.getDeclaredTypeOfNode(jsdoc, ownerType, registry);
                if (simpleType.isUnknown() || simpleType.isTop()) {
                    return this.qmarkFunctionDeclared;
                }
                FunctionType funType = simpleType.getFunType();
                if (funType != null) {
                    JSType slotType = simpleType.isFunctionType() ? null : simpleType;
                    DeclaredFunctionType declType = funType.toDeclaredFunctionType();
                    if (ownerType != null && funType.getThisType() == null) {
                        declType = declType.withReceiverType(ownerType.getInstanceAsJSType());
                    }
                    return new FunctionAndSlotType(slotType, declType);
                }
                this.warnings.add(JSError.make(declNode, FUNCTION_WITH_NONFUNC_JSDOC, new String[0]));
                jsdoc = null;
            }
            DeclaredFunctionType declType = this.getFunTypeFromTypicalFunctionJsdoc(jsdoc, functionName, declNode, constructorType, ownerType, registry, builder);
            return new FunctionAndSlotType(null, declType);
        }
        catch (FunctionTypeBuilder.WrongParameterOrderException e) {
            this.warnings.add(JSError.make(declNode, WRONG_PARAMETER_ORDER, new String[0]));
            return this.qmarkFunctionDeclared;
        }
    }

    private DeclaredFunctionType getFunTypeFromTypicalFunctionJsdoc(JSDocInfo jsdoc, String functionName, Node funNode, RawNominalType constructorType, RawNominalType ownerType, DeclaredTypeRegistry registry, FunctionTypeBuilder builder) {
        Node parent = funNode.getParent();
        ImmutableList<String> typeParamsInScope = this.collectTypeParamsInScope(jsdoc, funNode, constructorType, ownerType, builder);
        this.fillInFormalParameterTypes(jsdoc, funNode, typeParamsInScope, registry, builder, false);
        this.fillInReturnType(jsdoc, funNode, parent, typeParamsInScope, registry, builder, false);
        if (jsdoc == null) {
            return builder.buildDeclaration();
        }
        NominalType parentClass = this.getMaybeParentClass(jsdoc, functionName, funNode, typeParamsInScope, registry);
        ImmutableSet<NominalType> implementedIntfs = this.getImplementedInterfaces(jsdoc, registry, typeParamsInScope);
        if (constructorType == null && jsdoc.isConstructorOrInterface()) {
            return builder.buildDeclaration();
        }
        if (jsdoc.isConstructor()) {
            this.handleConstructorAnnotation(functionName, funNode, constructorType, parentClass, implementedIntfs, builder);
        } else if (jsdoc.isInterface()) {
            this.handleInterfaceAnnotation(jsdoc, functionName, funNode, constructorType, implementedIntfs, typeParamsInScope, registry, builder);
        } else if (!implementedIntfs.isEmpty()) {
            this.warnings.add(JSError.make(funNode, IMPLEMENTS_WITHOUT_CONSTRUCTOR, functionName));
        }
        if (jsdoc.hasThisType()) {
            Node thisRoot = jsdoc.getThisType().getRoot();
            Preconditions.checkState((thisRoot.getToken() == Token.BANG ? 1 : 0) != 0);
            builder.addReceiverType(this.getThisOrNewType(thisRoot.getFirstChild(), registry, typeParamsInScope));
        }
        if (!jsdoc.isConstructor()) {
            builder.addAbstract(jsdoc.isAbstract());
        }
        return builder.buildDeclaration();
    }

    private void fillInFormalParameterTypes(JSDocInfo jsdoc, Node funNode, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry, FunctionTypeBuilder builder, boolean ignoreJsdoc) {
        boolean ignoreFunNode = !funNode.isFunction();
        Node params = ignoreFunNode ? null : funNode.getSecondChild();
        ParamIterator iterator = new ParamIterator(params, jsdoc);
        while (iterator.hasNext()) {
            JSTypeExpression jsdocExp;
            ParameterType inlineParamType;
            String pname = iterator.nextString();
            Node param = iterator.getNode();
            ParameterKind p = ParameterKind.REQUIRED;
            if (param != null && this.convention.isOptionalParameter(param)) {
                p = ParameterKind.OPTIONAL;
            } else if (param != null && this.convention.isVarArgsParameter(param)) {
                p = ParameterKind.REST;
            }
            ParameterType fnParamType = inlineParamType = ignoreJsdoc || ignoreFunNode || param.getJSDocInfo() == null ? null : this.parseParameter(param.getJSDocInfo().getType(), p, registry, typeParameters);
            JSTypeExpression jSTypeExpression = jsdocExp = jsdoc == null ? null : jsdoc.getParameterType(pname);
            if (jsdocExp != null) {
                if (inlineParamType == null) {
                    fnParamType = this.parseParameter(jsdocExp, p, registry, typeParameters);
                } else {
                    this.warnings.add(JSError.make(param, TWO_JSDOCS, "formal parameter " + pname));
                }
            }
            JSType t = null;
            if (fnParamType != null) {
                p = fnParamType.kind;
                t = fnParamType.type;
            }
            switch (p) {
                case REQUIRED: {
                    builder.addReqFormal(t);
                    break;
                }
                case OPTIONAL: {
                    builder.addOptFormal(t);
                    break;
                }
                case REST: {
                    builder.addRestFormals(t != null ? t : this.commonTypes.UNKNOWN);
                }
            }
        }
    }

    private void fillInReturnType(JSDocInfo jsdoc, Node funNode, Node parent, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry, FunctionTypeBuilder builder, boolean ignoreJsdoc) {
        JSTypeExpression retTypeExp;
        JSDocInfo inlineRetJsdoc = ignoreJsdoc || !funNode.isFunction() ? null : funNode.getFirstChild().getJSDocInfo();
        JSTypeExpression jSTypeExpression = retTypeExp = jsdoc == null ? null : jsdoc.getReturnType();
        if (parent.isSetterDef() && retTypeExp == null) {
            builder.addRetType(this.commonTypes.UNDEFINED);
        } else if (inlineRetJsdoc != null) {
            builder.addRetType(this.getDeclaredTypeOfNode(inlineRetJsdoc, registry, typeParameters));
            if (retTypeExp != null) {
                this.warnings.add(JSError.make(funNode, TWO_JSDOCS, "the return type"));
            }
        } else {
            builder.addRetType(this.getTypeFromJSTypeExpression(retTypeExp, registry, typeParameters));
        }
    }

    private ImmutableList<String> collectTypeParamsInScope(JSDocInfo jsdoc, Node funNode, RawNominalType constructorType, RawNominalType ownerType, FunctionTypeBuilder builder) {
        Node parent = funNode.getParent();
        ImmutableList.Builder typeParamsCollector = ImmutableList.builder();
        if (jsdoc != null) {
            ArrayList<String> declaredTypeParams = new ArrayList<String>();
            if (constructorType != null) {
                typeParamsCollector.addAll(constructorType.getTypeParameters());
                declaredTypeParams = constructorType.getTypeParameters();
            } else {
                for (String typeParam : jsdoc.getTemplateTypeNames()) {
                    String generatedName = this.nameGen.getNextName(typeParam);
                    typeParamsCollector.add((Object)generatedName);
                    declaredTypeParams.add(generatedName);
                }
            }
            LinkedHashMap<String, Node> typeTransformations = new LinkedHashMap<String, Node>();
            for (Map.Entry entry : jsdoc.getTypeTransformations().entrySet()) {
                String name = (String)entry.getKey();
                Node ttlAst = (Node)entry.getValue();
                String generatedName = this.nameGen.getNextName(name);
                typeTransformations.put(generatedName, ttlAst);
                typeParamsCollector.add((Object)generatedName);
            }
            if (!jsdoc.getTemplateTypeNames().isEmpty() || !typeTransformations.isEmpty()) {
                if (parent.isSetterDef() || parent.isGetterDef()) {
                    this.warnings.add(JSError.make(funNode, TEMPLATED_GETTER_SETTER, new String[0]));
                } else {
                    builder.addTypeParameters(TypeParameters.make(declaredTypeParams, typeTransformations));
                }
            }
        }
        if (ownerType != null) {
            typeParamsCollector.addAll(ownerType.getTypeParameters());
        }
        return typeParamsCollector.build();
    }

    private NominalType getMaybeParentClass(JSDocInfo jsdoc, String functionName, Node funNode, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry) {
        if (!jsdoc.hasBaseType()) {
            return null;
        }
        if (!jsdoc.isConstructor()) {
            this.warnings.add(JSError.make(funNode, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
            return null;
        }
        Node docNode = jsdoc.getBaseType().getRoot();
        JSType extendedType = this.getTypeFromComment(docNode, registry, typeParameters);
        NominalType parentClass = extendedType.getNominalTypeIfSingletonObj();
        if (parentClass != null && parentClass.isClass()) {
            return parentClass;
        }
        if (parentClass == null) {
            return this.getMaybeHigherOrderParentClass(docNode, functionName, funNode, extendedType, registry);
        }
        Preconditions.checkState((boolean)parentClass.isInterface());
        this.warnings.add(JSError.make(funNode, CONFLICTING_EXTENDED_TYPE, "constructor", functionName));
        return null;
    }

    private NominalType getMaybeHigherOrderParentClass(Node docNode, String functionName, Node funNode, JSType extendedType, DeclaredTypeRegistry registry) {
        String varname;
        Declaration decl;
        if (extendedType.isUnknown() && docNode.getToken() == Token.BANG && docNode.getFirstChild().isString() && (decl = registry.getDeclaration(QualifiedName.fromQualifiedString(varname = docNode.getFirstChild().getString()), false)) != null) {
            NominalType parentClass;
            FunctionType maybeCtor;
            if (decl.getTypeOfSimpleDecl() == null) {
                return null;
            }
            JSType maybeFunction = decl.getTypeOfSimpleDecl();
            if (maybeFunction != null && maybeFunction.isFunctionType() && (maybeCtor = maybeFunction.getFunType()).isSomeConstructorOrInterface() && ((parentClass = (extendedType = maybeCtor.getThisType()).getNominalTypeIfSingletonObj()) == null || parentClass.isClass())) {
                return parentClass;
            }
        }
        this.warnings.add(JSError.make(funNode, EXTENDS_NON_OBJECT, functionName, extendedType.toString()));
        return null;
    }

    private void handleConstructorAnnotation(String functionName, Node funNode, RawNominalType constructorType, NominalType parentClass, ImmutableSet<NominalType> implementedIntfs, FunctionTypeBuilder builder) {
        String className = constructorType.toString();
        NominalType builtinObject = this.commonTypes.getObjectType();
        if (parentClass == null && !functionName.equals("Object")) {
            parentClass = builtinObject;
        }
        if (parentClass != null && !constructorType.addSuperClass(parentClass)) {
            this.warnings.add(JSError.make(funNode, INHERITANCE_CYCLE, className));
        }
        if (constructorType.isDict() && !implementedIntfs.isEmpty()) {
            this.warnings.add(JSError.make(funNode, DICT_IMPLEMENTS_INTERF, className));
        }
        boolean noCycles = constructorType.addInterfaces(implementedIntfs);
        Preconditions.checkState((boolean)noCycles);
        builder.addNominalType(constructorType.getInstanceAsJSType());
    }

    private void handleInterfaceAnnotation(JSDocInfo jsdoc, String functionName, Node funNode, RawNominalType constructorType, ImmutableSet<NominalType> implementedIntfs, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry, FunctionTypeBuilder builder) {
        ImmutableSet extendedInterfaces;
        boolean noCycles;
        if (!implementedIntfs.isEmpty()) {
            this.warnings.add(JSError.make(funNode, CONFLICTING_IMPLEMENTED_TYPE, functionName));
        }
        if (!(noCycles = constructorType.addInterfaces((extendedInterfaces = this.getExtendedInterfaces(jsdoc, registry, typeParameters)).isEmpty() ? ImmutableSet.of((Object)this.commonTypes.getObjectType()) : extendedInterfaces))) {
            this.warnings.add(JSError.make(funNode, INHERITANCE_CYCLE, constructorType.toString()));
        }
        builder.addNominalType(constructorType.getInstanceAsJSType());
    }

    public static boolean isRestArg(JSDocInfo funJsdoc, String formalParamName) {
        if (funJsdoc == null) {
            return false;
        }
        JSTypeExpression texp = funJsdoc.getParameterType(formalParamName);
        Node jsdocNode = texp == null ? null : texp.getRoot();
        return jsdocNode != null && jsdocNode.getToken() == Token.ELLIPSIS;
    }

    private ParameterType parseParameter(JSTypeExpression jsdoc, ParameterKind p, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (jsdoc == null) {
            return null;
        }
        return this.parseParameter(jsdoc.getRoot(), p, registry, typeParameters);
    }

    private ParameterType parseParameter(Node jsdoc, ParameterKind p, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (jsdoc == null) {
            return null;
        }
        switch (jsdoc.getToken()) {
            case EQUALS: {
                p = ParameterKind.OPTIONAL;
                jsdoc = jsdoc.getFirstChild();
                break;
            }
            case ELLIPSIS: {
                p = ParameterKind.REST;
                jsdoc = jsdoc.getFirstChild();
                break;
            }
        }
        JSType t = this.getTypeFromComment(jsdoc, registry, typeParameters);
        return new ParameterType(t, p);
    }

    private static enum ParameterKind implements Serializable
    {
        REQUIRED,
        OPTIONAL,
        REST;

    }

    private static class ParameterType
    implements Serializable {
        private final JSType type;
        private final ParameterKind kind;

        ParameterType(JSType type, ParameterKind kind) {
            this.type = type;
            this.kind = kind;
        }
    }

    private static class ParamIterator {
        Iterator<String> paramNames;
        Node params;
        int index = -1;

        ParamIterator(Node params, JSDocInfo jsdoc) {
            Preconditions.checkArgument((params != null || jsdoc != null ? 1 : 0) != 0);
            if (params != null) {
                this.params = params;
                this.paramNames = null;
            } else {
                this.params = null;
                this.paramNames = jsdoc.getParameterNames().iterator();
            }
        }

        boolean hasNext() {
            if (this.paramNames != null) {
                return this.paramNames.hasNext();
            }
            return this.index + 1 < this.params.getChildCount();
        }

        String nextString() {
            if (this.paramNames != null) {
                return this.paramNames.next();
            }
            ++this.index;
            return this.params.getChildAtIndex(this.index).getString();
        }

        Node getNode() {
            if (this.paramNames != null) {
                return null;
            }
            return this.params.getChildAtIndex(this.index);
        }
    }

    public static class FunctionAndSlotType
    implements Serializable {
        public JSType slotType;
        public DeclaredFunctionType functionType;

        public FunctionAndSlotType(JSType slotType, DeclaredFunctionType functionType) {
            this.slotType = slotType;
            this.functionType = functionType;
        }
    }
}

