/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;

public final class CheckArrayWithGoogObject
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    final AbstractCompiler compiler;
    private static final ImmutableSet<String> GOOG_OBJECT_METHODS = ImmutableSet.of((Object)"goog.object.forEach", (Object)"goog.object.filter", (Object)"goog.object.map", (Object)"goog.object.some", (Object)"goog.object.every", (Object)"goog.object.getCount", (Object[])new String[]{"goog.object.getAnyKey", "goog.object.getAnyValue", "goog.object.contains", "goog.object.getValues", "goog.object.getKeys", "goog.object.findKey", "goog.object.findValue", "goog.object.isEmpty", "goog.object.clear", "goog.object.remove", "goog.object.equals", "goog.object.clone", "goog.object.transpose"});
    public static final DiagnosticType ARRAY_PASSED_TO_GOOG_OBJECT = DiagnosticType.warning("JSC_ARRAY_PASSED_TO_GOOG_OBJECT", "{0} expects an object, not an array. Did you mean to use goog.array?");

    public CheckArrayWithGoogObject(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public boolean isGoogObjectIterationOverArray(Node n) {
        if (!n.isCall()) {
            return false;
        }
        if (!n.getFirstChild().isQualifiedName()) {
            return false;
        }
        String name = n.getFirstChild().getQualifiedName();
        if (!GOOG_OBJECT_METHODS.contains((Object)name)) {
            return false;
        }
        Node firstArg = n.getSecondChild();
        if (firstArg == null) {
            return false;
        }
        TypeI type = firstArg.getTypeI();
        return type != null && type.containsArray();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.isGoogObjectIterationOverArray(n)) {
            this.compiler.report(t.makeError(n, ARRAY_PASSED_TO_GOOG_OBJECT, n.getFirstChild().getQualifiedName()));
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }
}

