/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GwtIncompatible(value="java.util.regex")
public final class JsFileParser
extends JsFileLineParser {
    private static final Logger logger = Logger.getLogger(JsFileParser.class.getName());
    private static final Pattern GOOG_PROVIDE_REQUIRE_PATTERN = Pattern.compile("(?:^|;)(?:[a-zA-Z0-9$_,:{}\\s]+=)?\\s*goog\\.(provide|module|require|addDependency)\\s*\\((.*?)\\)");
    private static final Pattern ES6_MODULE_PATTERN = Pattern.compile("^(?:import|export)\\b\\s*(?:[a-zA-Z0-9$_*,{}\\s]+\\bfrom\\s*|)(?:['\"]([^'\"]+)['\"])?\\s*;");
    private static final Pattern ES6_EXPORT_PATTERN = Pattern.compile("^export\\b");
    private static final String BASE_JS_START = "var COMPILED = false;";
    private static final String BUNDLED_GOOG_MODULE_START = "goog.loadModule(function(";
    private final Matcher googMatcher = GOOG_PROVIDE_REQUIRE_PATTERN.matcher("");
    private final Matcher es6Matcher = ES6_MODULE_PATTERN.matcher("");
    private List<String> provides;
    private List<String> requires;
    private boolean fileHasProvidesOrRequires;
    private ModuleLoader loader = ModuleLoader.EMPTY;
    private ModuleLoader.ModulePath file;
    private ModuleType moduleType;
    private boolean includeGoogBase = false;

    public JsFileParser(ErrorManager errorManager) {
        super(errorManager);
    }

    public JsFileParser setIncludeGoogBase(boolean include) {
        Preconditions.checkState((boolean)JsFileParser.isSupported());
        this.includeGoogBase = include;
        return this;
    }

    public JsFileParser setModuleLoader(ModuleLoader loader) {
        this.loader = loader;
        return this;
    }

    public DependencyInfo parseFile(String filePath, String closureRelativePath, String fileContents) {
        return this.parseReader(filePath, closureRelativePath, new StringReader(fileContents));
    }

    private DependencyInfo parseReader(String filePath, String closureRelativePath, Reader fileContents) {
        this.provides = new ArrayList<String>();
        this.requires = new ArrayList<String>();
        this.fileHasProvidesOrRequires = false;
        this.file = this.loader.resolve(filePath);
        this.moduleType = ModuleType.NON_MODULE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Parsing Source: " + filePath);
        }
        this.doParse(filePath, fileContents);
        if (this.moduleType == ModuleType.ES6_MODULE) {
            this.provides.add(this.file.toModuleName());
        }
        LinkedHashMap<String, String> loadFlags = new LinkedHashMap<String, String>();
        switch (this.moduleType) {
            case UNWRAPPED_GOOG_MODULE: {
                loadFlags.put("module", "goog");
                break;
            }
            case ES6_MODULE: {
                loadFlags.put("module", "es6");
                break;
            }
        }
        SimpleDependencyInfo dependencyInfo = new SimpleDependencyInfo(closureRelativePath, filePath, this.provides, this.requires, loadFlags);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DepInfo: " + dependencyInfo);
        }
        return dependencyInfo;
    }

    private void setModuleType(ModuleType type) {
        if (this.moduleType != type && this.moduleType != ModuleType.NON_MODULE) {
            this.errorManager.report(CheckLevel.WARNING, JSError.make(ModuleLoader.MODULE_CONFLICT, this.file.toString()));
        }
        this.moduleType = type;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean lineHasProvidesOrRequires = false;
        if (line.startsWith(BUNDLED_GOOG_MODULE_START)) {
            this.setModuleType(ModuleType.WRAPPED_GOOG_MODULE);
        }
        if (line.contains("provide") || line.contains("require") || line.contains("module") || line.contains("addDependency")) {
            this.googMatcher.reset(line);
            while (this.googMatcher.find()) {
                boolean isRequire;
                char firstChar;
                lineHasProvidesOrRequires = true;
                if (this.includeGoogBase && !this.fileHasProvidesOrRequires) {
                    this.fileHasProvidesOrRequires = true;
                    this.requires.add("goog");
                }
                boolean isProvide = (firstChar = this.googMatcher.group(1).charAt(0)) == 'p' || firstChar == 'm';
                boolean isModule = firstChar == 'm';
                boolean bl = isRequire = firstChar == 'r';
                if (isModule && this.moduleType != ModuleType.WRAPPED_GOOG_MODULE) {
                    this.setModuleType(ModuleType.UNWRAPPED_GOOG_MODULE);
                }
                if (!isProvide && !isRequire) continue;
                String arg = this.parseJsString(this.googMatcher.group(2));
                if (isRequire) {
                    if ("goog".equals(arg)) continue;
                    this.requires.add(arg);
                    continue;
                }
                this.provides.add(arg);
            }
        } else if (this.includeGoogBase && line.startsWith(BASE_JS_START) && this.provides.isEmpty() && this.requires.isEmpty()) {
            this.provides.add("goog");
            return false;
        }
        if (line.startsWith("import") || line.startsWith("export")) {
            this.es6Matcher.reset(line);
            while (this.es6Matcher.find()) {
                this.setModuleType(ModuleType.ES6_MODULE);
                lineHasProvidesOrRequires = true;
                String arg = this.es6Matcher.group(1);
                if (arg == null) continue;
                if (arg.startsWith("goog:")) {
                    this.requires.add(arg.substring(5));
                    continue;
                }
                ModuleLoader.ModulePath path = this.file.resolveJsModule(arg);
                if (path == null) {
                    path = this.file.resolveModuleAsPath(arg);
                }
                this.requires.add(path.toModuleName());
            }
            if (this.moduleType != ModuleType.ES6_MODULE && ES6_EXPORT_PATTERN.matcher(line).lookingAt()) {
                this.setModuleType(ModuleType.ES6_MODULE);
            }
        }
        return !this.shortcutMode || lineHasProvidesOrRequires || CharMatcher.whitespace().matchesAllOf((CharSequence)line) || !line.contains(";") || line.contains("goog.setTestOnly") || line.contains("goog.module.declareLegacyNamespace");
    }

    public static boolean isSupported() {
        return true;
    }

    private static enum ModuleType {
        NON_MODULE,
        UNWRAPPED_GOOG_MODULE,
        WRAPPED_GOOG_MODULE,
        ES6_MODULE;

    }
}

