/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.bundle;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.bundle.Source;
import java.io.IOException;
import java.nio.file.Path;

@Immutable
@GwtIncompatible
public class Transpiler
implements Source.Transformer {
    private final CompilerSupplier compilerSupplier;
    private final String runtimeLibraryName;
    public static final Transpiler ES5_TRANSPILER = new Transpiler(new CompilerSupplier(), "es6_runtime");
    private static final Transpiler TO_ES5 = new Transpiler(new CompilerSupplier(), "es6_runtime");

    public Transpiler(CompilerSupplier compilerSupplier, String runtimeLibraryName) {
        this.compilerSupplier = (CompilerSupplier)Preconditions.checkNotNull((Object)compilerSupplier);
        this.runtimeLibraryName = (String)Preconditions.checkNotNull((Object)runtimeLibraryName);
    }

    @Override
    public Source transform(Source input) {
        CompileResult result = this.compilerSupplier.compile(input.path(), input.code());
        if (result.errors.length > 0) {
            MessageFormatter formatter = ErrorFormat.SOURCELESS.toFormatter(null, false);
            StringBuilder message = new StringBuilder().append("Transpilation failed.\n");
            for (JSError error : result.errors) {
                message.append(formatter.formatError(error));
            }
            throw new IllegalStateException(message.toString());
        }
        if (!result.transpiled) {
            return input;
        }
        return input.toBuilder().setCode(result.source).setSourceMap(result.sourceMap).addRuntime(this.compilerSupplier.runtime(this.runtimeLibraryName)).build();
    }

    public static Transpiler toEs5() {
        return TO_ES5;
    }

    public static class CompileResult {
        public final String source;
        public final JSError[] errors;
        public final boolean transpiled;
        public final String sourceMap;

        public CompileResult(String source, JSError[] errors, boolean transpiled, String sourceMap) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            this.errors = (JSError[])Preconditions.checkNotNull((Object)errors);
            this.transpiled = transpiled;
            this.sourceMap = (String)Preconditions.checkNotNull((Object)sourceMap);
        }
    }

    @Immutable
    public static class CompilerSupplier {
        protected static final SourceFile EXTERNS = SourceFile.fromCode("externs.js", "function Symbol() {}");
        protected static final SourceFile EMPTY = SourceFile.fromCode("empty.js", "");
        protected static final DiagnosticGroup ES5_WARNINGS = new DiagnosticGroup(new DiagnosticType[]{DiagnosticType.error("JSC_CANNOT_CONVERT", "")});

        public CompileResult compile(Path path, String code) {
            Compiler compiler = this.compiler();
            Result result = compiler.compile(EXTERNS, SourceFile.fromCode(path.toString(), code), this.options());
            String source = compiler.toSource();
            StringBuilder sourceMap = new StringBuilder();
            if (result.sourceMap != null) {
                try {
                    result.sourceMap.appendTo(sourceMap, path.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean transpiled = !result.transpiledFiles.isEmpty();
            return new CompileResult(source, result.errors, transpiled, transpiled ? sourceMap.toString() : "");
        }

        public String runtime(String library) {
            Compiler compiler = this.compiler();
            CompilerOptions options = this.options();
            options.setForceLibraryInjection((Iterable<String>)ImmutableList.of((Object)library));
            compiler.compile(EXTERNS, EMPTY, options);
            return compiler.toSource();
        }

        protected Compiler compiler() {
            return new Compiler();
        }

        protected CompilerOptions options() {
            CompilerOptions options = new CompilerOptions();
            this.setOptions(options);
            return options;
        }

        protected void setOptions(CompilerOptions options) {
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2017);
            options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
            options.setQuoteKeywordProperties(true);
            options.setSkipNonTranspilationPasses(true);
            options.setVariableRenaming(VariableRenamingPolicy.OFF);
            options.setPropertyRenaming(PropertyRenamingPolicy.OFF);
            options.setWrapGoogModulesForWhitespaceOnly(false);
            options.setPrettyPrint(true);
            options.setSourceMapOutputPath("/dev/null");
            options.setSourceMapIncludeSourcesContent(true);
            options.setWarningLevel(ES5_WARNINGS, CheckLevel.OFF);
        }
    }
}

