/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class ReplaceCssNames
implements CompilerPass {
    static final Node GET_CSS_NAME_FUNCTION = IR.getprop(IR.name("goog"), IR.string("getCssName"));
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_GETCSSNAME_NUM_ARGS", "goog.getCssName called with \"{0}\" arguments, expected 1 or 2.");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_GETCSSNAME_STRING_LITERAL_EXPECTED", "goog.getCssName called with invalid argument, string literal expected.  Was \"{0}\".");
    static final DiagnosticType UNEXPECTED_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_GETCSSNAME_UNEXPECTED_STRING_LITERAL", "goog.getCssName called with invalid arguments, string literal passed as first of two arguments.  Did you mean goog.getCssName(\"{0}-{1}\")?");
    static final DiagnosticType UNKNOWN_SYMBOL_WARNING = DiagnosticType.warning("JSC_GETCSSNAME_UNKNOWN_CSS_SYMBOL", "goog.getCssName called with unrecognized symbol \"{0}\" in class \"{1}\".");
    private final AbstractCompiler compiler;
    private final Map<String, Integer> cssNames;
    private CssRenamingMap symbolMap;
    private final Set<String> whitelist;
    private TypeI nativeStringType;

    ReplaceCssNames(AbstractCompiler compiler, @Nullable Map<String, Integer> cssNames, @Nullable Set<String> whitelist) {
        this.compiler = compiler;
        this.cssNames = cssNames;
        this.whitelist = whitelist;
    }

    private TypeI getNativeStringType() {
        if (this.nativeStringType == null) {
            this.nativeStringType = this.compiler.getTypeIRegistry().getNativeType(JSTypeNative.STRING_TYPE);
        }
        return this.nativeStringType;
    }

    @Override
    public void process(Node externs, Node root) {
        this.symbolMap = this.getCssRenamingMap();
        NodeTraversal.traverseEs6(this.compiler, root, new Traversal());
    }

    @VisibleForTesting
    protected CssRenamingMap getCssRenamingMap() {
        return this.compiler.getCssRenamingMap();
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback {
        private Traversal() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall() && n.getFirstChild().matchesQualifiedName(GET_CSS_NAME_FUNCTION)) {
                int count = n.getChildCount();
                Node first = n.getSecondChild();
                switch (count) {
                    case 2: {
                        if (first.isString()) {
                            this.processStringNode(t, first);
                            n.removeChild(first);
                            parent.replaceChild(n, first);
                            t.reportCodeChange();
                            break;
                        }
                        ReplaceCssNames.this.compiler.report(t.makeError(n, STRING_LITERAL_EXPECTED_ERROR, first.getToken().toString()));
                        break;
                    }
                    case 3: {
                        Node second = first.getNext();
                        if (!second.isString()) {
                            ReplaceCssNames.this.compiler.report(t.makeError(n, STRING_LITERAL_EXPECTED_ERROR, second.getToken().toString()));
                            break;
                        }
                        if (first.isString()) {
                            ReplaceCssNames.this.compiler.report(t.makeError(n, UNEXPECTED_STRING_LITERAL_ERROR, first.getString(), second.getString()));
                            break;
                        }
                        this.processStringNode(t, second);
                        n.removeChild(first);
                        Node replacement = IR.add(first, IR.string("-" + second.getString()).useSourceInfoIfMissingFrom(second)).useSourceInfoIfMissingFrom(n);
                        replacement.setTypeI(ReplaceCssNames.this.getNativeStringType());
                        parent.replaceChild(n, replacement);
                        t.reportCodeChange();
                        break;
                    }
                    default: {
                        ReplaceCssNames.this.compiler.report(t.makeError(n, INVALID_NUM_ARGUMENTS_ERROR, String.valueOf(count)));
                    }
                }
            }
        }

        private void processStringNode(NodeTraversal t, Node n) {
            String name = n.getString();
            if (ReplaceCssNames.this.whitelist != null && ReplaceCssNames.this.whitelist.contains(name)) {
                return;
            }
            String[] parts = name.split("-");
            if (ReplaceCssNames.this.symbolMap != null) {
                String replacement = null;
                switch (ReplaceCssNames.this.symbolMap.getStyle()) {
                    case BY_WHOLE: {
                        replacement = ReplaceCssNames.this.symbolMap.get(name);
                        if (replacement != null) break;
                        ReplaceCssNames.this.compiler.report(t.makeError(n, UNKNOWN_SYMBOL_WARNING, name, name));
                        return;
                    }
                    case BY_PART: {
                        Object[] replaced = new String[parts.length];
                        for (int i = 0; i < parts.length; ++i) {
                            String part = ReplaceCssNames.this.symbolMap.get(parts[i]);
                            if (part == null) {
                                ReplaceCssNames.this.compiler.report(t.makeError(n, UNKNOWN_SYMBOL_WARNING, parts[i], name));
                                return;
                            }
                            replaced[i] = part;
                        }
                        replacement = Joiner.on((String)"-").join(replaced);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown replacement style: " + (Object)((Object)ReplaceCssNames.this.symbolMap.getStyle()));
                    }
                }
                n.setString(replacement);
            }
            if (ReplaceCssNames.this.cssNames != null) {
                for (String element : parts) {
                    Integer count = (Integer)ReplaceCssNames.this.cssNames.get(element);
                    if (count == null) {
                        count = 0;
                    }
                    ReplaceCssNames.this.cssNames.put(element, count + 1);
                }
            }
        }
    }
}

