/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionUseSiteFinder;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RemoveUnusedVars
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final boolean removeGlobals;
    private boolean preserveFunctionExpressionNames;
    private final Set<Var> referenced = new HashSet<Var>();
    private final List<Var> maybeUnreferenced = new ArrayList<Var>();
    private final List<Scope> allFunctionParamScopes = new ArrayList<Scope>();
    private final Multimap<Var, Assign> assignsByVar = ArrayListMultimap.create();
    private final Map<Node, Assign> assignsByNode = new HashMap<Node, Assign>();
    private final Multimap<Var, Node> classDefiningCalls = ArrayListMultimap.create();
    private final Multimap<Var, Continuation> continuations = ArrayListMultimap.create();
    private boolean modifyCallSites;
    private CallSiteOptimizer callSiteOptimizer;
    private final ScopeCreator scopeCreator;

    RemoveUnusedVars(AbstractCompiler compiler, boolean removeGlobals, boolean preserveFunctionExpressionNames, boolean modifyCallSites) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
        this.removeGlobals = removeGlobals;
        this.preserveFunctionExpressionNames = preserveFunctionExpressionNames;
        this.modifyCallSites = modifyCallSites;
        this.scopeCreator = new Es6SyntacticScopeCreator(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        boolean shouldResetModifyCallSites = false;
        if (this.modifyCallSites && this.compiler.getDefinitionFinder() == null) {
            this.modifyCallSites = false;
            shouldResetModifyCallSites = true;
        }
        this.process(externs, root, this.compiler.getDefinitionFinder());
        this.compiler.setDefinitionFinder(null);
        if (shouldResetModifyCallSites) {
            this.modifyCallSites = true;
        }
    }

    @Override
    public void process(Node externs, Node root, DefinitionUseSiteFinder defFinder) {
        if (this.modifyCallSites) {
            Preconditions.checkNotNull((Object)defFinder);
            this.callSiteOptimizer = new CallSiteOptimizer(this.compiler, defFinder);
        }
        this.traverseAndRemoveUnusedReferences(root);
        if (this.callSiteOptimizer != null) {
            this.callSiteOptimizer.applyChanges();
        }
    }

    private void traverseAndRemoveUnusedReferences(Node root) {
        Scope scope = this.scopeCreator.createScope(root, null);
        this.traverseNode(root, null, scope);
        if (this.removeGlobals) {
            this.collectMaybeUnreferencedVars(scope);
        }
        this.interpretAssigns();
        this.removeUnreferencedVars();
        for (Scope fparamScope : this.allFunctionParamScopes) {
            this.removeUnreferencedFunctionArgs(fparamScope);
        }
    }

    private void traverseNode(Node n, Node parent, Scope scope) {
        Token type = n.getToken();
        Var var = null;
        switch (type) {
            case FUNCTION: {
                if (NodeUtil.isFunctionDeclaration(n)) {
                    var = scope.getVar(n.getFirstChild().getString());
                }
                if (var != null && this.isRemovableVar(var)) {
                    this.continuations.put((Object)var, (Object)new Continuation(n, scope));
                } else {
                    this.traverseFunction(n, scope);
                }
                return;
            }
            case ASSIGN: {
                Assign maybeAssign = Assign.maybeCreateAssign(n);
                if (maybeAssign == null || (var = scope.getVar(maybeAssign.nameNode.getString())) == null) break;
                this.assignsByVar.put((Object)var, (Object)maybeAssign);
                this.assignsByNode.put(maybeAssign.nameNode, maybeAssign);
                if (!this.isRemovableVar(var) || maybeAssign.mayHaveSecondarySideEffects) break;
                this.continuations.put((Object)var, (Object)new Continuation(n, scope));
                return;
            }
            case CALL: {
                Var modifiedVar = null;
                CodingConvention.SubclassRelationship subclassRelationship = this.codingConvention.getClassesDefinedByCall(n);
                if (subclassRelationship != null) {
                    modifiedVar = scope.getVar(subclassRelationship.subclassName);
                } else {
                    String className = this.codingConvention.getSingletonGetterClassName(n);
                    if (className != null) {
                        modifiedVar = scope.getVar(className);
                    }
                }
                if (modifiedVar == null || !modifiedVar.isGlobal() || this.referenced.contains(modifiedVar)) break;
                this.classDefiningCalls.put((Object)modifiedVar, (Object)parent);
                this.continuations.put((Object)modifiedVar, (Object)new Continuation(n, scope));
                return;
            }
            case BLOCK: {
                if (!NodeUtil.createsBlockScope(n)) break;
                Scope blockScope = this.scopeCreator.createScope(n, scope);
                this.collectMaybeUnreferencedVars(blockScope);
                scope = blockScope;
                break;
            }
            case CLASS: {
                if (NodeUtil.isClassDeclaration(n)) {
                    var = scope.getVar(n.getFirstChild().getString());
                }
                if (var != null && this.isRemovableVar(var)) {
                    this.continuations.put((Object)var, (Object)new Continuation(n, scope));
                }
                return;
            }
            case ARRAY_PATTERN: {
                if (!n.getParent().isDestructuringLhs() || NodeUtil.isNestedArrayPattern(n)) break;
                return;
            }
            case OBJECT_PATTERN: {
                if (!n.getParent().isDestructuringLhs() || NodeUtil.isNestedObjectPattern(n)) break;
                return;
            }
            case NAME: {
                var = scope.getVar(n.getString());
                if (NodeUtil.isNameDeclaration(parent)) {
                    Node value = n.getFirstChild();
                    if (value == null || var == null || !this.isRemovableVar(var) || NodeUtil.mayHaveSideEffects(value, this.compiler)) break;
                    this.continuations.put((Object)var, (Object)new Continuation(n, scope));
                    return;
                }
                if (var != null && "arguments".equals(n.getString()) && var.equals(scope.getArgumentsVar())) {
                    Scope fnScope = var.getScope();
                    Node lp = fnScope.getRootNode().getSecondChild();
                    for (Node p = lp.getFirstChild(); p != null; p = p.getNext()) {
                        Var paramVar = fnScope.getOwnSlot(p.getString());
                        Preconditions.checkNotNull((Object)paramVar);
                        this.markReferencedVar(paramVar);
                    }
                }
                if (var == null) break;
                if (this.isRemovableVar(var)) {
                    if (this.assignsByNode.containsKey(n)) break;
                    this.markReferencedVar(var);
                    break;
                }
                this.markReferencedVar(var);
                break;
            }
        }
        this.traverseChildren(n, scope);
    }

    private void traverseChildren(Node n, Scope scope) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.traverseNode(c, n, scope);
        }
    }

    private boolean isRemovableVar(Var var) {
        if (var.equals(var.getScope().getArgumentsVar())) {
            return false;
        }
        if (!this.removeGlobals && var.isGlobal()) {
            return false;
        }
        if (var.getParentNode() != null && NodeUtil.isEnhancedFor(var.getParentNode().getParent())) {
            return false;
        }
        if (this.referenced.contains(var)) {
            return false;
        }
        return !this.codingConvention.isExported(var.getName());
    }

    private void traverseFunction(Node function, Scope parentScope) {
        Preconditions.checkState((function.getChildCount() == 3 ? 1 : 0) != 0, (Object)function);
        Preconditions.checkState((boolean)function.isFunction(), (Object)function);
        Node body = function.getLastChild();
        Preconditions.checkState((body.getNext() == null && body.isNormalBlock() ? 1 : 0) != 0, (Object)body);
        Scope fparamScope = this.scopeCreator.createScope(function, parentScope);
        Scope fbodyScope = this.scopeCreator.createScope(body, fparamScope);
        this.traverseChildren(body, fbodyScope);
        this.collectMaybeUnreferencedVars(fparamScope);
        this.collectMaybeUnreferencedVars(fbodyScope);
        this.allFunctionParamScopes.add(fparamScope);
    }

    private void collectMaybeUnreferencedVars(Scope scope) {
        for (Var var : scope.getVarIterable()) {
            if (!this.isRemovableVar(var)) continue;
            this.maybeUnreferenced.add(var);
        }
    }

    private void removeUnreferencedFunctionArgs(Scope fparamScope) {
        boolean modifyCallers;
        if (!this.removeGlobals) {
            return;
        }
        Node function = fparamScope.getRootNode();
        Preconditions.checkState((boolean)function.isFunction());
        if (NodeUtil.isGetOrSetKey(function.getParent())) {
            return;
        }
        Node argList = NodeUtil.getFunctionParameters(function);
        boolean bl = modifyCallers = this.modifyCallSites && this.callSiteOptimizer.canModifyCallers(function);
        if (!modifyCallers) {
            this.removeUnusedDestructuringNames(argList, fparamScope);
            this.maybeRemoveUnusedTrailingParameters(argList, fparamScope);
        } else {
            this.callSiteOptimizer.optimize(fparamScope, this.referenced);
        }
    }

    private void removeUnusedDestructuringNames(Node argList, Scope fparamScope) {
        List<Node> destructuringDeclarations = NodeUtil.getLhsNodesOfDeclaration(argList);
        Iterator iterator = Lists.reverse(destructuringDeclarations).iterator();
        while (iterator.hasNext()) {
            Var var;
            Node patternElt;
            Node toRemove = patternElt = (Node)iterator.next();
            if (patternElt.getParent().isDefaultValue()) {
                Node defaultValueRhs = patternElt.getNext();
                if (NodeUtil.mayHaveSideEffects(defaultValueRhs)) continue;
                toRemove = patternElt.getParent();
            }
            if (toRemove.getParent().isParamList() || this.referenced.contains(var = fparamScope.getVar(patternElt.getString()))) continue;
            if (toRemove.getParent().isStringKey()) {
                toRemove = toRemove.getParent();
            }
            NodeUtil.markFunctionsDeleted(toRemove, this.compiler);
            this.compiler.reportChangeToEnclosingScope(toRemove.getParent());
            NodeUtil.removeChild(toRemove.getParent(), toRemove);
        }
    }

    private void maybeRemoveUnusedTrailingParameters(Node argList, Scope fparamScope) {
        Node lastArg;
        while ((lastArg = argList.getLastChild()) != null) {
            Node defaultValueSecondChild;
            Node lValue = lastArg;
            if (lastArg.isDefaultValue() && NodeUtil.mayHaveSideEffects(defaultValueSecondChild = (lValue = lastArg.getFirstChild()).getNext())) break;
            if (lValue.isRest()) {
                lValue = lValue.getFirstChild();
            }
            if (lValue.isDestructuringPattern()) {
                if (lValue.hasChildren()) break;
                NodeUtil.deleteNode(lastArg, this.compiler);
                continue;
            }
            Var var = fparamScope.getVar(lValue.getString());
            if (this.referenced.contains(var)) break;
            NodeUtil.deleteNode(lastArg, this.compiler);
        }
    }

    private void interpretAssigns() {
        boolean changes = false;
        do {
            changes = false;
            for (int current = 0; current < this.maybeUnreferenced.size(); ++current) {
                Node value;
                Var var = this.maybeUnreferenced.get(current);
                if (this.referenced.contains(var)) {
                    this.maybeUnreferenced.remove(current);
                    --current;
                    continue;
                }
                boolean assignedToUnknownValue = false;
                assignedToUnknownValue = NodeUtil.isNameDeclaration(var.getParentNode()) && !var.getParentNode().getParent().isForIn() ? (value = var.getInitialValue()) != null && !NodeUtil.isLiteralValue(value, true) : true;
                boolean maybeEscaped = false;
                boolean hasPropertyAssign = false;
                for (Assign assign : this.assignsByVar.get((Object)var)) {
                    if (assign.isPropertyAssign) {
                        hasPropertyAssign = true;
                    } else if (!NodeUtil.isLiteralValue(assign.assignNode.getLastChild(), true)) {
                        assignedToUnknownValue = true;
                    }
                    if (!assign.maybeAliased) continue;
                    maybeEscaped = true;
                }
                if (!assignedToUnknownValue && !maybeEscaped || !hasPropertyAssign) continue;
                changes = this.markReferencedVar(var) || changes;
                this.maybeUnreferenced.remove(current);
                --current;
            }
        } while (changes);
    }

    private void removeAllAssigns(Var var) {
        for (Assign assign : this.assignsByVar.get((Object)var)) {
            this.compiler.reportChangeToEnclosingScope(assign.assignNode);
            assign.remove(this.compiler);
        }
    }

    private boolean markReferencedVar(Var var) {
        if (this.referenced.add(var)) {
            for (Continuation c : this.continuations.get((Object)var)) {
                c.apply();
            }
            return true;
        }
        return false;
    }

    private void removeUnreferencedVars() {
        for (Var var : this.maybeUnreferenced) {
            for (Node exprCallNode : this.classDefiningCalls.get((Object)var)) {
                this.compiler.reportChangeToEnclosingScope(exprCallNode);
                NodeUtil.removeChild(exprCallNode.getParent(), exprCallNode);
            }
            this.removeAllAssigns(var);
            this.compiler.addToDebugLog("Unreferenced var: ", var.name);
            Node nameNode = var.nameNode;
            Node toRemove = nameNode.getParent();
            Node parent = toRemove.getParent();
            Node grandParent = toRemove.getGrandparent();
            Preconditions.checkState((NodeUtil.isNameDeclaration(toRemove) || toRemove.isFunction() || toRemove.isParamList() && parent.isFunction() || NodeUtil.isDestructuringDeclaration(grandParent) || toRemove.isArrayPattern() || parent.isObjectPattern() || toRemove.isClass() || toRemove.isDefaultValue() && NodeUtil.getEnclosingScopeRoot(toRemove).isFunction() || toRemove.isRest() && NodeUtil.getEnclosingScopeRoot(toRemove).isFunction() ? 1 : 0) != 0, (Object)"We should only declare Vars and functions and function args and classes");
            if (toRemove.isParamList() && parent.isFunction() || toRemove.isDefaultValue() && NodeUtil.getEnclosingScopeRoot(toRemove).isFunction() || toRemove.isRest() && NodeUtil.getEnclosingScopeRoot(toRemove).isFunction() || toRemove.isComputedProp()) continue;
            if (NodeUtil.isFunctionExpression(toRemove)) {
                if (this.preserveFunctionExpressionNames) continue;
                Node fnNameNode = toRemove.getFirstChild();
                this.compiler.reportChangeToEnclosingScope(fnNameNode);
                fnNameNode.setString("");
                continue;
            }
            if (toRemove.isArrayPattern() && grandParent.isParamList()) {
                this.compiler.reportChangeToEnclosingScope(toRemove);
                NodeUtil.removeChild(toRemove, nameNode);
                continue;
            }
            if (parent.isForIn()) continue;
            if (parent.isDestructuringPattern()) {
                this.compiler.reportChangeToEnclosingScope(toRemove);
                NodeUtil.removeChild(parent, toRemove);
                continue;
            }
            if (parent.isDestructuringLhs()) {
                this.compiler.reportChangeToEnclosingScope(nameNode);
                NodeUtil.removeChild(toRemove, nameNode);
                continue;
            }
            if (NodeUtil.isNameDeclaration(toRemove) && nameNode.hasChildren() && NodeUtil.mayHaveSideEffects(nameNode.getFirstChild(), this.compiler)) {
                if (!toRemove.hasOneChild()) continue;
                this.compiler.reportChangeToEnclosingScope(toRemove);
                parent.replaceChild(toRemove, IR.exprResult(nameNode.removeFirstChild()));
                continue;
            }
            if (NodeUtil.isNameDeclaration(toRemove) && toRemove.hasMoreThanOneChild()) {
                this.compiler.reportChangeToEnclosingScope(toRemove);
                toRemove.removeChild(nameNode);
                continue;
            }
            if (parent == null) continue;
            this.compiler.reportChangeToEnclosingScope(toRemove);
            NodeUtil.removeChild(parent, toRemove);
            NodeUtil.markFunctionsDeleted(toRemove, this.compiler);
        }
    }

    private static boolean alreadyRemoved(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.isRoot()) {
            return false;
        }
        return RemoveUnusedVars.alreadyRemoved(parent);
    }

    private static class Assign {
        final Node assignNode;
        final Node nameNode;
        final boolean isPropertyAssign;
        final boolean mayHaveSecondarySideEffects;
        final boolean maybeAliased;

        Assign(Node assignNode, Node nameNode, boolean isPropertyAssign) {
            Preconditions.checkState((boolean)NodeUtil.isAssignmentOp(assignNode));
            this.assignNode = assignNode;
            this.nameNode = nameNode;
            this.isPropertyAssign = isPropertyAssign;
            this.maybeAliased = NodeUtil.isExpressionResultUsed(assignNode);
            this.mayHaveSecondarySideEffects = this.maybeAliased || NodeUtil.mayHaveSideEffects(assignNode.getFirstChild()) || NodeUtil.mayHaveSideEffects(assignNode.getLastChild());
        }

        static Assign maybeCreateAssign(Node assignNode) {
            Preconditions.checkState((boolean)NodeUtil.isAssignmentOp(assignNode));
            boolean isPropAssign = false;
            Node current = assignNode.getFirstChild();
            if (NodeUtil.isGet(current)) {
                current = current.getFirstChild();
                isPropAssign = true;
                if (current.isGetProp() && current.getLastChild().getString().equals("prototype")) {
                    current = current.getFirstChild();
                }
            }
            if (current.isName()) {
                return new Assign(assignNode, current, isPropAssign);
            }
            return null;
        }

        void remove(AbstractCompiler compiler) {
            Node parent = this.assignNode.getParent();
            if (this.mayHaveSecondarySideEffects) {
                Node replacement = this.assignNode.getLastChild().detach();
                Node current = this.assignNode.getFirstChild();
                while (!current.isName()) {
                    if (current.isGetElem()) {
                        replacement = IR.comma(current.getLastChild().detach(), replacement);
                        replacement.useSourceInfoIfMissingFrom(current);
                    }
                    current = current.getFirstChild();
                }
                parent.replaceChild(this.assignNode, replacement);
            } else {
                Node grandparent = parent.getParent();
                if (parent.isExprResult()) {
                    grandparent.removeChild(parent);
                    NodeUtil.markFunctionsDeleted(parent, compiler);
                } else {
                    parent.replaceChild(this.assignNode, IR.number(0.0).srcref(this.assignNode));
                }
            }
        }
    }

    private class Continuation {
        private final Node node;
        private final Scope scope;

        Continuation(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
        }

        void apply() {
            if (NodeUtil.isFunctionDeclaration(this.node)) {
                RemoveUnusedVars.this.traverseFunction(this.node, this.scope);
            } else {
                for (Node child = this.node.getFirstChild(); child != null; child = child.getNext()) {
                    RemoveUnusedVars.this.traverseNode(child, this.node, this.scope);
                }
            }
        }
    }

    private static class CallSiteOptimizer {
        private final AbstractCompiler compiler;
        private final DefinitionUseSiteFinder defFinder;
        private final List<Node> toRemove = new ArrayList<Node>();
        private final List<Node> toReplaceWithZero = new ArrayList<Node>();

        CallSiteOptimizer(AbstractCompiler compiler, DefinitionUseSiteFinder defFinder) {
            this.compiler = compiler;
            this.defFinder = defFinder;
        }

        public void optimize(Scope fparamScope, Set<Var> referenced) {
            Node function = fparamScope.getRootNode();
            Preconditions.checkState((boolean)function.isFunction());
            Node argList = NodeUtil.getFunctionParameters(function);
            boolean changeCallSignature = this.canChangeSignature(function);
            this.markUnreferencedFunctionArgs(fparamScope, function, referenced, argList.getFirstChild(), 0, changeCallSignature);
        }

        public void applyChanges() {
            for (Node n : this.toRemove) {
                if (RemoveUnusedVars.alreadyRemoved(n)) continue;
                this.compiler.reportChangeToEnclosingScope(n);
                n.detach();
                NodeUtil.markFunctionsDeleted(n, this.compiler);
            }
            for (Node n : this.toReplaceWithZero) {
                if (RemoveUnusedVars.alreadyRemoved(n)) continue;
                this.compiler.reportChangeToEnclosingScope(n);
                n.replaceWith(IR.number(0.0).srcref(n));
                NodeUtil.markFunctionsDeleted(n, this.compiler);
            }
        }

        private boolean markUnreferencedFunctionArgs(Scope scope, Node function, Set<Var> referenced, Node param, int paramIndex, boolean canChangeSignature) {
            if (param != null) {
                boolean hasFollowing = this.markUnreferencedFunctionArgs(scope, function, referenced, param.getNext(), paramIndex + 1, canChangeSignature);
                Var var = scope.getVar(param.getString());
                if (!referenced.contains(var)) {
                    boolean modifyAllCallSites;
                    Preconditions.checkNotNull((Object)var);
                    boolean bl = modifyAllCallSites = canChangeSignature || !hasFollowing;
                    if (modifyAllCallSites) {
                        modifyAllCallSites = this.canRemoveArgFromCallSites(function, paramIndex);
                    }
                    this.tryRemoveArgFromCallSites(function, paramIndex, modifyAllCallSites);
                    if (modifyAllCallSites || !hasFollowing) {
                        this.toRemove.add(param);
                        return hasFollowing;
                    }
                }
                return true;
            }
            this.tryRemoveAllFollowingArgs(function, paramIndex - 1);
            return false;
        }

        private boolean canRemoveArgFromCallSites(Node function, int argIndex) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            for (UseSite site : this.defFinder.getUseSites(definition)) {
                if (CallSiteOptimizer.isModifiableCallSite(site)) {
                    Node arg = CallSiteOptimizer.getArgumentForCallOrNewOrDotCall(site, argIndex);
                    if (arg == null || !NodeUtil.mayHaveSideEffects(arg, this.compiler)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private void tryRemoveArgFromCallSites(Node function, int argIndex, boolean canModifyAllSites) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            for (UseSite site : this.defFinder.getUseSites(definition)) {
                Node arg;
                if (!CallSiteOptimizer.isModifiableCallSite(site) || (arg = CallSiteOptimizer.getArgumentForCallOrNewOrDotCall(site, argIndex)) == null) continue;
                if (canModifyAllSites || arg.getNext() == null && !NodeUtil.mayHaveSideEffects(arg, this.compiler)) {
                    this.toRemove.add(arg);
                    continue;
                }
                if (NodeUtil.mayHaveSideEffects(arg, this.compiler) || arg.isNumber() && arg.getDouble() == 0.0) continue;
                this.toReplaceWithZero.add(arg);
            }
        }

        private void tryRemoveAllFollowingArgs(Node function, int argIndex) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            for (UseSite site : this.defFinder.getUseSites(definition)) {
                if (!CallSiteOptimizer.isModifiableCallSite(site)) continue;
                for (Node arg = CallSiteOptimizer.getArgumentForCallOrNewOrDotCall(site, argIndex + 1); arg != null; arg = arg.getNext()) {
                    if (NodeUtil.mayHaveSideEffects(arg)) continue;
                    this.toRemove.add(arg);
                }
            }
        }

        private static Node getArgumentForCallOrNewOrDotCall(UseSite site, int argIndex) {
            int adjustedArgIndex = argIndex;
            Node parent = site.node.getParent();
            if (NodeUtil.isFunctionObjectCall(parent)) {
                ++adjustedArgIndex;
            }
            return NodeUtil.getArgumentForCallOrNew(parent, adjustedArgIndex);
        }

        boolean canModifyCallers(Node function) {
            if (NodeUtil.isVarArgsFunction(function)) {
                return false;
            }
            DefinitionSite defSite = this.defFinder.getDefinitionForFunction(function);
            if (defSite == null) {
                return false;
            }
            DefinitionsRemover.Definition definition = defSite.definition;
            if (!NodeUtil.isSimpleFunctionDeclaration(function)) {
                return false;
            }
            return this.defFinder.canModifyDefinition(definition);
        }

        private static boolean isModifiableCallSite(UseSite site) {
            return DefinitionUseSiteFinder.isCallOrNewSite(site) && !NodeUtil.isFunctionObjectApply(site.node.getParent());
        }

        private boolean canChangeSignature(Node function) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(function);
            CodingConvention convention = this.compiler.getCodingConvention();
            Preconditions.checkState((!definition.isExtern() ? 1 : 0) != 0);
            Collection<UseSite> useSites = this.defFinder.getUseSites(definition);
            for (UseSite site : useSites) {
                Node parent = site.node.getParent();
                if (parent == null || parent.isCall() && convention.getClassesDefinedByCall(parent) != null) continue;
                if (!(DefinitionUseSiteFinder.isCallOrNewSite(site) || parent.isGetProp() && NodeUtil.isFunctionObjectCall(parent.getParent()))) {
                    return false;
                }
                if (NodeUtil.isFunctionObjectApply(parent)) {
                    return false;
                }
                Node nameNode = site.node;
                Collection<DefinitionsRemover.Definition> singleSiteDefinitions = this.defFinder.getDefinitionsReferencedAt(nameNode);
                Preconditions.checkState((singleSiteDefinitions.size() == 1 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)singleSiteDefinitions.contains(definition));
            }
            return true;
        }

        private DefinitionsRemover.Definition getFunctionDefinition(Node function) {
            DefinitionSite definitionSite = this.defFinder.getDefinitionForFunction(function);
            Preconditions.checkNotNull((Object)definitionSite);
            DefinitionsRemover.Definition definition = definitionSite.definition;
            Preconditions.checkState((!definitionSite.inExterns ? 1 : 0) != 0);
            Preconditions.checkState((definition.getRValue() == function ? 1 : 0) != 0);
            return definition;
        }
    }
}

