/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionToBlockMutator;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ProcessCommonJSModules
implements CompilerPass {
    private static final String EXPORTS = "exports";
    private static final String MODULE = "module";
    public static final DiagnosticType UNKNOWN_REQUIRE_ENSURE = DiagnosticType.warning("JSC_COMMONJS_UNKNOWN_REQUIRE_ENSURE_ERROR", "Unrecognized require.ensure call: {0}");
    public static final DiagnosticType SUSPICIOUS_EXPORTS_ASSIGNMENT = DiagnosticType.warning("JSC_COMMONJS_SUSPICIOUS_EXPORTS_ASSIGNMENT", "Suspicious re-assignment of \"exports\" variable. Did you actually intend to export something?");
    private final Compiler compiler;
    private final boolean reportDependencies;

    public ProcessCommonJSModules(Compiler compiler) {
        this(compiler, true);
    }

    public ProcessCommonJSModules(Compiler compiler, boolean reportDependencies) {
        this.compiler = compiler;
        this.reportDependencies = reportDependencies;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)root.isScript());
        FindImportsAndExports finder = new FindImportsAndExports();
        NodeTraversal.traverseEs6(this.compiler, root, finder);
        ImmutableList.Builder exports = ImmutableList.builder();
        if (finder.isCommonJsModule()) {
            finder.reportModuleErrors();
            if (!finder.umdPatterns.isEmpty()) {
                finder.replaceUmdPatterns();
                if (this.removeIIFEWrapper(root)) {
                    finder = new FindImportsAndExports();
                    NodeTraversal.traverseEs6(this.compiler, root, finder);
                }
            }
            for (ExportInfo export : finder.getModuleExports()) {
                if (NodeUtil.getEnclosingScript(export.node) == null) continue;
                exports.add((Object)export);
            }
            for (ExportInfo export : finder.getExports()) {
                if (NodeUtil.getEnclosingScript(export.node) == null) continue;
                exports.add((Object)export);
            }
            finder.initializeModule();
        }
        NodeTraversal.traverseEs6(this.compiler, root, new RewriteModule(finder.isCommonJsModule(), (ImmutableCollection<ExportInfo>)exports.build()));
        finder.addGoogProvideAndRequires();
    }

    private Node getBaseQualifiedNameNode(Node n) {
        Node refParent = n;
        while (refParent.getParent() != null && refParent.getParent().isQualifiedName()) {
            refParent = refParent.getParent();
        }
        return refParent;
    }

    private boolean removeIIFEWrapper(Node root) {
        Node fnc;
        Node n;
        Preconditions.checkState((boolean)root.isScript());
        for (n = root.getFirstChild(); n != null && n.isEmpty(); n = n.getNext()) {
        }
        if (n == null || !n.isExprResult() || n.getNext() != null) {
            return false;
        }
        Node call = n.getFirstChild();
        if (call == null || !call.isCall()) {
            return false;
        }
        if (call.getFirstChild().isFunction()) {
            fnc = n.getFirstFirstChild();
        } else if (call.getFirstChild().isGetProp() && call.getFirstFirstChild().isFunction() && call.getFirstFirstChild().getNext().isString() && call.getFirstFirstChild().getNext().getString().equals("call")) {
            fnc = call.getFirstFirstChild();
            if (call.getSecondChild() == null || !call.getSecondChild().isThis()) {
                return false;
            }
        } else {
            return false;
        }
        if (NodeUtil.isVarArgsFunction(fnc)) {
            return false;
        }
        CompilerInput ci = this.compiler.getInput(root.getInputId());
        ModuleLoader.ModulePath modulePath = ci.getPath();
        if (modulePath == null) {
            return false;
        }
        String iifeLabel = modulePath.toModuleName() + "_iifeWrapper";
        FunctionToBlockMutator mutator = new FunctionToBlockMutator(this.compiler, this.compiler.getUniqueNameIdSupplier());
        Node block = mutator.unwrapIifeInModule(iifeLabel, fnc, call);
        root.removeChildren();
        root.addChildrenToFront(block.removeChildren());
        this.compiler.reportChangeToEnclosingScope(root);
        return true;
    }

    private static boolean umdPatternsContains(List<UmdPattern> umdPatterns, Node n) {
        for (UmdPattern umd : umdPatterns) {
            if (umd.ifRoot != n) continue;
            return true;
        }
        return false;
    }

    private class RewriteModule
    extends NodeTraversal.AbstractPostOrderCallback {
        private final boolean allowFullRewrite;
        private final ImmutableCollection<ExportInfo> exports;
        private final List<Node> imports = new ArrayList<Node>();
        private final List<Node> rewrittenClassExpressions = new ArrayList<Node>();
        private final List<Node> functionsToHoist = new ArrayList<Node>();

        public RewriteModule(boolean allowFullRewrite, ImmutableCollection<ExportInfo> exports) {
            this.allowFullRewrite = allowFullRewrite;
            this.exports = exports;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    for (Node clazz : this.rewrittenClassExpressions) {
                        clazz.replaceChild(clazz.getFirstChild(), IR.empty().useSourceInfoFrom(clazz.getFirstChild()));
                        t.reportCodeChange();
                    }
                    CompilerInput ci = ProcessCommonJSModules.this.compiler.getInput(n.getInputId());
                    ModuleLoader.ModulePath modulePath = ci.getPath();
                    String moduleName = modulePath.toModuleName();
                    for (int i = this.functionsToHoist.size() - 1; i >= 0; --i) {
                        Node functionExpr = this.functionsToHoist.get(i);
                        Node scopeRoot = t.getClosestHoistScopeRoot();
                        Node insertionPoint = scopeRoot.getFirstChild();
                        if (insertionPoint == null || !insertionPoint.isVar() || !insertionPoint.getFirstChild().getString().equals(moduleName)) {
                            insertionPoint = null;
                        }
                        if (insertionPoint == null) {
                            if (scopeRoot.getFirstChild() == functionExpr) continue;
                            scopeRoot.addChildToFront(functionExpr.detach());
                            continue;
                        }
                        if (insertionPoint == functionExpr || insertionPoint.getNext() == functionExpr) continue;
                        scopeRoot.addChildAfter(functionExpr.detach(), insertionPoint);
                    }
                    for (ExportInfo export : this.exports) {
                        this.visitExport(t, export.node);
                    }
                    for (Object require : this.imports) {
                        this.visitRequireCall(t, (Node)require, ((Node)require).getParent());
                    }
                    break;
                }
                case CALL: {
                    if (!n.hasTwoChildren() || !n.getFirstChild().matchesQualifiedName("require") || !n.getSecondChild().isString()) break;
                    this.imports.add(n);
                    break;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    if (!n.hasMoreThanOneChild() || NodeUtil.isAnyFor(parent)) break;
                    List<Node> vars = this.splitMultipleDeclarations(n);
                    t.reportCodeChange();
                    for (Node var : vars) {
                        this.visit(t, var.getFirstChild(), var);
                    }
                    break;
                }
                case NAME: {
                    Var nameDeclaration;
                    String qName;
                    if (NodeUtil.isNameDeclaration(n.getParent()) && n.getParent().hasMoreThanOneChild() || (qName = n.getQualifiedName()) == null || (nameDeclaration = t.getScope().getVar(qName)) == null || nameDeclaration.getNode() == null || nameDeclaration.getNode().getInputId() != n.getInputId()) break;
                    this.maybeUpdateName(t, n, nameDeclaration);
                    break;
                }
                case STRING_KEY: {
                    Var nameDeclaration;
                    if (n.hasChildren() || n.isQuotedString() || n.getParent().getParent().isDestructuringLhs() || (nameDeclaration = t.getScope().getVar(n.getString())) == null) break;
                    String importedName = this.getModuleImportName(t, nameDeclaration.getNode());
                    if (!nameDeclaration.isGlobal() && importedName == null) break;
                    Node value = IR.name(n.getString()).useSourceInfoFrom(n);
                    n.addChildToBack(value);
                    this.maybeUpdateName(t, value, nameDeclaration);
                    break;
                }
            }
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String requireName = require.getSecondChild().getString();
            ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(requireName, require.getSourceFileName(), require.getLineno(), require.getCharno());
            if (modulePath == null) {
                return;
            }
            String moduleName = modulePath.toModuleName();
            Node moduleRef = IR.name(moduleName).srcref(require);
            parent.replaceChild(require, moduleRef);
            t.reportCodeChange();
        }

        private void visitExport(NodeTraversal t, Node export) {
            Node root = ProcessCommonJSModules.this.getBaseQualifiedNameNode(export);
            Node rValue = NodeUtil.getRValueOfLValue(root);
            if (root.matchesQualifiedName("module.exports") && rValue != null && rValue.isObjectLit() && root.getParent().isAssign() && root.getParent().getParent().isExprResult()) {
                this.expandObjectLitAssignment(t, root);
                return;
            }
            ModuleLoader.ModulePath modulePath = t.getInput().getPath();
            String moduleName = modulePath.toModuleName();
            Var rValueVar = null;
            if (rValue != null && rValue.isQualifiedName() && (rValueVar = t.getScope().getVar(rValue.getQualifiedName())) == null && root == export && (rValueVar = t.getScope().getVar(moduleName)) != null && rValueVar.getNode() == root) {
                rValueVar = null;
            }
            if (root.getParent().isAssign() && root.getNext() != null && (root.getNext().isName() || root.getNext().isGetProp()) && root.getParent().getParent().isExprResult() && rValueVar != null) {
                root.getParent().getParent().detach();
                t.reportCodeChange();
                return;
            }
            Node updatedExport = NodeUtil.newName(ProcessCommonJSModules.this.compiler, moduleName, export, export.getQualifiedName());
            if (root.matchesQualifiedName("module.exports") && rValue != null && t.getScope().getVar("module.exports") == null && root.getParent().isAssign()) {
                if (root.getParent().getParent().isExprResult()) {
                    Node parent = root.getParent();
                    Node var = IR.var(updatedExport, rValue.detach()).useSourceInfoFrom(root.getParent());
                    parent.getParent().replaceWith(var);
                } else if (root.getNext() != null && root.getNext().isName() && rValueVar.isGlobal()) {
                    root.getParent().replaceWith(updatedExport);
                } else {
                    export.replaceWith(updatedExport);
                }
            } else {
                export.replaceWith(updatedExport);
            }
            t.reportCodeChange();
        }

        private void expandObjectLitAssignment(NodeTraversal t, Node export) {
            Preconditions.checkState((boolean)export.getParent().isAssign());
            Node insertionRef = export.getParent().getParent();
            Preconditions.checkState((boolean)insertionRef.isExprResult());
            Node insertionParent = insertionRef.getParent();
            Preconditions.checkNotNull((Object)insertionParent);
            Node rValue = NodeUtil.getRValueOfLValue(export);
            for (Node key = rValue.getFirstChild(); key != null; key = key.getNext()) {
                Node lhs = key.isQuotedString() ? IR.getelem(export.cloneTree(), IR.string(key.getString())) : IR.getprop(export.cloneTree(), IR.string(key.getString()));
                Node value = null;
                if (key.isStringKey()) {
                    value = key.hasChildren() ? key.removeFirstChild() : IR.name(key.getString());
                } else if (key.isMemberFunctionDef()) {
                    value = key.getFirstChild().detach();
                }
                Node expr = null;
                if (!key.isGetterDef()) {
                    expr = IR.exprResult(IR.assign(lhs, value)).useSourceInfoIfMissingFromForTree(key);
                    insertionParent.addChildAfter(expr, insertionRef);
                    this.visitExport(t, lhs.getFirstChild());
                } else {
                    Node getter = key.detach();
                    String moduleName = t.getInput().getPath().toModuleName();
                    Node moduleObj = t.getScope().getVar(moduleName).getNode().getFirstChild();
                    moduleObj.addChildToBack(getter);
                }
                if (expr == null || expr.getParent() == null) continue;
                insertionRef = expr;
            }
            export.getParent().getParent().detach();
        }

        private void maybeUpdateName(NodeTraversal t, Node n, Var var) {
            Preconditions.checkNotNull((Object)var);
            Preconditions.checkState((n.isName() || n.isGetProp() ? 1 : 0) != 0);
            Preconditions.checkState((n.getParent() != null ? 1 : 0) != 0);
            String importedModuleName = this.getModuleImportName(t, var.getNode());
            String originalName = n.getOriginalQualifiedName();
            if (importedModuleName != null && n != var.getNode()) {
                this.updateNameReference(t, n, originalName, importedModuleName, false);
            } else if (this.allowFullRewrite) {
                String exportedName = this.getExportedName(t, n, var);
                if ((n != var.getNode() || n.getParent().isClass()) && exportedName == null) {
                    if (n.getParent().isClass() && n.getParent().getFirstChild() == n) {
                        this.rewrittenClassExpressions.add(n.getParent());
                    }
                    return;
                }
                if (importedModuleName == null && exportedName != null && !exportedName.equals(originalName)) {
                    this.updateNameReference(t, n, originalName, exportedName, true);
                } else if (var.isGlobal()) {
                    ModuleLoader.ModulePath modulePath = t.getInput().getPath();
                    String currentModuleName = modulePath.toModuleName();
                    if (currentModuleName.equals(originalName)) {
                        return;
                    }
                    if (ProcessCommonJSModules.EXPORTS.equals(originalName)) {
                        return;
                    }
                    if (((ProcessCommonJSModules)ProcessCommonJSModules.this).compiler.getOptions().exportTestFunctions && currentModuleName.startsWith("test")) {
                        return;
                    }
                    String newName = originalName + "$$" + currentModuleName;
                    this.updateNameReference(t, n, originalName, newName, false);
                }
            }
        }

        private void updateNameReference(NodeTraversal t, Node nameRef, String originalName, String newName, boolean requireFunctionExpressions) {
            Node parent = nameRef.getParent();
            Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)newName);
            boolean newNameIsQualified = newName.indexOf(46) >= 0;
            Var newNameDeclaration = t.getScope().getVar(newName);
            switch (parent.getToken()) {
                case CLASS: {
                    if (parent.getIndexOfChild(nameRef) == 0 && (newNameIsQualified || requireFunctionExpressions)) {
                        this.rewrittenClassExpressions.add(parent);
                        Node newNameRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        Node grandparent = parent.getParent();
                        Node expr = !newNameIsQualified && newNameDeclaration == null ? IR.let(newNameRef, IR.nullNode()).useSourceInfoIfMissingFromForTree(nameRef) : IR.exprResult(IR.assign(newNameRef, IR.nullNode())).useSourceInfoIfMissingFromForTree(nameRef);
                        grandparent.replaceChild(parent, expr);
                        if (expr.isLet()) {
                            expr.getFirstChild().replaceChild(expr.getFirstFirstChild(), parent);
                            break;
                        }
                        expr.getFirstChild().replaceChild(expr.getFirstChild().getSecondChild(), parent);
                        break;
                    }
                    if (parent.getIndexOfChild(nameRef) == 1) {
                        Node newNameRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        parent.replaceChild(nameRef, newNameRef);
                        break;
                    }
                    nameRef.setString(newName);
                    nameRef.setOriginalName(originalName);
                    break;
                }
                case FUNCTION: {
                    if (newNameIsQualified || requireFunctionExpressions) {
                        Node newNameRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        Node grandparent = parent.getParent();
                        nameRef.setString("");
                        Node expr = !newNameIsQualified && newNameDeclaration == null ? IR.var(newNameRef, IR.nullNode()).useSourceInfoIfMissingFromForTree(nameRef) : IR.exprResult(IR.assign(newNameRef, IR.nullNode())).useSourceInfoIfMissingFromForTree(nameRef);
                        grandparent.replaceChild(parent, expr);
                        if (expr.isVar()) {
                            expr.getFirstChild().replaceChild(expr.getFirstFirstChild(), parent);
                        } else {
                            expr.getFirstChild().replaceChild(expr.getFirstChild().getSecondChild(), parent);
                        }
                        this.functionsToHoist.add(expr);
                        break;
                    }
                    nameRef.setString(newName);
                    nameRef.setOriginalName(originalName);
                    break;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    if (newNameIsQualified) {
                        Node getProp = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        JSDocInfo info = parent.getJSDocInfo();
                        parent.setJSDocInfo(null);
                        if (nameRef.hasChildren()) {
                            Node assign = IR.assign(getProp, nameRef.removeFirstChild());
                            assign.setJSDocInfo(info);
                            Node expr = IR.exprResult(assign).useSourceInfoIfMissingFromForTree(nameRef);
                            parent.replaceWith(expr);
                            break;
                        }
                        getProp.setJSDocInfo(info);
                        parent.replaceWith(IR.exprResult(getProp).useSourceInfoFrom(getProp));
                        break;
                    }
                    if (newNameDeclaration != null) {
                        if (!nameRef.hasChildren()) {
                            parent.detachFromParent();
                            break;
                        }
                        Node name = NodeUtil.newName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        Node assign = IR.assign(name, nameRef.removeFirstChild());
                        JSDocInfo info = parent.getJSDocInfo();
                        if (info != null) {
                            parent.setJSDocInfo(null);
                            assign.setJSDocInfo(info);
                        }
                        parent.replaceWith(IR.exprResult(assign).useSourceInfoFromForTree(nameRef));
                        break;
                    }
                    nameRef.setString(newName);
                    nameRef.setOriginalName(originalName);
                    break;
                }
                default: {
                    Node name = newNameIsQualified ? NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName) : NodeUtil.newName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                    JSDocInfo info = nameRef.getJSDocInfo();
                    if (info != null) {
                        nameRef.setJSDocInfo(null);
                        name.setJSDocInfo(info);
                    }
                    parent.replaceChild(nameRef, name);
                    if (!nameRef.hasChildren()) break;
                    name.addChildrenToFront(nameRef.removeChildren());
                    break;
                }
            }
            t.reportCodeChange();
        }

        private String getExportedName(NodeTraversal t, Node n, Var var) {
            if (var == null || var.getNode().getInputId() != n.getInputId()) {
                return n.getQualifiedName();
            }
            String moduleName = t.getInput().getPath().toModuleName();
            for (ExportInfo export : this.exports) {
                String exportPrefix;
                Node exportBase = ProcessCommonJSModules.this.getBaseQualifiedNameNode(export.node);
                Node exportRValue = NodeUtil.getRValueOfLValue(exportBase);
                if (exportRValue == null) continue;
                Node exportedName = this.getExportedNameNode(export);
                if (exportRValue == n || (NodeUtil.isClassExpression(exportRValue) || NodeUtil.isFunctionExpression(exportRValue)) && exportedName == n) {
                    return null;
                }
                String exportBaseQName = exportBase.getQualifiedName();
                if (exportRValue.isObjectLit()) {
                    Node key;
                    if (!"module.exports".equals(exportBaseQName)) {
                        return n.getQualifiedName();
                    }
                    boolean keyIsExport = false;
                    for (key = exportRValue.getFirstChild(); key != null; key = key.getNext()) {
                        Var valVar;
                        if (!key.isStringKey() || key.isQuotedString() || !NodeUtil.isValidPropertyName(ProcessCommonJSModules.this.compiler.getOptions().getLanguageIn().toFeatureSet(), key.getString())) continue;
                        if (key.hasChildren()) {
                            if (!key.getFirstChild().isQualifiedName()) continue;
                            if (key.getFirstChild() == n) {
                                return null;
                            }
                            valVar = t.getScope().getVar(key.getFirstChild().getQualifiedName());
                            if (valVar == null || valVar.getNameNode() != var.getNameNode()) continue;
                            keyIsExport = true;
                            break;
                        }
                        if (key == n) {
                            return null;
                        }
                        valVar = t.getScope().getVar(key.getString());
                        if (valVar == null || valVar.getNameNode() != var.getNameNode()) continue;
                        keyIsExport = true;
                        break;
                    }
                    if (key == null || !keyIsExport) continue;
                    return moduleName + "." + key.getString();
                }
                if (var.getNameNode() != exportedName) continue;
                String string = exportPrefix = exportBaseQName.startsWith(ProcessCommonJSModules.MODULE) ? "module.exports" : ProcessCommonJSModules.EXPORTS;
                if (exportBaseQName.length() == exportPrefix.length()) {
                    return moduleName;
                }
                return moduleName + exportBaseQName.substring(exportPrefix.length());
            }
            return n.getQualifiedName();
        }

        private Node getExportedNameNode(ExportInfo info) {
            Node qNameBase = ProcessCommonJSModules.this.getBaseQualifiedNameNode(info.node);
            Node rValue = NodeUtil.getRValueOfLValue(qNameBase);
            if (rValue == null) {
                return null;
            }
            if (NodeUtil.isFunctionExpression(rValue) || NodeUtil.isClassExpression(rValue)) {
                return rValue.getFirstChild();
            }
            Var var = info.scope.getVar(rValue.getQualifiedName());
            if (var == null) {
                return null;
            }
            return var.getNameNode();
        }

        private String getModuleImportName(NodeTraversal t, Node n) {
            String moduleName;
            Node rValue = null;
            String propSuffix = "";
            if (n.isStringKey() && n.getParent().isObjectPattern() && n.getParent().getParent().isDestructuringLhs()) {
                rValue = n.getParent().getNext();
                propSuffix = "." + n.getString();
            } else if (n.getParent() != null) {
                rValue = NodeUtil.getRValueOfLValue(n);
            }
            if (rValue == null) {
                return null;
            }
            if (rValue.isCall()) {
                if (rValue.hasTwoChildren() && rValue.getFirstChild().matchesQualifiedName("require") && rValue.getSecondChild().isString() && t.getScope().getVar(rValue.getFirstChild().getQualifiedName()) == null) {
                    String requireName = rValue.getSecondChild().getString();
                    ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(requireName, n.getSourceFileName(), n.getLineno(), n.getCharno());
                    if (modulePath == null) {
                        return null;
                    }
                    return modulePath.toModuleName() + propSuffix;
                }
                return null;
            }
            if (rValue.isGetProp() && (moduleName = this.getModuleImportName(t, rValue.getFirstChild())) != null) {
                return moduleName + "." + n.getSecondChild().getString() + propSuffix;
            }
            return null;
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                int endIndex;
                String name = typeNode.getString();
                if (ModuleLoader.isPathIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(moduleName, typeNode.getSourceFileName(), typeNode.getLineno(), typeNode.getCharno());
                    if (modulePath == null) {
                        return;
                    }
                    String globalModuleName = modulePath.toModuleName();
                    typeNode.setString(localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else {
                    String baseName;
                    boolean wasRewritten = false;
                    endIndex = -1;
                    while (endIndex < name.length()) {
                        String exportedName;
                        String suffix;
                        if ((endIndex = name.indexOf(46, endIndex + 1)) == -1) {
                            endIndex = name.length();
                        }
                        baseName = name.substring(0, endIndex);
                        String string = suffix = endIndex < name.length() ? name.substring(endIndex) : "";
                        Var typeDeclaration = t.getScope().getVar(baseName);
                        if (typeDeclaration == null || typeDeclaration.getNode().getInputId() != typeNode.getInputId()) continue;
                        String importedModuleName = this.getModuleImportName(t, typeDeclaration.getNode());
                        if (importedModuleName != null) {
                            typeNode.setString(importedModuleName + suffix);
                            typeNode.setOriginalName(name);
                            wasRewritten = true;
                            break;
                        }
                        if (!this.allowFullRewrite || (exportedName = this.getExportedName(t, typeNode, typeDeclaration)) == null || exportedName.equals(name)) continue;
                        typeNode.setString(exportedName + suffix);
                        typeNode.setOriginalName(name);
                        wasRewritten = true;
                        break;
                    }
                    if (!wasRewritten && this.allowFullRewrite) {
                        endIndex = name.indexOf(46);
                        if (endIndex == -1) {
                            endIndex = name.length();
                        }
                        baseName = name.substring(0, endIndex);
                        Var typeDeclaration = t.getScope().getVar(baseName);
                        if (typeDeclaration != null && typeDeclaration.isGlobal()) {
                            String moduleName = t.getInput().getPath().toModuleName();
                            String newName = baseName + "$$" + moduleName;
                            if (endIndex < name.length()) {
                                newName = newName + name.substring(endIndex);
                            }
                            typeNode.setString(newName);
                            typeNode.setOriginalName(name);
                        }
                    }
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }

        private List<Node> splitMultipleDeclarations(Node var) {
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(var));
            ArrayList<Node> vars = new ArrayList<Node>();
            while (var.getSecondChild() != null) {
                Node newVar = new Node(var.getToken(), var.removeFirstChild());
                newVar.useSourceInfoFrom(var);
                var.getParent().addChildBefore(newVar, var);
                vars.add(newVar);
            }
            vars.add(var);
            return vars;
        }
    }

    class FindImportsAndExports
    implements NodeTraversal.Callback {
        private boolean hasGoogProvideOrModule = false;
        private Node script = null;
        List<UmdPattern> umdPatterns = new ArrayList<UmdPattern>();
        List<ExportInfo> moduleExports = new ArrayList<ExportInfo>();
        List<ExportInfo> exports = new ArrayList<ExportInfo>();
        Set<String> imports = new HashSet<String>();
        List<JSError> errors = new ArrayList<JSError>();

        FindImportsAndExports() {
        }

        boolean isCommonJsModule() {
            return (this.exports.size() > 0 || this.moduleExports.size() > 0) && !this.hasGoogProvideOrModule;
        }

        public List<ExportInfo> getModuleExports() {
            return ImmutableList.copyOf(this.moduleExports);
        }

        public List<ExportInfo> getExports() {
            return ImmutableList.copyOf(this.exports);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isScript()) {
                Preconditions.checkState((this.script == null ? 1 : 0) != 0);
                this.script = n;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node ifAncestor;
            Var v;
            Node maybeGetProp;
            if (t.inGlobalScope() && (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) && n.isExprResult() && (maybeGetProp = n.getFirstFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                this.hasGoogProvideOrModule = true;
            }
            if (n.isCall() && n.getFirstChild().matchesQualifiedName("require.ensure")) {
                this.visitRequireEnsureCall(t, n);
            }
            if (n.matchesQualifiedName("module.exports")) {
                v = t.getScope().getVar(ProcessCommonJSModules.MODULE);
                if (v == null) {
                    this.moduleExports.add(new ExportInfo(n, t.getScope()));
                    Node ifAncestor2 = this.getOutermostIfAncestor(parent);
                    if (ifAncestor2 != null && !ProcessCommonJSModules.umdPatternsContains(this.umdPatterns, ifAncestor2)) {
                        this.umdPatterns.add(new UmdPattern(ifAncestor2, ifAncestor2.getSecondChild()));
                    }
                }
            } else if (n.matchesQualifiedName("define.amd") && (ifAncestor = this.getOutermostIfAncestor(parent)) != null && !ProcessCommonJSModules.umdPatternsContains(this.umdPatterns, ifAncestor)) {
                this.umdPatterns.add(new UmdPattern(ifAncestor, ifAncestor.getChildAtIndex(2)));
            }
            if (n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString()) && ((v = t.getScope().getVar(ProcessCommonJSModules.EXPORTS)) == null || v.isGlobal())) {
                Node qNameRoot = ProcessCommonJSModules.this.getBaseQualifiedNameNode(n);
                if (qNameRoot != null && qNameRoot.matchesQualifiedName(ProcessCommonJSModules.EXPORTS) && NodeUtil.isLValue(qNameRoot)) {
                    if (!this.hasGoogProvideOrModule) {
                        this.errors.add(t.makeError(qNameRoot, SUSPICIOUS_EXPORTS_ASSIGNMENT, new String[0]));
                    }
                } else {
                    this.exports.add(new ExportInfo(n, t.getScope()));
                    Node ifAncestor3 = this.getOutermostIfAncestor(parent);
                    if (ifAncestor3 != null && !ProcessCommonJSModules.umdPatternsContains(this.umdPatterns, ifAncestor3)) {
                        this.umdPatterns.add(new UmdPattern(ifAncestor3, ifAncestor3.getSecondChild()));
                    }
                }
            }
            if (n.isCall() && n.hasTwoChildren() && n.getFirstChild().matchesQualifiedName("require") && n.getSecondChild().isString()) {
                this.visitRequireCall(t, n, parent);
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String requireName = require.getSecondChild().getString();
            ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(requireName, require.getSourceFileName(), require.getLineno(), require.getCharno());
            if (modulePath == null) {
                return;
            }
            String moduleName = modulePath.toModuleName();
            if (!NodeUtil.isExpressionResultUsed(require) && parent.isExprResult() && NodeUtil.isStatementBlock(parent.getParent())) {
                parent.detach();
            }
            this.imports.add(moduleName);
        }

        private void visitRequireEnsureCall(NodeTraversal t, Node call) {
            if (call.getChildCount() != 3) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(call, UNKNOWN_REQUIRE_ENSURE, "Expected the function to have 2 arguments but instead found {0}", "" + call.getChildCount()));
                return;
            }
            Node dependencies = call.getSecondChild();
            if (!dependencies.isArrayLit()) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(dependencies, UNKNOWN_REQUIRE_ENSURE, "The first argument must be an array literal of string literals."));
                return;
            }
            for (Node dep : dependencies.children()) {
                if (dep.isString()) continue;
                ProcessCommonJSModules.this.compiler.report(t.makeError(dep, UNKNOWN_REQUIRE_ENSURE, "The first argument must be an array literal of string literals."));
                return;
            }
            Node callback = dependencies.getNext();
            if (!(callback.isFunction() && callback.getSecondChild().getChildCount() == 1 && callback.getSecondChild().getFirstChild().isName() && "require".equals(callback.getSecondChild().getFirstChild().getString()))) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(callback, UNKNOWN_REQUIRE_ENSURE, "The second argument must be a function whose first argument is named \"require\"."));
                return;
            }
            callback.detach();
            callback.getSecondChild().removeChildren();
            call.removeChildren();
            call.putBooleanProp((byte)50, true);
            call.addChildToFront(callback);
            t.reportCodeChange();
        }

        void reportModuleErrors() {
            for (JSError error : this.errors) {
                ProcessCommonJSModules.this.compiler.report(error);
            }
        }

        void initializeModule() {
            CompilerInput ci = ProcessCommonJSModules.this.compiler.getInput(this.script.getInputId());
            ModuleLoader.ModulePath modulePath = ci.getPath();
            if (modulePath == null) {
                return;
            }
            String moduleName = modulePath.toModuleName();
            int directAssignmentsAtTopLevel = 0;
            int directAssignments = 0;
            for (ExportInfo export : this.moduleExports) {
                Node rValue;
                Node base;
                if (NodeUtil.getEnclosingScript(export.node) == null || (base = ProcessCommonJSModules.this.getBaseQualifiedNameNode(export.node)) != export.node || !export.node.getParent().isAssign() || (rValue = NodeUtil.getRValueOfLValue(export.node)) != null && rValue.isObjectLit()) continue;
                ++directAssignments;
                if (!export.node.getParent().getParent().isExprResult() || !NodeUtil.isTopLevel(export.node.getParent().getParent().getParent())) continue;
                ++directAssignmentsAtTopLevel;
            }
            if (directAssignmentsAtTopLevel > 1 || directAssignmentsAtTopLevel == 0 && directAssignments > 0 || directAssignments == 0) {
                int totalExportStatements = this.moduleExports.size() + this.exports.size();
                Node initModule = IR.var(IR.name(moduleName));
                if (directAssignments < totalExportStatements) {
                    initModule.getFirstChild().addChildToFront(IR.objectlit(new Node[0]));
                    if (directAssignments == 0) {
                        JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                        builder.recordConstancy();
                        initModule.setJSDocInfo(builder.build());
                    }
                }
                initModule.useSourceInfoIfMissingFromForTree(this.script);
                this.script.addChildToFront(initModule);
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(this.script);
            }
        }

        void addGoogProvideAndRequires() {
            CompilerInput ci = ProcessCommonJSModules.this.compiler.getInput(this.script.getInputId());
            ModuleLoader.ModulePath modulePath = ci.getPath();
            if (modulePath == null) {
                return;
            }
            String moduleName = modulePath.toModuleName();
            for (String importName : this.imports) {
                if (ProcessCommonJSModules.this.reportDependencies) {
                    ci.addRequire(importName);
                }
                this.script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(importName))).useSourceInfoIfMissingFromForTree(this.script));
            }
            if (this.isCommonJsModule()) {
                if (ProcessCommonJSModules.this.reportDependencies) {
                    ci.addProvide(moduleName);
                }
                this.script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("provide")), IR.string(moduleName))).useSourceInfoIfMissingFromForTree(this.script));
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(this.script);
            } else if (this.imports.size() > 0) {
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(this.script);
            }
        }

        private Node getOutermostIfAncestor(Node n) {
            if (n == null || NodeUtil.isTopLevel(n) || n.isFunction()) {
                return null;
            }
            Node parent = n.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.isIf() && parent.getFirstChild() == n) {
                Node outerIf = this.getOutermostIfAncestor(parent);
                if (outerIf != null) {
                    return outerIf;
                }
                return parent;
            }
            return this.getOutermostIfAncestor(parent);
        }

        void replaceUmdPatterns() {
            for (UmdPattern umdPattern : this.umdPatterns) {
                Node parent = umdPattern.ifRoot.getParent();
                Node newNode = umdPattern.activeBranch;
                if (newNode == null) {
                    parent.removeChild(umdPattern.ifRoot);
                    ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(parent);
                    return;
                }
                if (umdPattern.activeBranch.isNormalBlock() && umdPattern.activeBranch.getChildCount() == 1) {
                    newNode = umdPattern.activeBranch.getFirstChild();
                    umdPattern.activeBranch.detachChildren();
                } else {
                    umdPattern.ifRoot.detachChildren();
                }
                parent.replaceChild(umdPattern.ifRoot, newNode);
                Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(parent);
                if (changeScope == null) continue;
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }

    static class ExportInfo {
        final Node node;
        final Scope scope;

        ExportInfo(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
        }
    }

    static class UmdPattern {
        final Node ifRoot;
        final Node activeBranch;

        UmdPattern(Node ifRoot, Node activeBranch) {
            this.ifRoot = ifRoot;
            this.activeBranch = activeBranch;
        }
    }
}

