/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.SourceFile;
import java.util.HashMap;
import java.util.Map;

public class PersistentInputStore {
    Map<String, CacheEntry> store = new HashMap<String, CacheEntry>();

    public void addInput(String path, String digest) {
        if (this.store.containsKey(path)) {
            CacheEntry dep = this.store.get(path);
            if (!dep.digest.equals(digest)) {
                dep.digest = digest;
                dep.input = null;
            }
        } else {
            this.store.put(path, new CacheEntry(digest));
        }
    }

    public CompilerInput getCachedCompilerInput(SourceFile source) {
        if (this.store.containsKey(source.getOriginalPath())) {
            CacheEntry cacheEntry = this.store.get(source.getOriginalPath());
            if (cacheEntry.input == null) {
                cacheEntry.input = new CompilerInput(source);
            }
            return cacheEntry.input;
        }
        return new CompilerInput(source);
    }

    private static class CacheEntry {
        String digest;
        CompilerInput input;

        CacheEntry(String digest) {
            this.digest = digest;
        }
    }
}

