/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionUseSiteFinder;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class OptimizeParameters
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;

    OptimizeParameters(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node externs, Node root) {
        Preconditions.checkState((this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED ? 1 : 0) != 0);
        DefinitionUseSiteFinder definitionFinder = new DefinitionUseSiteFinder(this.compiler);
        definitionFinder.process(externs, root);
        this.process(externs, root, definitionFinder);
    }

    @Override
    public void process(Node externs, Node root, DefinitionUseSiteFinder definitionFinder) {
        ArrayList definitionSites = Lists.newArrayList(definitionFinder.getDefinitionSites());
        for (DefinitionSite definitionSite : definitionSites) {
            if (!OptimizeParameters.canChangeSignature(definitionSite, definitionFinder)) continue;
            this.tryEliminateConstantArgs(definitionSite, definitionFinder);
            this.tryEliminateOptionalArgs(definitionSite, definitionFinder);
        }
    }

    private static boolean canChangeSignature(DefinitionSite definitionSite, DefinitionUseSiteFinder definitionFinder) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        if (definitionSite.inExterns) {
            return false;
        }
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction() || NodeUtil.isVarArgsFunction(rValue)) {
            return false;
        }
        Node lValue = definition.getLValue();
        if (lValue.matchesQualifiedName("$jscomp.inherits") || lValue.matchesQualifiedName("$jscomp$inherits")) {
            return false;
        }
        if (!NodeUtil.isSimpleFunctionDeclaration(rValue)) {
            return false;
        }
        if (!definitionFinder.canModifyDefinition(definition)) {
            return false;
        }
        Collection<UseSite> useSites = definitionFinder.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        for (UseSite site : useSites) {
            if (!DefinitionUseSiteFinder.isCallOrNewSite(site)) {
                return false;
            }
            Node nameNode = site.node;
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = definitionFinder.getDefinitionsReferencedAt(nameNode);
            if (singleSiteDefinitions.size() > 1) {
                return false;
            }
            Preconditions.checkState((!singleSiteDefinitions.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)singleSiteDefinitions.contains(definition));
        }
        return true;
    }

    private void tryEliminateOptionalArgs(DefinitionSite definitionSite, DefinitionUseSiteFinder definitionFinder) {
        int maxArgs = -1;
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Collection<UseSite> useSites = definitionFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Preconditions.checkState((boolean)DefinitionUseSiteFinder.isCallOrNewSite(site));
            Node call = site.node.getParent();
            int numArgs = call.getChildCount() - 1;
            if (numArgs <= maxArgs) continue;
            maxArgs = numArgs;
        }
        this.eliminateParamsAfter(definition.getRValue(), maxArgs, definitionFinder);
    }

    private void tryEliminateConstantArgs(DefinitionSite definitionSite, DefinitionUseSiteFinder definitionFinder) {
        Node call;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        boolean firstCall = true;
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Collection<UseSite> useSites = definitionFinder.getUseSites(definition);
        boolean continueLooking = false;
        for (UseSite site : useSites) {
            Preconditions.checkState((boolean)DefinitionUseSiteFinder.isCallOrNewSite(site));
            call = site.node.getParent();
            Node cur = call.getFirstChild();
            if (firstCall) {
                continueLooking = this.buildParameterList(parameters, cur, site.scope);
                firstCall = false;
            } else {
                continueLooking = this.findFixedParameters(parameters, cur);
            }
            if (continueLooking) continue;
            return;
        }
        continueLooking = OptimizeParameters.adjustForSideEffects(parameters);
        if (!continueLooking) {
            return;
        }
        for (UseSite site : useSites) {
            Preconditions.checkState((boolean)DefinitionUseSiteFinder.isCallOrNewSite(site));
            call = site.node.getParent();
            this.optimizeCallSite(definitionFinder, parameters, call);
        }
        Node function = definition.getRValue();
        if (function.isFunction()) {
            this.optimizeFunctionDefinition(parameters, function, definitionFinder);
        }
    }

    private static boolean adjustForSideEffects(List<Parameter> parameters) {
        boolean anyMovable = false;
        boolean seenUnmovableSideEffects = false;
        boolean seenUnmoveableSideEfffected = false;
        for (int i = parameters.size() - 1; i >= 0; --i) {
            Parameter current = parameters.get(i);
            if (current.shouldRemove && (seenUnmovableSideEffects && current.canBeSideEffected() || seenUnmoveableSideEfffected && current.hasSideEffects())) {
                current.shouldRemove = false;
            }
            if (current.shouldRemove) {
                anyMovable = true;
                continue;
            }
            if (current.canBeSideEffected) {
                seenUnmoveableSideEfffected = true;
            }
            if (!current.hasSideEffects) continue;
            seenUnmovableSideEffects = true;
        }
        return anyMovable;
    }

    private boolean findFixedParameters(List<Parameter> parameters, Node cur) {
        boolean anyMovable = false;
        int index = 0;
        while ((cur = cur.getNext()) != null) {
            Parameter p;
            if (index >= parameters.size()) {
                p = new Parameter(cur, false);
                parameters.add(p);
            } else {
                p = parameters.get(index);
                if (p.shouldRemove()) {
                    Node value = p.getArg();
                    if (!cur.isEquivalentTo(value)) {
                        p.setShouldRemove(false);
                    } else {
                        anyMovable = true;
                    }
                }
            }
            this.setParameterSideEffectInfo(p, cur);
            ++index;
        }
        while (index < parameters.size()) {
            parameters.get(index).setShouldRemove(false);
            ++index;
        }
        return anyMovable;
    }

    private boolean buildParameterList(List<Parameter> parameters, Node cur, Scope s) {
        boolean anyMovable = false;
        while ((cur = cur.getNext()) != null) {
            boolean movable = OptimizeParameters.isMovableValue(cur, s);
            Parameter p = new Parameter(cur, movable);
            this.setParameterSideEffectInfo(p, cur);
            parameters.add(p);
            if (!movable) continue;
            anyMovable = true;
        }
        return anyMovable;
    }

    private void setParameterSideEffectInfo(Parameter p, Node value) {
        if (!p.hasSideEffects()) {
            p.setHasSideEffects(NodeUtil.mayHaveSideEffects(value, this.compiler));
        }
        if (!p.canBeSideEffected()) {
            p.setCanBeSideEffected(NodeUtil.canBeSideEffected(value));
        }
    }

    private static boolean isMovableValue(Node n, Scope s) {
        switch (n.getToken()) {
            case THIS: {
                return false;
            }
            case FUNCTION: {
                return false;
            }
            case NAME: {
                if (n.getString().equals("arguments")) {
                    return false;
                }
                Var v = s.getVar(n.getString());
                if (v == null || !v.isLocal() && !v.nameNode.getParent().isCatch()) break;
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (OptimizeParameters.isMovableValue(c, s)) continue;
            return false;
        }
        return true;
    }

    private void optimizeFunctionDefinition(List<Parameter> parameters, Node function, DefinitionUseSiteFinder definitionFinder) {
        for (int index = parameters.size() - 1; index >= 0; --index) {
            if (!parameters.get(index).shouldRemove()) continue;
            Node paramName = this.eliminateFunctionParamAt(function, index, definitionFinder);
            this.addVariableToFunction(function, paramName, parameters.get(index).getArg());
        }
    }

    private void optimizeCallSite(DefinitionUseSiteFinder definitionFinder, List<Parameter> parameters, Node call) {
        boolean mayMutateArgs = call.mayMutateArguments();
        boolean mayMutateGlobalsOrThrow = call.mayMutateGlobalStateOrThrow();
        for (int index = parameters.size() - 1; index >= 0; --index) {
            Parameter p = parameters.get(index);
            if (!p.shouldRemove()) continue;
            this.eliminateCallParamAt(definitionFinder, p, call, index);
            if (!mayMutateArgs || mayMutateGlobalsOrThrow || NodeUtil.isImmutableValue(p.getArg())) continue;
            mayMutateGlobalsOrThrow = true;
            call.setSideEffectFlags(new Node.SideEffectFlags(call.getSideEffectFlags()).setMutatesGlobalState());
        }
    }

    private void addVariableToFunction(Node function, Node varName, Node value) {
        Preconditions.checkArgument((boolean)function.isFunction(), (String)"Expected function, got: %s", (Object)function);
        Node block = NodeUtil.getFunctionBody(function);
        Preconditions.checkState((value.getParent() == null ? 1 : 0) != 0);
        Node stmt = varName != null ? NodeUtil.newVarNode(varName.getString(), value) : IR.exprResult(value).useSourceInfoFrom(value);
        block.addChildToFront(stmt);
        this.compiler.reportChangeToEnclosingScope(stmt);
    }

    private boolean eliminateParamsAfter(Node function, int argIndex, DefinitionUseSiteFinder definitionFinder) {
        Node formalArgPtr;
        for (formalArgPtr = function.getSecondChild().getFirstChild(); argIndex != 0 && formalArgPtr != null; formalArgPtr = formalArgPtr.getNext(), --argIndex) {
        }
        return this.eliminateParamsAfter(function, formalArgPtr, definitionFinder);
    }

    private boolean eliminateParamsAfter(Node fnNode, Node argNode, DefinitionUseSiteFinder definitionFinder) {
        if (argNode != null) {
            this.eliminateParamsAfter(fnNode, argNode.getNext(), definitionFinder);
            this.compiler.reportChangeToEnclosingScope(argNode);
            argNode.detach();
            Node var = IR.var(argNode).useSourceInfoIfMissingFrom(argNode);
            fnNode.getLastChild().addChildToFront(var);
            this.compiler.reportChangeToEnclosingScope(var);
            return true;
        }
        return false;
    }

    private Node eliminateFunctionParamAt(Node function, int argIndex, DefinitionUseSiteFinder definitionFinder) {
        Preconditions.checkArgument((boolean)function.isFunction(), (Object)"Node must be a function.");
        Node formalArgPtr = NodeUtil.getArgumentForFunction(function, argIndex);
        if (formalArgPtr != null) {
            this.compiler.reportChangeToEnclosingScope(formalArgPtr);
            definitionFinder.removeReferences(formalArgPtr);
            function.getSecondChild().removeChild(formalArgPtr);
        }
        return formalArgPtr;
    }

    private Node eliminateCallParamAt(DefinitionUseSiteFinder definitionFinder, Parameter p, Node call, int argIndex) {
        Preconditions.checkArgument((boolean)NodeUtil.isCallOrNew(call), (Object)"Node must be a call or new.");
        Node formalArgPtr = NodeUtil.getArgumentForCallOrNew(call, argIndex);
        if (formalArgPtr != null) {
            this.compiler.reportChangeToEnclosingScope(formalArgPtr);
            if (p.getArg() != formalArgPtr) {
                definitionFinder.removeReferences(formalArgPtr);
            }
            call.removeChild(formalArgPtr);
        }
        return formalArgPtr;
    }

    private static class Parameter {
        private final Node arg;
        private boolean shouldRemove;
        private boolean hasSideEffects;
        private boolean canBeSideEffected;

        public Parameter(Node arg, boolean shouldRemove) {
            this.shouldRemove = shouldRemove;
            this.arg = arg;
        }

        public Node getArg() {
            return this.arg;
        }

        public boolean shouldRemove() {
            return this.shouldRemove;
        }

        public void setShouldRemove(boolean value) {
            this.shouldRemove = value;
        }

        public void setHasSideEffects(boolean hasSideEffects) {
            this.hasSideEffects = hasSideEffects;
        }

        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public void setCanBeSideEffected(boolean canBeSideEffected) {
            this.canBeSideEffected = canBeSideEffected;
        }

        public boolean canBeSideEffected() {
            return this.canBeSideEffected;
        }
    }
}

