/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstChangeProxy;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GatherSideEffectSubexpressionsCallback;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class NameAnalyzer
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<String, JsName> allNames = new HashMap<String, JsName>();
    private LinkedDirectedGraph<JsName, RefType> referenceGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final ListMultimap<Node, NameInformation> scopes = LinkedListMultimap.create();
    private static final String PROTOTYPE_SUBSTRING = ".prototype.";
    private static final int PROTOTYPE_SUBSTRING_LEN = ".prototype.".length();
    private static final int PROTOTYPE_SUFFIX_LEN = ".prototype".length();
    private static final String WINDOW = "window";
    private static final String FUNCTION = "Function";
    static final ImmutableSet<String> DEFAULT_GLOBAL_NAMES = ImmutableSet.of((Object)"window", (Object)"goog.global");
    private final boolean removeUnreferenced;
    private final String reportPath;
    private final Set<String> globalNames;
    private final AstChangeProxy changeProxy;
    private final Set<String> externalNames = new HashSet<String>();
    private final List<RefNode> refNodes = new ArrayList<RefNode>();
    private final Map<String, AliasSet> aliases = new HashMap<String, AliasSet>();
    static final DiagnosticType REPORT_PATH_IO_ERROR = DiagnosticType.error("JSC_REPORT_PATH_IO_ERROR", "Error writing compiler report to {0}:\n{1}");
    private static final Predicate<Node> NON_LOCAL_RESULT_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return !input.isCall();
        }
    };

    static Node getConsumingExpression(Node expr) {
        Node parent = expr.getParent();
        switch (parent.getToken()) {
            case OR: 
            case AND: 
            case CAST: {
                return NameAnalyzer.getConsumingExpression(parent);
            }
            case COMMA: 
            case HOOK: {
                return expr == parent.getFirstChild() ? parent : NameAnalyzer.getConsumingExpression(parent);
            }
        }
        return parent;
    }

    NameAnalyzer(AbstractCompiler compiler, boolean removeUnreferenced, String reportPath) {
        this.compiler = compiler;
        this.removeUnreferenced = removeUnreferenced;
        this.reportPath = reportPath;
        this.globalNames = DEFAULT_GLOBAL_NAMES;
        this.changeProxy = new AstChangeProxy(compiler);
    }

    static void createEmptyReport(AbstractCompiler compiler, String reportPath) {
        Preconditions.checkNotNull((Object)reportPath);
        try {
            Files.write((CharSequence)"", (File)new File(reportPath), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            compiler.report(JSError.make(REPORT_PATH_IO_ERROR, reportPath, e.getMessage()));
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, new ProcessExternals());
        NodeTraversal.traverseEs6(this.compiler, root, new FindDependencyScopes());
        NodeTraversal.traverseEs6(this.compiler, root, new HoistVariableAndFunctionDeclarations());
        NodeTraversal.traverseEs6(this.compiler, root, new FindDeclarationsAndSetters());
        NodeTraversal.traverseEs6(this.compiler, root, new FindReferences());
        this.referenceParentNames();
        this.referenceAliases();
        this.calculateReferences();
        if (this.reportPath != null) {
            try {
                Files.append((CharSequence)this.getHtmlReport(), (File)new File(this.reportPath), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.compiler.report(JSError.make(REPORT_PATH_IO_ERROR, this.reportPath, e.getMessage()));
            }
        }
        if (this.removeUnreferenced) {
            this.removeUnreferenced();
        }
    }

    private void recordAlias(String fromName, String toName) {
        this.recordReference(fromName, toName, RefType.REGULAR);
        AliasSet toNameAliasSet = this.aliases.get(toName);
        AliasSet fromNameAliasSet = this.aliases.get(fromName);
        AliasSet resultSet = null;
        if (toNameAliasSet == null && fromNameAliasSet == null) {
            resultSet = new AliasSet(toName, fromName);
        } else if (toNameAliasSet != null && fromNameAliasSet != null) {
            resultSet = toNameAliasSet;
            resultSet.names.addAll(fromNameAliasSet.names);
            for (String name : fromNameAliasSet.names) {
                this.aliases.put(name, resultSet);
            }
        } else if (toNameAliasSet != null) {
            resultSet = toNameAliasSet;
            resultSet.names.add(fromName);
        } else {
            resultSet = fromNameAliasSet;
            resultSet.names.add(toName);
        }
        this.aliases.put(fromName, resultSet);
        this.aliases.put(toName, resultSet);
    }

    private void recordReference(String fromName, String toName, RefType depType) {
        if (fromName.equals(toName)) {
            return;
        }
        JsName from = this.getName(fromName, true);
        JsName to = this.getName(toName, true);
        this.referenceGraph.connectIfNotConnectedInDirection(from, depType, to);
    }

    private void recordReference(DiGraph.DiGraphNode<JsName, RefType> from, DiGraph.DiGraphNode<JsName, RefType> to, RefType depType) {
        if (from == to) {
            return;
        }
        if (!this.referenceGraph.isConnectedInDirection((JsName)((Object)from), (Predicate<RefType>)Predicates.equalTo((Object)((Object)depType)), (JsName)((Object)to))) {
            this.referenceGraph.connect(from, depType, to);
        }
    }

    void removeUnreferenced() {
        RemoveListener listener = new RemoveListener();
        this.changeProxy.registerListener(listener);
        for (RefNode refNode : this.refNodes) {
            JsName name = refNode.name();
            if (name.referenced || name.externallyDefined) continue;
            refNode.remove();
        }
        this.changeProxy.unregisterListener(listener);
    }

    String getHtmlReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><style type=\"text/css\">body, td, p {font-family: Arial; font-size: 83%} ul {margin-top:2px; margin-left:0px; padding-left:1em;} li {margin-top:3px; margin-left:24px; padding-left:0px;padding-bottom: 4px}</style>");
        sb.append("OVERALL STATS<ul>");
        NameAnalyzer.appendListItem(sb, "Total Names: " + this.countOf(TriState.BOTH, TriState.BOTH));
        NameAnalyzer.appendListItem(sb, "Total Classes: " + this.countOf(TriState.TRUE, TriState.BOTH));
        NameAnalyzer.appendListItem(sb, "Total Static Functions: " + this.countOf(TriState.FALSE, TriState.BOTH));
        NameAnalyzer.appendListItem(sb, "Referenced Names: " + this.countOf(TriState.BOTH, TriState.TRUE));
        NameAnalyzer.appendListItem(sb, "Referenced Classes: " + this.countOf(TriState.TRUE, TriState.TRUE));
        NameAnalyzer.appendListItem(sb, "Referenced Functions: " + this.countOf(TriState.FALSE, TriState.TRUE));
        sb.append("</ul>");
        sb.append("ALL NAMES<ul>\n");
        for (JsName node : Ordering.natural().sortedCopy(this.allNames.values())) {
            sb.append("<li>").append(NameAnalyzer.nameAnchor(node.name)).append("<ul>");
            if (!node.prototypeNames.isEmpty()) {
                sb.append("<li>PROTOTYPES: ");
                Iterator<String> protoIter = node.prototypeNames.iterator();
                while (protoIter.hasNext()) {
                    sb.append(protoIter.next());
                    if (!protoIter.hasNext()) continue;
                    sb.append(", ");
                }
            }
            if (this.referenceGraph.hasNode(node)) {
                List<DiGraph.DiGraphEdge<JsName, RefType>> referencedBy;
                List<DiGraph.DiGraphEdge<JsName, RefType>> refersTo = this.referenceGraph.getOutEdges(node);
                if (!refersTo.isEmpty()) {
                    sb.append("<li>REFERS TO: ");
                    Iterator<DiGraph.DiGraphEdge<JsName, RefType>> toIter = refersTo.iterator();
                    while (toIter.hasNext()) {
                        sb.append(NameAnalyzer.nameLink(((JsName)toIter.next().getDestination().getValue()).name));
                        if (!toIter.hasNext()) continue;
                        sb.append(", ");
                    }
                }
                if (!(referencedBy = this.referenceGraph.getInEdges(node)).isEmpty()) {
                    sb.append("<li>REFERENCED BY: ");
                    Iterator<DiGraph.DiGraphEdge<JsName, RefType>> fromIter = refersTo.iterator();
                    while (fromIter.hasNext()) {
                        sb.append(NameAnalyzer.nameLink(((JsName)fromIter.next().getDestination().getValue()).name));
                        if (!fromIter.hasNext()) continue;
                        sb.append(", ");
                    }
                }
            }
            sb.append("</li>");
            sb.append("</ul></li>");
        }
        sb.append("</ul>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private static void appendListItem(StringBuilder sb, String text) {
        sb.append("<li>").append(text).append("</li>\n");
    }

    private static String nameLink(String name) {
        return "<a href=\"#" + name + "\">" + name + "</a>";
    }

    private static String nameAnchor(String name) {
        return "<a name=\"" + name + "\">" + name + "</a>";
    }

    private JsName getName(String name, boolean canCreate) {
        if (canCreate) {
            return this.createName(name);
        }
        return this.allNames.get(name);
    }

    private JsName createName(String name) {
        JsName jsn = this.allNames.get(name);
        if (jsn == null) {
            jsn = new JsName();
            jsn.name = name;
            this.allNames.put(name, jsn);
        }
        return jsn;
    }

    private void referenceAliases() {
        HashSet<AliasSet> sets = new HashSet<AliasSet>(this.aliases.values());
        for (AliasSet set : sets) {
            DiGraph.DiGraphNode<JsName, RefType> first = null;
            HashSet<DiGraph.DiGraphNode<JsName, RefType>> required = new HashSet<DiGraph.DiGraphNode<JsName, RefType>>();
            for (String string : set.names) {
                JsName name = this.getName(string, false);
                if (!name.hasWrittenDescendants && !name.hasInstanceOfReference) continue;
                DiGraph.DiGraphNode<JsName, RefType> node = this.getGraphNode(name);
                required.add(node);
                if (first != null) continue;
                first = node;
            }
            if (required.isEmpty()) continue;
            for (DiGraph.DiGraphNode diGraphNode : required) {
                this.recordReference(diGraphNode, first, RefType.REGULAR);
                this.recordReference(first, diGraphNode, RefType.REGULAR);
            }
            for (String string : set.names) {
                DiGraph.DiGraphNode<JsName, RefType> alias = this.getGraphNode(this.getName(string, false));
                this.recordReference(alias, first, RefType.REGULAR);
            }
        }
    }

    private DiGraph.DiGraphNode<JsName, RefType> getGraphNode(JsName name) {
        return this.referenceGraph.createDirectedGraphNode((Object)name);
    }

    private void referenceParentNames() {
        JsName[] allNamesCopy;
        for (JsName name : allNamesCopy = this.allNames.values().toArray(new JsName[0])) {
            String parentName;
            String curName = name.name;
            if (!curName.contains(".") || this.globalNames.contains(parentName = curName.substring(0, curName.lastIndexOf(46)))) continue;
            JsName parentJsName = this.getName(parentName, true);
            DiGraph.DiGraphNode<JsName, RefType> nameNode = this.getGraphNode(name);
            DiGraph.DiGraphNode<JsName, RefType> parentNode = this.getGraphNode(parentJsName);
            this.recordReference(nameNode, parentNode, RefType.REGULAR);
            this.recordReference(parentNode, nameNode, RefType.REGULAR);
        }
    }

    @Nullable
    private NameInformation createNameInformation(NodeTraversal t, Node n) {
        NameInformation nameInfo;
        Node parent = n.getParent();
        String name = "";
        Node rootNameNode = n;
        boolean bNameWasShortened = false;
        while (true) {
            if (NodeUtil.isGet(rootNameNode)) {
                Node prop = rootNameNode.getLastChild();
                if (rootNameNode.isGetProp()) {
                    name = "." + prop.getString() + name;
                } else {
                    bNameWasShortened = true;
                    name = "";
                }
                rootNameNode = rootNameNode.getFirstChild();
                continue;
            }
            if (NodeUtil.isObjectLitKey(rootNameNode)) {
                name = "." + rootNameNode.getString() + name;
                Node objLit = rootNameNode.getParent();
                Node objLitParent = objLit.getParent();
                if (objLitParent.isAssign()) {
                    rootNameNode = objLitParent.getFirstChild();
                    continue;
                }
                if (objLitParent.isName()) {
                    rootNameNode = objLitParent;
                    continue;
                }
                if (objLitParent.isStringKey()) {
                    rootNameNode = objLitParent;
                    continue;
                }
                return null;
            }
            if (!NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(rootNameNode)) break;
            Node target = rootNameNode.getSecondChild();
            if (!target.isQualifiedName()) {
                return null;
            }
            rootNameNode = target;
        }
        if (parent.isCall() && t.inGlobalHoistScope()) {
            CodingConvention convention = this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship classes = convention.getClassesDefinedByCall(parent);
            if (classes != null) {
                NameInformation nameInfo2 = new NameInformation(classes.subclassName);
                nameInfo2.onlyAffectsClassDef = true;
                nameInfo2.superclass = classes.superclassName;
                return nameInfo2;
            }
            String singletonGetterClass = convention.getSingletonGetterClassName(parent);
            if (singletonGetterClass != null) {
                NameInformation nameInfo3 = new NameInformation(singletonGetterClass);
                nameInfo3.onlyAffectsClassDef = true;
                return nameInfo3;
            }
        }
        if (parent.isClass() && n == parent.getFirstChild()) {
            Preconditions.checkState((boolean)n.isName());
            nameInfo = new NameInformation(n.getString());
            if (n.getNext().isName()) {
                nameInfo.superclass = n.getNext().getString();
                nameInfo.onlyAffectsClassDef = true;
            }
            return nameInfo;
        }
        switch (rootNameNode.getToken()) {
            case NAME: {
                if (!bNameWasShortened && n.isGetProp() && parent.isAssign() && "prototype".equals(n.getLastChild().getString())) {
                    if (this.createNameInformation(t, n.getFirstChild()) != null) {
                        name = rootNameNode.getString() + name;
                        name = name.substring(0, name.length() - PROTOTYPE_SUFFIX_LEN);
                        nameInfo = new NameInformation(name);
                        return nameInfo;
                    }
                    return null;
                }
                return this.createNameInformation(rootNameNode.getString() + name, t.getScope(), rootNameNode);
            }
            case THIS: {
                if (t.inGlobalHoistScope()) {
                    nameInfo = new NameInformation(name.indexOf(46) == 0 ? name.substring(1) : name);
                    nameInfo.isExternallyReferenceable = true;
                    return nameInfo;
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private NameInformation createNameInformation(String name, Scope scope, Node rootNameNode) {
        boolean isGlobalRef;
        String rootName = rootNameNode.getString();
        Var v = scope.getVar(rootName);
        boolean isExtern = v == null && this.externalNames.contains(rootName);
        boolean bl = isGlobalRef = v != null && v.isGlobal() || isExtern || rootName.equals(WINDOW);
        if (!isGlobalRef) {
            return null;
        }
        NameInformation nameInfo = new NameInformation(name);
        int idx = name.indexOf(PROTOTYPE_SUBSTRING);
        if (idx != -1) {
            nameInfo.isPrototype = true;
            nameInfo.prototypeClass = name.substring(0, idx);
            nameInfo.prototypeProperty = name.substring(idx + PROTOTYPE_SUBSTRING_LEN);
        }
        nameInfo.isExternallyReferenceable = isExtern || this.isExternallyReferenceable(scope, name);
        return nameInfo;
    }

    private boolean isExternallyReferenceable(Scope scope, String name) {
        if (this.compiler.getCodingConvention().isExported(name)) {
            return true;
        }
        if (scope.isLocal()) {
            return false;
        }
        for (String s : this.globalNames) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private List<NameInformation> getDependencyScope(Node n) {
        for (Node node : n.getAncestors()) {
            List refs = this.scopes.get((Object)node);
            if (refs.isEmpty()) continue;
            return refs;
        }
        return Collections.emptyList();
    }

    private List<NameInformation> getEnclosingFunctionDependencyScope(NodeTraversal t) {
        Node function = t.getEnclosingFunction();
        if (function == null) {
            return Collections.emptyList();
        }
        List refs = this.scopes.get((Object)function);
        if (!refs.isEmpty()) {
            return refs;
        }
        Node parent = function.getParent();
        if (parent != null) {
            while (parent.isHook()) {
                parent = parent.getParent();
            }
            if (parent.isName()) {
                return this.scopes.get((Object)parent);
            }
            if (parent.isAssign()) {
                return this.scopes.get((Object)parent);
            }
        }
        return Collections.emptyList();
    }

    private void calculateReferences() {
        JsName window = this.getName(WINDOW, true);
        window.referenced = true;
        JsName function = this.getName(FUNCTION, true);
        function.referenced = true;
        this.propagateReference(window, function);
    }

    private void propagateReference(JsName ... names) {
        ArrayDeque work = new ArrayDeque();
        for (JsName name : names) {
            work.push(this.referenceGraph.createDirectedGraphNode((Object)name));
        }
        while (!work.isEmpty()) {
            DiGraph.DiGraphNode source = (DiGraph.DiGraphNode)work.pop();
            List outEdges = source.getOutEdges();
            int len = outEdges.size();
            for (int i = 0; i < len; ++i) {
                DiGraph.DiGraphNode item = outEdges.get(i).getDestination();
                JsName destNode = (JsName)item.getValue();
                if (destNode.referenced) continue;
                destNode.referenced = true;
                work.push(item);
            }
        }
    }

    private int countOf(TriState isClass, TriState referenced) {
        int count = 0;
        for (JsName name : this.allNames.values()) {
            boolean referenceMatch;
            boolean nodeIsClass = !name.prototypeNames.isEmpty();
            boolean classMatch = isClass == TriState.BOTH || nodeIsClass && isClass == TriState.TRUE || !nodeIsClass && isClass == TriState.FALSE;
            boolean bl = referenceMatch = referenced == TriState.BOTH || name.referenced && referenced == TriState.TRUE || !name.referenced && referenced == TriState.FALSE;
            if (!classMatch || !referenceMatch || name.externallyDefined) continue;
            ++count;
        }
        return count;
    }

    private List<Node> getSideEffectNodes(Node n) {
        ArrayList<Node> subexpressions = new ArrayList<Node>();
        NodeTraversal.traverseEs6(this.compiler, n, new GatherSideEffectSubexpressionsCallback(this.compiler, new GatherSideEffectSubexpressionsCallback.GetReplacementSideEffectSubexpressions(this.compiler, subexpressions)));
        ArrayList<Node> replacements = new ArrayList<Node>(subexpressions.size());
        for (Node subexpression : subexpressions) {
            replacements.add(NodeUtil.newExpr(subexpression));
        }
        return replacements;
    }

    private void replaceWithRhs(Node parent, Node n) {
        if (NameAnalyzer.valueConsumedByParent(n, parent)) {
            List<Node> replacements = NameAnalyzer.getRhsSubexpressions(n);
            ArrayList<Node> newReplacements = new ArrayList<Node>();
            for (int i = 0; i < replacements.size() - 1; ++i) {
                newReplacements.addAll(this.getSideEffectNodes(replacements.get(i)));
            }
            Node valueExpr = (Node)Iterables.getLast(replacements);
            valueExpr.detach();
            newReplacements.add(valueExpr);
            this.changeProxy.replaceWith(parent, n, NameAnalyzer.collapseReplacements(newReplacements));
        } else if (n.isAssign() && !parent.isVanillaFor()) {
            Node replacement = n.getLastChild();
            replacement.detach();
            this.changeProxy.replaceWith(parent, n, replacement);
        } else {
            this.replaceTopLevelExpressionWithRhs(parent, n);
        }
    }

    private void replaceTopLevelExpressionWithRhs(Node parent, Node n) {
        switch (parent.getToken()) {
            case BLOCK: 
            case ROOT: 
            case SCRIPT: 
            case FOR: 
            case FOR_IN: 
            case LABEL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parent node type in replaceWithRhs " + (Object)((Object)parent.getToken()));
            }
        }
        switch (n.getToken()) {
            case VAR: 
            case LET: 
            case CONST: 
            case CLASS: 
            case FUNCTION: 
            case EXPR_RESULT: {
                break;
            }
            case ASSIGN: {
                Preconditions.checkArgument((boolean)parent.isVanillaFor(), (String)"Unsupported assignment in replaceWithRhs. parent: %s", (Object)parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in replaceWithRhs " + (Object)((Object)n.getToken()));
            }
        }
        ArrayList<Node> replacements = new ArrayList<Node>();
        for (Node rhs : NameAnalyzer.getRhsSubexpressions(n)) {
            replacements.addAll(this.getSideEffectNodes(rhs));
        }
        if (parent.isVanillaFor() || parent.isForIn()) {
            if (replacements.isEmpty()) {
                replacements.add(IR.empty());
            } else {
                Node expr = NameAnalyzer.collapseReplacements(replacements);
                replacements.clear();
                replacements.add(expr);
            }
        }
        this.changeProxy.replaceWith(parent, n, replacements);
    }

    private static boolean valueConsumedByParent(Node n, Node parent) {
        if (NodeUtil.isAssignmentOp(parent)) {
            return parent.getLastChild() == n;
        }
        switch (parent.getToken()) {
            case NAME: 
            case RETURN: {
                return true;
            }
            case OR: 
            case AND: 
            case HOOK: 
            case IF: 
            case WHILE: {
                return parent.getFirstChild() == n;
            }
            case FOR: 
            case FOR_IN: {
                return parent.getSecondChild() == n;
            }
            case DO: {
                return parent.getLastChild() == n;
            }
        }
        return false;
    }

    private static Node collapseReplacements(List<Node> replacements) {
        Node expr = null;
        for (Node rep : replacements) {
            if (rep.isExprResult()) {
                rep = rep.getFirstChild();
                rep.detach();
            }
            if (expr == null) {
                expr = rep;
                continue;
            }
            expr = IR.comma(expr, rep);
        }
        return expr;
    }

    private static List<Node> getRhsSubexpressions(Node n) {
        switch (n.getToken()) {
            case EXPR_RESULT: {
                return NameAnalyzer.getRhsSubexpressions(n.getFirstChild());
            }
            case CLASS: 
            case FUNCTION: {
                return ImmutableList.of();
            }
            case CALL: {
                Preconditions.checkState((boolean)NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(n));
                return ImmutableList.of((Object)n.getLastChild());
            }
            case NAME: {
                Node rhs = n.getFirstChild();
                if (rhs != null) {
                    return ImmutableList.of((Object)rhs);
                }
                return ImmutableList.of();
            }
            case ASSIGN: 
            case DESTRUCTURING_LHS: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                return ImmutableList.of((Object)lhs, (Object)rhs);
            }
            case VAR: 
            case LET: 
            case CONST: {
                ImmutableList.Builder nodes = ImmutableList.builder();
                for (Node child : n.children()) {
                    nodes.addAll(NameAnalyzer.getRhsSubexpressions(child));
                }
                return nodes.build();
            }
        }
        throw new IllegalArgumentException("AstChangeProxy::getRhs " + n);
    }

    private static boolean isAnalyzableObjectDefinePropertiesDefinition(Node n) {
        return NodeUtil.isObjectDefinePropertiesDefinition(n) && n.getParent().isExprResult() && n.getFirstChild().getNext().isQualifiedName() && n.getLastChild().isObjectLit();
    }

    private static enum TriState {
        TRUE,
        FALSE,
        BOTH;

    }

    private class RemoveListener
    implements AstChangeProxy.ChangeListener {
        private RemoveListener() {
        }

        @Override
        public void nodeRemoved(Node n, Node parent) {
            NameAnalyzer.this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private class FindReferences
    implements NodeTraversal.Callback {
        Set<Node> nodesToKeep = new HashSet<Node>();

        FindReferences() {
        }

        private boolean isInterestingNode(Node n) {
            switch (n.getToken()) {
                case NAME: 
                case GETPROP: 
                case GETELEM: {
                    return true;
                }
            }
            return false;
        }

        private void addAllChildren(Node n) {
            if (this.isInterestingNode(n)) {
                this.nodesToKeep.add(n);
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.addAllChildren(child);
            }
        }

        private void addSimplifiedChildren(Node n) {
            NodeTraversal.traverseEs6(NameAnalyzer.this.compiler, n, new GatherSideEffectSubexpressionsCallback(NameAnalyzer.this.compiler, new NodeAccumulator()));
        }

        private void addSimplifiedExpression(Node n, Node parent) {
            if (NodeUtil.isNameDeclaration(parent)) {
                Node value = n.getFirstChild();
                if (value != null) {
                    this.addSimplifiedChildren(value);
                }
            } else if (n.isAssign() && (parent.isExprResult() || parent.isVanillaFor() || parent.isReturn())) {
                for (Node child : n.children()) {
                    this.addSimplifiedChildren(child);
                }
            } else if (NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(n)) {
                this.addSimplifiedChildren(n.getLastChild());
            } else if (n.isCall() && parent.isExprResult()) {
                this.addSimplifiedChildren(n);
            } else {
                this.addAllChildren(n);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (parent == null) {
                return true;
            }
            if (n.isVanillaFor()) {
                Node decl = n.getFirstChild();
                Node pred = decl.getNext();
                Node step = pred.getNext();
                this.addSimplifiedExpression(decl, n);
                this.addSimplifiedExpression(pred, n);
                this.addSimplifiedExpression(step, n);
            } else if (n.isForIn()) {
                Node decl = n.getFirstChild();
                Node iter = decl.getNext();
                this.addAllChildren(decl);
                this.addAllChildren(iter);
            }
            if (NodeUtil.isNameDeclaration(parent) || parent.isExprResult() || parent.isReturn() || parent.isThrow()) {
                this.addSimplifiedExpression(n, parent);
            }
            if ((parent.isIf() || parent.isWhile() || parent.isWith() || parent.isSwitch() || parent.isCase()) && parent.getFirstChild() == n) {
                this.addAllChildren(n);
            }
            if (parent.isDo() && parent.getLastChild() == n) {
                this.addAllChildren(n);
            }
            if (parent.isDestructuringLhs() && n.isCall()) {
                this.addAllChildren(n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            List referers;
            boolean isInstanceOfCheck;
            if (!(n.isName() || NodeUtil.isGet(n) && !parent.isGetProp())) {
                return;
            }
            NameInformation nameInfo = NameAnalyzer.this.createNameInformation(t, n);
            if (nameInfo == null) {
                return;
            }
            if (nameInfo.onlyAffectsClassDef) {
                if (nameInfo.superclass != null) {
                    NameAnalyzer.this.recordReference(nameInfo.name, nameInfo.superclass, RefType.INHERITANCE);
                }
                if (n.isQualifiedName()) {
                    String nodeName = n.getQualifiedName();
                    NameAnalyzer.this.recordReference(nameInfo.name, nodeName, RefType.REGULAR);
                }
                return;
            }
            boolean bl = isInstanceOfCheck = parent.isInstanceOf() && parent.getLastChild() == n;
            if (isInstanceOfCheck) {
                JsName checkedClass = NameAnalyzer.this.getName(nameInfo.name, true);
                if (checkedClass.hasSetterReference && !nameInfo.isExternallyReferenceable && n.isQualifiedName()) {
                    NameAnalyzer.this.refNodes.add(new InstanceOfCheckNode(checkedClass, n));
                    checkedClass.hasInstanceOfReference = true;
                    return;
                }
            }
            if ((referers = NameAnalyzer.this.getDependencyScope(n)).isEmpty()) {
                this.maybeRecordReferenceOrAlias(t, n, parent, nameInfo, null);
            } else {
                for (NameInformation referring : referers) {
                    this.maybeRecordReferenceOrAlias(t, n, parent, nameInfo, referring);
                }
                this.recordAliases(referers);
            }
        }

        private void maybeRecordReferenceOrAlias(NodeTraversal t, Node n, Node parent, NameInformation nameInfo, @Nullable NameInformation referring) {
            block7: {
                String name;
                block10: {
                    String referringName;
                    block8: {
                        block9: {
                            referringName = "";
                            if (referring != null) {
                                referringName = referring.isPrototype ? referring.prototypeClass : referring.name;
                            }
                            name = nameInfo.name;
                            if (this.maybeHiddenAlias(n)) {
                                NameAnalyzer.this.recordAlias(name, NameAnalyzer.WINDOW);
                            }
                            if (nameInfo.isExternallyReferenceable) {
                                NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, name, RefType.REGULAR);
                                this.maybeRecordAlias(name, n, referring, referringName);
                                return;
                            }
                            if (NodeUtil.isNameDeclOrSimpleAssignLhs(n, parent)) {
                                if (referring != null) {
                                    NameAnalyzer.this.recordReference(referringName, name, RefType.REGULAR);
                                }
                                return;
                            }
                            if (!this.nodesToKeep.contains(n)) break block8;
                            List functionScopes = NameAnalyzer.this.getEnclosingFunctionDependencyScope(t);
                            if (functionScopes.isEmpty()) break block9;
                            for (NameInformation functionScope : functionScopes) {
                                NameAnalyzer.this.recordReference(functionScope.name, name, RefType.REGULAR);
                            }
                            break block7;
                        }
                        NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, name, RefType.REGULAR);
                        if (referring == null) break block7;
                        this.maybeRecordAlias(name, n, referring, referringName);
                        break block7;
                    }
                    if (referring == null) break block10;
                    if (this.maybeRecordAlias(name, n, referring, referringName)) break block7;
                    RefType depType = referring.onlyAffectsClassDef ? RefType.INHERITANCE : RefType.REGULAR;
                    NameAnalyzer.this.recordReference(referringName, name, depType);
                    break block7;
                }
                for (Node ancestor : n.getAncestors()) {
                    if (!NodeUtil.isAssignmentOp(ancestor) && !ancestor.isFunction()) continue;
                    NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, name, RefType.REGULAR);
                    break;
                }
            }
        }

        private void recordAliases(List<NameInformation> referers) {
            int size = referers.size();
            for (int i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    NameAnalyzer.this.recordAlias(referers.get((int)i).name, referers.get((int)j).name);
                    NameAnalyzer.this.recordAlias(referers.get((int)j).name, referers.get((int)i).name);
                }
            }
        }

        private boolean maybeHiddenAlias(Node n) {
            Node parent = n.getParent();
            if (NodeUtil.isNameDeclOrSimpleAssignLhs(n, parent)) {
                Node rhs = parent.isVar() ? n.getFirstChild() : parent.getLastChild();
                return rhs != null && !NodeUtil.evaluatesToLocalValue(rhs, (Predicate<Node>)NON_LOCAL_RESULT_PREDICATE);
            }
            return false;
        }

        private boolean maybeRecordAlias(String name, Node n, @Nullable NameInformation referring, String referringName) {
            boolean isPrototypePropAssignment;
            Node consumer = NameAnalyzer.getConsumingExpression(n);
            boolean bl = isPrototypePropAssignment = consumer.isAssign() && NodeUtil.isPrototypeProperty(consumer.getFirstChild());
            if ((consumer.isName() || consumer.isAssign()) && !isPrototypePropAssignment && referring != null && NameAnalyzer.this.scopes.containsEntry((Object)consumer, (Object)referring)) {
                NameAnalyzer.this.recordAlias(referringName, name);
                return true;
            }
            return false;
        }

        private class NodeAccumulator
        implements GatherSideEffectSubexpressionsCallback.SideEffectAccumulator {
            private NodeAccumulator() {
            }

            @Override
            public boolean classDefiningCallsHaveSideEffects() {
                return false;
            }

            @Override
            public void keepSubTree(Node original) {
                FindReferences.this.addAllChildren(original);
            }

            @Override
            public void keepSimplifiedShortCircuitExpression(Node original) {
                Node condition = original.getFirstChild();
                Node thenBranch = condition.getNext();
                FindReferences.this.addAllChildren(condition);
                FindReferences.this.addSimplifiedChildren(thenBranch);
            }

            @Override
            public void keepSimplifiedHookExpression(Node hook, boolean thenHasSideEffects, boolean elseHasSideEffects) {
                Node condition = hook.getFirstChild();
                Node thenBranch = condition.getNext();
                Node elseBranch = thenBranch.getNext();
                FindReferences.this.addAllChildren(condition);
                if (thenHasSideEffects) {
                    FindReferences.this.addSimplifiedChildren(thenBranch);
                }
                if (elseHasSideEffects) {
                    FindReferences.this.addSimplifiedChildren(elseBranch);
                }
            }
        }
    }

    private class FindDeclarationsAndSetters
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindDeclarationsAndSetters() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            NameInformation ns;
            Node nameNode;
            if (t.inGlobalHoistScope()) {
                Object ns2;
                if (n.isName() && (t.inGlobalScope() && NodeUtil.isNameDeclaration(parent) || parent.isVar())) {
                    ns2 = NameAnalyzer.this.createNameInformation(t, n);
                    Preconditions.checkNotNull((Object)ns2, (String)"createNameInformation returned null for: %s", (Object)n);
                    this.recordSet(((NameInformation)ns2).name, n);
                } else if (NodeUtil.isNameDeclaration(parent) && n.isDestructuringLhs()) {
                    for (Node child : NodeUtil.getLhsNodesOfDeclaration(n)) {
                        if (child.getParent().isComputedProp()) continue;
                        Preconditions.checkState((boolean)child.isName());
                        NameInformation ns3 = NameAnalyzer.this.createNameInformation(t, child);
                        Preconditions.checkNotNull((Object)ns3, (String)"createNameInformation returned null for: %s", (Object)n);
                        this.recordSet(ns3.name, child);
                    }
                } else if (t.inGlobalScope() && (NodeUtil.isFunctionDeclaration(n) || NodeUtil.isClassDeclaration(n))) {
                    nameNode = n.getFirstChild();
                    ns = NameAnalyzer.this.createNameInformation(t, nameNode);
                    if (ns != null) {
                        JsName nameInfo = NameAnalyzer.this.getName(nameNode.getString(), true);
                        this.recordSet(nameInfo.name, nameNode);
                    }
                } else if (NodeUtil.isObjectLitKey(n) && (ns2 = NameAnalyzer.this.createNameInformation(t, n)) != null) {
                    this.recordSet(((NameInformation)ns2).name, n);
                }
            }
            if (n.isAssign() || NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(n)) {
                nameNode = n.isAssign() ? n.getFirstChild() : n;
                ns = NameAnalyzer.this.createNameInformation(t, nameNode);
                if (ns != null) {
                    if (ns.isPrototype) {
                        this.recordPrototypeSet(ns.prototypeClass, ns.prototypeProperty, n);
                    } else {
                        this.recordSet(ns.name, nameNode);
                    }
                }
            } else if (n.isCall() && (ns = NameAnalyzer.this.createNameInformation(t, nameNode = n.getFirstChild())) != null && ns.onlyAffectsClassDef) {
                JsName name = NameAnalyzer.this.getName(ns.name, true);
                NameAnalyzer.this.refNodes.add(new ClassDefiningFunctionNode(name, n));
            }
        }

        private void recordSet(String name, Node node) {
            JsName jsn = NameAnalyzer.this.getName(name, true);
            JsNameRefNode nameRefNode = new JsNameRefNode(jsn, node);
            NameAnalyzer.this.refNodes.add(nameRefNode);
            jsn.hasSetterReference = true;
            if (node.isGetElem() || NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(node)) {
                this.recordWriteOnProperties(name);
            } else if (name.indexOf(46) != -1) {
                this.recordWriteOnProperties(name.substring(0, name.lastIndexOf(46)));
            }
        }

        private void recordPrototypeSet(String className, String prototypeProperty, Node node) {
            JsName name = NameAnalyzer.this.getName(className, true);
            name.prototypeNames.add(prototypeProperty);
            NameAnalyzer.this.refNodes.add(new PrototypeSetNode(name, node));
            this.recordWriteOnProperties(className);
        }

        private void recordWriteOnProperties(String parentName) {
            while (true) {
                JsName parent = NameAnalyzer.this.getName(parentName, true);
                if (parent.hasWrittenDescendants) {
                    return;
                }
                parent.hasWrittenDescendants = true;
                if (parentName.indexOf(46) == -1) {
                    return;
                }
                parentName = parentName.substring(0, parentName.lastIndexOf(46));
            }
        }
    }

    private class HoistVariableAndFunctionDeclarations
    extends NodeTraversal.AbstractShallowCallback {
        private HoistVariableAndFunctionDeclarations() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && parent.isVar()) {
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, n);
                Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)n);
                NameAnalyzer.this.createName(ns.name);
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                Node nameNode = n.getFirstChild();
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, nameNode);
                Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)nameNode);
                NameAnalyzer.this.createName(nameNode.getString());
            }
        }
    }

    private class FindDependencyScopes
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindDependencyScopes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!t.inGlobalHoistScope()) {
                return;
            }
            if (n.isAssign()) {
                this.recordAssignment(t, n, n);
                if (!NodeUtil.isImmutableResult(n.getLastChild())) {
                    this.recordConsumers(t, n, n);
                }
            } else if (n.isName() && (t.inGlobalScope() && NodeUtil.isNameDeclaration(parent) || parent.isVar())) {
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, n);
                Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)n);
                this.recordDepScope(n, ns);
            } else if (NodeUtil.isFunctionDeclaration(n) && t.inGlobalScope()) {
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, n.getFirstChild());
                Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)n.getFirstChild());
                this.recordDepScope(n, ns);
            } else if (NodeUtil.isExprCall(n)) {
                Node callNode = n.getFirstChild();
                Node nameNode = callNode.getFirstChild();
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, nameNode);
                if (ns != null && ns.onlyAffectsClassDef) {
                    this.recordDepScope(n, ns);
                }
            } else if (NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(n)) {
                Node targetObject = n.getSecondChild();
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, targetObject);
                Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)targetObject);
                this.recordDepScope(n, ns);
            } else if (n.isDestructuringLhs()) {
                for (Node child : NodeUtil.getLhsNodesOfDeclaration(n)) {
                    if (child.getParent().isComputedProp()) continue;
                    Preconditions.checkState((boolean)child.isName());
                    NameInformation ns = NameAnalyzer.this.createNameInformation(t, child);
                    Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)n);
                    this.recordDepScope(child, ns);
                }
            }
        }

        private void recordConsumers(NodeTraversal t, Node n, Node recordNode) {
            Node parent = n.getParent();
            switch (parent.getToken()) {
                case ASSIGN: {
                    if (n == parent.getLastChild()) {
                        this.recordAssignment(t, parent, recordNode);
                    }
                    this.recordConsumers(t, parent, recordNode);
                    break;
                }
                case NAME: {
                    NameInformation ns = NameAnalyzer.this.createNameInformation(t, parent);
                    Preconditions.checkNotNull((Object)ns, (String)"createNameInformation returned null for: %s", (Object)parent);
                    this.recordDepScope(recordNode, ns);
                    break;
                }
                case OR: {
                    this.recordConsumers(t, parent, recordNode);
                    break;
                }
                case AND: 
                case COMMA: 
                case HOOK: {
                    if (n == parent.getFirstChild()) break;
                    this.recordConsumers(t, parent, recordNode);
                    break;
                }
            }
        }

        private void recordAssignment(NodeTraversal t, Node n, Node recordNode) {
            Node nameNode = n.getFirstChild();
            Node parent = n.getParent();
            NameInformation ns = NameAnalyzer.this.createNameInformation(t, nameNode);
            if (ns != null) {
                if (parent.isVanillaFor()) {
                    if (parent.getSecondChild() != n) {
                        this.recordDepScope(recordNode, ns);
                    } else {
                        this.recordDepScope(nameNode, ns);
                    }
                } else if (!parent.isCall() || n != parent.getFirstChild()) {
                    this.recordDepScope(recordNode, ns);
                }
            }
        }

        private void recordDepScope(Node node, NameInformation name) {
            Preconditions.checkNotNull((Object)name);
            NameAnalyzer.this.scopes.put((Object)node, (Object)name);
        }
    }

    private class ProcessExternals
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternals() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            NameInformation ns = null;
            if (n.isName() && NodeUtil.isNameDeclaration(parent)) {
                ns = NameAnalyzer.this.createNameInformation(t, n);
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                ns = NameAnalyzer.this.createNameInformation(t, n.getFirstChild());
            }
            if (ns != null) {
                JsName jsName = NameAnalyzer.this.getName(ns.name, true);
                jsName.externallyDefined = true;
                NameAnalyzer.this.externalNames.add(ns.name);
            }
        }
    }

    private class InstanceOfCheckNode
    extends SpecialReferenceNode {
        InstanceOfCheckNode(JsName name, Node node) {
            super(name, node);
            Preconditions.checkState((boolean)node.isQualifiedName());
            Preconditions.checkState((boolean)this.getParent().isInstanceOf());
        }

        @Override
        public void remove() {
            NameAnalyzer.this.changeProxy.replaceWith(this.getGrandparent(), this.getParent(), IR.falseNode());
        }
    }

    private class ClassDefiningFunctionNode
    extends SpecialReferenceNode {
        ClassDefiningFunctionNode(JsName name, Node node) {
            super(name, node);
            Preconditions.checkState((boolean)node.isCall());
        }

        @Override
        public void remove() {
            Preconditions.checkState((boolean)this.node.isCall());
            Node parent = this.getParent();
            if (parent.isExprResult()) {
                NameAnalyzer.this.changeProxy.removeChild(this.getGrandparent(), parent);
            } else {
                NameAnalyzer.this.changeProxy.replaceWith(parent, this.node, IR.voidNode(IR.number(0.0)));
            }
        }
    }

    private static abstract class SpecialReferenceNode
    implements RefNode {
        JsName name;
        Node node;

        SpecialReferenceNode(JsName name, Node node) {
            this.name = name;
            this.node = node;
        }

        @Override
        public JsName name() {
            return this.name;
        }

        Node getParent() {
            return this.node.getParent();
        }

        Node getGrandparent() {
            return this.node.getGrandparent();
        }
    }

    private class PrototypeSetNode
    extends JsNameRefNode {
        PrototypeSetNode(JsName name, Node parent) {
            super(name, parent.getFirstChild());
            Preconditions.checkState((boolean)parent.isAssign());
        }

        @Override
        public void remove() {
            Node grandparent = this.parent.getParent();
            if (grandparent.isExprResult()) {
                NameAnalyzer.this.changeProxy.removeChild(grandparent.getParent(), grandparent);
            } else {
                NameAnalyzer.this.changeProxy.replaceWith(grandparent, this.parent, this.parent.getLastChild().detach());
            }
        }
    }

    private class JsNameRefNode
    implements RefNode {
        JsName name;
        Node parent;

        JsNameRefNode(JsName name, Node node) {
            this.name = name;
            this.parent = node.getParent();
        }

        @Override
        public JsName name() {
            return this.name;
        }

        @Override
        public void remove() {
            Node containingNode = this.parent.getParent();
            switch (this.parent.getToken()) {
                case VAR: 
                case LET: 
                case CONST: {
                    Preconditions.checkState((boolean)this.parent.hasOneChild());
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
                case CLASS: 
                case FUNCTION: {
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
                case ASSIGN: {
                    if (containingNode.isExprResult()) {
                        NameAnalyzer.this.replaceWithRhs(containingNode.getParent(), containingNode);
                        break;
                    }
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
                case STRING_KEY: {
                    Node grandparent = this.parent.getParent();
                    NodeUtil.removeChild(containingNode, this.parent);
                    NameAnalyzer.this.compiler.reportChangeToEnclosingScope(grandparent);
                    if (containingNode.hasChildren() || !containingNode.getParent().isDestructuringLhs()) break;
                    Node rhs = containingNode.getNext().detach();
                    Node newExp = new Node(Token.EXPR_RESULT, rhs);
                    containingNode.getGrandparent().replaceWith(newExp);
                    break;
                }
                case DEFAULT_VALUE: 
                case REST: 
                case ARRAY_PATTERN: 
                case OBJECTLIT: {
                    break;
                }
                case EXPR_RESULT: {
                    Preconditions.checkState((boolean)NameAnalyzer.isAnalyzableObjectDefinePropertiesDefinition(this.parent.getFirstChild()));
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parent node type in JsNameRefNode.remove: " + (Object)((Object)this.parent.getToken()));
                }
            }
        }
    }

    static interface RefNode {
        public JsName name();

        public void remove();
    }

    private static class JsName
    implements Comparable<JsName> {
        String name;
        List<String> prototypeNames = new ArrayList<String>();
        boolean externallyDefined = false;
        boolean referenced = false;
        boolean hasWrittenDescendants = false;
        boolean hasInstanceOfReference = false;
        boolean hasSetterReference = false;

        private JsName() {
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append(this.name);
            if (!this.prototypeNames.isEmpty()) {
                out.append(" (CLASS)\n");
                out.append(" - FUNCTIONS: ");
                Iterator<String> pIter = this.prototypeNames.iterator();
                while (pIter.hasNext()) {
                    out.append(pIter.next());
                    if (!pIter.hasNext()) continue;
                    out.append(", ");
                }
            }
            return out.toString();
        }

        @Override
        public int compareTo(JsName rhs) {
            return this.name.compareTo(rhs.name);
        }
    }

    private static class NameInformation {
        String name;
        boolean isExternallyReferenceable = false;
        boolean isPrototype = false;
        @Nullable
        String prototypeClass = null;
        @Nullable
        String prototypeProperty = null;
        @Nullable
        String superclass = null;
        boolean onlyAffectsClassDef = false;

        NameInformation(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public String toString() {
            return "NameInformation:" + this.name;
        }
    }

    private static enum RefType {
        REGULAR,
        INHERITANCE;

    }

    private static class AliasSet {
        Set<String> names = new HashSet<String>();

        AliasSet(String name1, String name2) {
            this.names.add(name1);
            this.names.add(name2);
        }
    }
}

