/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class NTIWorkset {
    private List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> ntiWorkset;

    static NTIWorkset create(ControlFlowGraph<Node> cfg) {
        NTIWorkset result = new NTIWorkset();
        result.ntiWorkset = Collections.unmodifiableList(new WorksetBuilder(cfg).build());
        return result;
    }

    Iterable<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> forward() {
        Preconditions.checkState((!this.ntiWorkset.isEmpty() ? 1 : 0) != 0);
        return this.ntiWorkset;
    }

    Iterable<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> backward() {
        Preconditions.checkState((!this.ntiWorkset.isEmpty() ? 1 : 0) != 0);
        return new Iterable<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

            @Override
            public Iterator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> iterator() {
                return new BackwardIterator();
            }
        };
    }

    private static class WorksetBuilder {
        private final ControlFlowGraph<Node> cfg;
        private List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> ntiWorkset;
        private Deque<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset;
        private Set<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> seen;

        WorksetBuilder(ControlFlowGraph<Node> cfg) {
            this.cfg = cfg;
        }

        List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> build() {
            this.ntiWorkset = new ArrayList<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>();
            this.workset = new ArrayDeque<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>();
            this.seen = new LinkedHashSet<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>();
            this.workset.push(this.cfg.getEntry());
            while (!this.workset.isEmpty()) {
                this.processGraphNode();
            }
            return this.ntiWorkset;
        }

        private void processGraphNode() {
            DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn = this.workset.pop();
            if (this.seen.contains(dn) || dn == this.cfg.getImplicitReturn()) {
                return;
            }
            switch (((Node)dn.getValue()).getToken()) {
                case DO: 
                case WHILE: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: {
                    List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> outEdges = dn.getOutEdges();
                    for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> outEdge : outEdges) {
                        if (outEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                        this.workset.push(outEdge.getDestination());
                    }
                    for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> outEdge : outEdges) {
                        if (outEdge.getValue() != ControlFlowGraph.Branch.ON_TRUE) continue;
                        this.workset.push(outEdge.getDestination());
                    }
                    this.seen.add(dn);
                    this.ntiWorkset.add(dn);
                    return;
                }
            }
            for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> inEdge : dn.getInEdges()) {
                DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> source = inEdge.getSource();
                Node sourceNode = (Node)source.getValue();
                if (!this.seen.contains(inEdge.getSource()) && !sourceNode.isDo()) {
                    return;
                }
                if (!NodeUtil.isLoopStructure(sourceNode) || sourceNode.isDo() || inEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                this.ntiWorkset.add(source);
            }
            this.seen.add(dn);
            if (this.cfg.getEntry() != dn) {
                this.ntiWorkset.add(dn);
            }
            Node n = (Node)dn.getValue();
            List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> succs = this.cfg.getDirectedSuccNodes(dn);
            for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> succ : succs) {
                this.workset.push(succ);
                if (succ != this.cfg.getImplicitReturn() || n.getNext() == null) continue;
                this.processDeadNode(n.getNext());
            }
            if (n.isTry()) {
                this.processDeadNode(n.getSecondChild());
            } else if (n.isBreak() || n.isContinue() || n.isThrow()) {
                this.processDeadNode(n.getNext());
            }
        }

        private void processDeadNode(Node maybeDeadNode) {
            if (maybeDeadNode == null) {
                return;
            }
            DiGraph.DiGraphNode cfgNode = this.cfg.getDirectedGraphNode(maybeDeadNode);
            if (cfgNode == null) {
                return;
            }
            if (this.cfg.getDirectedPredNodes(cfgNode).isEmpty()) {
                this.workset.push(cfgNode);
            }
        }
    }

    private class BackwardIterator
    implements Iterator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> {
        int i;

        private BackwardIterator() {
            this.i = NTIWorkset.this.ntiWorkset.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.i >= 0;
        }

        @Override
        public DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> next() {
            return (DiGraph.DiGraphNode)NTIWorkset.this.ntiWorkset.get(this.i--);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

