/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MaybeReachingVariableUse
extends DataFlowAnalysis<Node, ReachingUses> {
    private final Set<Var> escaped = new HashSet<Var>();
    private final Map<String, Var> allVarsInFn = new HashMap<String, Var>();
    private final List<Var> orderedVars = new LinkedList<Var>();

    MaybeReachingVariableUse(ControlFlowGraph<Node> cfg, Scope jsScope, AbstractCompiler compiler, Es6SyntacticScopeCreator scopeCreator) {
        super(cfg, new ReachingUsesJoinOp());
        MaybeReachingVariableUse.computeEscapedEs6(jsScope.getParent(), this.escaped, compiler, scopeCreator);
        NodeUtil.getAllVarsDeclaredInFunction(this.allVarsInFn, this.orderedVars, compiler, scopeCreator, jsScope.getParent());
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    ReachingUses createEntryLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses createInitialEstimateLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses flowThrough(Node n, ReachingUses input) {
        ReachingUses output = new ReachingUses(input);
        boolean conditional = this.hasExceptionHandler(n);
        this.computeMayUse(n, n, output, conditional);
        return output;
    }

    private boolean hasExceptionHandler(Node cfgNode) {
        List branchEdges = this.getCfg().getOutEdges(cfgNode);
        for (DiGraph.DiGraphEdge edge : branchEdges) {
            if (edge.getValue() != ControlFlowGraph.Branch.ON_EX) continue;
            return true;
        }
        return false;
    }

    private void computeMayUse(Node n, Node cfgNode, ReachingUses output, boolean conditional) {
        switch (n.getToken()) {
            case BLOCK: 
            case ROOT: 
            case FUNCTION: {
                return;
            }
            case NAME: {
                this.addToUseIfLocal(n.getString(), cfgNode, output);
                return;
            }
            case WHILE: 
            case DO: 
            case IF: {
                this.computeMayUse(NodeUtil.getConditionExpression(n), cfgNode, output, conditional);
                return;
            }
            case FOR: {
                this.computeMayUse(NodeUtil.getConditionExpression(n), cfgNode, output, conditional);
                return;
            }
            case FOR_IN: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (lhs.isVar()) {
                    lhs = lhs.getLastChild();
                }
                if (lhs.isName() && !conditional) {
                    this.removeFromUseIfLocal(lhs.getString(), output);
                }
                this.computeMayUse(rhs, cfgNode, output, conditional);
                return;
            }
            case AND: 
            case OR: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case HOOK: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case VAR: {
                Node varName = n.getFirstChild();
                Preconditions.checkState((boolean)n.hasChildren(), (String)"AST should be normalized", (Object)n);
                if (varName.hasChildren()) {
                    this.computeMayUse(varName.getFirstChild(), cfgNode, output, conditional);
                    if (!conditional) {
                        this.removeFromUseIfLocal(varName.getString(), output);
                    }
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
            Node name = n.getFirstChild();
            if (!conditional) {
                this.removeFromUseIfLocal(name.getString(), output);
            }
            if (!n.isAssign()) {
                this.addToUseIfLocal(name.getString(), cfgNode, output);
            }
            this.computeMayUse(name.getNext(), cfgNode, output, conditional);
        } else {
            for (Node c = n.getLastChild(); c != null; c = c.getPrevious()) {
                this.computeMayUse(c, cfgNode, output, conditional);
            }
        }
    }

    private void addToUseIfLocal(String name, Node node, ReachingUses use) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.mayUseMap.put((Object)var, (Object)node);
        }
    }

    private void removeFromUseIfLocal(String name, ReachingUses use) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.mayUseMap.removeAll((Object)var);
        }
    }

    Collection<Node> getUses(String name, Node defNode) {
        GraphNode n = this.getCfg().getNode(defNode);
        Preconditions.checkNotNull(n);
        DataFlowAnalysis.FlowState state = (DataFlowAnalysis.FlowState)n.getAnnotation();
        return ((ReachingUses)state.getOut()).mayUseMap.get((Object)this.allVarsInFn.get(name));
    }

    private static class ReachingUsesJoinOp
    implements JoinOp<ReachingUses> {
        private ReachingUsesJoinOp() {
        }

        public ReachingUses apply(List<ReachingUses> from) {
            ReachingUses result = new ReachingUses();
            for (ReachingUses uses : from) {
                result.mayUseMap.putAll(uses.mayUseMap);
            }
            return result;
        }
    }

    static final class ReachingUses
    implements LatticeElement {
        final Multimap<Var, Node> mayUseMap;

        public ReachingUses() {
            this.mayUseMap = HashMultimap.create();
        }

        public ReachingUses(ReachingUses other) {
            this.mayUseMap = MultimapBuilder.hashKeys().hashSetValues().build(other.mayUseMap);
        }

        public boolean equals(Object other) {
            return other instanceof ReachingUses && ((ReachingUses)other).mayUseMap.equals(this.mayUseMap);
        }

        public int hashCode() {
            return this.mayUseMap.hashCode();
        }
    }
}

