/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class J2clPass
implements CompilerPass {
    private static final String ALL_CLASS_FILE_NAMES = "*";
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;

    public J2clPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.safeNameIdSupplier = compiler.getUniqueNameIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        Set<String> defines = new ProcessDefines(this.compiler, null, true).collectDefines(externs, root).keySet();
        NodeTraversal.traverseEs6(this.compiler, root, new GetDefineRewriter(defines));
        this.inlineFunctionsInFile(root, "vmbootstrap/Arrays.impl.java.js", (Set<String>)ImmutableSet.of((Object)"$create", (Object)"$init", (Object)"$instanceIsOfType", (Object)"$castTo", (Object)"$stampType"), FunctionInjector.InliningMode.DIRECT);
        this.inlineFunctionsInFile(root, "vmbootstrap/Casts.impl.java.js", (Set<String>)ImmutableSet.of((Object)"$to"), FunctionInjector.InliningMode.DIRECT);
        this.inlineFunctionsInFile(root, ALL_CLASS_FILE_NAMES, (Set<String>)ImmutableSet.of((Object)"$markImplementor"), FunctionInjector.InliningMode.BLOCK);
        this.inlineFunctionsInFile(root, "nativebootstrap/Util.impl.java.js", (Set<String>)ImmutableSet.of((Object)"$setClassMetadata", (Object)"$setClassMetadataForInterface", (Object)"$setClassMetadataForEnum", (Object)"$setClassMetadataForPrimitive"), FunctionInjector.InliningMode.BLOCK);
        NodeTraversal.traverseEs6(this.compiler, root, new NativeAliasInliner());
    }

    private void inlineFunctionsInFile(Node root, String classFileName, Set<String> fnNamesToInline, FunctionInjector.InliningMode inliningMode) {
        new ClassStaticFunctionsInliner(root, classFileName, fnNamesToInline, inliningMode).run();
    }

    private class ClassStaticFunctionsInliner {
        private final String classFileName;
        private final Set<String> fnNamesToInline;
        private final FunctionInjector.InliningMode inliningMode;
        private final Map<String, Node> fnsToInlineByQualifiedName = new HashMap<String, Node>();
        private final FunctionInjector injector;
        private final Node root;

        private ClassStaticFunctionsInliner(Node root, String classFileName, Set<String> fnNamesToInline, FunctionInjector.InliningMode inliningMode) {
            this.root = root;
            this.classFileName = classFileName;
            this.fnNamesToInline = fnNamesToInline;
            this.inliningMode = inliningMode;
            this.injector = new FunctionInjector(J2clPass.this.compiler, (Supplier<String>)J2clPass.this.safeNameIdSupplier, true, true, true);
            this.injector.setKnownConstants(fnNamesToInline);
        }

        private void run() {
            NodeTraversal.traverseEs6(J2clPass.this.compiler, this.root, new FunctionDefsCollector());
            NodeTraversal.traverseEs6(J2clPass.this.compiler, this.root, new StaticCallInliner());
        }

        private class StaticCallInliner
        extends NodeTraversal.AbstractPostOrderCallback {
            private StaticCallInliner() {
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!n.isCall()) {
                    return;
                }
                Node qualifiedNameNode = n.getFirstChild();
                if (!qualifiedNameNode.isGetProp() || !qualifiedNameNode.isQualifiedName()) {
                    return;
                }
                String qualifiedFnName = qualifiedNameNode.getQualifiedName();
                String fnName = qualifiedNameNode.getLastChild().getString();
                Node fnImpl = (Node)ClassStaticFunctionsInliner.this.fnsToInlineByQualifiedName.get(qualifiedFnName);
                if (fnImpl == null) {
                    return;
                }
                Node inlinedCall = ClassStaticFunctionsInliner.this.injector.inline(new FunctionInjector.Reference(n, t.getScope(), t.getModule(), ClassStaticFunctionsInliner.this.inliningMode), fnName, fnImpl);
                t.getCompiler().reportChangeToEnclosingScope(inlinedCall);
            }
        }

        private class FunctionDefsCollector
        implements NodeTraversal.Callback {
            private FunctionDefsCollector() {
            }

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                return !n.isScript() || n.getSourceFileName().endsWith(ClassStaticFunctionsInliner.this.classFileName) || ClassStaticFunctionsInliner.this.classFileName.equals(J2clPass.ALL_CLASS_FILE_NAMES);
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!n.isAssign() || !n.getLastChild().isFunction()) {
                    return;
                }
                Node qualifiedNameNode = n.getFirstChild();
                if (!qualifiedNameNode.isGetProp() || !qualifiedNameNode.isQualifiedName()) {
                    return;
                }
                Node fnNode = n.getLastChild();
                String qualifiedFnName = qualifiedNameNode.getQualifiedName();
                String fnName = qualifiedNameNode.getLastChild().getString();
                if (ClassStaticFunctionsInliner.this.fnNamesToInline.contains(fnName)) {
                    ClassStaticFunctionsInliner.this.fnsToInlineByQualifiedName.put(qualifiedFnName, fnNode);
                }
            }
        }
    }

    private static class NativeAliasInliner
    extends NodeTraversal.AbstractPostOrderCallback {
        private NativeAliasInliner() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node declaringNode;
            if (n.isName() && !NodeUtil.isNameDeclaration(parent) && !parent.isAssign() && (declaringNode = this.getDeclaringNode(t, n)) != null && declaringNode.getFirstChild() != n && this.isNativeAlias(declaringNode)) {
                parent.replaceChild(n, declaringNode.getFirstFirstChild().cloneTree());
                t.reportCodeChange();
            }
        }

        private Node getDeclaringNode(NodeTraversal t, Node nameNode) {
            Var var = t.getScope().getVar(nameNode.getString());
            return var == null ? null : var.getParentNode();
        }

        private boolean isNativeAlias(Node n) {
            return NodeUtil.isNameDeclaration(n) && n.getParent().isScript() && n.getJSDocInfo() != null && n.getJSDocInfo().isConstructor() && n.getFirstFirstChild() != null && n.getFirstFirstChild().isGetProp() && n.getFirstFirstChild().getQualifiedName().matches("window.[A-Z][A-Za-z]+");
        }
    }

    private class GetDefineRewriter
    extends NodeTraversal.AbstractPostOrderCallback {
        private Set<String> defines;

        GetDefineRewriter(Set<String> defines) {
            this.defines = defines;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isUtilGetDefineCall(n)) {
                this.substituteUtilGetDefine(t, n);
            }
        }

        private void substituteUtilGetDefine(NodeTraversal t, Node callNode) {
            Node firstExpr = callNode.getSecondChild();
            Node secondExpr = callNode.getLastChild();
            if (secondExpr != firstExpr) {
                secondExpr.detach();
            } else {
                secondExpr = IR.nullNode();
            }
            Node replacement = this.getDefineReplacement(firstExpr, secondExpr);
            replacement.useSourceInfoIfMissingFromForTree(callNode);
            callNode.replaceWith(replacement);
            t.reportCodeChange();
        }

        private Node getDefineReplacement(Node firstExpr, Node secondExpr) {
            if (this.defines.contains(firstExpr.getString())) {
                Node define = NodeUtil.newQName(J2clPass.this.compiler, firstExpr.getString());
                Node defineStringValue = NodeUtil.newCallNode(IR.name("String"), define);
                return IR.comma(secondExpr, defineStringValue);
            }
            return secondExpr;
        }

        private boolean isUtilGetDefineCall(Node n) {
            return n.isCall() && this.isUtilGetDefineMethodName(n.getFirstChild().getQualifiedName());
        }

        private boolean isUtilGetDefineMethodName(String fnName) {
            return fnName != null && fnName.endsWith(".$getDefine") && fnName.contains("Util");
        }
    }
}

