/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIEnv;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalTypeInfo
implements TypeIRegistry {
    private final List<NTIScope> scopes = new ArrayList<NTIScope>();
    private NTIScope globalScope;
    private final List<TypeMismatch> mismatches;
    private final List<TypeMismatch> implicitInterfaceUses;
    private final JSTypeCreatorFromJSDoc typeParser;
    private final Map<Node, String> anonFunNames = new LinkedHashMap<Node, String>();
    private UniqueNameGenerator varNameGen;
    private final Map<Node, JSType> castTypes = new LinkedHashMap<Node, JSType>();
    private final Map<Node, JSType> declaredObjLitProps = new LinkedHashMap<Node, JSType>();
    private final JSTypes commonTypes;
    private final Set<String> unknownTypeNames;
    private final Set<String> allPropertyNames = new LinkedHashSet<String>();
    private final Set<String> externPropertyNames = new LinkedHashSet<String>();
    private Collection<RawNominalType> rawNominalTypes;

    GlobalTypeInfo(AbstractCompiler compiler, Set<String> unknownTypeNames) {
        boolean inCompatibilityMode = compiler.getOptions().disables(DiagnosticGroups.NEW_CHECK_TYPES_EXTRA_CHECKS);
        this.varNameGen = new UniqueNameGenerator();
        this.mismatches = new ArrayList<TypeMismatch>();
        this.implicitInterfaceUses = new ArrayList<TypeMismatch>();
        this.allPropertyNames.add("prototype");
        this.unknownTypeNames = unknownTypeNames;
        this.commonTypes = JSTypes.init(inCompatibilityMode);
        this.typeParser = new JSTypeCreatorFromJSDoc(this.getCommonTypes(), compiler.getCodingConvention(), this.varNameGen, new RecordPropertyCallBack());
    }

    void initGlobalTypeInfo(Node root) {
        this.globalScope = new NTIScope(root, null, (List<String>)ImmutableList.of(), this.getCommonTypes());
        this.globalScope.addUnknownTypeNames(this.unknownTypeNames);
        this.scopes.add(this.globalScope);
    }

    void recordPropertyName(Node pnameNode) {
        String pname = pnameNode.getString();
        this.allPropertyNames.add(pname);
        if (pnameNode.isFromExterns()) {
            this.externPropertyNames.add(pname);
        }
    }

    Set<String> getExternPropertyNames() {
        return this.externPropertyNames;
    }

    Map<Node, JSType> getCastTypes() {
        return this.castTypes;
    }

    Map<Node, JSType> getDeclaredObjLitProps() {
        return this.declaredObjLitProps;
    }

    public JSTypeCreatorFromJSDoc getTypeParser() {
        return this.typeParser;
    }

    public UniqueNameGenerator getVarNameGen() {
        return this.varNameGen;
    }

    Map<Node, String> getAnonFunNames() {
        return this.anonFunNames;
    }

    List<TypeMismatch> getMismatches() {
        return this.mismatches;
    }

    List<TypeMismatch> getImplicitInterfaceUses() {
        return this.implicitInterfaceUses;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    Collection<String> getAllPropertyNames() {
        return this.allPropertyNames;
    }

    boolean isPropertyDefined(String pname) {
        return this.allPropertyNames.contains(pname);
    }

    List<NTIScope> getScopes() {
        return this.scopes;
    }

    NTIScope getGlobalScope() {
        return this.globalScope;
    }

    JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        if (this.anonFunNames.containsKey(n)) {
            return this.anonFunNames.get(n);
        }
        Node fnNameNode = NodeUtil.getNameNode(n);
        Preconditions.checkState((fnNameNode != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)fnNameNode.isName());
        return fnNameNode.getString();
    }

    void setRawNominalTypes(Collection<RawNominalType> rawNominalTypes) {
        Preconditions.checkState((this.rawNominalTypes == null ? 1 : 0) != 0);
        this.rawNominalTypes = new ArrayList<RawNominalType>(rawNominalTypes);
    }

    @Override
    public TypeI createTypeFromCommentNode(Node n) {
        return this.typeParser.getTypeOfCommentNode(n, null, this.globalScope);
    }

    public JSType getNativeFunctionType(JSTypeNative typeId) {
        return this.getNativeType(typeId);
    }

    public JSType getNativeObjectType(JSTypeNative typeId) {
        return this.getNativeType(typeId);
    }

    public JSType getNativeType(JSTypeNative typeId) {
        return this.commonTypes.getNativeType(typeId);
    }

    @Override
    public String getReadableTypeName(Node n) {
        return n.getTypeI().getDisplayName();
    }

    public JSType getType(String typeName) {
        switch (typeName) {
            case "boolean": {
                return this.commonTypes.BOOLEAN;
            }
            case "number": {
                return this.commonTypes.NUMBER;
            }
            case "string": {
                return this.commonTypes.STRING;
            }
            case "null": {
                return this.commonTypes.NULL;
            }
            case "undefined": 
            case "void": {
                return this.commonTypes.UNDEFINED;
            }
        }
        return this.globalScope.getType(typeName);
    }

    @Override
    public String createGetterPropName(String originalPropName) {
        return this.commonTypes.createGetterPropName(originalPropName);
    }

    @Override
    public String createSetterPropName(String originalPropName) {
        return this.commonTypes.createSetterPropName(originalPropName);
    }

    @Override
    public TypeI createUnionType(List<? extends TypeI> members) {
        Preconditions.checkArgument((!members.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create union type with no members");
        JSType result = this.commonTypes.BOTTOM;
        for (TypeI typeI : members) {
            result = JSType.join(result, (JSType)typeI);
        }
        return result;
    }

    @Override
    public TypeI evaluateTypeExpression(JSTypeExpression expr, TypeIEnv<TypeI> typeEnv) {
        return this.createTypeFromCommentNode(expr.getRoot());
    }

    @Override
    public TypeI evaluateTypeExpressionInGlobalScope(JSTypeExpression expr) {
        return this.createTypeFromCommentNode(expr.getRoot());
    }

    @Override
    public TypeI createRecordType(Map<String, ? extends TypeI> props) {
        return JSType.fromProperties(this.commonTypes, props);
    }

    @Override
    public TypeI instantiateGenericType(ObjectTypeI genericType, ImmutableList<? extends TypeI> typeArgs) {
        JSType t = (JSType)genericType;
        int numTypeParams = t.getTypeParameters().size();
        int numTypeArgs = typeArgs.size();
        if (numTypeArgs == numTypeParams) {
            return t.instantiateGenerics((List<? extends TypeI>)typeArgs);
        }
        ArrayList<JSType> newTypeArgs = new ArrayList<JSType>(numTypeParams);
        for (int i = 0; i < numTypeParams; ++i) {
            newTypeArgs.add(i < numTypeArgs ? (JSType)typeArgs.get(i) : this.commonTypes.UNKNOWN);
        }
        return t.instantiateGenerics(newTypeArgs);
    }

    @Override
    public TypeI buildRecordTypeFromObject(ObjectTypeI obj) {
        return JSType.buildRecordTypeFromObject(this.commonTypes, (JSType)obj);
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (RawNominalType rawNominalType : this.rawNominalTypes) {
            rawNominalType.unfreezeForDeserialization();
        }
        for (RawNominalType rawNominalType : this.rawNominalTypes) {
            rawNominalType.fixSubtypesAfterDeserialization();
        }
        for (RawNominalType rawNominalType : this.rawNominalTypes) {
            rawNominalType.refreezeAfterDeserialization();
        }
    }

    class RecordPropertyCallBack
    implements Function<Node, Void>,
    Serializable {
        RecordPropertyCallBack() {
        }

        public Void apply(Node pnameNode) {
            GlobalTypeInfo.this.recordPropertyName(pnameNode);
            return null;
        }
    }
}

