/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Es6RewriteModules
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private static final String DEFAULT_EXPORT_NAME = "$jscompDefaultExport";
    static final DiagnosticType LHS_OF_GOOG_REQUIRE_MUST_BE_CONST = DiagnosticType.error("JSC_LHS_OF_GOOG_REQUIRE_MUST_BE_CONST", "The left side of a goog.require() must use ''const'' (not ''let'' or ''var'')");
    static final DiagnosticType NAMESPACE_IMPORT_CANNOT_USE_STAR = DiagnosticType.error("JSC_NAMESPACE_IMPORT_CANNOT_USE_STAR", "Namespace imports ('goog:some.Namespace') cannot use import * as. Did you mean to import {0} from ''{1}'';?");
    private final AbstractCompiler compiler;
    private int scriptNodeCount;
    private Map<String, NameNodePair> exportMap;
    private Map<String, ModuleOriginalNamePair> importMap;
    private Set<String> classes;
    private Set<String> typedefs;
    private Set<String> alreadyRequired;
    private Node googRequireInsertSpot;

    public Es6RewriteModules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public static boolean isEs6ModuleRoot(Node scriptNode) {
        Preconditions.checkArgument((boolean)scriptNode.isScript());
        if (scriptNode.getBooleanProp((byte)87)) {
            return false;
        }
        return scriptNode.hasChildren() && scriptNode.getFirstChild().isModuleBody();
    }

    public boolean forceToEs6Module(Node root) {
        if (Es6RewriteModules.isEs6ModuleRoot(root)) {
            return true;
        }
        FindGoogProvideOrGoogModule finder = new FindGoogProvideOrGoogModule();
        NodeTraversal.traverseEs6(this.compiler, root, finder);
        if (finder.isFound()) {
            return false;
        }
        Node moduleNode = new Node(Token.MODULE_BODY).srcref(root);
        moduleNode.addChildrenToBack(root.removeChildren());
        root.addChildToBack(moduleNode);
        return true;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node file = root.getFirstChild(); file != null; file = file.getNext()) {
            this.hotSwapScript(file, null);
        }
        this.compiler.setFeatureSet(this.compiler.getFeatureSet().without(FeatureSet.Feature.MODULES));
    }

    @Override
    public void hotSwapScript(Node scriptNode, Node originalRoot) {
        if (Es6RewriteModules.isEs6ModuleRoot(scriptNode)) {
            this.processFile(scriptNode);
        }
    }

    private void processFile(Node root) {
        Preconditions.checkArgument((boolean)Es6RewriteModules.isEs6ModuleRoot(root), (Object)root);
        this.clearState();
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    public void clearState() {
        this.scriptNodeCount = 0;
        this.exportMap = new LinkedHashMap<String, NameNodePair>();
        this.importMap = new HashMap<String, ModuleOriginalNamePair>();
        this.classes = new HashSet<String>();
        this.typedefs = new HashSet<String>();
        this.alreadyRequired = new HashSet<String>();
        this.googRequireInsertSpot = null;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isImport()) {
            this.visitImport(t, n, parent);
        } else if (n.isExport()) {
            this.visitExport(t, n, parent);
        } else if (n.isScript()) {
            ++this.scriptNodeCount;
            this.visitScript(t, n);
        }
    }

    private void visitImport(NodeTraversal t, Node importDecl, Node parent) {
        String moduleName;
        Preconditions.checkArgument((boolean)parent.isModuleBody(), (Object)parent);
        String importName = importDecl.getLastChild().getString();
        boolean isNamespaceImport = importName.startsWith("goog:");
        if (isNamespaceImport) {
            moduleName = importName.substring("goog:".length());
        } else {
            Object modulePath = t.getInput().getPath().resolveJsModule(importName, importDecl.getSourceFileName(), importDecl.getLineno(), importDecl.getCharno());
            if (modulePath == null) {
                modulePath = t.getInput().getPath().resolveModuleAsPath(importName);
            }
            moduleName = ((ModuleLoader.ModulePath)modulePath).toModuleName();
        }
        for (Node child : importDecl.children()) {
            if (child.isEmpty() || child.isString()) continue;
            if (child.isName()) {
                String name = isNamespaceImport ? "" : "default";
                this.importMap.put(child.getString(), new ModuleOriginalNamePair(moduleName, name));
                continue;
            }
            if (child.isImportSpecs()) {
                for (Node grandChild : child.children()) {
                    String origName = grandChild.getFirstChild().getString();
                    if (grandChild.hasTwoChildren()) {
                        this.importMap.put(grandChild.getLastChild().getString(), new ModuleOriginalNamePair(moduleName, origName));
                        continue;
                    }
                    this.importMap.put(origName, new ModuleOriginalNamePair(moduleName, origName));
                }
                continue;
            }
            Preconditions.checkState((boolean)child.isImportStar(), (String)"Expected an IMPORT_STAR node, but was: %s", (Object)child);
            if (isNamespaceImport) {
                this.compiler.report(t.makeError(importDecl, NAMESPACE_IMPORT_CANNOT_USE_STAR, child.getString(), moduleName));
            }
            this.importMap.put(child.getString(), new ModuleOriginalNamePair(moduleName, ""));
        }
        if (this.alreadyRequired.add(moduleName)) {
            Node require = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.require"), IR.string(moduleName)));
            require.useSourceInfoIfMissingFromForTree(importDecl);
            parent.addChildAfter(require, this.googRequireInsertSpot);
            this.googRequireInsertSpot = require;
            t.getInput().addRequire(moduleName);
        }
        parent.removeChild(importDecl);
        t.reportCodeChange();
    }

    private void visitExport(NodeTraversal t, Node export, Node parent) {
        Preconditions.checkArgument((boolean)parent.isModuleBody(), (Object)parent);
        if (export.getBooleanProp((byte)63)) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction() || child.isClass()) {
                name = NodeUtil.getName(child);
            }
            if (name != null) {
                Node decl = child.detach();
                parent.replaceChild(export, decl);
                this.exportMap.put("default", new NameNodePair(name, child));
            } else {
                Node var = IR.var(IR.name(DEFAULT_EXPORT_NAME), export.removeFirstChild());
                var.setJSDocInfo(child.getJSDocInfo());
                child.setJSDocInfo(null);
                var.useSourceInfoIfMissingFromForTree(export);
                parent.replaceChild(export, var);
                this.exportMap.put("default", new NameNodePair(DEFAULT_EXPORT_NAME, child));
            }
        } else if (export.getBooleanProp((byte)64)) {
            this.compiler.report(JSError.make(export, Es6ToEs3Util.CANNOT_CONVERT_YET, "Wildcard export"));
        } else if (export.hasTwoChildren()) {
            Node moduleIdentifier = export.getLastChild();
            Node importNode = IR.importNode(IR.empty(), IR.empty(), moduleIdentifier.cloneNode());
            importNode.useSourceInfoFrom(export);
            parent.addChildBefore(importNode, export);
            this.visit(t, importNode, parent);
            ModuleLoader.ModulePath path = t.getInput().getPath().resolveJsModule(moduleIdentifier.getString(), export.getSourceFileName(), export.getLineno(), export.getCharno());
            if (path == null) {
                path = t.getInput().getPath().resolveModuleAsPath(moduleIdentifier.getString());
            }
            String moduleName = path.toModuleName();
            for (Node exportSpec : export.getFirstChild().children()) {
                String nameFromOtherModule = exportSpec.getFirstChild().getString();
                String exportedName = exportSpec.getLastChild().getString();
                this.exportMap.put(exportedName, new NameNodePair(moduleName + "." + nameFromOtherModule, exportSpec));
            }
            parent.removeChild(export);
        } else {
            if (export.getFirstChild().getToken() == Token.EXPORT_SPECS) {
                for (Node exportSpec : export.getFirstChild().children()) {
                    Node origName = exportSpec.getFirstChild();
                    this.exportMap.put(exportSpec.hasTwoChildren() ? exportSpec.getLastChild().getString() : origName.getString(), new NameNodePair(origName.getString(), exportSpec));
                }
                parent.removeChild(export);
            } else {
                Node first;
                Node declaration = export.getFirstChild();
                for (Node maybeName = first = declaration.getFirstChild(); maybeName != null && maybeName.isName() && (!declaration.isClass() || maybeName == first); maybeName = maybeName.getNext()) {
                    String name = maybeName.getString();
                    Var v = t.getScope().getVar(name);
                    if (v == null || v.isGlobal()) {
                        this.exportMap.put(name, new NameNodePair(name, maybeName));
                    }
                    if (declaration.isClass()) {
                        this.classes.add(name);
                    }
                    if (declaration.getJSDocInfo() == null || !declaration.getJSDocInfo().hasTypedefType()) continue;
                    this.typedefs.add(name);
                }
                parent.replaceChild(export, declaration.detach());
            }
            t.reportCodeChange();
        }
    }

    private void inlineModuleToGlobalScope(Node moduleNode) {
        Preconditions.checkState((boolean)moduleNode.isModuleBody());
        Node scriptNode = moduleNode.getParent();
        moduleNode.detach();
        scriptNode.addChildrenToFront(moduleNode.removeChildren());
    }

    private void visitScript(NodeTraversal t, Node script) {
        JSDocInfoBuilder jsDocInfo;
        this.inlineModuleToGlobalScope(script.getFirstChild());
        ClosureRewriteModule.checkAndSetStrictModeDirective(t, script);
        Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"Es6RewriteModules supports only one invocation per CompilerInput / script node");
        this.rewriteRequires(script);
        String moduleName = t.getInput().getPath().toModuleName();
        for (Map.Entry<String, NameNodePair> entry : this.exportMap.entrySet()) {
            String exportedName = entry.getKey();
            String withSuffix = entry.getValue().name;
            Node nodeForSourceInfo = entry.getValue().nodeForSourceInfo;
            Node getProp = IR.getprop(IR.name(moduleName), IR.string(exportedName));
            if (this.typedefs.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                JSTypeExpression typeExpr = new JSTypeExpression(IR.string(exportedName), script.getSourceFileName());
                builder.recordTypedef(typeExpr);
                JSDocInfo info = builder.build();
                getProp.setJSDocInfo(info);
                Node exprResult = IR.exprResult(getProp).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
                script.addChildToBack(exprResult);
                continue;
            }
            Node assign = IR.assign(getProp, NodeUtil.newQName(this.compiler, withSuffix));
            Node exprResult = IR.exprResult(assign).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
            if (this.classes.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                builder.recordConstancy();
                JSDocInfo info = builder.build();
                assign.setJSDocInfo(info);
            }
            script.addChildToBack(exprResult);
        }
        NodeTraversal.traverseEs6(this.compiler, script, new RenameGlobalVars(moduleName));
        Node googProvide = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.provide"), IR.string(moduleName)));
        script.addChildToFront(googProvide.useSourceInfoIfMissingFromForTree(script));
        t.getInput().addProvide(moduleName);
        JSDocInfoBuilder jSDocInfoBuilder = jsDocInfo = script.getJSDocInfo() == null ? new JSDocInfoBuilder(false) : JSDocInfoBuilder.copyFrom(script.getJSDocInfo());
        if (!jsDocInfo.isPopulatedWithFileOverview()) {
            jsDocInfo.recordFileOverview("");
        }
        jsDocInfo.recordSuppressions((Set<String>)ImmutableSet.of((Object)"missingProvide", (Object)"missingRequire"));
        script.setJSDocInfo(jsDocInfo.build());
        this.exportMap.clear();
        t.reportCodeChange();
    }

    private void rewriteRequires(Node script) {
        NodeTraversal.traverseEs6(this.compiler, script, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isCall() && n.getFirstChild().matchesQualifiedName("goog.require") && NodeUtil.isNameDeclaration(parent.getParent())) {
                    this.visitRequire(n, parent);
                }
            }

            private void visitRequire(Node requireCall, Node parent) {
                String namespace = requireCall.getLastChild().getString();
                if (!parent.getParent().isConst()) {
                    Es6RewriteModules.this.compiler.report(JSError.make(parent.getParent(), LHS_OF_GOOG_REQUIRE_MUST_BE_CONST, new String[0]));
                }
                if (parent.isObjectPattern()) {
                    for (Node key = parent.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.hasChildren()) continue;
                        key.addChildToBack(IR.name(key.getString()).useSourceInfoFrom(key));
                    }
                }
                Node replacement = NodeUtil.newQName(Es6RewriteModules.this.compiler, namespace).srcrefTree(requireCall);
                parent.replaceChild(requireCall, replacement);
                Node varNode = parent.getParent();
                varNode.getParent().addChildBefore(IR.exprResult(requireCall).srcrefTree(requireCall), varNode);
            }
        });
    }

    private static class NameNodePair {
        final String name;
        final Node nodeForSourceInfo;

        private NameNodePair(String name, Node nodeForSourceInfo) {
            this.name = name;
            this.nodeForSourceInfo = nodeForSourceInfo;
        }

        public String toString() {
            return "(" + this.name + ", " + this.nodeForSourceInfo + ")";
        }
    }

    private static class ModuleOriginalNamePair {
        private String module;
        private String originalName;

        private ModuleOriginalNamePair(String module, String originalName) {
            this.module = module;
            this.originalName = originalName;
        }

        public String toString() {
            return "(" + this.module + ", " + this.originalName + ")";
        }
    }

    private class RenameGlobalVars
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String suffix;

        RenameGlobalVars(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean isShorthandObjLitKey;
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            boolean bl = isShorthandObjLitKey = n.isStringKey() && !n.hasChildren();
            if (n.isName() || isShorthandObjLitKey) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                Var var = t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    String newName = name + "$$" + this.suffix;
                    if (isShorthandObjLitKey) {
                        this.fixShorthandObjLit(n, IR.name(newName));
                    } else {
                        n.setString(newName);
                        n.setOriginalName(name);
                    }
                    t.reportCodeChange(n);
                } else if (var == null && Es6RewriteModules.this.importMap.containsKey(name)) {
                    if (parent.isCall() && parent.getFirstChild() == n) {
                        parent.putBooleanProp((byte)50, false);
                    }
                    ModuleOriginalNamePair pair = (ModuleOriginalNamePair)Es6RewriteModules.this.importMap.get(name);
                    Node moduleAccess = NodeUtil.newQName(Es6RewriteModules.this.compiler, pair.module);
                    boolean isImportStar = pair.originalName.isEmpty();
                    if (isShorthandObjLitKey) {
                        if (isImportStar) {
                            this.fixShorthandObjLit(n, moduleAccess);
                        } else {
                            this.fixShorthandObjLit(n, IR.getprop(moduleAccess, IR.string(pair.originalName)));
                        }
                        t.reportCodeChange(n);
                    } else {
                        if (isImportStar) {
                            n.replaceWith(moduleAccess.useSourceInfoIfMissingFromForTree(n));
                        } else {
                            n.replaceWith(IR.getprop(moduleAccess, IR.string(pair.originalName)).useSourceInfoIfMissingFromForTree(n));
                        }
                        t.reportCodeChange(moduleAccess);
                    }
                }
            }
        }

        private void fixShorthandObjLit(Node n, Node newNode) {
            n.addChildToBack(newNode.useSourceInfoIfMissingFromForTree(n));
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                String name = typeNode.getString();
                if (ModuleLoader.isPathIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    int endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    ModuleLoader.ModulePath path = t.getInput().getPath().resolveJsModule(moduleName, typeNode.getSourceFileName(), typeNode.getLineno(), typeNode.getCharno());
                    if (path == null) {
                        path = t.getInput().getPath().resolveModuleAsPath(moduleName);
                    }
                    String globalModuleName = path.toModuleName();
                    this.maybeSetNewName(t, typeNode, name, localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else {
                    Var var;
                    List splitted = Splitter.on((char)'.').limit(2).splitToList((CharSequence)name);
                    String baseName = (String)splitted.get(0);
                    String rest = "";
                    if (splitted.size() == 2) {
                        rest = "." + (String)splitted.get(1);
                    }
                    if ((var = t.getScope().getVar(baseName)) != null && var.isGlobal()) {
                        this.maybeSetNewName(t, typeNode, name, baseName + "$$" + this.suffix + rest);
                    } else if (var == null && Es6RewriteModules.this.importMap.containsKey(baseName)) {
                        ModuleOriginalNamePair pair = (ModuleOriginalNamePair)Es6RewriteModules.this.importMap.get(baseName);
                        if (pair.originalName.isEmpty()) {
                            this.maybeSetNewName(t, typeNode, name, pair.module + rest);
                        } else {
                            this.maybeSetNewName(t, typeNode, name, baseName + "$$" + pair.module + rest);
                        }
                    }
                    typeNode.setOriginalName(name);
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }

        private void maybeSetNewName(NodeTraversal t, Node node, String name, String newName) {
            if (!name.equals(newName)) {
                node.setString(newName);
                node.setOriginalName(name);
                t.reportCodeChange();
            }
        }
    }

    static class FindGoogProvideOrGoogModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindGoogProvideOrGoogModule() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (this.found) {
                return false;
            }
            if (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) {
                Node maybeGetProp;
                if (n.isExprResult() && (maybeGetProp = n.getFirstFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                    this.found = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

