/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;

public final class Es6CheckModule
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType ES6_MODULE_REFERENCES_THIS = DiagnosticType.warning("ES6_MODULE_REFERENCES_THIS", "The body of an ES6 module cannot reference 'this'.");
    private final AbstractCompiler compiler;

    public Es6CheckModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case THIS: {
                if (!t.inModuleHoistScope()) break;
                t.report(n, ES6_MODULE_REFERENCES_THIS, new String[0]);
                break;
            }
        }
    }
}

