/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RewriteGenerators;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;

public final class EarlyEs6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType BAD_REST_PARAMETER_ANNOTATION = DiagnosticType.warning("BAD_REST_PARAMETER_ANNOTATION", "Missing \"...\" in type annotation for rest parameter.");
    private static final String REST_INDEX = "$jscomp$restIndex";
    private static final String REST_PARAMS = "$jscomp$restParams";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";

    public EarlyEs6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, this);
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case REST: {
                this.visitRestParam(t, n, parent);
                break;
            }
            case FOR_OF: {
                Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "makeIterator");
                break;
            }
            case YIELD: {
                if (n.isYieldAll()) {
                    Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "makeIterator");
                }
                Es6ToEs3Util.preloadEs6Symbol(this.compiler);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (!n.isAsyncFunction()) break;
                throw new IllegalStateException("async functions should have already been converted");
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getToken()) {
            case NAME: {
                if (n.isFromExterns() || !this.isGlobalSymbol(t, n)) break;
                this.initSymbolBefore(n);
                break;
            }
            case GETPROP: {
                if (n.isFromExterns()) break;
                this.visitGetprop(t, n);
                break;
            }
            case ARRAYLIT: 
            case NEW: 
            case CALL: {
                for (Node child : n.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(n, parent);
                    break block0;
                }
                break;
            }
            case FUNCTION: {
                if (!n.isGeneratorFunction()) break;
                Es6RewriteGenerators.preloadGeneratorSkeletonAndReportChange(this.compiler);
                break;
            }
        }
    }

    private boolean isGlobalSymbol(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol")) {
            return false;
        }
        Var var = t.getScope().getVar("Symbol");
        return var == null || var.isGlobal();
    }

    private void initSymbolBefore(Node n) {
        this.compiler.ensureLibraryInjected("es6/symbol", false);
        Node statement = NodeUtil.getEnclosingStatement(n);
        Node initSymbol = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbol"), new Node[0]));
        statement.getParent().addChildBefore(initSymbol.useSourceInfoFromForTree(statement), statement);
        this.compiler.reportChangeToEnclosingScope(initSymbol);
    }

    private void visitGetprop(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol.iterator")) {
            return;
        }
        if (this.isGlobalSymbol(t, n.getFirstChild())) {
            this.compiler.ensureLibraryInjected("es6/symbol", false);
            Node statement = NodeUtil.getEnclosingStatement(n);
            Node init = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbolIterator"), new Node[0]));
            statement.getParent().addChildBefore(init.useSourceInfoFromForTree(statement), statement);
            this.compiler.reportChangeToEnclosingScope(init);
        }
    }

    private void visitRestParam(NodeTraversal t, Node restParam, Node paramList) {
        Node functionBody = paramList.getNext();
        int restIndex = paramList.getIndexOfChild(restParam);
        String paramName = restParam.getFirstChild().getString();
        Node nameNode = IR.name(paramName);
        nameNode.setVarArgs(true);
        nameNode.setJSDocInfo(restParam.getJSDocInfo());
        paramList.replaceChild(restParam, nameNode);
        JSTypeExpression type = null;
        JSDocInfo info = restParam.getJSDocInfo();
        if (info != null) {
            type = info.getType();
        } else {
            JSDocInfo functionInfo = NodeUtil.getBestJSDocInfo(paramList.getParent());
            if (functionInfo != null) {
                type = functionInfo.getParameterType(paramName);
            }
        }
        if (type != null && type.getRoot().getToken() != Token.ELLIPSIS) {
            this.compiler.report(JSError.make(restParam, BAD_REST_PARAMETER_ANNOTATION, new String[0]));
        }
        if (!functionBody.hasChildren()) {
            t.reportCodeChange();
            return;
        }
        Node newBlock = IR.block().useSourceInfoFrom(functionBody);
        Node name = IR.name(paramName);
        Node let = IR.let(name, IR.name(REST_PARAMS)).useSourceInfoIfMissingFromForTree(functionBody);
        newBlock.addChildToFront(let);
        for (Node child : functionBody.children()) {
            newBlock.addChildToBack(child.detach());
        }
        if (type != null) {
            Node arrayType = IR.string("Array");
            Node typeNode = type.getRoot();
            Node memberType = typeNode.getToken() == Token.ELLIPSIS ? typeNode.getFirstChild().cloneTree() : typeNode.cloneTree();
            arrayType.addChildToFront(new Node(Token.BLOCK, memberType).useSourceInfoIfMissingFrom(typeNode));
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordType(new JSTypeExpression(new Node(Token.BANG, arrayType), restParam.getSourceFileName()));
            name.setJSDocInfo(builder.build());
        }
        Node newArr = IR.var(IR.name(REST_PARAMS), IR.arraylit(new Node[0]));
        functionBody.addChildToFront(newArr.useSourceInfoIfMissingFromForTree(restParam));
        Node init = IR.var(IR.name(REST_INDEX), IR.number(restIndex));
        Node cond = IR.lt(IR.name(REST_INDEX), IR.getprop(IR.name("arguments"), IR.string("length")));
        Node incr = IR.inc(IR.name(REST_INDEX), false);
        Node body = IR.block(IR.exprResult(IR.assign(IR.getelem(IR.name(REST_PARAMS), IR.sub(IR.name(REST_INDEX), IR.number(restIndex))), IR.getelem(IR.name("arguments"), IR.name(REST_INDEX)))));
        functionBody.addChildAfter(IR.forNode(init, cond, incr, body).useSourceInfoIfMissingFromForTree(restParam), newArr);
        functionBody.addChildToBack(newBlock);
        this.compiler.reportChangeToEnclosingScope(newBlock);
    }

    private void visitArrayLitOrCallWithSpread(Node node, Node parent) {
        Preconditions.checkArgument((node.isCall() || node.isArrayLit() || node.isNew() ? 1 : 0) != 0);
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node callee = node.isArrayLit() ? null : node.removeFirstChild();
        Node currElement = node.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                if (currGroup != null) {
                    groups.add(currGroup);
                    currGroup = null;
                }
                groups.add(Es6ToEs3Util.arrayFromIterable(this.compiler, currElement.removeFirstChild()));
            } else {
                if (currGroup == null) {
                    currGroup = IR.arraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = node.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        Node result = null;
        Node firstGroup = node.isNew() ? IR.arraylit(IR.nullNode()) : IR.arraylit(new Node[0]);
        Node joinedGroups = IR.call(IR.getprop(firstGroup, IR.string("concat")), groups.toArray(new Node[0]));
        if (node.isArrayLit()) {
            result = joinedGroups;
        } else if (node.isCall()) {
            if (NodeUtil.mayHaveSideEffects(callee) && callee.isGetProp()) {
                Node statement = node;
                while (!NodeUtil.isStatement(statement)) {
                    statement = statement.getParent();
                }
                Node freshVar = IR.name(FRESH_SPREAD_VAR + (String)this.compiler.getUniqueNameIdSupplier().get());
                Node n = IR.var(freshVar.cloneTree());
                n.useSourceInfoIfMissingFromForTree(statement);
                statement.getParent().addChildBefore(n, statement);
                callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()));
                result = IR.call(IR.getprop(callee, IR.string("apply")), freshVar, joinedGroups);
            } else {
                Node context = callee.isGetProp() ? callee.getFirstChild().cloneTree() : IR.nullNode();
                result = IR.call(IR.getprop(callee, IR.string("apply")), context, joinedGroups);
            }
        } else {
            if (this.compiler.getOptions().getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT3) {
                Es6ToEs3Util.cannotConvert(this.compiler, node, "\"...\" passed to a constructor (consider using --language_out=ES5)");
            }
            Node bindApply = NodeUtil.newQName(this.compiler, "Function.prototype.bind.apply");
            result = IR.newNode(IR.call(bindApply, callee, joinedGroups), new Node[0]);
        }
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportChangeToEnclosingScope(result);
    }
}

