/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionUseSiteFinder;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import java.util.Collection;

class DevirtualizePrototypeMethods
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private final AbstractCompiler compiler;

    DevirtualizePrototypeMethods(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        DefinitionUseSiteFinder defFinder = new DefinitionUseSiteFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, DefinitionUseSiteFinder definitions) {
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            this.rewriteDefinitionIfEligible(defSite, definitions);
        }
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getFirstChild() == node && parent.isCall();
    }

    private static boolean isPrototypeMethodDefinition(Node node) {
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        Node gramp = parent.getParent();
        if (gramp == null) {
            return false;
        }
        if (node.isGetProp()) {
            if (parent.getFirstChild() != node) {
                return false;
            }
            if (!NodeUtil.isExprAssign(gramp)) {
                return false;
            }
            Node functionNode = parent.getLastChild();
            if (functionNode == null || !functionNode.isFunction()) {
                return false;
            }
            Node nameNode = node.getFirstChild();
            return nameNode.isGetProp() && nameNode.getLastChild().getString().equals("prototype");
        }
        if (node.isStringKey()) {
            Preconditions.checkState((boolean)parent.isObjectLit());
            if (!gramp.isAssign()) {
                return false;
            }
            if (gramp.getLastChild() != parent) {
                return false;
            }
            Node greatGramp = gramp.getParent();
            if (greatGramp == null || !greatGramp.isExprResult()) {
                return false;
            }
            Node functionNode = node.getFirstChild();
            if (functionNode == null || !functionNode.isFunction()) {
                return false;
            }
            Node target = gramp.getFirstChild();
            return target.isGetProp() && target.getLastChild().getString().equals("prototype");
        }
        return false;
    }

    private static String getMethodName(Node node) {
        if (node.isGetProp()) {
            return node.getLastChild().getString();
        }
        if (node.isStringKey()) {
            return node.getString();
        }
        throw new IllegalStateException("unexpected");
    }

    private static String getRewrittenMethodName(String originalMethodName) {
        return "JSCompiler_StaticMethods_" + originalMethodName;
    }

    private void rewriteDefinitionIfEligible(DefinitionSite defSite, DefinitionUseSiteFinder defFinder) {
        if (defSite.inExterns || !defSite.inGlobalScope || !this.isEligibleDefinition(defFinder, defSite)) {
            return;
        }
        Node node = defSite.node;
        if (!DevirtualizePrototypeMethods.isPrototypeMethodDefinition(node)) {
            return;
        }
        for (Node ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!NodeUtil.isControlStructure(ancestor)) continue;
            return;
        }
        String newMethodName = DevirtualizePrototypeMethods.getRewrittenMethodName(DevirtualizePrototypeMethods.getMethodName(node));
        this.rewriteDefinition(node, newMethodName);
        this.rewriteCallSites(defFinder, defSite.definition, newMethodName);
    }

    private boolean isEligibleDefinition(DefinitionUseSiteFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        JSModule definitionModule = definitionSite.module;
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction() || NodeUtil.isVarArgsFunction(rValue)) {
            return false;
        }
        Node lValue = definition.getLValue();
        if (lValue == null || !lValue.isGetProp()) {
            return false;
        }
        if (!lValue.isQualifiedName() && !lValue.getFirstChild().isObjectLit()) {
            return false;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (codingConvention.isExported(lValue.getLastChild().getString())) {
            return false;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        for (UseSite site : useSites) {
            if (!DevirtualizePrototypeMethods.isCall(site)) {
                return false;
            }
            Node nameNode = site.node;
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = defFinder.getDefinitionsReferencedAt(nameNode);
            if (!this.allDefinitionsEquivalent(singleSiteDefinitions)) {
                return false;
            }
            Preconditions.checkState((!singleSiteDefinitions.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)singleSiteDefinitions.contains(definition));
            JSModule callModule = site.module;
            if (definitionModule == callModule || callModule != null && moduleGraph.dependsOn(callModule, definitionModule)) continue;
            return false;
        }
        return true;
    }

    boolean allDefinitionsEquivalent(Collection<DefinitionsRemover.Definition> definitions) {
        if (definitions.size() <= 1) {
            return true;
        }
        DefinitionsRemover.Definition first = null;
        for (DefinitionsRemover.Definition definition : definitions) {
            if (definition.getRValue() == null) {
                return false;
            }
            if (first == null) {
                first = definition;
                continue;
            }
            if (this.compiler.areNodesEqualForInlining(first.getRValue(), definition.getRValue())) continue;
            return false;
        }
        return true;
    }

    private void rewriteCallSites(DefinitionUseSiteFinder defFinder, DefinitionsRemover.Definition definition, String newMethodName) {
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node node = site.node;
            Node parent = node.getParent();
            Node objectNode = node.getFirstChild();
            node.removeChild(objectNode);
            parent.replaceChild(node, objectNode);
            parent.addChildToFront(IR.name(newMethodName).srcref(node));
            Preconditions.checkState((boolean)parent.isCall());
            parent.putBooleanProp((byte)50, true);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private void rewriteDefinition(Node node, String newMethodName) {
        Node functionNode;
        boolean isObjLitDefKey = node.isStringKey();
        Node parent = node.getParent();
        Node refNode = isObjLitDefKey ? node : parent.getFirstChild();
        Node newNameNode = IR.name(newMethodName).useSourceInfoIfMissingFrom(refNode);
        Node newVarNode = IR.var(newNameNode).useSourceInfoIfMissingFrom(refNode);
        if (!isObjLitDefKey) {
            Preconditions.checkState((boolean)parent.isAssign());
            functionNode = parent.getLastChild();
            Node expr = parent.getParent();
            Node block = expr.getParent();
            parent.removeChild(functionNode);
            newNameNode.addChildToFront(functionNode);
            block.replaceChild(expr, newVarNode);
        } else {
            Preconditions.checkState((boolean)parent.isObjectLit());
            functionNode = node.getFirstChild();
            Node assign = parent.getParent();
            Node expr = assign.getParent();
            Node block = expr.getParent();
            node.removeChild(functionNode);
            parent.removeChild(node);
            newNameNode.addChildToFront(functionNode);
            block.addChildAfter(newVarNode, expr);
        }
        this.compiler.reportChangeToEnclosingScope(newVarNode);
        String self = newMethodName + "$self";
        Node argList = functionNode.getSecondChild();
        argList.addChildToFront(IR.name(self).useSourceInfoIfMissingFrom(functionNode));
        this.compiler.reportChangeToEnclosingScope(argList);
        Node body = functionNode.getLastChild();
        if (DevirtualizePrototypeMethods.replaceReferencesToThis(body, self)) {
            this.compiler.reportChangeToEnclosingScope(body);
        }
        this.fixFunctionType(functionNode);
    }

    private void fixFunctionType(Node functionNode) {
        TypeI t = functionNode.getTypeI();
        if (t == null) {
            return;
        }
        FunctionTypeI ft = t.toMaybeFunctionType();
        if (ft != null) {
            functionNode.setTypeI(ft.convertMethodToFunction());
        }
    }

    private static boolean replaceReferencesToThis(Node node, String name) {
        if (node.isFunction()) {
            return false;
        }
        boolean changed = false;
        for (Node child : node.children()) {
            if (child.isThis()) {
                Node newName = IR.name(name);
                newName.setTypeI(child.getTypeI());
                node.replaceChild(child, newName);
                changed = true;
                continue;
            }
            changed |= DevirtualizePrototypeMethods.replaceReferencesToThis(child, name);
        }
        return changed;
    }
}

