/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class Denormalize
implements CompilerPass,
NodeTraversal.Callback,
ReferenceCollectingCallback.Behavior {
    private final AbstractCompiler compiler;

    Denormalize(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
        if (this.compiler.getOptions().syntheticBlockStartMarker == null) {
            new ReferenceCollectingCallback(this.compiler, this, new Es6SyntacticScopeCreator(this.compiler)).process(root);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
        Node scopeRoot = t.getScopeRoot();
        if (scopeRoot.isNormalBlock() && scopeRoot.getParent().isFunction()) {
            boolean changed = false;
            for (Var var : t.getScope().getVarIterable()) {
                Node lhs;
                Node assignNode;
                ReferenceCollection references = referenceMap.getReferences(var);
                Reference declaration = null;
                Reference assign = null;
                for (Reference r : references) {
                    if (r.isVarDeclaration() && NodeUtil.isStatement(r.getNode().getParent()) && !r.isInitializingDeclaration()) {
                        declaration = r;
                        continue;
                    }
                    if (assign != null || !r.isSimpleAssignmentToName() || !r.getScope().getClosestHoistScope().equals(t.getScope())) continue;
                    assign = r;
                }
                if (declaration == null || assign == null || !(assignNode = (lhs = assign.getNode()).getParent()).getParent().isExprResult()) continue;
                Node rhs = lhs.getNext();
                assignNode.getGrandparent().replaceChild(assignNode.getParent(), IR.var(lhs.detach(), rhs.detach()));
                Node var2 = declaration.getNode().getParent();
                Preconditions.checkState((boolean)var2.isVar(), (Object)var2);
                NodeUtil.removeChild(var2, declaration.getNode());
                changed = true;
            }
            if (changed) {
                t.reportCodeChange();
            }
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.maybeCollapseIntoForStatements(n, parent);
        this.maybeCollapseAssignShorthand(n, parent);
    }

    private void maybeCollapseIntoForStatements(Node n, Node parent) {
        if (parent == null || !NodeUtil.isStatementBlock(parent)) {
            return;
        }
        if (!n.isExprResult() && !n.isVar()) {
            return;
        }
        Node nextSibling = n.getNext();
        if (nextSibling == null) {
            return;
        }
        if (nextSibling.isForIn() || nextSibling.isForOf()) {
            Node name;
            Node forNode = nextSibling;
            Node forVar = forNode.getFirstChild();
            if (forVar.isName() && n.isVar() && n.hasOneChild() && !(name = n.getFirstChild()).hasChildren() && forVar.getString().equals(name.getString())) {
                parent.removeChild(n);
                forNode.replaceChild(forVar, n);
                this.compiler.reportChangeToEnclosingScope(parent);
            }
        } else if (nextSibling.isVanillaFor() && nextSibling.getFirstChild().isEmpty()) {
            Node newInitializer;
            if (NodeUtil.containsType(n, Token.IN)) {
                return;
            }
            Node forNode = nextSibling;
            Node oldInitializer = forNode.getFirstChild();
            parent.removeChild(n);
            if (n.isVar()) {
                newInitializer = n;
            } else {
                Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
                newInitializer = n.getFirstChild();
                n.removeChild(newInitializer);
            }
            forNode.replaceChild(oldInitializer, newInitializer);
            this.compiler.reportChangeToEnclosingScope(forNode);
        }
    }

    private void maybeCollapseAssignShorthand(Node n, Node parent) {
        if (n.isAssign() && n.getFirstChild().isName() && NodeUtil.hasCorrespondingAssignmentOp(n.getLastChild()) && n.getLastChild().getFirstChild().isName()) {
            Node op = n.getLastChild();
            Token assignOp = NodeUtil.getAssignOpFromOp(op);
            if (n.getFirstChild().getString().equals(op.getFirstChild().getString())) {
                op.setToken(assignOp);
                Node opDetached = op.detach();
                opDetached.setJSDocInfo(n.getJSDocInfo());
                parent.replaceChild(n, opDetached);
                this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }
}

