/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CleanupPasses;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerExecutor;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerOptionsPreprocessor;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.CoverageInstrumentationPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.DefinitionUseSiteFinder;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.FunctionInformationMap;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.GlobalVarReferenceMap;
import com.google.javascript.jscomp.HasCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.IncrementalScopeCreator;
import com.google.javascript.jscomp.IndexProvider;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.MemoizedTypedScopeCreator;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.PrebuildAst;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.PrintStreamErrorManager;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.jscomp.RecordFunctionInformation;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.RewriteJsonToModule;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.SanityCheck;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceFileMapping;
import com.google.javascript.jscomp.SourceInformationAnnotator;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.SourceMapResolver;
import com.google.javascript.jscomp.SuppressDocWarningsGuard;
import com.google.javascript.jscomp.SymbolTable;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.SyntheticAst;
import com.google.javascript.jscomp.ThreadSafeDelegatingErrorManager;
import com.google.javascript.jscomp.Timeline;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.TransformAMDToCJSModule;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ClosureReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.SemanticReverseAbstractInterpreter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public class Compiler
extends AbstractCompiler
implements ErrorHandler,
SourceFileMapping {
    static final String SINGLETON_MODULE_NAME = "$singleton$";
    static final DiagnosticType MODULE_DEPENDENCY_ERROR = DiagnosticType.error("JSC_MODULE_DEPENDENCY_ERROR", "Bad dependency: {0} -> {1}. Modules must be listed in dependency order.");
    static final DiagnosticType MISSING_ENTRY_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "required entry point \"{0}\" never provided");
    static final DiagnosticType MISSING_MODULE_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "unknown module \"{0}\" specified in entry point spec");
    static final DiagnosticType INCONSISTENT_MODULE_DEFINITIONS = DiagnosticType.error("JSC_INCONSISTENT_MODULE_DEFINITIONS", "Serialized module definitions are not consistent with the module definitions supplied in the command line");
    private static final String CONFIG_RESOURCE = "com.google.javascript.jscomp.parsing.ParserConfig";
    CompilerOptions options = null;
    private PassConfig passes = null;
    private List<CompilerInput> externs;
    private List<JSModule> modules;
    private JSModuleGraph moduleGraph;
    private ModuleLoader moduleLoader;
    private List<CompilerInput> inputs;
    private ErrorManager errorManager;
    private WarningsGuard warningsGuard;
    private final Map<String, Node> injectedLibraries = new LinkedHashMap<String, Node>();
    private Node lastInjectedLibrary;
    Node externsRoot;
    Node jsRoot;
    Node externAndJsRoot;
    private String lastJsSource = null;
    private FeatureSet featureSet;
    private final Map<InputId, CompilerInput> inputsById = new ConcurrentHashMap<InputId, CompilerInput>();
    private transient IncrementalScopeCreator scopeCreator = null;
    private final ConcurrentHashMap<String, SourceFile> sourceMapOriginalSources = new ConcurrentHashMap();
    ConcurrentHashMap<String, SourceMapInput> inputSourceMaps = new ConcurrentHashMap();
    private Map<String, List<Comment>> commentsPerFile = new ConcurrentHashMap<String, List<Comment>>();
    private SourceMap sourceMap;
    private String externExports = null;
    private int uniqueNameId = 0;
    private boolean hasRegExpGlobalReferences = true;
    private FunctionInformationMap functionInformationMap;
    private final StringBuilder debugLog = new StringBuilder();
    CodingConvention defaultCodingConvention = new ClosureCodingConvention();
    private JSTypeRegistry typeRegistry;
    private volatile Config parserConfig = null;
    private volatile Config externsParserConfig = null;
    private ReverseAbstractInterpreter abstractInterpreter;
    private TypeValidator typeValidator;
    private PhaseOptimizer phaseOptimizer = null;
    public PerformanceTracker tracker;
    private DefinitionUseSiteFinder defFinder = null;
    private Set<String> forwardDeclaredTypes = new HashSet<String>();
    private GlobalTypeInfo globalTypeInfo;
    private AbstractCompiler.MostRecentTypechecker mostRecentTypechecker = AbstractCompiler.MostRecentTypechecker.NONE;
    private final ErrorReporter oldErrorReporter = RhinoErrorReporter.forOldRhino(this);
    public static final DiagnosticType OPTIMIZE_LOOP_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of optimization iterations: {0}");
    public static final DiagnosticType MOTION_ITERATIONS_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of code motion iterations: {0}");
    private final CompilerExecutor compilerExecutor = this.createCompilerExecutor();
    public static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final PrintStream outStream;
    private GlobalVarReferenceMap globalRefMap = null;
    private volatile double progress = 0.0;
    private String lastPassName;
    private Set<String> externProperties = null;
    private static final Joiner pathJoiner = Joiner.on((String)File.separator);
    private Node currentChangeScope = null;
    private int changeStamp = 1;
    private final Timeline<Node> changeTimeline = new Timeline();
    private final Timeline<Node> deleteTimeline = new Timeline();
    private static final DiagnosticType EMPTY_MODULE_LIST_ERROR = DiagnosticType.error("JSC_EMPTY_MODULE_LIST_ERROR", "At least one module must be provided");
    private static final DiagnosticType EMPTY_ROOT_MODULE_ERROR = DiagnosticType.error("JSC_EMPTY_ROOT_MODULE_ERROR", "Root module ''{0}'' must contain at least one source code input");
    static final DiagnosticType DUPLICATE_INPUT = DiagnosticType.error("JSC_DUPLICATE_INPUT", "Duplicate input: {0}");
    static final DiagnosticType DUPLICATE_EXTERN_INPUT = DiagnosticType.error("JSC_DUPLICATE_EXTERN_INPUT", "Duplicate extern input: {0}");
    private final PassFactory sanityCheck = new PassFactory("sanityCheck", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new SanityCheck(compiler);
        }
    };
    private Tracer currentTracer = null;
    private String currentPassName = null;
    private int syntheticCodeId = 0;
    protected final RecentChange recentChange = new RecentChange();
    private final List<CodeChangeHandler> codeChangeHandlers = new ArrayList<CodeChangeHandler>();
    private final Map<Class<?>, IndexProvider<?>> indexProvidersByType = new LinkedHashMap();
    static final String SYNTHETIC_EXTERNS = "{SyntheticVarsDeclar}";
    static final String SYNTHETIC_EXTERNS_AT_END = "{SyntheticVarsAtEnd}";
    private CompilerInput synthesizedExternsInput = null;
    private CompilerInput synthesizedExternsInputAtEnd = null;
    private ImmutableMap<String, Node> defaultDefineValues = ImmutableMap.of();
    private IdGenerator crossModuleIdGenerator = new IdGenerator();
    private Map<String, Integer> cssNames = null;
    private VariableMap variableMap = null;
    private VariableMap propertyMap = null;
    private VariableMap anonymousFunctionNameMap = null;
    private FunctionNames functionNames = null;
    private VariableMap stringMap = null;
    private String idGeneratorMap = null;
    private final Set<String> exportedNames = new LinkedHashSet<String>();

    public Compiler() {
        this((PrintStream)null);
    }

    public Compiler(PrintStream outStream) {
        this.addChangeHandler(this.recentChange);
        this.outStream = outStream;
    }

    public Compiler(ErrorManager errorManager) {
        this();
        this.setErrorManager(errorManager);
    }

    public void setErrorManager(ErrorManager errorManager) {
        Preconditions.checkNotNull((Object)errorManager, (Object)"the error manager cannot be null");
        this.errorManager = new ThreadSafeDelegatingErrorManager(errorManager);
    }

    private MessageFormatter createMessageFormatter() {
        boolean colorize = this.options.shouldColorizeErrorOutput();
        return this.options.errorFormat.toFormatter(this, colorize);
    }

    public void initOptions(CompilerOptions options) {
        this.options = options;
        this.setFeatureSet(options.getLanguageIn().toFeatureSet());
        if (this.errorManager == null) {
            if (this.outStream == null) {
                this.setErrorManager(new LoggerErrorManager(this.createMessageFormatter(), logger));
            } else {
                PrintStreamErrorManager printer = new PrintStreamErrorManager(this.createMessageFormatter(), this.outStream);
                printer.setSummaryDetailLevel(options.summaryDetailLevel);
                this.setErrorManager(printer);
            }
        }
        this.moduleLoader = ModuleLoader.EMPTY;
        this.reconcileOptionsWithGuards();
        if (!options.checkTypes) {
            options.setDisambiguateProperties(false);
            options.setAmbiguateProperties(false);
            options.setInlineProperties(false);
            options.setUseTypesForLocalOptimization(false);
            options.setUseTypesForOptimization(false);
        }
        if (options.legacyCodeCompile) {
            options.setDisambiguateProperties(false);
            options.setAmbiguateProperties(false);
            options.useNonStrictWarningsGuard();
        }
        if (options.assumeForwardDeclaredForMissingTypes) {
            this.forwardDeclaredTypes = new AbstractSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public boolean add(String e) {
                    return false;
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.emptySet().iterator();
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }
        this.initWarningsGuard(options.getWarningsGuard());
    }

    public void printConfig(PrintStream printStream) {
        printStream.println("==== CompilerOptions ====");
        printStream.println(this.options);
        printStream.println("==== WarningsGuard ====");
        printStream.println(this.warningsGuard);
    }

    void initWarningsGuard(WarningsGuard warningsGuard) {
        this.warningsGuard = new ComposeWarningsGuard(new SuppressDocWarningsGuard(this, this.getDiagnosticGroups().getRegisteredGroups()), warningsGuard);
    }

    protected void reconcileOptionsWithGuards() {
        if (this.options.enables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = true;
        } else if (this.options.disables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = false;
        } else if (!this.options.checkTypes) {
            this.options.setWarningLevel(DiagnosticGroup.forType(RhinoErrorReporter.TYPE_PARSE_ERROR), CheckLevel.OFF);
        }
        WarningsGuard.DiagnosticGroupState ntiState = this.options.getWarningsGuard().enablesExplicitly(DiagnosticGroups.NEW_CHECK_TYPES);
        if (ntiState == WarningsGuard.DiagnosticGroupState.ON) {
            this.options.setNewTypeInference(true);
        } else if (ntiState == WarningsGuard.DiagnosticGroupState.OFF) {
            this.options.setNewTypeInference(false);
        }
        if (this.options.getNewTypeInference() && this.options.getRunOTIafterNTI()) {
            this.options.checkTypes = true;
            this.options.setWarningLevel(DiagnosticGroups.ACCESS_CONTROLS_CONST, CheckLevel.OFF);
            if (!this.options.reportOTIErrorsUnderNTI) {
                this.options.setWarningLevel(DiagnosticGroups.OLD_CHECK_TYPES, CheckLevel.OFF);
                this.options.setWarningLevel(DiagnosticGroups.OLD_REPORT_UNKNOWN_TYPES, CheckLevel.OFF);
                this.options.setWarningLevel(FunctionTypeBuilder.ALL_DIAGNOSTICS, CheckLevel.OFF);
            }
            this.options.setWarningLevel(DiagnosticGroup.forType(RhinoErrorReporter.TYPE_PARSE_ERROR), CheckLevel.WARNING);
        }
        if (this.options.checkGlobalThisLevel.isOn() && !this.options.disables(DiagnosticGroups.GLOBAL_THIS)) {
            this.options.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, this.options.checkGlobalThisLevel);
        }
        if (this.options.expectStrictModeInput()) {
            this.options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.ERROR);
        }
        if (!this.options.checkSymbols && !this.options.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            this.options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF);
        }
    }

    public final <T1 extends SourceFile, T2 extends SourceFile> void init(List<T1> externs, List<T2> sources, CompilerOptions options) {
        JSModule module = new JSModule(SINGLETON_MODULE_NAME);
        for (SourceFile source : sources) {
            if (this.getPersistentInputStore() != null) {
                module.add(this.getPersistentInputStore().getCachedCompilerInput(source));
                continue;
            }
            module.add(new CompilerInput(source));
        }
        ArrayList<JSModule> modules = new ArrayList<JSModule>(1);
        modules.add(module);
        this.initModules(externs, modules, options);
        this.addFilesToSourceMap(sources);
    }

    public <T extends SourceFile> void initModules(List<T> externs, List<JSModule> modules, CompilerOptions options) {
        this.initOptions(options);
        this.checkFirstModule(modules);
        Compiler.fillEmptyModules(modules);
        this.externs = this.makeExternInputs(externs);
        this.modules = modules;
        try {
            this.moduleGraph = new JSModuleGraph(modules);
        }
        catch (JSModuleGraph.ModuleDependenceException e) {
            this.report(JSError.make(MODULE_DEPENDENCY_ERROR, e.getModule().getName(), e.getDependentModule().getName()));
            return;
        }
        this.inputs = Compiler.getAllInputsFromModules(modules);
        this.commentsPerFile = new ConcurrentHashMap<String, List<Comment>>(this.inputs.size());
        this.initBasedOnOptions();
        this.initInputsByIdMap();
        this.initAST();
    }

    @Deprecated
    public void breakThisCompilerSoItsModulesCanBeReused() {
        this.moduleGraph.breakThisGraphSoItsModulesCanBeReused();
        this.moduleGraph = null;
    }

    public void initBasedOnOptions() {
        this.inputSourceMaps.putAll((Map<String, SourceMapInput>)this.options.inputSourceMaps);
        if (this.options.sourceMapOutputPath != null) {
            this.sourceMap = this.options.sourceMapFormat.getInstance();
            this.sourceMap.setPrefixMappings(this.options.sourceMapLocationMappings);
            if (this.options.applyInputSourceMaps) {
                this.sourceMap.setSourceFileMapping(this);
            }
        }
    }

    private <T extends SourceFile> List<CompilerInput> makeExternInputs(List<T> externSources) {
        ArrayList<CompilerInput> inputs = new ArrayList<CompilerInput>(externSources.size());
        for (SourceFile file : externSources) {
            inputs.add(new CompilerInput(file, true));
        }
        return inputs;
    }

    private void checkFirstModule(List<JSModule> modules) {
        if (modules.isEmpty()) {
            this.report(JSError.make(EMPTY_MODULE_LIST_ERROR, new String[0]));
        } else if (modules.get(0).getInputs().isEmpty() && modules.size() > 1) {
            this.report(JSError.make(EMPTY_ROOT_MODULE_ERROR, modules.get(0).getName()));
        }
    }

    static String createFillFileName(String moduleName) {
        return moduleName + "$fillFile";
    }

    public static String joinPathParts(String ... pathParts) {
        return pathJoiner.join((Object[])pathParts);
    }

    private static void fillEmptyModules(List<JSModule> modules) {
        for (JSModule module : modules) {
            if (!module.getInputs().isEmpty()) continue;
            module.add(SourceFile.fromCode(Compiler.createFillFileName(module.getName()), ""));
        }
    }

    public void rebuildInputsFromModules() {
        this.inputs = Compiler.getAllInputsFromModules(this.modules);
        this.initInputsByIdMap();
    }

    private static List<CompilerInput> getAllInputsFromModules(List<JSModule> modules) {
        ArrayList<CompilerInput> inputs = new ArrayList<CompilerInput>();
        HashMap<String, JSModule> inputMap = new HashMap<String, JSModule>();
        for (JSModule module : modules) {
            for (CompilerInput input : module.getInputs()) {
                String inputName = input.getName();
                inputs.add(input);
                inputMap.put(inputName, module);
            }
        }
        return inputs;
    }

    void initInputsByIdMap() {
        CompilerInput previous;
        InputId id;
        this.inputsById.clear();
        for (CompilerInput input : this.externs) {
            id = input.getInputId();
            previous = this.putCompilerInput(id, input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_EXTERN_INPUT, input.getName()));
        }
        for (CompilerInput input : this.inputs) {
            id = input.getInputId();
            previous = this.putCompilerInput(id, input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_INPUT, input.getName()));
        }
    }

    private void initAST() {
        this.jsRoot = IR.root(new Node[0]);
        this.externsRoot = IR.root(new Node[0]);
        this.externAndJsRoot = IR.root(this.externsRoot, this.jsRoot);
    }

    public Result compile(SourceFile extern, SourceFile input, CompilerOptions options) {
        return this.compile((List)ImmutableList.of((Object)extern), (List)ImmutableList.of((Object)input), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1 extends SourceFile, T2 extends SourceFile> Result compile(List<T1> externs, List<T2> inputs, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.init(externs, inputs, options);
            if (options.printConfig) {
                this.printConfig(System.err);
            }
            if (!this.hasErrors()) {
                this.parseForCompilation();
            }
            if (!this.hasErrors()) {
                if (options.getInstrumentForCoverageOnly()) {
                    this.instrumentForCoverage();
                } else {
                    this.stage1Passes();
                    if (!this.hasErrors()) {
                        this.stage2Passes();
                    }
                }
                this.performPostCompilationTasks();
            }
        }
        finally {
            this.generateReport();
        }
        return this.getResult();
    }

    public void generateReport() {
        Tracer t = this.newTracer("generateReport");
        this.errorManager.generateReport();
        this.stopTracer(t, "generateReport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SourceFile> Result compileModules(List<T> externs, List<JSModule> modules, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.initModules(externs, modules, options);
            if (options.printConfig) {
                this.printConfig(System.err);
            }
            if (!this.hasErrors()) {
                this.parseForCompilation();
            }
            if (!this.hasErrors()) {
                if (options.getInstrumentForCoverageOnly()) {
                    this.instrumentForCoverage();
                } else {
                    this.stage1Passes();
                    if (!this.hasErrors()) {
                        this.stage2Passes();
                    }
                }
                this.performPostCompilationTasks();
            }
        }
        finally {
            this.generateReport();
        }
        return this.getResult();
    }

    public void stage1Passes() {
        Preconditions.checkState((this.inputs != null && !this.inputs.isEmpty() ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initModules()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        Preconditions.checkState((!this.options.getInstrumentForCoverageOnly() ? 1 : 0) != 0);
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Compiler.this.performChecksAndTranspilation();
                return null;
            }
        });
    }

    public void stage2Passes() {
        Preconditions.checkState((this.inputs != null && !this.inputs.isEmpty() ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initModules()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        Preconditions.checkState((!this.options.getInstrumentForCoverageOnly() ? 1 : 0) != 0);
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (Compiler.this.options.shouldOptimize()) {
                    Compiler.this.performOptimizations();
                }
                return null;
            }
        });
    }

    public void disableThreads() {
        this.compilerExecutor.disableThreads();
    }

    public void setTimeout(int timeout) {
        this.compilerExecutor.setTimeout(timeout);
    }

    <T> T runInCompilerThread(Callable<T> callable) {
        return this.compilerExecutor.runInCompilerThread(callable, this.options != null && this.options.getTracerMode().isOn());
    }

    private void performChecksAndTranspilation() {
        if (this.options.skipNonTranspilationPasses) {
            this.whitespaceOnlyPasses();
            if (this.options.needsTranspilationFrom(FeatureSet.ES6)) {
                this.transpileAndDontCheck();
            }
        } else {
            this.check();
        }
    }

    public void performPostCompilationTasks() {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Compiler.this.performPostCompilationTasksInternal();
                return null;
            }
        });
    }

    private void performPostCompilationTasksInternal() {
        if (this.options.recordFunctionInformation) {
            this.recordFunctionInformation();
        }
        if (this.options.devMode == CompilerOptions.DevMode.START_AND_END) {
            this.runSanityCheck();
        }
        this.setProgress(1.0, "recordFunctionInformation");
        if (this.tracker != null) {
            this.tracker.outputTracerReport();
        }
    }

    public void instrumentForCoverage() {
        Preconditions.checkState((this.inputs != null && !this.inputs.isEmpty() ? 1 : 0) != 0, (Object)"No inputs. Did you call init() or initModules()?");
        Preconditions.checkState((!this.hasErrors() ? 1 : 0) != 0);
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Preconditions.checkState((boolean)Compiler.this.options.getInstrumentForCoverageOnly());
                Preconditions.checkState((!Compiler.this.hasErrors() ? 1 : 0) != 0);
                Compiler.this.instrumentForCoverageInternal(Compiler.this.options.instrumentBranchCoverage);
                return null;
            }
        });
    }

    private void instrumentForCoverageInternal(boolean instrumentBranchCoverage) {
        Tracer tracer = this.newTracer("instrumentationPass");
        CoverageInstrumentationPass.InstrumentOption instrumentOption = CoverageInstrumentationPass.InstrumentOption.LINE_ONLY;
        if (instrumentBranchCoverage) {
            instrumentOption = CoverageInstrumentationPass.InstrumentOption.BRANCH_ONLY;
        }
        this.process(new CoverageInstrumentationPass(this, CoverageInstrumentationPass.CoverageReach.ALL, instrumentOption));
        this.stopTracer(tracer, "instrumentationPass");
    }

    public void parseForCompilation() {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Compiler.this.parseForCompilationInternal();
                return null;
            }
        });
    }

    private void parseForCompilationInternal() {
        this.setProgress(0.0, null);
        CompilerOptionsPreprocessor.preprocess(this.options);
        this.maybeSetTracker();
        this.parseInputs();
        this.setProgress(0.15, "parse");
    }

    public void parse() {
        this.parseInputs();
    }

    PassConfig getPassConfig() {
        if (this.passes == null) {
            this.passes = this.createPassConfigInternal();
        }
        return this.passes;
    }

    PassConfig createPassConfigInternal() {
        return new DefaultPassConfig(this.options);
    }

    public void setPassConfig(PassConfig passes) {
        Preconditions.checkNotNull((Object)passes);
        Preconditions.checkState((this.passes == null ? 1 : 0) != 0, (Object)"setPassConfig was already called");
        this.passes = passes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whitespaceOnlyPasses() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        Tracer t = this.newTracer("runWhitespaceOnlyPasses");
        try {
            for (PassFactory pf : this.getPassConfig().getWhitespaceOnlyPasses()) {
                pf.create(this).process(this.externsRoot, this.jsRoot);
            }
        }
        finally {
            this.stopTracer(t, "runWhitespaceOnlyPasses");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transpileAndDontCheck() {
        Tracer t = this.newTracer("runTranspileOnlyPasses");
        try {
            for (PassFactory pf : this.getPassConfig().getTranspileOnlyPasses()) {
                pf.create(this).process(this.externsRoot, this.jsRoot);
            }
        }
        finally {
            this.stopTracer(t, "runTranspileOnlyPasses");
        }
    }

    private PhaseOptimizer createPhaseOptimizer() {
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        if (this.options.getCheckDeterminism()) {
            phaseOptimizer.setPrintAstHashcodes(true);
        }
        return phaseOptimizer;
    }

    void check() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        this.phaseOptimizer = this.createPhaseOptimizer().withProgress(new PhaseOptimizer.ProgressRange(this.getProgress(), 1.0));
        this.phaseOptimizer.consume(this.getPassConfig().getChecks());
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS);
        this.phaseOptimizer = null;
    }

    @Override
    void setExternExports(String externExports) {
        this.externExports = externExports;
    }

    @Override
    void process(CompilerPass p) {
        p.process(this.externsRoot, this.jsRoot);
    }

    private void maybeSanityCheck() {
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            this.runSanityCheck();
        }
    }

    private void runSanityCheck() {
        this.sanityCheck.create(this).process(this.externsRoot, this.jsRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomPasses(CustomPassExecutionTime executionTime) {
        if (this.options.customPasses != null) {
            Tracer t = this.newTracer("runCustomPasses");
            try {
                for (CompilerPass p : this.options.customPasses.get((Object)executionTime)) {
                    this.process(p);
                }
            }
            finally {
                this.stopTracer(t, "runCustomPasses");
            }
        }
    }

    void startPass(String passName) {
        Preconditions.checkState((this.currentTracer == null ? 1 : 0) != 0);
        this.currentPassName = passName;
        this.currentTracer = this.newTracer(passName);
        this.beforePass(passName);
    }

    void endPass(String passName) {
        Preconditions.checkState((this.currentTracer != null ? 1 : 0) != 0, (Object)"Tracer should not be null at the end of a pass.");
        this.stopTracer(this.currentTracer, this.currentPassName);
        this.afterPass(passName);
        this.currentPassName = null;
        this.currentTracer = null;
        this.maybeSanityCheck();
    }

    @Override
    final void beforePass(String passName) {
    }

    @Override
    final void afterPass(String passName) {
        String currentJsSource;
        if (this.options.printSourceAfterEachPass && !(currentJsSource = this.getCurrentJsSource()).equals(this.lastJsSource)) {
            System.out.println();
            System.out.println("// " + passName + " yields:");
            System.out.println("// ************************************");
            System.out.println(currentJsSource);
            System.out.println("// ************************************");
            this.lastJsSource = currentJsSource;
        }
    }

    final String getCurrentJsSource() {
        List<String> fileNameRegexList = this.options.filesToPrintAfterEachPassRegexList;
        if (fileNameRegexList.isEmpty()) {
            return this.toSource();
        }
        StringBuilder builder = new StringBuilder();
        Preconditions.checkNotNull((Object)this.jsRoot);
        block0: for (Node fileNode : this.jsRoot.children()) {
            String fileName = fileNode.getSourceFileName();
            for (String regex : fileNameRegexList) {
                if (!fileName.matches(regex)) continue;
                String source = "// " + fileName + "\n" + this.toSource(fileNode);
                builder.append(source);
                continue block0;
            }
        }
        return builder.toString();
    }

    @Override
    @Nullable
    final Node getScriptNode(String filename) {
        Preconditions.checkNotNull((Object)filename);
        if (this.jsRoot == null) {
            return null;
        }
        for (Node file : this.jsRoot.children()) {
            if (file.getSourceFileName() == null || !file.getSourceFileName().endsWith(filename)) continue;
            return file;
        }
        return null;
    }

    Tracer newTracer(String passName) {
        String comment = passName + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.options.getTracerMode().isOn() && this.tracker != null) {
            this.tracker.recordPassStart(passName, true);
        }
        return new Tracer("Compiler", comment);
    }

    void stopTracer(Tracer t, String passName) {
        long result = t.stop();
        if (this.options.getTracerMode().isOn() && this.tracker != null) {
            this.tracker.recordPassStop(passName, result);
        }
    }

    public Result getResult() {
        HashSet<SourceFile> transpiledFiles = new HashSet<SourceFile>();
        if (this.jsRoot != null) {
            for (Node scriptNode : this.jsRoot.children()) {
                if (!scriptNode.getBooleanProp((byte)93)) continue;
                transpiledFiles.add(this.getSourceFileByName(scriptNode.getSourceFileName()));
            }
        }
        return new Result(this.getErrors(), this.getWarnings(), this.debugLog.toString(), this.variableMap, this.propertyMap, this.anonymousFunctionNameMap, this.stringMap, this.functionInformationMap, this.sourceMap, this.externExports, this.cssNames, this.idGeneratorMap, transpiledFiles);
    }

    public JSError[] getErrors() {
        if (this.errorManager == null) {
            return new JSError[0];
        }
        return this.errorManager.getErrors();
    }

    public JSError[] getWarnings() {
        if (this.errorManager == null) {
            return new JSError[0];
        }
        return this.errorManager.getWarnings();
    }

    @Override
    public Node getRoot() {
        return this.externAndJsRoot;
    }

    @Override
    FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    @Override
    void setFeatureSet(FeatureSet fs) {
        this.featureSet = fs;
    }

    private int nextUniqueNameId() {
        return this.uniqueNameId++;
    }

    @VisibleForTesting
    void resetUniqueNameId() {
        this.uniqueNameId = 0;
    }

    @Override
    Supplier<String> getUniqueNameIdSupplier() {
        return new Supplier<String>(){

            public String get() {
                return String.valueOf(Compiler.this.nextUniqueNameId());
            }
        };
    }

    @Override
    boolean areNodesEqualForInlining(Node n1, Node n2) {
        if (this.options.shouldAmbiguateProperties() || this.options.shouldDisambiguateProperties()) {
            return n1.isEquivalentToTyped(n2);
        }
        return n1.isEquivalentTo(n2);
    }

    @Override
    public CompilerInput getInput(InputId id) {
        if (id == null) {
            return null;
        }
        return this.inputsById.get(id);
    }

    protected void removeExternInput(InputId id) {
        CompilerInput input = this.getInput(id);
        if (input == null) {
            return;
        }
        Preconditions.checkState((boolean)input.isExtern(), (String)"Not an extern input: %s", (Object)input.getName());
        this.inputsById.remove(id);
        this.externs.remove(input);
        Node root = input.getAstRoot(this);
        if (root != null) {
            root.detach();
        }
    }

    CompilerInput newExternInput(String name, SyntheticExternsPosition pos) {
        SyntheticAst ast = new SyntheticAst(name);
        if (this.inputsById.containsKey(ast.getInputId())) {
            throw new IllegalArgumentException("Conflicting externs name: " + name);
        }
        CompilerInput input = new CompilerInput(ast, true);
        this.putCompilerInput(input.getInputId(), input);
        if (pos == SyntheticExternsPosition.START) {
            this.externsRoot.addChildToFront(ast.getAstRoot(this));
            this.externs.add(0, input);
        } else {
            this.externsRoot.addChildToBack(ast.getAstRoot(this));
            this.externs.add(input);
        }
        return input;
    }

    CompilerInput putCompilerInput(InputId id, CompilerInput input) {
        input.setCompiler(this);
        return this.inputsById.put(id, input);
    }

    boolean replaceIncrementalSourceAst(JsAst ast) {
        CompilerInput oldInput = this.getInput(ast.getInputId());
        Preconditions.checkNotNull((Object)oldInput, (String)"No input to replace: %s", (Object)ast.getInputId().getIdName());
        Node newRoot = ast.getAstRoot(this);
        if (newRoot == null) {
            return false;
        }
        Node oldRoot = oldInput.getAstRoot(this);
        if (oldRoot != null) {
            oldRoot.replaceWith(newRoot);
        } else {
            this.getRoot().getLastChild().addChildToBack(newRoot);
        }
        CompilerInput newInput = new CompilerInput(ast);
        this.putCompilerInput(ast.getInputId(), newInput);
        JSModule module = oldInput.getModule();
        if (module != null) {
            module.addAfter(newInput, oldInput);
            module.remove(oldInput);
        }
        Preconditions.checkState((boolean)newInput.getInputId().equals(oldInput.getInputId()));
        InputId inputIdOnAst = newInput.getAstRoot(this).getInputId();
        Preconditions.checkState((boolean)newInput.getInputId().equals(inputIdOnAst));
        this.inputs.remove(oldInput);
        return true;
    }

    boolean addNewSourceAst(JsAst ast) {
        CompilerInput oldInput = this.getInput(ast.getInputId());
        if (oldInput != null) {
            throw new IllegalStateException("Input already exists: " + ast.getInputId().getIdName());
        }
        Node newRoot = ast.getAstRoot(this);
        if (newRoot == null) {
            return false;
        }
        this.getRoot().getLastChild().addChildToBack(newRoot);
        CompilerInput newInput = new CompilerInput(ast);
        if (this.moduleGraph == null && !this.modules.isEmpty()) {
            this.modules.get(0).add(newInput);
        }
        this.putCompilerInput(ast.getInputId(), newInput);
        return true;
    }

    @Override
    JSModuleGraph getModuleGraph() {
        if (this.moduleGraph != null && this.modules.size() > 1) {
            return this.moduleGraph;
        }
        return null;
    }

    public List<JSModule> getModules() {
        return this.modules;
    }

    JSModuleGraph getDegenerateModuleGraph() {
        return this.moduleGraph;
    }

    @Override
    public TypeIRegistry getTypeIRegistry() {
        switch (this.mostRecentTypechecker) {
            case NONE: {
                return this.options.getNewTypeInference() ? this.getGlobalTypeInfo() : this.getTypeRegistry();
            }
            case OTI: {
                return this.getTypeRegistry();
            }
            case NTI: {
                return this.getGlobalTypeInfo();
            }
        }
        throw new RuntimeException("Unhandled typechecker " + (Object)((Object)this.mostRecentTypechecker));
    }

    @Override
    public void clearTypeIRegistry() {
        switch (this.mostRecentTypechecker) {
            case OTI: {
                this.typeRegistry = null;
                return;
            }
            case NTI: {
                this.globalTypeInfo = null;
                return;
            }
            case NONE: {
                return;
            }
        }
        throw new RuntimeException("Unhandled typechecker " + (Object)((Object)this.mostRecentTypechecker));
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = new JSTypeRegistry(this.oldErrorReporter, this.forwardDeclaredTypes);
        }
        return this.typeRegistry;
    }

    @Override
    void forwardDeclareType(String typeName) {
        if (this.options.allowUnfulfilledForwardDeclarations()) {
            this.forwardDeclaredTypes.add(typeName);
        }
    }

    @Override
    void setMostRecentTypechecker(AbstractCompiler.MostRecentTypechecker lastRun) {
        this.mostRecentTypechecker = lastRun;
    }

    @Override
    AbstractCompiler.MostRecentTypechecker getMostRecentTypechecker() {
        return this.mostRecentTypechecker;
    }

    @Override
    public MemoizedTypedScopeCreator getTypedScopeCreator() {
        return this.getPassConfig().getTypedScopeCreator();
    }

    @Override
    IncrementalScopeCreator getScopeCreator() {
        return this.scopeCreator;
    }

    @Override
    void putScopeCreator(IncrementalScopeCreator creator) {
        this.scopeCreator = creator;
    }

    DefaultPassConfig ensureDefaultPassConfig() {
        PassConfig passes = this.getPassConfig().getBasePassConfig();
        Preconditions.checkState((boolean)(passes instanceof DefaultPassConfig), (Object)"PassConfigs must eventually delegate to the DefaultPassConfig");
        return (DefaultPassConfig)passes;
    }

    public SymbolTable buildKnownSymbolTable() {
        SymbolTable symbolTable = new SymbolTable(this, this.getTypeRegistry());
        MemoizedTypedScopeCreator typedScopeCreator = this.getTypedScopeCreator();
        if (typedScopeCreator != null) {
            symbolTable.addScopes(typedScopeCreator.getAllMemoizedScopes());
            symbolTable.addSymbolsFrom(typedScopeCreator);
        } else {
            symbolTable.findScopes(this.externsRoot, this.jsRoot);
        }
        GlobalNamespace globalNamespace = this.ensureDefaultPassConfig().getGlobalNamespace();
        if (globalNamespace != null) {
            symbolTable.addSymbolsFrom(globalNamespace);
        }
        ReferenceCollectingCallback refCollector = new ReferenceCollectingCallback(this, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, SyntacticScopeCreator.makeUntyped(this));
        refCollector.process(this.getRoot());
        symbolTable.addSymbolsFrom(refCollector);
        PreprocessorSymbolTable preprocessorSymbolTable = this.ensureDefaultPassConfig().getPreprocessorSymbolTable();
        if (preprocessorSymbolTable != null) {
            symbolTable.addSymbolsFrom(preprocessorSymbolTable);
        }
        symbolTable.fillNamespaceReferences();
        symbolTable.fillPropertyScopes();
        symbolTable.fillThisReferences(this.externsRoot, this.jsRoot);
        symbolTable.fillPropertySymbols(this.externsRoot, this.jsRoot);
        symbolTable.fillJSDocInfo(this.externsRoot, this.jsRoot);
        symbolTable.fillSymbolVisibility(this.externsRoot, this.jsRoot);
        symbolTable.removeGeneratedSymbols();
        return symbolTable;
    }

    @Override
    public TypedScope getTopScope() {
        return this.getPassConfig().getTopScope();
    }

    @Override
    public ReverseAbstractInterpreter getReverseAbstractInterpreter() {
        if (this.abstractInterpreter == null) {
            ChainableReverseAbstractInterpreter interpreter = new SemanticReverseAbstractInterpreter(this.getTypeRegistry());
            if (this.options.closurePass) {
                interpreter = new ClosureReverseAbstractInterpreter(this.getTypeRegistry()).append(interpreter).getFirst();
            }
            this.abstractInterpreter = interpreter;
        }
        return this.abstractInterpreter;
    }

    @Override
    TypeValidator getTypeValidator() {
        if (this.typeValidator == null) {
            this.typeValidator = new TypeValidator(this);
        }
        return this.typeValidator;
    }

    @Override
    Iterable<TypeMismatch> getTypeMismatches() {
        switch (this.mostRecentTypechecker) {
            case OTI: {
                return this.getTypeValidator().getMismatches();
            }
            case NTI: {
                return this.getGlobalTypeInfo().getMismatches();
            }
        }
        throw new RuntimeException("Can't ask for type mismatches before type checking.");
    }

    @Override
    Iterable<TypeMismatch> getImplicitInterfaceUses() {
        switch (this.mostRecentTypechecker) {
            case OTI: {
                return this.getTypeValidator().getImplicitInterfaceUses();
            }
            case NTI: {
                return this.getGlobalTypeInfo().getImplicitInterfaceUses();
            }
        }
        throw new RuntimeException("Can't ask for type mismatches before type checking.");
    }

    GlobalTypeInfo getGlobalTypeInfo() {
        if (this.globalTypeInfo == null) {
            this.globalTypeInfo = new GlobalTypeInfo(this, this.forwardDeclaredTypes);
        }
        return this.globalTypeInfo;
    }

    @Override
    DefinitionUseSiteFinder getDefinitionFinder() {
        return this.defFinder;
    }

    @Override
    void setDefinitionFinder(DefinitionUseSiteFinder defFinder) {
        this.defFinder = defFinder;
    }

    public void maybeSetTracker() {
        if (this.options.getTracerMode().isOn()) {
            PrintStream tracerOutput = this.options.getTracerOutput() == null ? this.outStream : this.options.getTracerOutput();
            this.tracker = new PerformanceTracker(this.externsRoot, this.jsRoot, this.options.getTracerMode(), tracerOutput);
            this.addChangeHandler(this.tracker.getCodeChangeHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node parseInputs() {
        boolean devMode = this.options.devMode != CompilerOptions.DevMode.OFF;
        this.externsRoot.detachChildren();
        this.jsRoot.detachChildren();
        Tracer tracer = this.newTracer("parseInputs");
        this.beforePass("parseInputs");
        try {
            Object object;
            if (this.options.numParallelThreads > 1) {
                new PrebuildAst(this, this.options.numParallelThreads).prebuild(this.externs);
            }
            for (CompilerInput compilerInput : this.externs) {
                Node node = compilerInput.getAstRoot(this);
                if (this.hasErrors()) {
                    Node node2 = null;
                    return node2;
                }
                this.externsRoot.addChildToBack(node);
            }
            if (this.options.needsTranspilationFrom(FeatureSet.ES6_MODULES) || this.options.transformAMDToCJSModules || this.options.processCommonJSModules) {
                this.moduleLoader = new ModuleLoader(this, this.options.moduleRoots, this.inputs, ModuleLoader.PathResolver.RELATIVE, this.options.moduleResolutionMode, null);
                if (this.options.moduleResolutionMode == ModuleLoader.ResolutionMode.NODE) {
                    this.moduleLoader = new ModuleLoader(this, this.options.moduleRoots, this.inputs, ModuleLoader.PathResolver.RELATIVE, this.options.moduleResolutionMode, this.processJsonInputs(this.inputs));
                }
                if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
                    this.parsePotentialModules(this.inputs);
                }
                if (this.options.transformAMDToCJSModules || this.options.processCommonJSModules) {
                    this.processAMDAndCommonJSModules();
                }
                HashMap<String, CompilerInput> inputModuleIdentifiers = new HashMap<String, CompilerInput>();
                for (CompilerInput compilerInput : this.inputs) {
                    if (!compilerInput.getKnownProvides().isEmpty()) continue;
                    ModuleLoader.ModulePath modPath = this.moduleLoader.resolve(compilerInput.getSourceFile().getOriginalPath());
                    inputModuleIdentifiers.put(modPath.toModuleName(), compilerInput);
                }
                HashMap hashMap = new HashMap();
                for (CompilerInput input2 : this.inputs) {
                    for (String require : input2.getKnownRequires()) {
                        if (!inputModuleIdentifiers.containsKey(require) || hashMap.containsKey(require)) continue;
                        hashMap.put(require, inputModuleIdentifiers.get(require));
                    }
                }
                if (!hashMap.isEmpty()) {
                    this.forceToEs6Modules(hashMap.values());
                }
            } else {
                this.moduleLoader = ModuleLoader.EMPTY;
            }
            this.orderInputs();
            if (this.hasErrors()) {
                object = null;
                return object;
            }
            if (this.options.numParallelThreads > 1) {
                new PrebuildAst(this, this.options.numParallelThreads).prebuild(this.inputs);
            }
            for (CompilerInput compilerInput : this.inputs) {
                Node node = compilerInput.getAstRoot(this);
                if (node == null) continue;
                if (devMode) {
                    this.runSanityCheck();
                    if (this.hasErrors()) {
                        CompilerInput input2;
                        input2 = null;
                        return input2;
                    }
                }
                if (this.options.sourceMapOutputPath != null || this.options.isExternExportsEnabled() || this.options.externExportsPath != null || !this.options.replaceStringsFunctionDescriptions.isEmpty()) {
                    SourceInformationAnnotator sia = new SourceInformationAnnotator(compilerInput.getName(), this.options.devMode != CompilerOptions.DevMode.OFF);
                    NodeTraversal.traverseEs6(this, node, sia);
                }
                this.jsRoot.addChildToBack(node);
            }
            if (this.hasErrors()) {
                object = null;
                return object;
            }
            object = this.externAndJsRoot;
            return object;
        }
        finally {
            this.afterPass("parseInputs");
            this.stopTracer(tracer, "parseInputs");
        }
    }

    void orderInputsWithLargeStack() {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("orderInputsWithLargeStack");
                try {
                    Compiler.this.orderInputs();
                }
                finally {
                    Compiler.this.stopTracer(tracer, "orderInputsWithLargeStack");
                }
                return null;
            }
        });
    }

    void orderInputs() {
        this.hoistExterns();
        boolean staleInputs = false;
        if (this.options.dependencyOptions.needsManagement()) {
            for (CompilerInput input : this.inputs) {
                for (String provide : input.getProvides()) {
                    this.forwardDeclareType(provide);
                }
            }
            try {
                this.inputs = this.getDegenerateModuleGraph().manageDependencies(this.options.dependencyOptions, this.inputs);
                staleInputs = true;
            }
            catch (SortedDependencies.MissingProvideException e) {
                this.report(JSError.make(MISSING_ENTRY_ERROR, e.getMessage()));
            }
            catch (JSModuleGraph.MissingModuleException e) {
                this.report(JSError.make(MISSING_MODULE_ERROR, e.getMessage()));
            }
        }
        if (this.options.allowIjsInputs()) {
            this.hoistIjsFiles();
        }
        this.hoistNoCompileFiles();
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    void hoistExterns() {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            if (this.options.dependencyOptions.needsManagement() && (!input.getProvides().isEmpty() || !input.getRequires().isEmpty()) || !this.hoistIfExtern(input)) continue;
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    void hoistIjsFiles() {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            if (!this.hoistIfTypeSummary(input)) continue;
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private boolean hoistIfExtern(CompilerInput input) {
        Node n = input.getAstRoot(this);
        if (n == null) {
            return false;
        }
        JSDocInfo info = n.getJSDocInfo();
        if (info != null && info.isExterns()) {
            this.externsRoot.addChildToBack(n);
            input.setIsExtern(true);
            input.getModule().remove(input);
            this.externs.add(input);
            return true;
        }
        return false;
    }

    private boolean hoistIfTypeSummary(CompilerInput input) {
        Node n = input.getAstRoot(this);
        if (n == null) {
            return false;
        }
        JSDocInfo info = n.getJSDocInfo();
        if (info != null && info.isTypeSummary()) {
            this.externsRoot.addChildToBack(n);
            input.setIsExtern(true);
            input.getModule().remove(input);
            this.externs.add(input);
            return true;
        }
        return false;
    }

    void hoistNoCompileFiles() {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            JSDocInfo info;
            Node n = input.getAstRoot(this);
            if (n == null || (info = n.getJSDocInfo()) == null || !info.isNoCompile()) continue;
            input.getModule().remove(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void repartitionInputs() {
        Compiler.fillEmptyModules(this.modules);
        this.rebuildInputsFromModules();
    }

    Map<String, String> processJsonInputs(List<CompilerInput> inputsToProcess) {
        RewriteJsonToModule rewriteJson = new RewriteJsonToModule(this);
        for (CompilerInput input : inputsToProcess) {
            if (!input.getSourceFile().getOriginalPath().endsWith(".json")) continue;
            input.setCompiler(this);
            try {
                input.getSourceFile().setCode("(" + input.getSourceFile().getCode() + ")");
            }
            catch (IOException e) {
                continue;
            }
            Node root = input.getAstRoot(this);
            if (root == null) continue;
            rewriteJson.process(null, root);
        }
        return rewriteJson.getPackageJsonMainEntries();
    }

    void forceToEs6Modules(Collection<CompilerInput> inputsToProcess) {
        for (CompilerInput input : inputsToProcess) {
            input.setCompiler(this);
            input.addProvide(input.getPath().toModuleName());
            Node root = input.getAstRoot(this);
            if (root == null) continue;
            Es6RewriteModules moduleRewriter = new Es6RewriteModules(this);
            moduleRewriter.forceToEs6Module(root);
        }
    }

    private List<CompilerInput> parsePotentialModules(List<CompilerInput> inputsToProcess) {
        ArrayList<CompilerInput> filteredInputs = new ArrayList<CompilerInput>();
        for (CompilerInput input : inputsToProcess) {
            if (this.options.dependencyOptions.shouldPruneDependencies() && JsFileParser.isSupported() && !"es6".equals(input.getLoadFlags().get((Object)"module"))) continue;
            filteredInputs.add(input);
        }
        if (this.options.numParallelThreads > 1) {
            new PrebuildAst(this, this.options.numParallelThreads).prebuild(filteredInputs);
        }
        for (CompilerInput input : filteredInputs) {
            input.setCompiler(this);
            input.getRequires();
        }
        return filteredInputs;
    }

    void processAMDAndCommonJSModules() {
        for (CompilerInput input : this.inputs) {
            input.setCompiler(this);
            Node root = input.getAstRoot(this);
            if (root == null) continue;
            if (this.options.transformAMDToCJSModules) {
                new TransformAMDToCJSModule(this).process(null, root);
            }
            if (!this.options.processCommonJSModules) continue;
            ProcessCommonJSModules cjs = new ProcessCommonJSModules(this, true);
            cjs.process(null, root);
        }
    }

    public Node parse(SourceFile file) {
        this.initCompilerOptionsIfTesting();
        this.addToDebugLog("Parsing: " + file.getName());
        return new JsAst(file).getAstRoot(this);
    }

    protected CompilerOptions newCompilerOptions() {
        return new CompilerOptions();
    }

    void initCompilerOptionsIfTesting() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
        }
    }

    @Override
    Node parseSyntheticCode(String js) {
        return this.parseSyntheticCode(" [synthetic:" + ++this.syntheticCodeId + "] ", js);
    }

    @Override
    Node parseSyntheticCode(String fileName, String js) {
        this.initCompilerOptionsIfTesting();
        SourceFile source = SourceFile.fromCode(fileName, js);
        this.addFilesToSourceMap((Iterable<? extends SourceFile>)ImmutableList.of((Object)source));
        return this.parseCodeHelper(source);
    }

    @Override
    @VisibleForTesting
    Node parseTestCode(String js) {
        this.initCompilerOptionsIfTesting();
        this.initBasedOnOptions();
        return this.parseCodeHelper(SourceFile.fromCode("[testcode]", js));
    }

    private Node parseCodeHelper(SourceFile src) {
        CompilerInput input = new CompilerInput(src);
        this.putCompilerInput(input.getInputId(), input);
        return input.getAstRoot(this);
    }

    @Override
    ErrorReporter getDefaultErrorReporter() {
        return this.oldErrorReporter;
    }

    @Override
    public String toSource() {
        return this.runInCompilerThread(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSource");
                try {
                    CodeBuilder cb = new CodeBuilder();
                    if (Compiler.this.jsRoot != null) {
                        Node scriptNode;
                        int i = 0;
                        if (Compiler.this.options.shouldPrintExterns()) {
                            for (scriptNode = Compiler.this.externsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                                Compiler.this.toSource(cb, i++, scriptNode);
                            }
                        }
                        for (scriptNode = Compiler.this.jsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                            Compiler.this.toSource(cb, i++, scriptNode);
                        }
                    }
                    String string = cb.toString();
                    return string;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSource");
                }
            }
        });
    }

    public String[] toSourceArray() {
        return this.runInCompilerThread(new Callable<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSourceArray");
                try {
                    int numInputs = Compiler.this.inputs.size();
                    String[] sources = new String[numInputs];
                    CodeBuilder cb = new CodeBuilder();
                    for (int i = 0; i < numInputs; ++i) {
                        Node scriptNode = ((CompilerInput)Compiler.this.inputs.get(i)).getAstRoot(Compiler.this);
                        cb.reset();
                        Compiler.this.toSource(cb, i, scriptNode);
                        sources[i] = cb.toString();
                    }
                    String[] stringArray = sources;
                    return stringArray;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSourceArray");
                }
            }
        });
    }

    public String toSource(final JSModule module) {
        return this.runInCompilerThread(new Callable<String>(){

            @Override
            public String call() throws Exception {
                List<CompilerInput> inputs = module.getInputs();
                int numInputs = inputs.size();
                if (numInputs == 0) {
                    return "";
                }
                CodeBuilder cb = new CodeBuilder();
                for (int i = 0; i < numInputs; ++i) {
                    Node scriptNode = inputs.get(i).getAstRoot(Compiler.this);
                    if (scriptNode == null) {
                        throw new IllegalArgumentException("Bad module: " + module.getName());
                    }
                    Compiler.this.toSource(cb, i, scriptNode);
                }
                return cb.toString();
            }
        });
    }

    public String[] toSourceArray(final JSModule module) {
        return this.runInCompilerThread(new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                List<CompilerInput> inputs = module.getInputs();
                int numInputs = inputs.size();
                if (numInputs == 0) {
                    return new String[0];
                }
                String[] sources = new String[numInputs];
                CodeBuilder cb = new CodeBuilder();
                for (int i = 0; i < numInputs; ++i) {
                    Node scriptNode = inputs.get(i).getAstRoot(Compiler.this);
                    if (scriptNode == null) {
                        throw new IllegalArgumentException("Bad module input: " + inputs.get(i).getName());
                    }
                    cb.reset();
                    Compiler.this.toSource(cb, i, scriptNode);
                    sources[i] = cb.toString();
                }
                return sources;
            }
        });
    }

    public void toSource(final CodeBuilder cb, final int inputSeqNum, final Node root) {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String code;
                String license;
                if (Compiler.this.options.printInputDelimiter) {
                    if (cb.getLength() > 0 && !cb.endsWith("\n")) {
                        cb.append("\n");
                    }
                    Preconditions.checkState((boolean)root.isScript());
                    String delimiter = Compiler.this.options.inputDelimiter;
                    String inputName = root.getInputId().getIdName();
                    String sourceName = root.getSourceFileName();
                    Preconditions.checkState((sourceName != null ? 1 : 0) != 0);
                    Preconditions.checkState((!sourceName.isEmpty() ? 1 : 0) != 0);
                    delimiter = delimiter.replace("%name%", Matcher.quoteReplacement(inputName)).replace("%num%", String.valueOf(inputSeqNum)).replace("%n%", "\n");
                    cb.append(delimiter).append("\n");
                }
                if (root.getJSDocInfo() != null && (license = root.getJSDocInfo().getLicense()) != null && cb.addLicense(license)) {
                    cb.append("/*\n").append(license).append("*/\n");
                }
                if (Compiler.this.options.sourceMapOutputPath != null) {
                    Compiler.this.sourceMap.setStartingPosition(cb.getLineIndex(), cb.getColumnIndex());
                }
                if (!(code = Compiler.this.toSource(root, Compiler.this.sourceMap, inputSeqNum == 0)).isEmpty()) {
                    boolean hasSemiColon;
                    cb.append(code);
                    int length = code.length();
                    char lastChar = code.charAt(length - 1);
                    char secondLastChar = length >= 2 ? code.charAt(length - 2) : (char)'\u0000';
                    boolean bl = hasSemiColon = lastChar == ';' || lastChar == '\n' && secondLastChar == ';';
                    if (!hasSemiColon) {
                        cb.append(";");
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String toSource(Node n) {
        this.initCompilerOptionsIfTesting();
        return this.toSource(n, null, true);
    }

    private String toSource(Node n, SourceMap sourceMap, boolean firstOutput) {
        CodePrinter.Builder builder = new CodePrinter.Builder(n);
        builder.setTypeRegistry(this.getTypeIRegistry());
        builder.setCompilerOptions(this.options);
        builder.setSourceMap(sourceMap);
        builder.setTagAsExterns(firstOutput && n.isFromExterns());
        builder.setTagAsTypeSummary(firstOutput && !n.isFromExterns() && this.options.shouldGenerateTypedExterns());
        builder.setTagAsStrict(firstOutput && this.options.shouldEmitUseStrict());
        return builder.build();
    }

    void performOptimizations() {
        Preconditions.checkState((boolean)this.options.shouldOptimize());
        List<PassFactory> optimizations = this.getPassConfig().getOptimizations();
        if (optimizations.isEmpty()) {
            return;
        }
        this.phaseOptimizer = this.createPhaseOptimizer();
        this.phaseOptimizer.consume(optimizations);
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        this.phaseOptimizer = null;
    }

    @Override
    void setCssRenamingMap(CssRenamingMap map) {
        this.options.cssRenamingMap = map;
    }

    @Override
    CssRenamingMap getCssRenamingMap() {
        return this.options.cssRenamingMap;
    }

    ControlFlowGraph<Node> computeCFG() {
        logger.fine("Computing Control Flow Graph");
        Tracer tracer = this.newTracer("computeCFG");
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
        this.process(cfa);
        this.stopTracer(tracer, "computeCFG");
        return cfa.getCfg();
    }

    @Override
    void prepareAst(Node root) {
        PrepareAst pass = new PrepareAst(this);
        pass.process(null, root);
    }

    void recordFunctionInformation() {
        logger.fine("Recording function information");
        this.startPass("recordFunctionInformation");
        RecordFunctionInformation recordFunctionInfoPass = new RecordFunctionInformation(this, this.functionNames);
        this.process(recordFunctionInfoPass);
        this.functionInformationMap = recordFunctionInfoPass.getMap();
        this.endPass("recordFunctionInformation");
    }

    @Override
    void addChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.add(handler);
    }

    @Override
    void removeChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.remove(handler);
    }

    @Override
    void addIndexProvider(IndexProvider<?> indexProvider) {
        Class<?> type = indexProvider.getType();
        if (this.indexProvidersByType.put(type, indexProvider) != null) {
            throw new IllegalStateException("A provider is already registered for index of type " + type.getSimpleName());
        }
    }

    @Override
    <T> T getIndex(Class<T> key) {
        IndexProvider<?> indexProvider = this.indexProvidersByType.get(key);
        if (indexProvider == null) {
            return null;
        }
        return (T)indexProvider.get();
    }

    Node getExternsRoot() {
        return this.externsRoot;
    }

    @Override
    Node getJsRoot() {
        return this.jsRoot;
    }

    @VisibleForTesting
    void setPhaseOptimizer(PhaseOptimizer po) {
        this.phaseOptimizer = po;
    }

    @Override
    public int getChangeStamp() {
        return this.changeStamp;
    }

    @Override
    List<Node> getChangedScopeNodesForPass(String passName) {
        List<Node> changedScopeNodes = this.changeTimeline.getSince(passName);
        this.changeTimeline.mark(passName);
        return changedScopeNodes;
    }

    @Override
    List<Node> getDeletedScopeNodesForPass(String passName) {
        List<Node> deletedScopeNodes = this.deleteTimeline.getSince(passName);
        this.deleteTimeline.mark(passName);
        return deletedScopeNodes;
    }

    @Override
    public void incrementChangeStamp() {
        ++this.changeStamp;
    }

    @Override
    void setChangeScope(Node newChangeScopeRoot) {
        this.currentChangeScope = newChangeScopeRoot;
    }

    private Node getChangeScopeForNode(Node n) {
        if (n.isScript()) {
            return n;
        }
        Node enclosingScopeNode = NodeUtil.getEnclosingChangeScopeRoot(n.getParent());
        if (enclosingScopeNode == null) {
            throw new IllegalStateException("An enclosing scope is required for change reports but node " + n + " doesn't have one.");
        }
        return enclosingScopeNode;
    }

    private void recordChange(Node n) {
        if (n.isDeleted()) {
            return;
        }
        n.setChangeTime(this.changeStamp);
        ++this.changeStamp;
        this.changeTimeline.add(n);
    }

    @Override
    boolean hasScopeChanged(Node n) {
        if (this.phaseOptimizer == null) {
            return true;
        }
        return this.phaseOptimizer.hasScopeChanged(n);
    }

    @Override
    @Deprecated
    public void reportCodeChange() {
        if (this.currentChangeScope != null) {
            Preconditions.checkState((this.currentChangeScope.isScript() || this.currentChangeScope.isFunction() ? 1 : 0) != 0);
            this.recordChange(this.currentChangeScope);
        }
        this.notifyChangeHandlers();
    }

    @Override
    public void reportChangeToChangeScope(Node changeScopeRoot) {
        Preconditions.checkState((changeScopeRoot.isScript() || changeScopeRoot.isFunction() ? 1 : 0) != 0);
        this.recordChange(changeScopeRoot);
        this.notifyChangeHandlers();
    }

    @Override
    public void reportFunctionDeleted(Node n) {
        Preconditions.checkState((boolean)n.isFunction());
        n.setDeleted(true);
        this.changeTimeline.remove(n);
        this.deleteTimeline.add(n);
    }

    @Override
    public void reportChangeToEnclosingScope(Node n) {
        this.recordChange(this.getChangeScopeForNode(n));
        this.notifyChangeHandlers();
    }

    private void notifyChangeHandlers() {
        for (CodeChangeHandler handler : this.codeChangeHandlers) {
            handler.reportChange();
        }
    }

    @Override
    public CodingConvention getCodingConvention() {
        CodingConvention convention = this.options.getCodingConvention();
        convention = convention != null ? convention : this.defaultCodingConvention;
        return convention;
    }

    private Config.LanguageMode getParserConfigLanguageMode(CompilerOptions.LanguageMode languageMode) {
        switch (languageMode) {
            case ECMASCRIPT3: {
                return Config.LanguageMode.ECMASCRIPT3;
            }
            case ECMASCRIPT5: 
            case ECMASCRIPT5_STRICT: {
                return Config.LanguageMode.ECMASCRIPT5;
            }
            case ECMASCRIPT_2015: {
                return Config.LanguageMode.ECMASCRIPT6;
            }
            case ECMASCRIPT6_TYPED: {
                return Config.LanguageMode.TYPESCRIPT;
            }
            case ECMASCRIPT_2016: {
                return Config.LanguageMode.ECMASCRIPT7;
            }
            case ECMASCRIPT_2017: 
            case ECMASCRIPT_NEXT: {
                return Config.LanguageMode.ECMASCRIPT8;
            }
        }
        throw new IllegalStateException("Unexpected language mode: " + (Object)((Object)this.options.getLanguageIn()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Config getParserConfig(AbstractCompiler.ConfigContext context) {
        if (this.parserConfig == null || this.externsParserConfig == null) {
            Compiler compiler = this;
            synchronized (compiler) {
                if (this.parserConfig == null) {
                    Config.LanguageMode configLanguageMode = this.getParserConfigLanguageMode(this.options.getLanguageIn());
                    Config.StrictMode strictMode = this.options.expectStrictModeInput() ? Config.StrictMode.STRICT : Config.StrictMode.SLOPPY;
                    this.parserConfig = this.createConfig(configLanguageMode, strictMode);
                    this.externsParserConfig = configLanguageMode.equals((Object)Config.LanguageMode.ECMASCRIPT3) ? this.createConfig(Config.LanguageMode.ECMASCRIPT5, strictMode) : this.parserConfig;
                }
            }
        }
        switch (context) {
            case EXTERNS: {
                return this.externsParserConfig;
            }
        }
        return this.parserConfig;
    }

    protected Config createConfig(Config.LanguageMode mode, Config.StrictMode strictMode) {
        Config config = ParserRunner.createConfig(mode, this.options.isParseJsDocDocumentation(), this.options.canContinueAfterErrors() ? Config.RunMode.KEEP_GOING : Config.RunMode.STOP_AFTER_ERROR, this.options.extraAnnotationNames, this.options.parseInlineSourceMaps, strictMode);
        return config;
    }

    protected DiagnosticGroups getDiagnosticGroups() {
        return new DiagnosticGroups();
    }

    @Override
    public void report(JSError error) {
        CheckLevel newLevel;
        CheckLevel level = error.getDefaultLevel();
        if (this.warningsGuard != null && (newLevel = this.warningsGuard.level(error)) != null) {
            level = newLevel;
        }
        if (level.isOn()) {
            this.initCompilerOptionsIfTesting();
            if (this.getOptions().errorHandler != null) {
                this.getOptions().errorHandler.report(level, error);
            }
            this.errorManager.report(level, error);
        }
    }

    @Override
    public void report(CheckLevel ignoredLevel, JSError error) {
        this.report(error);
    }

    @Override
    public CheckLevel getErrorLevel(JSError error) {
        Preconditions.checkNotNull((Object)this.options);
        return this.warningsGuard.level(error);
    }

    @Override
    void throwInternalError(String message, Throwable cause) {
        String finalMessage = "INTERNAL COMPILER ERROR.\nPlease report this problem.\n\n" + message;
        RuntimeException e = new RuntimeException(finalMessage, cause);
        if (cause != null) {
            e.setStackTrace(cause.getStackTrace());
        }
        throw e;
    }

    public int getErrorCount() {
        return this.errorManager.getErrorCount();
    }

    public int getWarningCount() {
        return this.errorManager.getWarningCount();
    }

    @Override
    boolean hasHaltingErrors() {
        return !this.getOptions().canContinueAfterErrors() && this.getErrorCount() > 0;
    }

    public boolean hasErrors() {
        return this.hasHaltingErrors();
    }

    @Override
    void addToDebugLog(String ... strings) {
        if (this.options.useDebugLog) {
            String log = Joiner.on((String)"").join((Object[])strings);
            this.debugLog.append(log);
            this.debugLog.append('\n');
            logger.fine(log);
        }
    }

    @Override
    SourceFile getSourceFileByName(String sourceName) {
        if (sourceName != null) {
            CompilerInput input = this.inputsById.get(new InputId(sourceName));
            if (input != null) {
                return input.getSourceFile();
            }
            return this.sourceMapOriginalSources.get(sourceName);
        }
        return null;
    }

    public CharSequence getSourceFileContentByName(String sourceName) {
        SourceFile file = this.getSourceFileByName(sourceName);
        Preconditions.checkNotNull((Object)file);
        try {
            return file.getCode();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void addInputSourceMap(String sourceFileName, SourceMapInput inputSourceMap) {
        this.inputSourceMaps.put(sourceFileName, inputSourceMap);
    }

    @Override
    @Nullable
    public Mapping.OriginalMapping getSourceMapping(String sourceName, int lineNumber, int columnNumber) {
        if (sourceName == null) {
            return null;
        }
        SourceMapInput sourceMap = this.inputSourceMaps.get(sourceName);
        if (sourceMap == null) {
            return null;
        }
        SourceMapConsumerV3 consumer = sourceMap.getSourceMap(this.errorManager);
        if (consumer == null) {
            return null;
        }
        Mapping.OriginalMapping result = consumer.getMappingForLine(lineNumber, columnNumber + 1);
        if (result == null) {
            return null;
        }
        SourceFile source = SourceMapResolver.getRelativePath(sourceMap.getOriginalPath(), result.getOriginalFile());
        if (source == null) {
            return null;
        }
        String originalPath = source.getOriginalPath();
        this.sourceMapOriginalSources.putIfAbsent(originalPath, source);
        return result.toBuilder().setOriginalFile(originalPath).setColumnPosition(result.getColumnPosition() - 1).build();
    }

    @Override
    public String getSourceLine(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLine(lineNumber);
        }
        return null;
    }

    @Override
    public Region getSourceRegion(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getRegion(lineNumber);
        }
        return null;
    }

    @Override
    Node getNodeForCodeInsertion(JSModule module) {
        if (module == null) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("No inputs");
            }
            return this.inputs.get(0).getAstRoot(this);
        }
        List<CompilerInput> moduleInputs = module.getInputs();
        if (!moduleInputs.isEmpty()) {
            return moduleInputs.get(0).getAstRoot(this);
        }
        throw new IllegalStateException("Root module has no inputs");
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Override
    public void setVariableMap(VariableMap variableMap) {
        this.variableMap = variableMap;
    }

    VariableMap getVariableMap() {
        return this.variableMap;
    }

    @Override
    public void setPropertyMap(VariableMap propertyMap) {
        this.propertyMap = propertyMap;
    }

    VariableMap getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public void setStringMap(VariableMap stringMap) {
        this.stringMap = stringMap;
    }

    @Override
    public void setFunctionNames(FunctionNames functionNames) {
        this.functionNames = functionNames;
    }

    @Override
    public void setCssNames(Map<String, Integer> cssNames) {
        this.cssNames = cssNames;
    }

    Map<String, Integer> getCssNames() {
        return this.cssNames;
    }

    @Override
    public void setIdGeneratorMap(String serializedIdMappings) {
        this.idGeneratorMap = serializedIdMappings;
    }

    @Override
    public IdGenerator getCrossModuleIdGenerator() {
        return this.crossModuleIdGenerator;
    }

    @Override
    public void setAnonymousFunctionNameMap(VariableMap functionMap) {
        this.anonymousFunctionNameMap = functionMap;
    }

    @Override
    public FunctionNames getFunctionNames() {
        return this.functionNames;
    }

    VariableMap getStringMap() {
        return this.stringMap;
    }

    @Override
    public void addExportedNames(Set<String> exportedNames) {
        this.exportedNames.addAll(exportedNames);
    }

    @Override
    public Set<String> getExportedNames() {
        return this.exportedNames;
    }

    @Override
    CompilerOptions getOptions() {
        return this.options;
    }

    FunctionInformationMap getFunctionalInformationMap() {
        return this.functionInformationMap;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public String getAstDotGraph() throws IOException {
        if (this.jsRoot != null) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
            cfa.process(null, this.jsRoot);
            return DotFormatter.toDot(this.jsRoot, cfa.getCfg());
        }
        return "";
    }

    @Override
    public ErrorManager getErrorManager() {
        if (this.options == null) {
            this.initOptions(new CompilerOptions());
        }
        return this.errorManager;
    }

    @Override
    List<CompilerInput> getInputsInOrder() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    int getNumberOfInputs() {
        return this.inputs != null ? this.inputs.size() : 1;
    }

    public Map<InputId, CompilerInput> getInputsById() {
        return Collections.unmodifiableMap(this.inputsById);
    }

    List<CompilerInput> getExternsInOrder() {
        return Collections.unmodifiableList(this.externs);
    }

    @VisibleForTesting
    List<CompilerInput> getInputsForTesting() {
        return this.inputs;
    }

    @VisibleForTesting
    List<CompilerInput> getExternsForTesting() {
        return this.externs;
    }

    @Override
    boolean hasRegExpGlobalReferences() {
        return this.hasRegExpGlobalReferences;
    }

    @Override
    void setHasRegExpGlobalReferences(boolean references) {
        this.hasRegExpGlobalReferences = references;
    }

    @Override
    void updateGlobalVarReferences(Map<Var, ReferenceCollection> refMapPatch, Node collectionRoot) {
        Preconditions.checkState((collectionRoot.isScript() || collectionRoot.isRoot() ? 1 : 0) != 0);
        if (this.globalRefMap == null) {
            this.globalRefMap = new GlobalVarReferenceMap(this.getInputsInOrder(), this.getExternsInOrder());
        }
        this.globalRefMap.updateGlobalVarReferences(refMapPatch, collectionRoot);
    }

    @Override
    GlobalVarReferenceMap getGlobalVarReferences() {
        return this.globalRefMap;
    }

    @Override
    CompilerInput getSynthesizedExternsInput() {
        if (this.synthesizedExternsInput == null) {
            this.synthesizedExternsInput = this.newExternInput(SYNTHETIC_EXTERNS, SyntheticExternsPosition.START);
        }
        return this.synthesizedExternsInput;
    }

    @Override
    CompilerInput getSynthesizedExternsInputAtEnd() {
        if (this.synthesizedExternsInputAtEnd == null) {
            this.synthesizedExternsInputAtEnd = this.newExternInput(SYNTHETIC_EXTERNS_AT_END, SyntheticExternsPosition.END);
        }
        return this.synthesizedExternsInputAtEnd;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    String getLastPassName() {
        return this.lastPassName;
    }

    @Override
    void setProgress(double newProgress, String passName) {
        this.lastPassName = passName;
        this.progress = newProgress > 1.0 ? 1.0 : newProgress;
    }

    @Override
    void setExternProperties(Set<String> externProperties) {
        this.externProperties = externProperties;
    }

    @Override
    Set<String> getExternProperties() {
        return this.externProperties;
    }

    public void replaceScript(JsAst ast) {
        CompilerInput input = this.getInput(ast.getInputId());
        if (!this.replaceIncrementalSourceAst(ast)) {
            return;
        }
        Node originalRoot = input.getAstRoot(this);
        this.processNewScript(ast, originalRoot);
    }

    public void addNewScript(JsAst ast) {
        if (!this.addNewSourceAst(ast)) {
            return;
        }
        Node emptyScript = new Node(Token.SCRIPT);
        InputId inputId = ast.getInputId();
        emptyScript.setInputId(inputId);
        emptyScript.setStaticSourceFile(SourceFile.fromCode(inputId.getIdName(), ""));
        this.processNewScript(ast, emptyScript);
    }

    private void processNewScript(JsAst ast, Node originalRoot) {
        this.setFeatureSet(this.options.getLanguageIn().toFeatureSet());
        Node js = ast.getAstRoot(this);
        Preconditions.checkNotNull((Object)js);
        this.runHotSwap(originalRoot, js, this.getCleanupPassConfig());
        this.runHotSwapPass(null, null, this.ensureDefaultPassConfig().garbageCollectChecks);
        this.getTypeRegistry().clearNamedTypes();
        this.removeSyntheticVarsInput();
        this.runHotSwap(originalRoot, js, this.ensureDefaultPassConfig());
    }

    private void runHotSwap(Node originalRoot, Node js, PassConfig passConfig) {
        for (PassFactory passFactory : passConfig.getChecks()) {
            this.runHotSwapPass(originalRoot, js, passFactory);
        }
    }

    private void runHotSwapPass(Node originalRoot, Node js, PassFactory passFactory) {
        HotSwapCompilerPass pass = passFactory.getHotSwapPass(this);
        if (pass != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Performing HotSwap for pass " + passFactory.getName());
            }
            pass.hotSwapScript(js, originalRoot);
        }
    }

    private PassConfig getCleanupPassConfig() {
        return new CleanupPasses(this.getOptions());
    }

    private void removeSyntheticVarsInput() {
        String sourceName = SYNTHETIC_EXTERNS;
        this.removeExternInput(new InputId(sourceName));
    }

    @Override
    Node ensureLibraryInjected(String resourceName, boolean force) {
        boolean doNotInject;
        boolean bl = doNotInject = !force && (this.options.skipNonTranspilationPasses || this.options.preventLibraryInjection);
        if (this.injectedLibraries.containsKey(resourceName) || doNotInject) {
            return this.lastInjectedLibrary;
        }
        String originalCode = ResourceLoader.loadTextResource(Compiler.class, "js/" + resourceName + ".js");
        Node ast = this.parseSyntheticCode(" [synthetic:" + resourceName + "] ", originalCode);
        Node node = ast.getFirstChild();
        while (node != null && node.isExprResult() && node.getFirstChild().isString()) {
            String directive = node.getFirstChild().getString();
            List words = Splitter.on((char)' ').limit(2).splitToList((CharSequence)directive);
            switch ((String)words.get(0)) {
                case "use": {
                    break;
                }
                case "require": {
                    this.ensureLibraryInjected((String)words.get(1), force);
                    break;
                }
                case "declare": {
                    Node var = IR.var(IR.name((String)words.get(1)));
                    JSDocInfoBuilder jsdoc = new JSDocInfoBuilder(false);
                    jsdoc.addSuppression("duplicate");
                    var.setJSDocInfo(jsdoc.build());
                    this.getSynthesizedExternsInputAtEnd().getAstRoot(this).addChildToBack(var);
                    break;
                }
                default: {
                    throw new RuntimeException("Bad directive: " + directive);
                }
            }
            ast.removeChild(node);
            node = ast.getFirstChild();
        }
        if (this.getLifeCycleStage().isNormalized()) {
            Normalize.normalizeSyntheticCode(this, ast, "jscomp_" + resourceName + "_");
        }
        Node lastChild = ast.getLastChild();
        for (Node child = ast.getFirstChild(); child != null; child = child.getNext()) {
            NodeUtil.markNewScopesChanged(child, this);
        }
        Node firstChild = ast.removeChildren();
        if (firstChild == null) {
            return this.lastInjectedLibrary;
        }
        Node parent = this.getNodeForCodeInsertion(null);
        if (this.lastInjectedLibrary == null) {
            parent.addChildrenToFront(firstChild);
        } else {
            parent.addChildrenAfter(firstChild, this.lastInjectedLibrary);
        }
        this.lastInjectedLibrary = lastChild;
        this.injectedLibraries.put(resourceName, lastChild);
        this.reportChangeToEnclosingScope(parent);
        return lastChild;
    }

    @GwtIncompatible(value="java.util.ResourceBundle")
    public static String getReleaseVersion() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        return config.getString("compiler.version");
    }

    @GwtIncompatible(value="java.util.ResourceBundle")
    public static String getReleaseDate() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        return config.getString("compiler.date");
    }

    @Override
    void addComments(String filename, List<Comment> comments) {
        if (!this.getOptions().preservesDetailedSourceInfo()) {
            throw new UnsupportedOperationException("addComments may only be called in IDE mode.");
        }
        this.commentsPerFile.put(filename, comments);
    }

    @Override
    public List<Comment> getComments(String filename) {
        if (!this.getOptions().preservesDetailedSourceInfo()) {
            throw new UnsupportedOperationException("getComments may only be called in IDE mode.");
        }
        return this.commentsPerFile.get(filename);
    }

    @Override
    void setDefaultDefineValues(ImmutableMap<String, Node> values) {
        this.defaultDefineValues = values;
    }

    @Override
    ImmutableMap<String, Node> getDefaultDefineValues() {
        return this.defaultDefineValues;
    }

    @Override
    ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    private void addFilesToSourceMap(Iterable<? extends SourceFile> files) {
        if (this.getOptions().sourceMapIncludeSourcesContent && this.getSourceMap() != null) {
            for (SourceFile sourceFile : files) {
                this.getSourceMap().addSourceFile(sourceFile);
            }
        }
    }

    private void renameModules(List<JSModule> newModules, List<JSModule> deserializedModules) {
        if (newModules == null) {
            return;
        }
        if (newModules.size() != deserializedModules.size()) {
            this.report(JSError.make(INCONSISTENT_MODULE_DEFINITIONS, new String[0]));
            return;
        }
        for (int i = 0; i < deserializedModules.size(); ++i) {
            JSModule deserializedModule = deserializedModules.get(i);
            JSModule newModule = newModules.get(i);
            deserializedModule.setName(newModule.getName());
        }
    }

    protected CompilerExecutor createCompilerExecutor() {
        return new CompilerExecutor();
    }

    protected CompilerExecutor getCompilerExecutor() {
        return this.compilerExecutor;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    public void saveState(OutputStream outputStream) throws IOException {
        final ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("serializeCompilerState");
                objectOutputStream.writeObject(new CompilerState(Compiler.this));
                if (Compiler.this.typeRegistry != null) {
                    Compiler.this.typeRegistry.saveContents(objectOutputStream);
                }
                Compiler.this.stopTracer(tracer, "serializeCompilerState");
                return null;
            }
        });
    }

    @GwtIncompatible(value="ObjectInputStream")
    public void restoreState(InputStream inputStream) throws IOException, ClassNotFoundException {
        this.initWarningsGuard(this.options.getWarningsGuard());
        this.maybeSetTracker();
        List<JSModule> newModules = this.modules;
        class CompilerObjectInputStream
        extends ObjectInputStream
        implements HasCompiler {
            public CompilerObjectInputStream(InputStream in) throws IOException {
                super(in);
            }

            @Override
            public AbstractCompiler getCompiler() {
                return Compiler.this;
            }
        }
        final CompilerObjectInputStream objectInputStream = new CompilerObjectInputStream(inputStream);
        CompilerState compilerState = this.runInCompilerThread(new Callable<CompilerState>(){

            @Override
            public CompilerState call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("deserializeCompilerState");
                CompilerState compilerState = (CompilerState)objectInputStream.readObject();
                if (compilerState.typeRegistry != null) {
                    compilerState.typeRegistry.restoreContents(objectInputStream);
                }
                Compiler.this.stopTracer(tracer, "deserializeCompilerState");
                return compilerState;
            }
        });
        this.featureSet = compilerState.featureSet;
        this.externs = compilerState.externs;
        this.inputs = compilerState.inputs;
        this.inputsById.clear();
        this.inputsById.putAll(compilerState.inputsById);
        this.typeRegistry = compilerState.typeRegistry;
        this.externAndJsRoot = compilerState.externAndJsRoot;
        this.externsRoot = compilerState.externsRoot;
        this.jsRoot = compilerState.jsRoot;
        this.mostRecentTypechecker = compilerState.mostRecentTypeChecker;
        this.synthesizedExternsInput = compilerState.synthesizedExternsInput;
        this.synthesizedExternsInputAtEnd = compilerState.synthesizedExternsInputAtEnd;
        this.injectedLibraries.clear();
        this.injectedLibraries.putAll(compilerState.injectedLibraries);
        this.lastInjectedLibrary = compilerState.lastInjectedLibrary;
        this.globalTypeInfo = compilerState.globalTypeInfo;
        this.hasRegExpGlobalReferences = compilerState.hasRegExpGlobalReferences;
        this.typeValidator = compilerState.typeValidator;
        this.setLifeCycleStage(compilerState.lifeCycleStage);
        this.externProperties = compilerState.externProperties;
        this.moduleGraph = compilerState.moduleGraph;
        this.modules = compilerState.modules;
        this.uniqueNameId = compilerState.uniqueNameId;
        this.exportedNames.clear();
        this.exportedNames.addAll(compilerState.exportedNames);
        this.cssNames = compilerState.cssNames;
        this.variableMap = compilerState.variableMap;
        this.propertyMap = compilerState.propertyMap;
        this.stringMap = compilerState.stringMap;
        this.anonymousFunctionNameMap = compilerState.anonymousFunctionaMap;
        this.idGeneratorMap = compilerState.idGeneratorMap;
        this.crossModuleIdGenerator = compilerState.crossModuleIdGenerator;
        this.functionNames = compilerState.functioNames;
        this.defaultDefineValues = (ImmutableMap)Preconditions.checkNotNull((Object)compilerState.defaultDefineValues);
        this.annotationMap = (Map)Preconditions.checkNotNull((Object)compilerState.annotationMap);
        this.inputSourceMaps = compilerState.inputSourceMaps;
        this.changeStamp = compilerState.changeStamp;
        this.renameModules(newModules, this.modules);
        if (compilerState.errors != null) {
            for (JSError error : compilerState.errors) {
                this.report(CheckLevel.ERROR, error);
            }
        }
        if (compilerState.warnings != null) {
            for (JSError warning : compilerState.warnings) {
                this.report(CheckLevel.WARNING, warning);
            }
        }
        if (this.tracker != null) {
            this.tracker.updateAfterDeserialize(this.jsRoot);
        }
    }

    public void resetCompilerInput() {
        for (JSModule module : this.modules) {
            for (CompilerInput input : module.getInputs()) {
                input.reset();
            }
        }
    }

    private static class CompilerState
    implements Serializable {
        private final Node externAndJsRoot;
        private final Node externsRoot;
        private final Node jsRoot;
        private final FeatureSet featureSet;
        private final List<CompilerInput> externs;
        private final List<CompilerInput> inputs;
        private final Map<InputId, CompilerInput> inputsById;
        private final JSTypeRegistry typeRegistry;
        private final TypeValidator typeValidator;
        private final AbstractCompiler.MostRecentTypechecker mostRecentTypeChecker;
        private final CompilerInput synthesizedExternsInput;
        private final CompilerInput synthesizedExternsInputAtEnd;
        private final Map<String, Node> injectedLibraries;
        private final Node lastInjectedLibrary;
        private final GlobalTypeInfo globalTypeInfo;
        private final boolean hasRegExpGlobalReferences;
        private final AbstractCompiler.LifeCycleStage lifeCycleStage;
        private final Set<String> externProperties;
        private final JSError[] errors;
        private final JSError[] warnings;
        private final JSModuleGraph moduleGraph;
        private final List<JSModule> modules;
        private final int uniqueNameId;
        private final Set<String> exportedNames;
        private final Map<String, Integer> cssNames;
        private final VariableMap variableMap;
        private final VariableMap propertyMap;
        private final VariableMap anonymousFunctionaMap;
        private final FunctionNames functioNames;
        private final VariableMap stringMap;
        private final String idGeneratorMap;
        private final IdGenerator crossModuleIdGenerator;
        private final ImmutableMap<String, Node> defaultDefineValues;
        private final Map<String, Object> annotationMap;
        private final ConcurrentHashMap<String, SourceMapInput> inputSourceMaps;
        private final int changeStamp;

        CompilerState(Compiler compiler) {
            this.externsRoot = (Node)Preconditions.checkNotNull((Object)compiler.externsRoot);
            this.jsRoot = (Node)Preconditions.checkNotNull((Object)compiler.jsRoot);
            this.externAndJsRoot = (Node)Preconditions.checkNotNull((Object)compiler.externAndJsRoot);
            this.featureSet = (FeatureSet)Preconditions.checkNotNull((Object)compiler.featureSet);
            this.typeRegistry = compiler.typeRegistry;
            this.externs = compiler.externs;
            this.inputs = (List)Preconditions.checkNotNull((Object)compiler.inputs);
            this.inputsById = (Map)Preconditions.checkNotNull((Object)compiler.inputsById);
            this.mostRecentTypeChecker = compiler.mostRecentTypechecker;
            this.synthesizedExternsInput = compiler.synthesizedExternsInput;
            this.synthesizedExternsInputAtEnd = compiler.synthesizedExternsInputAtEnd;
            this.injectedLibraries = compiler.injectedLibraries;
            this.lastInjectedLibrary = compiler.lastInjectedLibrary;
            this.globalTypeInfo = compiler.globalTypeInfo;
            this.hasRegExpGlobalReferences = compiler.hasRegExpGlobalReferences;
            this.typeValidator = compiler.typeValidator;
            this.lifeCycleStage = compiler.getLifeCycleStage();
            this.externProperties = compiler.externProperties;
            this.errors = compiler.errorManager.getErrors();
            this.warnings = compiler.errorManager.getWarnings();
            this.moduleGraph = compiler.moduleGraph;
            this.modules = compiler.modules;
            this.uniqueNameId = compiler.uniqueNameId;
            this.exportedNames = compiler.exportedNames;
            this.cssNames = compiler.cssNames;
            this.variableMap = compiler.variableMap;
            this.propertyMap = compiler.propertyMap;
            this.anonymousFunctionaMap = compiler.anonymousFunctionNameMap;
            this.functioNames = compiler.functionNames;
            this.stringMap = compiler.stringMap;
            this.idGeneratorMap = compiler.idGeneratorMap;
            this.crossModuleIdGenerator = compiler.crossModuleIdGenerator;
            this.defaultDefineValues = (ImmutableMap)Preconditions.checkNotNull((Object)compiler.defaultDefineValues);
            this.annotationMap = (Map)Preconditions.checkNotNull((Object)compiler.annotationMap);
            this.inputSourceMaps = compiler.inputSourceMaps;
            this.changeStamp = compiler.changeStamp;
        }
    }

    public static class CodeBuilder {
        private final StringBuilder sb = new StringBuilder();
        private int lineCount = 0;
        private int colCount = 0;
        private final Set<String> uniqueLicenses = new HashSet<String>();

        void reset() {
            this.sb.setLength(0);
        }

        CodeBuilder append(String str) {
            int index;
            this.sb.append(str);
            int lastIndex = index = -1;
            while ((index = str.indexOf(10, index + 1)) >= 0) {
                ++this.lineCount;
                lastIndex = index;
            }
            this.colCount = lastIndex == -1 ? (this.colCount += str.length()) : str.length() - (lastIndex + 1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        int getLineIndex() {
            return this.lineCount;
        }

        int getColumnIndex() {
            return this.colCount;
        }

        boolean endsWith(String suffix) {
            return this.sb.length() > suffix.length() && suffix.equals(this.sb.substring(this.sb.length() - suffix.length()));
        }

        boolean addLicense(String license) {
            return this.uniqueLicenses.add(license);
        }
    }

    private static enum SyntheticExternsPosition {
        START,
        END;

    }

    public static class ExternalSourceLoader {
        public SourceFile loadSource(String filename) {
            throw new RuntimeException("Cannot load without a valid loader.");
        }
    }
}

