/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.LiveVariablesAnalysisEs6;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class CoalesceVariableNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final Deque<GraphColoring<Var, Void>> colorings;
    private final Deque<LiveVariablesAnalysisEs6> liveAnalyses;
    private final boolean usePseudoNames;
    private LiveVariablesAnalysisEs6 liveness;
    private final Comparator<Var> coloringTieBreaker = new Comparator<Var>(){

        @Override
        public int compare(Var v1, Var v2) {
            return CoalesceVariableNames.this.liveness.getVarIndex(v1.getName()) - CoalesceVariableNames.this.liveness.getVarIndex(v2.getName());
        }
    };

    CoalesceVariableNames(AbstractCompiler compiler, boolean usePseudoNames) {
        Preconditions.checkState((boolean)compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.colorings = new LinkedList<GraphColoring<Var, Void>>();
        this.liveAnalyses = new LinkedList<LiveVariablesAnalysisEs6>();
        this.usePseudoNames = usePseudoNames;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull((Object)externs);
        Preconditions.checkNotNull((Object)root);
        NodeTraversal.traverseEs6(this.compiler, root, this);
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
    }

    private static boolean shouldOptimizeScope(NodeTraversal t) {
        if (!t.getScopeRoot().isFunction()) {
            return false;
        }
        HashMap<String, Var> allVarsInFn = new HashMap<String, Var>();
        LinkedList<Var> orderedVars = new LinkedList<Var>();
        NodeUtil.getAllVarsDeclaredInFunction(allVarsInFn, orderedVars, t.getCompiler(), t.getScopeCreator(), t.getScope());
        return 100 > orderedVars.size();
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node enclosingFunction;
        Scope scope = t.getScope();
        if (!CoalesceVariableNames.shouldOptimizeScope(t)) {
            return;
        }
        Preconditions.checkState((boolean)scope.isFunctionScope(), (Object)scope);
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        this.liveness = new LiveVariablesAnalysisEs6(cfg, scope, null, this.compiler, new Es6SyntacticScopeCreator(this.compiler));
        if (this.compiler.getOptions().getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT3 && NodeUtil.getFunctionParameters(enclosingFunction = scope.getRootNode()).hasTwoChildren()) {
            this.liveness.markAllParametersEscaped();
        }
        this.liveness.analyze();
        this.liveAnalyses.push(this.liveness);
        UndiGraph<Var, Void> interferenceGraph = this.computeVariableNamesInterferenceGraph(cfg, this.liveness.getEscapedLocals());
        GraphColoring.GreedyGraphColoring<Var, Void> coloring = new GraphColoring.GreedyGraphColoring<Var, Void>(interferenceGraph, this.coloringTieBreaker);
        ((GraphColoring)coloring).color();
        this.colorings.push(coloring);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!CoalesceVariableNames.shouldOptimizeScope(t)) {
            return;
        }
        this.colorings.pop();
        this.liveAnalyses.pop();
        this.liveness = this.liveAnalyses.peek();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.colorings.isEmpty() || !n.isName() || parent.isFunction()) {
            return;
        }
        Var var = this.liveness.getAllVariables().get(n.getString());
        GraphNode<Var, Void> vNode = this.colorings.peek().getGraph().getNode(var);
        if (vNode == null) {
            return;
        }
        Var coalescedVar = this.colorings.peek().getPartitionSuperNode(var);
        if (!this.usePseudoNames) {
            if (vNode.getValue().equals(coalescedVar)) {
                return;
            }
            n.setString(coalescedVar.name);
            this.compiler.reportChangeToEnclosingScope(n);
            if (NodeUtil.isNameDeclaration(parent)) {
                CoalesceVariableNames.makeDeclarationVar(coalescedVar);
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        } else {
            String pseudoName = null;
            TreeSet<String> allMergedNames = new TreeSet<String>();
            for (Var iVar : this.liveness.getAllVariablesInOrder()) {
                if (this.colorings.peek().getGraph().getNode(iVar) == null || !coalescedVar.equals(this.colorings.peek().getPartitionSuperNode(iVar))) continue;
                allMergedNames.add(iVar.name);
            }
            if (allMergedNames.size() == 1) {
                return;
            }
            pseudoName = Joiner.on((String)"_").join(allMergedNames);
            while (t.getScope().isDeclared(pseudoName, true)) {
                pseudoName = pseudoName + "$";
            }
            n.setString(pseudoName);
            this.compiler.reportChangeToEnclosingScope(n);
            if (!vNode.getValue().equals(coalescedVar) && NodeUtil.isNameDeclaration(parent)) {
                CoalesceVariableNames.makeDeclarationVar(coalescedVar);
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        }
    }

    private UndiGraph<Var, Void> computeVariableNamesInterferenceGraph(ControlFlowGraph<Node> cfg, Set<? extends Var> escaped) {
        LinkedUndirectedGraph<Var, Void> interferenceGraph = LinkedUndirectedGraph.create();
        List<Var> orderedVariables = this.liveness.getAllVariablesInOrder();
        for (Var v : orderedVariables) {
            if (escaped.contains(v) || v.getParentNode().isFunction()) continue;
            ((Graph)interferenceGraph).createNode(v);
        }
        for (Var v1 : orderedVariables) {
            block2: for (Var v2 : orderedVariables) {
                int v2Index;
                int v1Index;
                DataFlowAnalysis.FlowState state;
                if (this.liveness.getVarIndex(v1.getName()) > this.liveness.getVarIndex(v2.getName()) || !interferenceGraph.hasNode(v1) || !interferenceGraph.hasNode(v2)) continue;
                if (v1.getParentNode().isParamList() && v2.getParentNode().isParamList()) {
                    interferenceGraph.connectIfNotFound(v1, null, v2);
                    continue;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode)) continue;
                    state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation();
                    v1Index = this.liveness.getVarIndex(v1.getName());
                    v2Index = this.liveness.getVarIndex(v2.getName());
                    if ((!((LiveVariablesAnalysisEs6.LiveVariableLattice)state.getIn()).isLive(v1Index) || !((LiveVariablesAnalysisEs6.LiveVariableLattice)state.getIn()).isLive(v2Index)) && (!((LiveVariablesAnalysisEs6.LiveVariableLattice)state.getOut()).isLive(v1Index) || !((LiveVariablesAnalysisEs6.LiveVariableLattice)state.getOut()).isLive(v2Index))) continue;
                    interferenceGraph.connectIfNotFound(v1, null, v2);
                    continue block2;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode)) continue;
                    state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation();
                    v1Index = this.liveness.getVarIndex(v1.getName());
                    v2Index = this.liveness.getVarIndex(v2.getName());
                    boolean v1OutLive = ((LiveVariablesAnalysisEs6.LiveVariableLattice)state.getOut()).isLive(v1Index);
                    boolean v2OutLive = ((LiveVariablesAnalysisEs6.LiveVariableLattice)state.getOut()).isLive(v2Index);
                    CombinedLiveRangeChecker checker = new CombinedLiveRangeChecker(new LiveRangeChecker(v1, v2OutLive ? null : v2), new LiveRangeChecker(v2, v1OutLive ? null : v1));
                    NodeTraversal.traverseEs6(this.compiler, (Node)cfgNode.getValue(), checker);
                    if (!checker.connectIfCrossed(interferenceGraph)) continue;
                    continue block2;
                }
            }
        }
        return interferenceGraph;
    }

    private static void removeVarDeclaration(Node name) {
        Node var = name.getParent();
        Node parent = var.getParent();
        if (!var.isVar()) {
            var.setToken(Token.VAR);
        }
        Preconditions.checkState((boolean)var.isVar(), (Object)var);
        if (NodeUtil.isEnhancedFor(parent)) {
            var.removeChild(name);
            parent.replaceChild(var, name);
        } else if (var.hasOneChild()) {
            if (name.hasChildren()) {
                Node value = name.removeFirstChild();
                var.removeChild(name);
                Node assign = IR.assign(name, value).srcref(name);
                if (!parent.isVanillaFor()) {
                    assign = NodeUtil.newExpr(assign);
                }
                parent.replaceChild(var, assign);
            } else {
                NodeUtil.removeChild(parent, var);
            }
        } else if (!name.hasChildren()) {
            var.removeChild(name);
        }
    }

    public static void makeDeclarationVar(Var coalescedName) {
        Node coalesceVarParent = coalescedName.getParentNode();
        if (coalesceVarParent.isLet() || coalesceVarParent.isConst()) {
            coalesceVarParent.setToken(Token.VAR);
            Preconditions.checkState((boolean)coalesceVarParent.isVar());
        }
    }

    private static class LiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        boolean defFound = false;
        boolean crossed = false;
        private final Var def;
        private final Var use;

        public LiveRangeChecker(Var def, Var use) {
            this.def = def;
            this.use = use;
        }

        Var getDef() {
            return this.def;
        }

        public static boolean shouldVisit(Node n) {
            return n.isName() || n.hasChildren() && n.getFirstChild().isName();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!this.defFound && LiveRangeChecker.isAssignTo(this.def, n, parent)) {
                this.defFound = true;
            }
            if (this.defFound && (this.use == null || LiveRangeChecker.isReadFrom(this.use, n))) {
                this.crossed = true;
            }
        }

        private static boolean isAssignTo(Var var, Node n, Node parent) {
            if (n.isName()) {
                if (var.getName().equals(n.getString()) && parent != null) {
                    if (parent.isParamList()) {
                        return true;
                    }
                    if (NodeUtil.isNameDeclaration(parent)) {
                        return n.hasChildren();
                    }
                }
            } else if (NodeUtil.isAssignmentOp(n)) {
                Node name = n.getFirstChild();
                return name != null && name.isName() && var.getName().equals(name.getString());
            }
            return false;
        }

        private static boolean isReadFrom(Var var, Node name) {
            return name != null && name.isName() && var.getName().equals(name.getString()) && !NodeUtil.isNameDeclOrSimpleAssignLhs(name, name.getParent());
        }
    }

    private static class CombinedLiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        private final LiveRangeChecker callback1;
        private final LiveRangeChecker callback2;

        CombinedLiveRangeChecker(LiveRangeChecker callback1, LiveRangeChecker callback2) {
            this.callback1 = callback1;
            this.callback2 = callback2;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (LiveRangeChecker.shouldVisit(n)) {
                this.callback1.visit(t, n, parent);
                this.callback2.visit(t, n, parent);
            }
        }

        boolean connectIfCrossed(UndiGraph<Var, Void> interferenceGraph) {
            if (this.callback1.crossed || this.callback2.crossed) {
                Var v1 = this.callback1.getDef();
                Var v2 = this.callback2.getDef();
                interferenceGraph.connectIfNotFound(v1, null, v2);
                return true;
            }
            return false;
        }
    }
}

