/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class MarkNoSideEffectCalls
implements CompilerPass {
    static final DiagnosticType INVALID_NO_SIDE_EFFECT_ANNOTATION = DiagnosticType.error("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION", "@nosideeffects may only appear in externs files.");
    private final AbstractCompiler compiler;
    private final Set<Node> noSideEffectFunctionNames;

    MarkNoSideEffectCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.noSideEffectFunctionNames = new HashSet<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, root);
        NodeTraversal.traverseEs6(this.compiler, externs, new GatherNoSideEffectFunctions(true));
        NodeTraversal.traverseEs6(this.compiler, root, new GatherNoSideEffectFunctions(false));
        NodeTraversal.traverseEs6(this.compiler, root, new SetNoSideEffectCallProperty(defFinder));
    }

    private static boolean definitionTypeContainsFunctionType(DefinitionsRemover.Definition def) {
        Node rhs = def.getRValue();
        if (rhs == null) {
            return true;
        }
        switch (rhs.getType()) {
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 86: 
            case 98: 
            case 100: 
            case 101: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNoSideEffectsAnnotation(Node node) {
        JSDocInfo docInfo = node.getJSDocInfo();
        return docInfo != null && docInfo.isNoSideEffects();
    }

    private class SetNoSideEffectCallProperty
    extends NodeTraversal.AbstractPostOrderCallback {
        private final SimpleDefinitionFinder defFinder;

        SetNoSideEffectCallProperty(SimpleDefinitionFinder defFinder) {
            this.defFinder = defFinder;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!node.isCall() && !node.isNew()) {
                return;
            }
            Collection<DefinitionsRemover.Definition> definitions = this.defFinder.getDefinitionsReferencedAt(node.getFirstChild());
            if (definitions == null) {
                return;
            }
            boolean maybeFunction = false;
            for (DefinitionsRemover.Definition def : definitions) {
                Node lValue = def.getLValue();
                Preconditions.checkNotNull((Object)lValue);
                if (!MarkNoSideEffectCalls.definitionTypeContainsFunctionType(def)) continue;
                maybeFunction = true;
                if (MarkNoSideEffectCalls.this.noSideEffectFunctionNames.contains(lValue)) continue;
                return;
            }
            if (maybeFunction) {
                node.setSideEffectFlags(15);
            }
        }
    }

    private class GatherNoSideEffectFunctions
    extends NodeTraversal.AbstractPostOrderCallback {
        private final boolean inExterns;

        GatherNoSideEffectFunctions(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!this.inExterns && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node)) {
                traversal.report(node, INVALID_NO_SIDE_EFFECT_ANNOTATION, new String[0]);
            }
            if (node.isGetProp()) {
                if (parent.isExprResult() && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node)) {
                    MarkNoSideEffectCalls.this.noSideEffectFunctionNames.add(node);
                }
            } else if (node.isFunction()) {
                boolean hasAnnotation = MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node);
                ArrayList<Node> nameNodes = new ArrayList<Node>();
                nameNodes.add(node.getFirstChild());
                if (parent.isName()) {
                    Node gramp = parent.getParent();
                    if (gramp.isVar() && gramp.hasOneChild() && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(gramp)) {
                        hasAnnotation = true;
                    }
                    nameNodes.add(parent);
                } else if (parent.isAssign()) {
                    if (MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(parent)) {
                        hasAnnotation = true;
                    }
                    nameNodes.add(parent.getFirstChild());
                }
                if (hasAnnotation) {
                    MarkNoSideEffectCalls.this.noSideEffectFunctionNames.addAll(nameNodes);
                }
            }
        }
    }
}

